/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs.definitions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionDialogMessages;
import com.ibm.team.build.internal.ui.dialogs.definitions.FetchBuildDefinitionsInConnectedProjectAreasJob;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class BuildDefinitionSelectionDialog
extends ElementListSelectionDialog {
    protected Job fFetchingJob;
    private boolean fFetchingDone;
    IStatus fStatus = null;
    IStatus fRealStatus = null;

    public BuildDefinitionSelectionDialog(Shell parent, boolean isMultiSelectAllowed) {
        super(parent, (ILabelProvider)new BuildDefinitionLabelProvider(false));
        String title = BuildDefinitionDialogMessages.BuildDefinitionSelectionDialog_TITLE;
        String message = this.createMessageString(isMultiSelectAllowed);
        this.init(title, message, isMultiSelectAllowed);
    }

    public BuildDefinitionSelectionDialog(Shell parent, String title, String message, boolean isMultiSelectAllowed, boolean showRepository) {
        super(parent, (ILabelProvider)new BuildDefinitionLabelProvider(showRepository));
        this.init(title, message, isMultiSelectAllowed);
    }

    protected void init(String title, String message, boolean isMultiSelectAllowed) {
        this.setTitle(title);
        this.setMessage(message);
        this.setStatusLineAboveButtons(true);
        this.setMultipleSelection(isMultiSelectAllowed);
        this.setEmptyListMessage(BuildDefinitionDialogMessages.BuildDefinitionSelectionDialog_NO_BUILDS_FOUND_MESSAGE);
        this.fFetchingJob = this.createFetchJob();
    }

    private String createMessageString(boolean isMultiSelectAllowed) {
        return isMultiSelectAllowed ? BuildDefinitionDialogMessages.BuildDefinitionSelectionDialog_PROMPT_SINGLE_SELECT : BuildDefinitionDialogMessages.BuildDefinitionSelectionDialog_PROMPT_MULTI_SELECT;
    }

    protected Job createFetchJob() {
        return new FetchBuildDefinitionsInConnectedProjectAreasJob(this);
    }

    public void setListElements(Object[] elements) {
        super.setListElements(elements);
    }

    protected void updateStatus(IStatus status) {
        this.fRealStatus = status;
        super.updateStatus(status);
    }

    protected void setStatus(IStatus status) {
        super.updateStatus(status);
        this.fStatus = status;
    }

    protected void handleSelectionChanged() {
        if (this.fFetchingDone) {
            super.handleSelectionChanged();
            if (this.fStatus != null) {
                super.updateStatus(this.fStatus);
                this.updateButtonsEnableState(this.fRealStatus);
            }
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    public int open() {
        this.fFetchingJob.schedule();
        this.setElements(new Object[]{BuildDefinitionDialogMessages.BuildDefinitionSelectionDialog_FETCHING_MESSAGE});
        return super.open();
    }

    public boolean close() {
        this.fFetchingJob.cancel();
        return super.close();
    }

    public void setFetchingDone() {
        this.fFetchingDone = true;
    }

    public boolean isFetchingDone() {
        return this.fFetchingDone;
    }

    public IBuildDefinition getFirstSelectedBuildDefinition() {
        return (IBuildDefinition)this.getFirstResult();
    }

    public List<IBuildDefinition> getSelectedBuildDefinitions() {
        ArrayList<IBuildDefinition> definitions = new ArrayList<IBuildDefinition>();
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            definitions.add((IBuildDefinition)object);
            ++n2;
        }
        return definitions;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_builddefinition");
        return super.createDialogArea(parent);
    }
}

