/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.dialogs.EditBuildEnginesDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class ScmOptionsSection
extends RequestBuildSection {
    public static final String PREFERENCE_WORKSPACE_PREFIX = "personalBuildWorkspace";
    private Composite fBuildOptionsComposite;
    protected Button fPersonalBuildButton;
    protected Text fPersonalBuildWorkspaceText;
    protected Button fBrowseWorkspaceButton;
    protected Text fComponentLoadRulesText;
    protected Button fBrowseComponentLoadRulesButton;
    private IWorkspace fPersonalBuildWorkspace;
    private ComponentLoadRules fComponentLoadRules;
    private Button fBrowseEngineButton;
    private Text fEngineText;
    private boolean fUncheckedInChangesInWorkspace;
    private Composite fPersonalBuildCheckBoxComposite;
    private boolean fPersonalBuildWorkspaceHasPrivateComponents;
    private boolean fErrorLoadRulesNotInXMLFormat = false;

    public ScmOptionsSection(RequestBuildSectionSite site) {
        super(site);
    }

    @Override
    protected String getSectionName() {
        if (this.getSite().isRebuild() && this.getSite().getBuildResult() != null) {
            return NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_REBUILD_OPTIONS_LABEL, (Object)this.getSite().getBuildResult().getLabel());
        }
        return BuildUIDialogMessages.RequestBuildDialog_BUILD_OPTIONS_LABEL;
    }

    @Override
    protected void createSectionContent(Section section) {
        if (this.fBuildOptionsComposite != null && !this.fBuildOptionsComposite.isDisposed()) {
            this.fBuildOptionsComposite.dispose();
        }
        this.fBuildOptionsComposite = new Composite((Composite)section, 0);
        this.fBuildOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 10;
        this.fBuildOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fBuildOptionsComposite);
        Label engineLabel = new Label(this.fBuildOptionsComposite, 0);
        engineLabel.setText(BuildUIDialogMessages.RequestBuildDialog_BUILD_ENGINE_LABEL);
        this.fEngineText = new Text(this.fBuildOptionsComposite, 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEngineText);
        this.setPotentialHandler(null);
        this.fBrowseEngineButton = new Button(this.fBuildOptionsComposite, 8);
        this.fBrowseEngineButton.setText(BuildUIDialogMessages.RequestBuildDialog_BUILD_ENGINE_BROWSE);
        this.fBrowseEngineButton.addSelectionListener(this.getBrowseEngineButtonListener());
        if (this.hasScmConfiguration()) {
            this.fPersonalBuildCheckBoxComposite = new Composite(this.fBuildOptionsComposite, 0);
            layout = new GridLayout(2, false);
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            this.fPersonalBuildCheckBoxComposite.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.fPersonalBuildCheckBoxComposite.setLayoutData((Object)gridData);
            this.fPersonalBuildButton = new Button(this.fPersonalBuildCheckBoxComposite, 32);
            this.fPersonalBuildButton.setText(BuildUIDialogMessages.RequestBuildDialog_PERSONAL_BUILD_BUTTON);
            GridDataFactory.swtDefaults().applyTo((Control)this.fPersonalBuildButton);
            this.fPersonalBuildButton.addSelectionListener(this.getPersonalBuildButtonListener());
            boolean isPersonalBuild = this.getSite().isPersonalBuild();
            this.fPersonalBuildButton.setSelection(isPersonalBuild);
            Label label = new Label(this.fPersonalBuildCheckBoxComposite, 0);
            label.setImage(BuildUIPlugin.getImage("icons/obj16/info.gif"));
            label.setToolTipText(BuildUIDialogMessages.RequestBuildDialog_PERSONAL_BUILD_DESCRIPTION);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            label = new Label(this.fBuildOptionsComposite, 0);
            label.setText(BuildUIDialogMessages.RequestBuildDialog_REPOSITORY_WORKSPACE);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            this.fPersonalBuildWorkspaceText = new Text(this.fBuildOptionsComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fPersonalBuildWorkspaceText);
            this.fPersonalBuildWorkspaceText.setEnabled(isPersonalBuild);
            IWorkspace personalBuildWorkspace = this.getPersonalBuildWorkspace();
            if (personalBuildWorkspace != null) {
                this.fPersonalBuildWorkspaceText.setText(personalBuildWorkspace.getName());
            }
            this.fBrowseWorkspaceButton = new Button(this.fBuildOptionsComposite, 8);
            this.fBrowseWorkspaceButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE_WORKSPACE);
            this.fBrowseWorkspaceButton.addSelectionListener(this.getBrowseWorkspaceButtonListener());
            this.fBrowseWorkspaceButton.setEnabled(isPersonalBuild);
            if (isPersonalBuild) {
                this.createJobToCheckWorkspace(this.fPersonalBuildButton.getDisplay());
            } else {
                this.setUncheckedInChangesExist(false);
                this.setPersonalBuildWorkspaceHasPrivateComponents(false);
            }
            if (!this.hasLoadPolicy() || this.isLoadPolicySetToUseLoadRules()) {
                label = new Label(this.fBuildOptionsComposite, 0);
                label.setText(this.isLoadPolicySetToUseLoadRules() ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULE_FILE_LABEL : BuildUIDialogMessages.RequestBuildDialog_COMPONENT_LOAD_RULES);
                GridDataFactory.swtDefaults().applyTo((Control)label);
                this.fComponentLoadRulesText = new Text(this.fBuildOptionsComposite, 2056);
                GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fComponentLoadRulesText);
                this.fComponentLoadRulesText.setEnabled(isPersonalBuild);
                if (this.getComponentLoadRules() != null) {
                    this.updateComponentLoadRules(this.getComponentLoadRules());
                    if (isPersonalBuild && this.isLoadPolicySetToUseLoadRules()) {
                        this.createJobToVerifyLoadRules(this.fPersonalBuildButton.getDisplay());
                    } else {
                        this.setErrorLoadRulesNotInXMLFormat(false);
                    }
                }
                this.fBrowseComponentLoadRulesButton = new Button(this.fBuildOptionsComposite, 8);
                this.fBrowseComponentLoadRulesButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE_COMPONENT_LOAD_RULES);
                this.fBrowseComponentLoadRulesButton.addSelectionListener(this.getBrowseComponentLoadRulesButtonListener());
                this.fBrowseComponentLoadRulesButton.setEnabled(isPersonalBuild && personalBuildWorkspace != null);
            }
            if (isPersonalBuild) {
                this.getSection().setExpanded(true);
            }
        }
    }

    protected boolean hasScmConfiguration() {
        return this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.team.build.jazzscm") != null;
    }

    protected boolean hasLoadPolicy() {
        String loadPolicy = this.getSite().getBuildDefinition().getPropertyValue("team.scm.loadPolicy", "");
        return loadPolicy != null && loadPolicy.trim().length() != 0;
    }

    protected boolean isLoadPolicySetToUseLoadRules() {
        String loadPolicy = this.getSite().getBuildDefinition().getPropertyValue("team.scm.loadPolicy", "");
        return loadPolicy != null && "useLoadRules".equals(loadPolicy.trim());
    }

    protected SelectionListener getPersonalBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isPersonalBuild = ScmOptionsSection.this.fPersonalBuildButton.getSelection();
                IWorkspace personalBuildWorkspace = ScmOptionsSection.this.getPersonalBuildWorkspace();
                if (isPersonalBuild) {
                    ScmOptionsSection.this.createJobToCheckWorkspace(ScmOptionsSection.this.fPersonalBuildButton.getDisplay());
                } else {
                    ScmOptionsSection.this.setUncheckedInChangesExist(false);
                    ScmOptionsSection.this.setPersonalBuildWorkspaceHasPrivateComponents(false);
                }
                ScmOptionsSection.this.fPersonalBuildWorkspaceText.setEnabled(isPersonalBuild);
                ScmOptionsSection.this.fBrowseWorkspaceButton.setEnabled(isPersonalBuild);
                if (!ScmOptionsSection.this.hasLoadPolicy() || ScmOptionsSection.this.isLoadPolicySetToUseLoadRules()) {
                    if (ScmOptionsSection.this.fComponentLoadRulesText != null) {
                        ScmOptionsSection.this.fComponentLoadRulesText.setEnabled(isPersonalBuild && personalBuildWorkspace != null);
                    }
                    if (ScmOptionsSection.this.fBrowseComponentLoadRulesButton != null) {
                        ScmOptionsSection.this.fBrowseComponentLoadRulesButton.setEnabled(isPersonalBuild && personalBuildWorkspace != null);
                    }
                    if (isPersonalBuild && ScmOptionsSection.this.isLoadPolicySetToUseLoadRules()) {
                        ScmOptionsSection.this.createJobToVerifyLoadRules(ScmOptionsSection.this.fPersonalBuildButton.getDisplay());
                    } else {
                        ScmOptionsSection.this.setErrorLoadRulesNotInXMLFormat(false);
                    }
                }
                ScmOptionsSection.this.getSite().setProperty("personalBuild", isPersonalBuild);
            }
        };
    }

    protected SelectionListener getBrowseEngineButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                button.setEnabled(false);
                ITeamRepository teamRepository = ScmOptionsSection.this.getSite().getTeamRepository();
                IProcessAreaHandle processAreaHandle = ScmOptionsSection.this.getSite().getBuildDefinition().getProcessArea();
                ScmOptionsSection.this.openBuildEngineChooserDialog(ScmOptionsSection.this.fBrowseEngineButton.getShell(), teamRepository, processAreaHandle, button);
            }
        };
    }

    protected SelectionListener getBrowseWorkspaceButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = ScmOptionsSection.this.getSite().getTeamRepository();
                IWorkspace workspace = ScmOptionsSection.this.openWorkspaceChooserDialog(ScmOptionsSection.this.fBrowseWorkspaceButton.getShell(), teamRepository);
                if (workspace != null) {
                    ScmOptionsSection.this.setPersonalBuildWorkspace(workspace);
                    ScmOptionsSection.this.fPersonalBuildWorkspaceText.setText(workspace.getName());
                    ScmOptionsSection.this.createJobToCheckWorkspace(ScmOptionsSection.this.fPersonalBuildButton.getDisplay());
                    if (ScmOptionsSection.this.fBrowseComponentLoadRulesButton != null) {
                        ScmOptionsSection.this.fBrowseComponentLoadRulesButton.setEnabled(true);
                    }
                    if (ScmOptionsSection.this.isLoadPolicySetToUseLoadRules()) {
                        ScmOptionsSection.this.createJobToVerifyLoadRules(ScmOptionsSection.this.fPersonalBuildButton.getDisplay());
                    }
                    ScmOptionsSection.this.getSite().revalidate();
                    BuildUIPlugin.getDefault().getPreferenceStore().setValue(ScmOptionsSection.PREFERENCE_WORKSPACE_PREFIX + ScmOptionsSection.this.getSite().getBuildDefinition().getId(), workspace.getItemId().getUuidValue());
                    BuildUIPlugin.getDefault().savePluginPreferences();
                } else {
                    ScmOptionsSection.this.setUncheckedInChangesExist(false);
                    ScmOptionsSection.this.setPersonalBuildWorkspaceHasPrivateComponents(false);
                    ScmOptionsSection.this.setErrorLoadRulesNotInXMLFormat(false);
                }
            }
        };
    }

    protected void createJobToCheckWorkspace(final Display display) {
        String jobNameCheckWorkspace = BuildUIDialogMessages.ScmOptionsSection_CHECK_PERSONAL_BUILD_WORKSPACE_JOB_NAME;
        TeamBuildJob jobCheckWorkspace = new TeamBuildJob(jobNameCheckWorkspace, false, this.getSite().getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ScmOptionsSection.this.checkPersonalBuildWorkspace(display, monitor);
                return Status.OK_STATUS;
            }
        };
        jobCheckWorkspace.schedule();
    }

    protected void checkPersonalBuildWorkspace(Display display, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.setUncheckedInChangesExist(this.hasUncheckedInChangesInWorkspace((IProgressMonitor)subMonitor.newChild(50)));
        this.setPersonalBuildWorkspaceHasPrivateComponents(this.hasPrivateComponents((IProgressMonitor)subMonitor.newChild(50)));
        this.handleWorkspaceCheckDone(display);
    }

    protected boolean hasPrivateComponents(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean privateComponents = false;
        IWorkspace workspace = this.getPersonalBuildWorkspace();
        if (workspace != null && workspace.getOrigin() instanceof ITeamRepository) {
            ITeamRepository repo = (ITeamRepository)workspace.getOrigin();
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            try {
                IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)subMonitor.newChild(10));
                List readScopes = workspaceManager.findReadScopeForComponents(workspaceConnection.getComponents(), (IProgressMonitor)subMonitor.newChild(90));
                for (IReadScope readScope : readScopes) {
                    if (!(readScope instanceof IPrivateScope)) continue;
                    privateComponents = true;
                    break;
                }
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
            }
        }
        return privateComponents;
    }

    protected boolean hasUncheckedInChangesInWorkspace(IProgressMonitor monitor) {
        boolean uncheckedInChangesExist = false;
        IWorkspace personalBuildWorkspace = this.getPersonalBuildWorkspace();
        if (personalBuildWorkspace != null) {
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            ISharingManager sm = FileSystemCore.getSharingManager();
            Collection sandboxes = sm.getRegisteredSandboxes();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxes.size());
            block2: for (ISandbox sandbox : sandboxes) {
                Collection loadedComponents = null;
                try {
                    loadedComponents = sandbox.allLoadedConfigurations((IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemException exception) {
                    BuildUIPlugin.log(exception);
                }
                for (IConfigurationDescriptor loaded : loadedComponents) {
                    IComponentHandle component;
                    ILocalChange[] localChanges;
                    if (!(loaded.getConnectionHandle() instanceof IWorkspaceHandle) || (localChanges = lcm.getPendingChanges((IContextHandle)personalBuildWorkspace, component = loaded.getComponentHandle(), sandbox)).length <= 0) continue;
                    uncheckedInChangesExist = true;
                    break block2;
                }
            }
        }
        return uncheckedInChangesExist;
    }

    protected void handleWorkspaceCheckDone(Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ScmOptionsSection.this.fPersonalBuildButton.isDisposed()) {
                    ScmOptionsSection.this.getSite().revalidate();
                }
            }
        });
    }

    protected SelectionListener getBrowseComponentLoadRulesButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = ScmOptionsSection.this.getSite().getTeamRepository();
                Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = ScmOptionsSection.this.openComponentLoadRulesChooserDialog(ScmOptionsSection.this.fBrowseComponentLoadRulesButton.getShell(), teamRepository, ScmOptionsSection.this.getPersonalBuildWorkspace());
                if (componentLoadRuleFiles != null) {
                    ScmOptionsSection.this.setComponentLoadRules(new ComponentLoadRules(componentLoadRuleFiles));
                    ScmOptionsSection.this.updateComponentLoadRules(ScmOptionsSection.this.getComponentLoadRules());
                    if (ScmOptionsSection.this.isLoadPolicySetToUseLoadRules()) {
                        ScmOptionsSection.this.createJobToVerifyLoadRules(ScmOptionsSection.this.fPersonalBuildButton.getDisplay());
                    }
                } else {
                    ScmOptionsSection.this.setErrorLoadRulesNotInXMLFormat(false);
                }
            }
        };
    }

    protected void updateComponentLoadRules(ComponentLoadRules rules) {
        if (this.fComponentLoadRulesText == null) {
            return;
        }
        int numLoadRules = this.getComponentLoadRules().getLoadRuleFiles().values().size();
        if (numLoadRules == 0) {
            this.fComponentLoadRulesText.setText("");
        } else {
            this.fComponentLoadRulesText.setEnabled(true);
            String messageId = numLoadRules > 1 ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT_MULTI : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT;
            this.fComponentLoadRulesText.setText(NLS.bind((String)messageId, (Object)numLoadRules));
        }
    }

    @Override
    public boolean validate2() {
        boolean isValid = true;
        boolean isEmptyBuildWorkspace = false;
        boolean isBuildWorkspaceSteam = false;
        boolean isBuildWorkspacePrivate = false;
        if (this.hasScmConfiguration() && this.getSite().isPersonalBuild()) {
            IWorkspace buildWorkspace = this.getPersonalBuildWorkspace();
            if (buildWorkspace == null) {
                isValid = false;
                isEmptyBuildWorkspace = true;
            } else if (buildWorkspace.isStream()) {
                isBuildWorkspaceSteam = true;
            } else if (buildWorkspace.getReadScope() instanceof IPrivateScope) {
                isBuildWorkspacePrivate = true;
            }
        }
        if (isEmptyBuildWorkspace) {
            this.getSite().addErrorMessage(BuildUIDialogMessages.ScmOptionsSection_ERROR_MESSAGE_NO_BUILD_WORKSPACE, BuildUIDialogMessages.ScmOptionsSection_ERROR_MESSAGE_NO_BUILD_WORKSPACE);
        } else {
            this.getSite().removeErrorMessage(BuildUIDialogMessages.ScmOptionsSection_ERROR_MESSAGE_NO_BUILD_WORKSPACE);
        }
        if (isBuildWorkspaceSteam) {
            this.getSite().addWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_BUILD_WORKSPACE_IS_STREAM, BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_BUILD_WORKSPACE_IS_STREAM);
        } else {
            this.getSite().removeWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_BUILD_WORKSPACE_IS_STREAM);
        }
        if (isBuildWorkspacePrivate) {
            this.getSite().addWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_PRIVATE_BUILD_WORKSPACE, BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_PRIVATE_BUILD_WORKSPACE);
        } else {
            this.getSite().removeWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_PRIVATE_BUILD_WORKSPACE);
        }
        if (this.getUncheckedInChangesExist()) {
            this.getSite().addWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_UNCHECKED_IN_CHANGES_EXIST_IN_BUILD_WORKSPACE, BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_UNCHECKED_IN_CHANGES_EXIST_IN_BUILD_WORKSPACE);
        } else {
            this.getSite().removeWarningMessage(BuildUIDialogMessages.ScmOptionsSection_WARNING_MESSAGE_UNCHECKED_IN_CHANGES_EXIST_IN_BUILD_WORKSPACE);
        }
        if (this.getPersonalBuildWorkspaceHasPrivateComponents()) {
            this.getSite().addWarningMessage(BuildUIDialogMessages.ScmOptionsSection_PRIVATE_COMPONENTS_IN_PERSONAL_WORKSPACE, BuildUIDialogMessages.ScmOptionsSection_PRIVATE_COMPONENTS_IN_PERSONAL_WORKSPACE);
        } else {
            this.getSite().removeWarningMessage(BuildUIDialogMessages.ScmOptionsSection_PRIVATE_COMPONENTS_IN_PERSONAL_WORKSPACE);
        }
        if (this.getErrorLoadRulesNotInXMLFormat() && this.getSite().isPersonalBuild()) {
            this.getSite().addErrorMessage(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_LOAD_RULES_NOT_XML, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_LOAD_RULES_NOT_XML);
            isValid = false;
        } else {
            this.getSite().removeErrorMessage(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_LOAD_RULES_NOT_XML);
        }
        return isValid;
    }

    @Override
    public void initialize(IProgressMonitor monitor) {
        if (this.getSite().isRebuild()) {
            this.setPersonalBuildWorkspace(this.getWorkspace(this.getSite().getBuildRequest(), monitor));
            this.setComponentLoadRules(this.getComponentLoadRules(this.getSite().getBuildRequest()));
        } else {
            this.setPersonalBuildWorkspace(this.getPersistedWorkspace(this.getSite().getBuildDefinition(), monitor));
            this.setComponentLoadRules(this.getComponentLoadRules(this.getSite().getBuildDefinition()));
        }
    }

    private ComponentLoadRules getComponentLoadRules(IBuildRequest buildRequest) {
        ComponentLoadRules componentLoadRules = null;
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.scm.componentLoadRules");
        if (property != null) {
            componentLoadRules = new ComponentLoadRules(property.getValue());
        }
        return componentLoadRules;
    }

    private ComponentLoadRules getComponentLoadRules(IBuildDefinition buildDefinition) {
        IBuildProperty property;
        ComponentLoadRules componentLoadRules = null;
        IBuildConfigurationElement element = buildDefinition.getConfigurationElement("com.ibm.team.build.jazzscm");
        if (element != null && (property = buildDefinition.getProperty("team.scm.componentLoadRules")) != null) {
            componentLoadRules = new ComponentLoadRules(property.getValue());
        }
        return componentLoadRules;
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesChooserDialog(Shell shell, ITeamRepository teamRepository, IWorkspace workspace) {
        Map initialSelection = this.getComponentLoadRules() != null ? this.getComponentLoadRules().getLoadRuleFiles() : Collections.EMPTY_MAP;
        HashMap<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = null;
        if (this.isLoadPolicySetToUseLoadRules()) {
            SiloedItemId siloedItem;
            RepositoryFilesPickerOutput pickerOutput = FileSelectionDialog.pickFile((Shell)shell, (ITeamRepository)teamRepository, (IWorkspace)workspace, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_LOAD_RULE_FILE_DIALOG_DESCRIPTION, (Map)initialSelection, (boolean)false);
            componentLoadRuleFiles = new HashMap<IComponentHandle, IFileItemHandle>(1);
            if (pickerOutput != null && pickerOutput.getItemIds() != null && pickerOutput.getItemIds().size() > 0 && (siloedItem = (SiloedItemId)pickerOutput.getItemIds().iterator().next()).toHandle() instanceof IFileItemHandle) {
                componentLoadRuleFiles.put(siloedItem.getComponentHandle(), (IFileItemHandle)siloedItem.toHandle());
            }
        } else {
            componentLoadRuleFiles = FileSelectionDialog.pickFilePerComponent((Shell)shell, (ITeamRepository)teamRepository, (IWorkspace)workspace, (String)BuildUIDialogMessages.RequestBuildDialog_LOAD_RULES_DIALOG_MESSAGE, (Map)initialSelection);
        }
        return componentLoadRuleFiles;
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions().setTarget(null).setAllowMultiSelect(false).setComponents(null).setShowWorkspaces(WORKSPACES_OR_STREAMS.WORKSPACES).setShowWorkspacesRadio(true).setExactOwnerName(null).setToIgnore(null).setForceRepo(true);
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, (WorkspaceAndStreamSelectionDialogOptions)options);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openBuildEngineChooserDialog(final Shell shell, final ITeamRepository teamRepository, final IProcessAreaHandle processAreaHandle, final Button button) {
        final Display display = shell.getDisplay();
        TeamBuildJob job = new TeamBuildJob(BuildUIDialogMessages.RequestBuildDialog_FETCHING_ENGINES_JOB_NAME, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)progress.newChild(10));
                final IProjectArea projectArea = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processArea.getProjectArea(), 0, (IProgressMonitor)progress.newChild(10));
                final List<IBuildEngine> buildEngines = ScmOptionsSection.this.getBuildEngines(teamRepository, (IProgressMonitor)progress.newChild(40));
                final Map<String, String> buildEngineIdsToProjectAreaName = ScmOptionsSection.this.fetchEngineIdToProjectName(teamRepository, buildEngines, (IProgressMonitor)progress.newChild(40));
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!shell.isDisposed()) {
                            button.setEnabled(true);
                            Map<String, IBuildEngine> buildEnginesById = ScmOptionsSection.this.getBuildEnginesById(buildEngines);
                            EditBuildEnginesDialog dialog = new EditBuildEnginesDialog(shell, buildEngineIdsToProjectAreaName, null, projectArea.getName(), buildEnginesById, teamRepository, projectArea.getItemId().getUuidValue()){

                                @Override
                                protected String getDialogTitle() {
                                    return BuildUIDialogMessages.RequestBuildDialog_SELECT_ENGINE_DIALOG_TITLE;
                                }

                                @Override
                                protected String getDialogDescription() {
                                    return BuildUIDialogMessages.RequestBuildDialog_SELECT_ENGINE_DIALOG_DESCRIPTION;
                                }
                            };
                            dialog.setSingleSelect(true);
                            if (dialog.open() == 0) {
                                Set<String> changedBuildEngineIds = dialog.getChangedBuildEngineIds();
                                IBuildEngine buildEngine = changedBuildEngineIds.isEmpty() ? null : buildEnginesById.get(changedBuildEngineIds.iterator().next());
                                ScmOptionsSection.this.setPotentialHandler(buildEngine);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void setPotentialHandler(IBuildEngine buildEngine) {
        this.fEngineText.setText(buildEngine == null ? BuildUIDialogMessages.RequestBuildDialog_ANY_SUPPORTING_ENGINE_TEXT : buildEngine.getId());
        this.getSite().setProperty("handlingEngine", buildEngine);
    }

    protected Map<String, IBuildEngine> getBuildEnginesById(List<IBuildEngine> buildEngines) {
        HashMap<String, IBuildEngine> buildEnginesById = new HashMap<String, IBuildEngine>();
        for (IBuildEngine engine : buildEngines) {
            buildEnginesById.put(engine.getId(), engine);
        }
        return buildEnginesById;
    }

    protected List<IBuildEngine> getBuildEngines(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList<IBuildEngine> buildEngines = new LinkedList<IBuildEngine>();
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (iter.hasNext((IProgressMonitor)loopProgress.newChild(20))) {
            loopProgress.setWorkRemaining(100);
            List engineHandles = iter.next(512, (IProgressMonitor)loopProgress.newChild(40));
            List items = teamRepository.itemManager().fetchCompleteItems(engineHandles, 0, (IProgressMonitor)loopProgress.newChild(40));
            for (IBuildEngine item : items) {
                if (item == null) continue;
                buildEngines.add(item);
            }
        }
        loopProgress.done();
        return buildEngines;
    }

    protected Map<String, String> fetchEngineIdToProjectName(ITeamRepository teamRepository, List<IBuildEngine> buildEngines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> idToProjectName = new HashMap<String, String>();
        if (buildEngines.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
            ArrayList<IProjectAreaHandle> projectAreaHandles = new ArrayList<IProjectAreaHandle>();
            for (IBuildEngine engine : buildEngines) {
                IProcessAreaHandle handle = engine.getProcessArea();
                if (handle instanceof ITeamAreaHandle) {
                    teamAreaHandles.add((ITeamAreaHandle)handle);
                    continue;
                }
                if (!(handle instanceof IProjectAreaHandle)) continue;
                projectAreaHandles.add((IProjectAreaHandle)handle);
            }
            ItemHandleAwareHashMap processAreaMap = new ItemHandleAwareHashMap();
            List teamAreas = teamRepository.itemManager().fetchPartialItems(teamAreaHandles, 0, Collections.singletonList("projectArea"), (IProgressMonitor)progress.newChild(50));
            for (ITeamArea teamArea : teamAreas) {
                if (teamArea == null) continue;
                processAreaMap.put((Object)teamArea, (Object)teamArea);
                if (teamArea.getProjectArea() == null) continue;
                projectAreaHandles.add(teamArea.getProjectArea());
            }
            List projectAreas = teamRepository.itemManager().fetchPartialItems(projectAreaHandles, 0, Collections.singletonList("name"), (IProgressMonitor)progress.newChild(50));
            for (IProjectArea projectArea : projectAreas) {
                if (projectArea == null) continue;
                processAreaMap.put((Object)projectArea, (Object)projectArea);
            }
            for (IBuildEngine engine : buildEngines) {
                IProcessArea processArea = (IProcessArea)processAreaMap.get((Object)engine.getProcessArea());
                IProjectArea projectArea = processArea instanceof ITeamArea ? (IProjectArea)processAreaMap.get((Object)processArea.getProjectArea()) : (IProjectArea)processArea;
                String projectName = projectArea == null ? null : projectArea.getName();
                idToProjectName.put(engine.getId(), projectName);
            }
        }
        return idToProjectName;
    }

    @Override
    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.hasScmConfiguration()) {
            IBuildResult buildResult;
            if (this.getSite().isPersonalBuild()) {
                this.setPersonalBuildProperties(buildDefinition);
            } else if (this.getSite().isRebuild() && (buildResult = this.getSite().getBuildResult()) != null && buildResult.isPersonalBuild()) {
                for (IBuildProperty origProperty : this.getSite().getOriginalBuildProperties()) {
                    IBuildProperty newProperty;
                    if (!origProperty.getName().equals("team.scm.workspaceUUID") && !origProperty.getName().equals("team.scm.componentLoadRules") || (newProperty = buildDefinition.getProperty(origProperty.getName())) == null) continue;
                    newProperty.setValue(origProperty.getValue());
                }
            }
        }
    }

    private void setPersonalBuildProperties(IBuildDefinition buildDefinition) {
        ComponentLoadRules loadRules;
        IWorkspace personalBuildWorkspace = this.getPersonalBuildWorkspace();
        if (personalBuildWorkspace != null) {
            buildDefinition.setProperty("team.scm.workspaceUUID", personalBuildWorkspace.getItemId().getUuidValue());
        }
        if ((!this.hasLoadPolicy() || this.isLoadPolicySetToUseLoadRules()) && (loadRules = this.getComponentLoadRules()) != null) {
            IBuildProperty property = buildDefinition.getProperty("team.scm.componentLoadRules");
            if (property == null) {
                property = BuildItemFactory.createBuildProperty();
                property.setName("team.scm.componentLoadRules");
                property.setGenericEditAllowed(false);
                buildDefinition.getProperties().add(property);
            }
            property.setValue(loadRules.getBuildPropertySetting());
        }
    }

    protected IWorkspace getPersistedWorkspace(IBuildDefinition buildDefinition, IProgressMonitor monitor) {
        String workspaceUuid = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_WORKSPACE_PREFIX + buildDefinition.getId());
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        return this.getWorkspace(workspaceUuid, teamRepository, monitor);
    }

    protected IWorkspace getWorkspace(IBuildRequest buildRequest, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.scm.workspaceUUID");
        if (property != null) {
            ITeamRepository teamRepository = (ITeamRepository)buildRequest.getOrigin();
            String workspaceUuid = property.getValue();
            workspace = this.getWorkspace(workspaceUuid, teamRepository, monitor);
        }
        return workspace;
    }

    protected IWorkspace getWorkspace(String workspaceUuid, ITeamRepository teamRepository, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        try {
            if (workspaceUuid != null && workspaceUuid.length() > 0) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
                workspace = this.fetchWorkspace(workspaceHandle, teamRepository, monitor);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return workspace;
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    @Override
    public void handlePropertyChanged(String propertyName) {
        if ("buildDefinition".equals(propertyName)) {
            this.getSite().setProperty("personalBuild", false);
            this.setPersonalBuildWorkspace(null);
            this.setPersonalBuildWorkspaceHasPrivateComponents(false);
        }
    }

    private void createJobToVerifyLoadRules(final Display display) {
        final ComponentLoadRules componentLoadRules = this.fComponentLoadRules;
        IWorkspace workspace = this.getPersonalBuildWorkspace();
        if (workspace != null && componentLoadRules != null && componentLoadRules.getLoadRuleFiles().values().size() == 1) {
            ITeamRepository repository = (ITeamRepository)workspace.getOrigin();
            TeamBuildJob verifyLoadRulesJob = new TeamBuildJob(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_VERIFY_LOAD_RULES_JOB_NAME, false, repository){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    ScmOptionsSection.this.verifyLoadRulesFormat(ScmOptionsSection.this.getSite().getTeamRepository(), ScmOptionsSection.this.getPersonalBuildWorkspace(), componentLoadRules, monitor, display);
                    return Status.OK_STATUS;
                }
            };
            verifyLoadRulesJob.schedule();
        } else {
            this.setErrorLoadRulesNotInXMLFormat(false);
        }
    }

    protected void verifyLoadRulesFormat(ITeamRepository repo, IWorkspace workspace, ComponentLoadRules currentComponentLoadRules, IProgressMonitor progress, Display display) {
        boolean isLoadRulesNotInXMLFormat = false;
        if (workspace != null && currentComponentLoadRules != null && currentComponentLoadRules.getLoadRuleFiles().values().size() > 0) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            try {
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
                isLoadRulesNotInXMLFormat = !currentComponentLoadRules.isLoadRulesInXMLFormat(connection, (IProgressMonitor)monitor);
            }
            catch (Exception e) {
                BuildUIPlugin.log(e);
            }
        }
        this.setErrorLoadRulesNotInXMLFormat(isLoadRulesNotInXMLFormat);
        this.handleUpdateToLoadRulesNotInXMLFormat(display);
    }

    private void handleUpdateToLoadRulesNotInXMLFormat(Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ScmOptionsSection.this.fPersonalBuildButton.isDisposed()) {
                    ScmOptionsSection.this.getSite().revalidate();
                }
            }
        });
    }

    protected synchronized void setComponentLoadRules(ComponentLoadRules componentLoadRules) {
        this.fComponentLoadRules = componentLoadRules;
    }

    protected synchronized ComponentLoadRules getComponentLoadRules() {
        return this.fComponentLoadRules;
    }

    protected synchronized void setPersonalBuildWorkspace(IWorkspace personalBuildWorkspace) {
        this.fPersonalBuildWorkspace = personalBuildWorkspace;
    }

    protected synchronized IWorkspace getPersonalBuildWorkspace() {
        return this.fPersonalBuildWorkspace;
    }

    protected synchronized void setPersonalBuildWorkspaceHasPrivateComponents(boolean hasPrivateComponents) {
        this.fPersonalBuildWorkspaceHasPrivateComponents = hasPrivateComponents;
    }

    protected synchronized boolean getPersonalBuildWorkspaceHasPrivateComponents() {
        return this.fPersonalBuildWorkspaceHasPrivateComponents;
    }

    protected synchronized void setUncheckedInChangesExist(boolean uncheckedInChangesExist) {
        this.fUncheckedInChangesInWorkspace = uncheckedInChangesExist;
    }

    protected synchronized boolean getUncheckedInChangesExist() {
        return this.fUncheckedInChangesInWorkspace;
    }

    private synchronized boolean getErrorLoadRulesNotInXMLFormat() {
        return this.fErrorLoadRulesNotInXMLFormat;
    }

    private synchronized void setErrorLoadRulesNotInXMLFormat(boolean loadRulesNotInXMLFormat) {
        this.fErrorLoadRulesNotInXMLFormat = loadRulesNotInXMLFormat;
    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        @Override
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new ScmOptionsSection(site);
        }
    }
}

