/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class RequestBuildDialogSectionExtensionManager {
    public static final String EXTENSION_POINT_ID = "com.ibm.team.build.ui.requestBuildDialogSections";
    protected static RequestBuildDialogSectionExtensionManager fManager = null;
    private RequestBuildDialogSectionExtension[] fExtensions = this.loadExtensions();

    protected RequestBuildDialogSectionExtensionManager() {
        Arrays.sort(this.fExtensions, new Comparator<RequestBuildDialogSectionExtension>(){

            @Override
            public int compare(RequestBuildDialogSectionExtension e1, RequestBuildDialogSectionExtension e2) {
                return e1.getOrderNumber() - e2.getOrderNumber();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestBuildDialogSectionExtensionManager getInstance() {
        Class<RequestBuildDialogSectionExtensionManager> clazz = RequestBuildDialogSectionExtensionManager.class;
        synchronized (RequestBuildDialogSectionExtensionManager.class) {
            if (fManager == null) {
                fManager = new RequestBuildDialogSectionExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public RequestBuildDialogSectionExtension[] getRequestBuildDialogSectionExtensions() {
        return this.fExtensions;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private RequestBuildDialogSectionExtension[] loadExtensions() {
        LinkedList<RequestBuildDialogSectionExtension> extensions = new LinkedList<RequestBuildDialogSectionExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    RequestBuildDialogSectionExtension extension = new RequestBuildDialogSectionExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new RequestBuildDialogSectionExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("class"), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_DUPLICATE_EXTENSION_POINT, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_MISSING_OR_INVALID, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

