/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class RequestBuildDialogSectionExtension {
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ORDER_ATTRIBUTE = "order";
    private String fClassAttribute;
    private String fOrderAttribute;
    private int fOrderNumber = -1;
    private IConfigurationElement fPluginConfigurationElement;

    public RequestBuildDialogSectionExtension(IConfigurationElement pluginConfigurationElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)pluginConfigurationElement);
        this.fPluginConfigurationElement = pluginConfigurationElement;
        this.fClassAttribute = pluginConfigurationElement.getAttribute(CLASS_ATTRIBUTE);
        this.fOrderAttribute = pluginConfigurationElement.getAttribute(ORDER_ATTRIBUTE);
        this.validateAttributes();
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getOrderAttribute() {
        return this.fOrderAttribute;
    }

    public int getOrderNumber() {
        if (this.fOrderNumber == -1) {
            this.fOrderNumber = Integer.parseInt(this.getOrderAttribute().trim());
        }
        return this.fOrderNumber;
    }

    public IRequestBuildSectionFactory createSectionFactory() throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension();
    }

    public int hashCode() {
        return this.fClassAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestBuildDialogSectionExtension other = (RequestBuildDialogSectionExtension)obj;
        return this.fClassAttribute.equals(other.fClassAttribute);
    }

    public String toString() {
        return this.fClassAttribute;
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)ORDER_ATTRIBUTE, (Object)this.fOrderAttribute);
        ValidationHelper.validateNotEmpty((String)ORDER_ATTRIBUTE, (String)this.fOrderAttribute.trim());
        ValidationHelper.validateIsInteger((String)ORDER_ATTRIBUTE, (String)this.fOrderAttribute.trim());
    }

    private IRequestBuildSectionFactory createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fPluginConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, IRequestBuildSectionFactory.class, (Object)executableExtension);
        return (IRequestBuildSectionFactory)executableExtension;
    }
}

