/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestParams;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.dialogs.PropertiesSection;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtension;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtensionManager;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.ShowBuildQueueAction;
import com.ibm.team.build.internal.ui.views.query.ShowHistoryAction;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RequestBuildDialog
extends TitleAreaDialog {
    public static final String PREFERENCE_DEFINITION = "mostRecentDefinition";
    public static final String PREFERENCE_SHOW_BUILDS_VIEW = "showBuildsViewAfterRequest";
    public static final String PREFERENCE_SHOW_BUILD_CONSOLE = "showBuildConsoleAfterRequest";
    public static final int SHOW_BUILDS_OF_REQUEST_TYPE = 0;
    public static final int SHOW_BUILD_QUEUE = 1;
    public static final int DO_NOTHING = 2;
    protected List<IBuildProperty> fOriginalBuildProperties;
    protected IBuildDefinitionHandle fBuildDefinitionHandle;
    protected IBuildDefinition fBuildDefinition;
    protected IBuildResult fBuildResult;
    protected IBuildResultHandle fBuildResultHandle;
    protected boolean fIsRebuild;
    protected IBuildRequest fBuildRequest;
    private Job fRequestBuildJob;
    private Job fInitializationJob;
    protected Text fBuildDefinitionText;
    protected Combo fShowBuildsViewCombo;
    protected Button fBrowseButton;
    protected boolean fIsPersonalBuild;
    protected IBuildEngine fHandlingEngine;
    private IWorkbenchPartSite fPartSite;
    protected Map<Object, String> fWarningMessagesMap = new LinkedHashMap<Object, String>();
    protected Map<Object, String> fErrorMessagesMap = new LinkedHashMap<Object, String>();
    protected List<RequestBuildSection> fSections = new ArrayList<RequestBuildSection>();

    public RequestBuildDialog(Shell parentShell, IBuildDefinitionHandle buildDefinitionHandle) {
        super(parentShell);
        this.fBuildDefinitionHandle = buildDefinitionHandle;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_BUILDS_VIEW, true);
    }

    public RequestBuildDialog(Shell parentShell, IBuildResultHandle buildResultHandle, boolean isRebuild) {
        super(parentShell);
        this.fBuildResultHandle = buildResultHandle;
        this.fIsRebuild = isRebuild;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_BUILDS_VIEW, true);
    }

    protected String getHeaderText() {
        return BuildUIDialogMessages.REQUEST_BUILD_HEADER;
    }

    protected String getHelpId() {
        return "com.ibm.team.build.ui.dialog_requestbuild";
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(BuildUIDialogMessages.RequestBuildDialog_REQUEST_BUILD_TITLE);
        this.setMessage(this.getHeaderText(), 0);
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).applyTo(mainComposite);
        Label label = new Label(mainComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        label = new Label(mainComposite, 0);
        label.setText(BuildUIDialogMessages.BUILD_DEFINITION_LABEL);
        label.setLayoutData((Object)new GridData());
        this.fBuildDefinitionText = new Text(mainComposite, 2048);
        this.fBuildDefinitionText.setText(BuildUIDialogMessages.PENDING_LABEL);
        this.fBuildDefinitionText.setLayoutData((Object)new GridData(768));
        this.fBuildDefinitionText.setEditable(false);
        this.fBrowseButton = new Button(mainComposite, 0);
        this.fBrowseButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonListener());
        this.fBrowseButton.setEnabled(!this.fIsRebuild);
        label = new Label(mainComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        this.fSections = this.createSections();
        Composite sectionsComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)sectionsComposite);
        GridLayoutFactory.fillDefaults().applyTo(sectionsComposite);
        for (RequestBuildSection section : this.fSections) {
            section.createContent(sectionsComposite);
        }
        label = new Label(mainComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        Composite composite = new Composite(mainComposite, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, -1).applyTo((Control)composite);
        label = new Label(composite, 0);
        label.setText(BuildUIDialogMessages.RequestBuildDialog_AFTER_REQUEST_LABEL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        this.fShowBuildsViewCombo = new Combo(composite, 8);
        this.fShowBuildsViewCombo.setItems(new String[]{BuildUIDialogMessages.RequestBuildDialog_SHOW_BUILDS_OF_REQUESTED_TYPE, BuildUIDialogMessages.RequestBuildDialog_SHOW_BUILD_QUEUE, BuildUIDialogMessages.RequestBuildDialog_DO_NOTHING});
        this.fShowBuildsViewCombo.setEnabled(false);
        this.fShowBuildsViewCombo.select(BuildUIPlugin.getDefault().getPreferenceStore().getInt(PREFERENCE_SHOW_BUILDS_VIEW));
        this.fShowBuildsViewCombo.addSelectionListener(this.getShowBuildsViewButtonListener());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fShowBuildsViewCombo);
        this.initializeInBackground();
        RequestBuildDialog.applyDialogFont((Control)dialogAreaComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        return dialogAreaComposite;
    }

    private void addWarningMessage(Object id, String warningMessage) {
        this.fWarningMessagesMap.put(id, warningMessage);
        this.updateMessage();
    }

    private void removeWarningMessage(Object id) {
        this.fWarningMessagesMap.remove(id);
        this.updateMessage();
    }

    private void addErrorMessage(Object id, String errorMessage) {
        this.fErrorMessagesMap.put(id, errorMessage);
        this.updateMessage();
    }

    private void removeErrorMessage(Object id) {
        this.fErrorMessagesMap.remove(id);
        this.updateMessage();
    }

    protected String getWarningMessageString() {
        return this.fWarningMessagesMap.values().iterator().next();
    }

    protected String getErrorMessageString() {
        return this.fErrorMessagesMap.values().iterator().next();
    }

    protected void updateMessage() {
        if (!this.fErrorMessagesMap.isEmpty()) {
            this.setMessage(this.getErrorMessageString(), 3);
        } else if (!this.fWarningMessagesMap.isEmpty()) {
            this.setMessage(this.getWarningMessageString(), 2);
        } else {
            this.setMessage(this.getHeaderText(), 0);
        }
    }

    protected List<RequestBuildSection> createSections() {
        RequestBuildDialogSectionExtension[] extensions;
        RequestBuildSectionSite site = this.createSectionSite();
        ArrayList<RequestBuildSection> sections = new ArrayList<RequestBuildSection>();
        RequestBuildDialogSectionExtension[] requestBuildDialogSectionExtensionArray = extensions = RequestBuildDialogSectionExtensionManager.getInstance().getRequestBuildDialogSectionExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            RequestBuildDialogSectionExtension extension = requestBuildDialogSectionExtensionArray[n2];
            try {
                RequestBuildSection buildSection = extension.createSectionFactory().createRequestBuildSection(site);
                if (buildSection instanceof PropertiesSection) {
                    ((PropertiesSection)buildSection).setWorkbenchPartSite(this.fPartSite);
                }
                sections.add(buildSection);
            }
            catch (Exception e) {
                BuildUIPlugin.log(e);
            }
            ++n2;
        }
        return sections;
    }

    protected RequestBuildSectionSite createSectionSite() {
        return new RequestBuildSectionSite(){

            @Override
            public void setProperty(String propertyName, Object value) {
                if ("personalBuild".equals(propertyName)) {
                    RequestBuildDialog.this.fIsPersonalBuild = (Boolean)value;
                } else if ("handlingEngine".equals(propertyName)) {
                    RequestBuildDialog.this.fHandlingEngine = (IBuildEngine)value;
                }
                RequestBuildDialog.this.notifyPropertyChanged(propertyName);
                RequestBuildDialog.this.revalidate();
            }

            @Override
            public void revalidate() {
                RequestBuildDialog.this.revalidate();
            }

            @Override
            public void layoutChanged() {
                RequestBuildDialog.this.handleLayoutChanged();
            }

            @Override
            public boolean isRebuild() {
                return RequestBuildDialog.this.fIsRebuild;
            }

            @Override
            public boolean isPersonalBuild() {
                return RequestBuildDialog.this.fIsPersonalBuild;
            }

            @Override
            public IBuildResult getBuildResult() {
                return RequestBuildDialog.this.fBuildResult;
            }

            @Override
            public IBuildRequest getBuildRequest() {
                return RequestBuildDialog.this.fBuildRequest;
            }

            @Override
            public IBuildDefinition getBuildDefinition() {
                return RequestBuildDialog.this.fBuildDefinition;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return RequestBuildDialog.this.fBuildDefinition == null ? null : (ITeamRepository)RequestBuildDialog.this.fBuildDefinition.getOrigin();
            }

            @Override
            public List<IBuildProperty> getOriginalBuildProperties() {
                return RequestBuildDialog.this.fOriginalBuildProperties;
            }

            @Override
            public IBuildEngine getHandlingEngine() {
                return RequestBuildDialog.this.fHandlingEngine;
            }

            @Override
            public void addErrorMessage(Object id, String errorMessage) {
                RequestBuildDialog.this.addErrorMessage(id, errorMessage);
            }

            @Override
            public void removeErrorMessage(Object id) {
                RequestBuildDialog.this.removeErrorMessage(id);
            }

            @Override
            public void addWarningMessage(Object id, String warningMessage) {
                RequestBuildDialog.this.addWarningMessage(id, warningMessage);
            }

            @Override
            public void removeWarningMessage(Object id) {
                RequestBuildDialog.this.removeWarningMessage(id);
            }
        };
    }

    protected SelectionListener getBrowseButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildDefinitionSelectionDialog selectionDialog = RequestBuildDialog.this.getSelectionDialog();
                if (selectionDialog.open() == 0) {
                    IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                    RequestBuildDialog.this.fBuildDefinitionHandle = definition;
                    RequestBuildDialog.this.fBuildDefinition = definition;
                    RequestBuildDialog.this.notifyPropertyChanged("buildDefinition");
                    RequestBuildDialog.this.handleInitializationComplete();
                }
            }
        };
    }

    protected void notifyPropertyChanged(String propertyName) {
        for (RequestBuildSection section : this.fSections) {
            section.handlePropertyChanged(propertyName);
        }
    }

    protected SelectionListener getShowBuildsViewButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(RequestBuildDialog.PREFERENCE_SHOW_BUILDS_VIEW, RequestBuildDialog.this.fShowBuildsViewCombo.getSelectionIndex());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected BuildDefinitionSelectionDialog getSelectionDialog() {
        return new BuildDefinitionSelectionDialog(this.getShell(), BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_TITLE, BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_MESSAGE, false, false);
    }

    private void handleLayoutChanged() {
        this.getShell().pack(true);
    }

    protected void handleInitializationComplete() {
        if (!this.fBuildDefinitionText.isDisposed()) {
            this.fShowBuildsViewCombo.setEnabled(true);
            this.fBuildDefinitionText.setText(this.fBuildDefinition.getId());
            this.fOriginalBuildProperties = this.fBuildDefinition.getProperties();
            this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
            if (this.fIsRebuild) {
                List requestProperties = this.fBuildRequest.getBuildDefinitionInstance().getProperties();
                this.fBuildDefinition.getProperties().clear();
                for (IBuildProperty requestProperty : requestProperties) {
                    if (requestProperty.getName().equals("scheduledBuild")) continue;
                    IBuildProperty newProperty = requestProperty.copyProperty();
                    this.fBuildDefinition.getProperties().add(newProperty);
                }
            }
            for (RequestBuildSection section : this.fSections) {
                section.initializationComplete();
            }
            this.revalidate();
            this.getContents().getParent().pack();
        }
    }

    protected IBuildDefinition getBuildDefinition(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        return (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 1, monitor);
    }

    private void initializeInBackground() {
        ITeamRepository jobTeamRepository = null;
        if (this.fBuildResultHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildResultHandle.getOrigin();
        } else if (this.fBuildDefinitionHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildDefinitionHandle.getOrigin();
        } else if (this.getPersistedDefinition() != null) {
            jobTeamRepository = (ITeamRepository)this.getPersistedDefinition().getOrigin();
        }
        String jobName = BuildUIDialogMessages.RequestBuildDialog_JOB_LABEL_INITIALIZING;
        this.fInitializationJob = new TeamBuildJob(jobName, true, jobTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (RequestBuildDialog.this.fBuildResultHandle != null) {
                    ITeamRepository teamRepository = (ITeamRepository)RequestBuildDialog.this.fBuildResultHandle.getOrigin();
                    RequestBuildDialog.this.fBuildResult = (IBuildResult)teamRepository.itemManager().fetchCompleteItem((IItemHandle)RequestBuildDialog.this.fBuildResultHandle, 1, monitor);
                    RequestBuildDialog.this.fBuildDefinitionHandle = RequestBuildDialog.this.fBuildResult.getBuildDefinition();
                }
                boolean isPersistedDefinition = false;
                if (RequestBuildDialog.this.fBuildDefinitionHandle == null) {
                    RequestBuildDialog.this.fBuildDefinitionHandle = RequestBuildDialog.this.getPersistedDefinition();
                    isPersistedDefinition = true;
                }
                if (RequestBuildDialog.this.fBuildDefinitionHandle != null) {
                    try {
                        RequestBuildDialog.this.fBuildDefinition = RequestBuildDialog.this.getBuildDefinition(RequestBuildDialog.this.fBuildDefinitionHandle, monitor);
                    }
                    catch (ItemNotFoundException exception) {
                        if (isPersistedDefinition) {
                            RequestBuildDialog.this.fBuildDefinitionHandle = null;
                            BuildUIPreferencesHelper.storeBuildDefinitionPreferences(new IBuildDefinition[0], RequestBuildDialog.PREFERENCE_DEFINITION);
                        }
                        throw exception;
                    }
                }
                if (RequestBuildDialog.this.fBuildDefinitionHandle == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).RequestBuildDialog.this.fBuildDefinitionText.isDisposed()) {
                                (this).RequestBuildDialog.this.fBuildDefinitionText.setText(BuildUIDialogMessages.RequestBuildDialog_NO_DEFINITION_SELECTED);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                if (RequestBuildDialog.this.fIsRebuild) {
                    RequestBuildDialog.this.fBuildRequest = RequestBuildDialog.this.getBuildRequest(RequestBuildDialog.this.fBuildResult, monitor);
                    RequestBuildDialog.this.fIsPersonalBuild = RequestBuildDialog.this.fBuildResult.isPersonalBuild();
                }
                for (RequestBuildSection section : RequestBuildDialog.this.fSections) {
                    section.initialize(monitor);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RequestBuildDialog.this.handleInitializationComplete();
                    }
                });
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.getSeverity() != 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RequestBuildDialog.this.close();
                        }
                    });
                }
                RequestBuildDialog.this.handleInitializationJobDone(this, status);
            }
        };
        this.fInitializationJob.schedule();
    }

    private IBuildDefinitionHandle getPersistedDefinition() {
        BuildDefinitionHandleHelper handleHelper;
        IBuildDefinitionHandle definitionHandle;
        ITeamRepository teamRepository;
        IBuildDefinitionHandle handle = null;
        List<BuildDefinitionHandleHelper> handleHelpers = BuildUIPreferencesHelper.getBuildDefinitionPreferences(PREFERENCE_DEFINITION);
        if (!handleHelpers.isEmpty() && (teamRepository = (ITeamRepository)(definitionHandle = (handleHelper = handleHelpers.get(0)).getBuildDefinitionHandle()).getOrigin()) != null && teamRepository.loggedIn()) {
            handle = definitionHandle;
        }
        return handle;
    }

    protected boolean isDefinitionSupported(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildEngineQueryModel.IBuildEngineQueryModel buildEngineQueryModel = IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildEngineQueryModel);
        query.filter(buildEngineQueryModel.active()._isTrue()._and(buildEngineQueryModel.supportedBuildDefinitions().itemId()._eq((IUUID)query.newUUIDArg())));
        query.select(query.count());
        IDataQueryPage page = client.queryData(query, new Object[]{buildDefinition.getItemId()}, 1, monitor);
        IDataRow row = page.getRow(0);
        return row.getInt(0) > 0;
    }

    protected void handleInitializationJobDone(TeamBuildJob job, IStatus status) {
    }

    protected void handleUnsupportedDefinition(IBuildDefinition buildDefinition) {
        MessageDialog dialog = this.getErrorDialog(BuildUIDialogMessages.RequestBuildDialog_ERROR_DIALOG_TITLE, NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_NO_SUPPORTING_ENGINES, (Object)buildDefinition.getId()));
        dialog.open();
    }

    protected void handleNoEnginesSupportingRequests(IBuildDefinition buildDefinition) {
        MessageDialog dialog = this.getErrorDialog(BuildUIDialogMessages.RequestBuildDialog_ERROR_DIALOG_TITLE, NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_NO_ENGINES_SUPPORT_REQUESTS, (Object)buildDefinition.getId()));
        dialog.open();
    }

    protected MessageDialog getErrorDialog(String title, String message) {
        return new MessageDialog(this.getParentShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected IBuildRequest getBuildRequest(IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        List buildRequestHandles = buildResult.getBuildRequests();
        ITeamRepository teamRepository = (ITeamRepository)buildResult.getOrigin();
        List buildRequests = teamRepository.itemManager().fetchCompleteItems(buildRequestHandles, 0, monitor);
        IBuildRequest buildRequest = null;
        for (IBuildRequest request : buildRequests) {
            if (request == null || !request.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) continue;
            buildRequest = request;
        }
        return buildRequest;
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected void okPressed() {
        this.requestBuild();
        super.okPressed();
    }

    protected void requestBuild() {
        this.requestBuild(this.fBuildDefinition);
    }

    protected void cancelPressed() {
        if (this.fInitializationJob != null) {
            this.fInitializationJob.cancel();
        }
        if (this.fRequestBuildJob != null) {
            this.fRequestBuildJob.cancel();
        }
        super.cancelPressed();
    }

    private String getConfirmationMessage(IBuildDefinition buildDefinition, boolean inProgress, boolean pendingRequest) {
        String message = null;
        if (inProgress) {
            message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_BUILD_ALREADY_IN_PROGRESS, (Object)buildDefinition.getId());
        } else if (pendingRequest) {
            message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_REQUEST_ALREADY_IN_QUEUE, (Object)buildDefinition.getId());
        }
        return message;
    }

    protected boolean isBuildInState(BuildState buildState, IBuildDefinition buildDefinition, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient buildClient = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        query.filter(buildResultQueryModel.buildState()._eq(buildState.name())._and(buildResultQueryModel.buildDefinition()._eq(query.newItemHandleArg())));
        query.select(query.count());
        IDataQueryPage page = buildClient.queryData(query, new Object[]{buildDefinition}, 1, progressMonitor);
        IDataRow row = page.getRow(0);
        return row.getInt(0) > 0;
    }

    protected boolean displayConfirmationPreExistingBuilds(final IBuildDefinition buildDefinition, final boolean inProgress, final boolean pendingRequest) {
        final boolean[] shouldMakeNewRequest = new boolean[]{true};
        if (inProgress || pendingRequest) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = RequestBuildDialog.this.getMessageDialog(RequestBuildDialog.this.getParentShell(), BuildUIDialogMessages.RequestBuildDialog_REQUEST_BUILD_TITLE, null, RequestBuildDialog.this.getConfirmationMessage(buildDefinition, inProgress, pendingRequest), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                    if (dialog.open() != 0) {
                        shouldMakeNewRequest[0] = false;
                    }
                }
            });
        }
        return shouldMakeNewRequest[0];
    }

    protected boolean displayConfirmationUnresponsiveEngine(final IBuildDefinition buildDefinition) {
        final boolean[] shouldMakeNewRequest = new boolean[]{true};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_ENGINES_NOT_PROCESSING, (Object)buildDefinition.getId());
                MessageDialog dialog = RequestBuildDialog.this.getMessageDialog(RequestBuildDialog.this.getParentShell(), BuildUIDialogMessages.RequestBuildDialog_REQUEST_BUILD_TITLE, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (dialog.open() != 0) {
                    shouldMakeNewRequest[0] = false;
                }
            }
        });
        return shouldMakeNewRequest[0];
    }

    protected boolean displayChangeShowPersonalBuildsInViewConfirmation() {
        final boolean[] shouldShowPersonalBuilds = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = RequestBuildDialog.this.getMessageDialog(RequestBuildDialog.this.getParentShell(), BuildUIDialogMessages.RequestBuildDialog_OPENING_BUILDS_VIEW_DIALOG_TITLE, null, BuildUIDialogMessages.RequestBuildDialog_SHOULD_SHOW_PERSONAL_BUILDS_QUESTION_MESSAGE, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (dialog.open() == 0) {
                    shouldShowPersonalBuilds[0] = true;
                }
            }
        });
        return shouldShowPersonalBuilds[0];
    }

    protected MessageDialog getMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        return new MessageDialog(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected void requestBuild(final IBuildDefinition buildDefinition) {
        final ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        BuildUIPreferencesHelper.storeBuildDefinitionPreferences(new IBuildDefinition[]{buildDefinition}, PREFERENCE_DEFINITION);
        this.fRequestBuildJob = new TeamBuildJob(BuildUIDialogMessages.REQUEST_BUILD_JOB_TITLE, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                return RequestBuildDialog.this.requestBuildJobImpl(buildDefinition, teamRepository, monitor);
            }
        };
        this.fRequestBuildJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                RequestBuildDialog.this.handleRequestJobCompleted(event);
            }
        });
        this.fRequestBuildJob.schedule();
    }

    protected IStatus requestBuildJobImpl(final IBuildDefinition buildDefinition, ITeamRepository teamRepository, IProgressMonitor monitor) throws Exception {
        if (this.fHandlingEngine == null) {
            if (!this.isDefinitionSupported(buildDefinition, monitor)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RequestBuildDialog.this.handleUnsupportedDefinition(buildDefinition);
                    }
                });
                return Status.OK_STATUS;
            }
            if (!this.anyEnginesSupportingRequests(buildDefinition, monitor)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RequestBuildDialog.this.handleNoEnginesSupportingRequests(buildDefinition);
                    }
                });
                return Status.OK_STATUS;
            }
            if (!this.anyResponsiveEngines((IBuildDefinitionHandle)buildDefinition, monitor) && !this.displayConfirmationUnresponsiveEngine(buildDefinition)) {
                return Status.OK_STATUS;
            }
        }
        if (!this.fIsPersonalBuild) {
            boolean inProgress = this.isBuildInState(BuildState.IN_PROGRESS, buildDefinition, monitor);
            boolean pendingRequest = false;
            if (!inProgress) {
                pendingRequest = this.isBuildInState(BuildState.NOT_STARTED, buildDefinition, monitor);
            }
            if ((inProgress || pendingRequest) && !this.displayConfirmationPreExistingBuilds(buildDefinition, inProgress, pendingRequest)) {
                return Status.OK_STATUS;
            }
        }
        for (RequestBuildSection section : this.fSections) {
            section.applyProperties(buildDefinition);
        }
        List newBuildProperties = buildDefinition.getProperties();
        Vector<IBuildProperty> deletedBuildProperties = new Vector<IBuildProperty>();
        if (this.fOriginalBuildProperties != null) {
            for (IBuildProperty originalProperty : this.fOriginalBuildProperties) {
                boolean deleted = true;
                for (IBuildProperty newProperty : newBuildProperties) {
                    if (!newProperty.getName().equals(originalProperty.getName())) continue;
                    deleted = false;
                    break;
                }
                if (!deleted) continue;
                deletedBuildProperties.add(originalProperty);
            }
        }
        IBuildProperty[] newPropertiesArray = newBuildProperties.toArray(new IBuildProperty[newBuildProperties.size()]);
        IBuildProperty[] deletedPropertiesArray = deletedBuildProperties.toArray(new IBuildProperty[deletedBuildProperties.size()]);
        IBuildRequest request = this.requestBuild(teamRepository, (IBuildDefinitionHandle)buildDefinition, newPropertiesArray, deletedPropertiesArray, true, monitor);
        final IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinition.getProcessArea(), 0, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RequestBuildDialog.this.handleAsyncShowBuildsView(processArea.getProjectArea(), buildDefinition);
            }
        });
        return Status.OK_STATUS;
    }

    private boolean anyEnginesSupportingRequests(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        return client.anyBuildEnginesWithRequestProcessingEnabled((IBuildDefinitionHandle)buildDefinition, monitor);
    }

    protected boolean anyResponsiveEngines(IBuildDefinitionHandle buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        return client.anyResponsiveBuildEngines(buildDefinition, monitor);
    }

    protected void handleAsyncShowBuildsView(IProjectAreaHandle projectAreaHandle, IBuildDefinition buildDefinition) {
        int buildsViewPreference = BuildUIPlugin.getDefault().getPreferenceStore().getInt(PREFERENCE_SHOW_BUILDS_VIEW);
        if (buildsViewPreference != 2) {
            this.showBuildsView(projectAreaHandle, buildDefinition, buildsViewPreference);
        }
    }

    protected void showBuildsView(IProjectAreaHandle projectAreaHandle, IBuildDefinition buildDefinition, int buildsViewOption) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        Boolean showPersonalBuilds = null;
        if (this.fIsPersonalBuild && !BuildQueryView.globalShowPersonalBuilds() && !BuildQueryView.globalShowMyPersonalBuilds()) {
            showPersonalBuilds = this.displayChangeShowPersonalBuildsInViewConfirmation();
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            Action action = buildsViewOption == 1 ? new ShowBuildQueueAction(projectAreaHandle, showPersonalBuilds) : new ShowHistoryAction(buildDefinition, showPersonalBuilds);
            action.run();
        }
    }

    protected void handleRequestJobCompleted(IJobChangeEvent event) {
    }

    protected IBuildRequest requestBuild(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] newAndModifiedBuildProperties, IBuildProperty[] deletedBuildProperties, boolean allowDuplicateRequests, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildRequestParams params = BuildItemFactory.createBuildRequestParams();
        params.setBuildDefinition(buildDefinitionHandle);
        params.getNewOrModifiedBuildProperties().addAll(Arrays.asList(newAndModifiedBuildProperties));
        params.getDeletedBuildProperties().addAll(Arrays.asList(deletedBuildProperties));
        params.setAllowDuplicateRequests(allowDuplicateRequests);
        params.setPersonalBuild(this.fIsPersonalBuild);
        if (this.fHandlingEngine != null) {
            params.getPotentialHandlers().add(this.fHandlingEngine);
        }
        return ClientFactory.getTeamBuildRequestClient((ITeamRepository)teamRepository).requestBuild(params, monitor);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fIsRebuild) {
            newShell.setText(BuildUIDialogMessages.RequestBuildDialog_DIALOG_TITLE_REQUEST_REBUILD);
        } else {
            newShell.setText(BuildUIDialogMessages.RequestBuildDialog_DIALOG_TITLE_REQUEST_BUILD);
        }
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setText(BuildUIDialogMessages.REQUEST_BUILD_SUBMIT);
        okButton.setEnabled(false);
        Button cancelButton = this.getButton(1);
        this.getShell().setDefaultButton(cancelButton);
        cancelButton.setFocus();
    }

    private void revalidate() {
        boolean valid = true;
        for (RequestBuildSection section : this.fSections) {
            if (section.validate2()) continue;
            valid = false;
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(valid);
    }

    public void setWorkbenchPartSite(IWorkbenchPartSite partSite) {
        this.fPartSite = partSite;
    }
}

