/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import java.util.ArrayList;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.Section;

public class PropertiesSection
extends RequestBuildSection {
    private IWorkbenchPartSite fPartSite;
    private Composite fPropertiesComposite;
    protected BuildPropertyControl fBuildPropertyControl;

    public PropertiesSection(RequestBuildSectionSite site) {
        super(site);
    }

    @Override
    protected String getSectionName() {
        if (this.getSite().isRebuild() && this.getSite().getBuildResult() != null) {
            return NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_REBUILD_PROPERTIES_LABEL, (Object)this.getSite().getBuildResult().getLabel());
        }
        return BuildUIDialogMessages.RequestBuildDialog_BUILD_PROPERTIES_LABEL;
    }

    @Override
    protected void createSectionContent(Section section) {
        if (this.fPropertiesComposite != null && !this.fPropertiesComposite.isDisposed()) {
            this.fPropertiesComposite.dispose();
        }
        this.fPropertiesComposite = new Composite((Composite)section, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 0).applyTo(this.fPropertiesComposite);
        section.setClient((Control)this.fPropertiesComposite);
        String disableEdit = this.getSite().getBuildDefinition().getPropertyValue("team.build.properties.disableUIEdit", "false");
        this.fBuildPropertyControl = new BuildPropertyControl(this.fPropertiesComposite, null, new ArrayList(), this.getSite().getTeamRepository(), !Boolean.parseBoolean(disableEdit), BuildPropertyControl.LayoutSize.COMPACT, BuildEngineHelper.supportsHiddenProperty((IBuildDefinition)this.getSite().getBuildDefinition()));
        this.fBuildPropertyControl.createAndRegisterDefaultContextMenu(this.fPartSite);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        this.fBuildPropertyControl.getComposite().setLayoutData((Object)gridData);
        this.fBuildPropertyControl.setBuildProperties(this.getSite().getBuildDefinition().getProperties());
    }

    @Override
    protected boolean grabVertical() {
        return true;
    }

    public void setWorkbenchPartSite(IWorkbenchPartSite partSite) {
        this.fPartSite = partSite;
    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        @Override
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new PropertiesSection(site);
        }
    }
}

