/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.common.MicrosoftBuildItem;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MicrosoftBuildInputDataDialog
extends Dialog {
    protected String fTitle;
    protected Shell fParentShell;
    protected Label fErrorMessageLabel;
    protected Text fBuildFileNameText;
    protected Text fBuildConfigurationText;
    protected Combo fBuildTypeCombo;
    protected Text fBuildLogFileText;
    protected Text fAdditionalArgumentsText;
    protected Text fWorkingDirectoryText;
    protected MicrosoftBuildItem fBuildItem;
    private String EMPTY = "";

    public MicrosoftBuildInputDataDialog(Shell parentShell, String title) {
        this(parentShell, title, null);
    }

    public MicrosoftBuildInputDataDialog(Shell parentShell, String title, MicrosoftBuildItem buildItem) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fBuildItem = buildItem;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        String message = BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_ADD_NEW_SOLUTION;
        this.createLabel(composite, message, null);
        this.fErrorMessageLabel = this.createLabel(composite, "", JFaceColors.getErrorText((Display)composite.getDisplay()));
        this.fBuildFileNameText = this.createText(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_SOLUTION_LABEL, this.EMPTY, 2);
        this.fBuildFileNameText.addModifyListener(this.getBuildFileNameModifiedListener());
        this.fBuildFileNameText.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_SOLUTION_DESC);
        this.fBuildConfigurationText = this.createText(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_CONFIG_LABEL, this.EMPTY, 2);
        this.fBuildConfigurationText.addModifyListener(this.getBuildConfigModifiedListener());
        this.fBuildConfigurationText.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_CONFIG_DESC);
        this.fBuildTypeCombo = this.createBuildTypeCombo(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_TYPE_LABEL, "Build", 2);
        this.fBuildTypeCombo.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_TYPE_DESC);
        this.fBuildLogFileText = this.createText(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_OUTPUT_LABEL, this.EMPTY, 2);
        this.fBuildLogFileText.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_OUTPUT_DESC);
        this.fAdditionalArgumentsText = this.createText(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_ADDITIONAL_ARG_LABEL, this.EMPTY, 2);
        this.fAdditionalArgumentsText.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_BUILD_ADDITIONAL_ARG_DESC);
        this.fWorkingDirectoryText = this.createText(composite, BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_WORKING_DIR_LABEL, this.EMPTY, 2);
        this.fWorkingDirectoryText.setToolTipText(BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_WORKING_DIR_DESC);
        MicrosoftBuildInputDataDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_msbuilditem");
        return composite;
    }

    public void create() {
        super.create();
        this.updateValues();
        this.validate(true);
    }

    private void updateValues() {
        if (this.fBuildItem != null) {
            this.fBuildFileNameText.setText(this.fBuildItem.getBuildFileName());
            this.fBuildConfigurationText.setText(this.fBuildItem.getBuildConfig());
            if (this.fBuildItem.getBuildType() != null) {
                this.fBuildTypeCombo.setText(this.fBuildItem.getBuildType());
            }
            this.fAdditionalArgumentsText.setText(this.fBuildItem.getAdditionalArguments());
            this.fBuildLogFileText.setText(this.fBuildItem.getBuildLogFile());
            this.fWorkingDirectoryText.setText(this.fBuildItem.getWorkingDir());
        }
    }

    protected void okPressed() {
        if (this.getErrorMessage() == null) {
            String buildType = this.fBuildTypeCombo.getText();
            if (this.fBuildItem == null) {
                this.fBuildItem = new MicrosoftBuildItem(this.fBuildFileNameText.getText().trim(), this.fBuildConfigurationText.getText().trim(), buildType, this.fAdditionalArgumentsText.getText().trim(), this.fBuildLogFileText.getText().trim(), this.fWorkingDirectoryText.getText().trim());
            } else {
                this.fBuildItem.setBuildFileName(this.fBuildFileNameText.getText().trim());
                this.fBuildItem.setBuildConfig(this.fBuildConfigurationText.getText().trim());
                this.fBuildItem.setBuildLogFile(this.fBuildLogFileText.getText().trim());
                this.fBuildItem.setBuildType(buildType);
                this.fBuildItem.setAdditionalArguments(this.fAdditionalArgumentsText.getText().trim());
                this.fBuildItem.setWorkingDir(this.fWorkingDirectoryText.getText().trim());
            }
        }
        super.okPressed();
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Combo createBuildTypeCombo(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Combo combo = new Combo(parent, 0);
        String[] items = new String[]{"Build", "ReBuild"};
        combo.setItems(items);
        combo.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private ModifyListener getBuildFileNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MicrosoftBuildInputDataDialog.this.validate(false);
            }
        };
    }

    private ModifyListener getBuildConfigModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MicrosoftBuildInputDataDialog.this.validate(false);
            }
        };
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.fErrorMessageLabel.setText("");
        } else {
            this.fErrorMessageLabel.setText(errorMessage);
        }
        this.fErrorMessageLabel.redraw();
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected String getErrorMessage() {
        if (this.fBuildFileNameText.getText().trim().equals(this.EMPTY)) {
            return BuildUIDialogMessages.MicrosoftSolutionInputDataDialog_SOLUTION_FILE_REQUIRED;
        }
        return null;
    }

    public MicrosoftBuildItem getBuildItem() {
        return this.fBuildItem;
    }
}

