/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.AddBuildEnginesDialog2;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class EditBuildEnginesDialog
extends AddBuildEnginesDialog2 {
    private String[] fSupportingBuildEngineIds;

    public EditBuildEnginesDialog(Shell parentShell, Map<String, String> buildEngineIdsToProjectAreaName, Collection<String> supportingBuildEngineIds, String currentProjectAreaName, Map<String, IBuildEngine> buildEngines, ITeamRepository repository, String projectAreaItemId) {
        super(parentShell, buildEngineIdsToProjectAreaName, supportingBuildEngineIds, currentProjectAreaName, buildEngines, repository, projectAreaItemId);
        this.fCurrentProjectAreaName = currentProjectAreaName;
        this.fBuildEngines = buildEngines;
        this.fProjectAreaEngineIds = new LinkedList();
        if (buildEngineIdsToProjectAreaName != null) {
            this.fIdNameMap = buildEngineIdsToProjectAreaName;
            if (currentProjectAreaName != null && !this.fCurrentProjectAreaName.equals(BuildUIMessages.UNKNOWN_PROJECT_AREA)) {
                for (String engineId : buildEngineIdsToProjectAreaName.keySet()) {
                    String projectAreaName = buildEngineIdsToProjectAreaName.get(engineId);
                    if (!this.fCurrentProjectAreaName.equals(projectAreaName)) continue;
                    this.fProjectAreaEngineIds.add(engineId);
                }
            }
        } else {
            this.fIdNameMap = new HashMap();
        }
        this.fSupportingBuildEngineIds = supportingBuildEngineIds != null ? supportingBuildEngineIds.toArray(new String[supportingBuildEngineIds.size()]) : new String[0];
    }

    private String formatWithProjectArea(Object element) {
        String engineId = element.toString();
        String areaName = (String)this.fIdNameMap.get(engineId);
        if (areaName == null) {
            areaName = BuildUIMessages.UNKNOWN_PROJECT_AREA;
        }
        return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)engineId, (Object)areaName);
    }

    @Override
    public Set<String> getChangedBuildEngineIds() {
        return this.getChangedItems();
    }

    @Override
    protected String getDialogDescription() {
        return BuildUIDialogMessages.EditBuildEnginesDialog_DESCRIPTION;
    }

    @Override
    protected String getDialogTitle() {
        return BuildUIDialogMessages.EditBuildEnginesDialog_TITLE;
    }

    @Override
    protected String getShowAllLabel() {
        return BuildUIDialogMessages.EditBuildEnginesDialog_SHOW_ALL_LABEL;
    }

    @Override
    protected String getShowSubSetLabel() {
        return BuildUIDialogMessages.EditBuildEnginesDialog_SHOW_PROJECT_AREA_LABEL;
    }

    @Override
    protected LabelProvider getLabelProvider(final boolean isSubSetDisplayed) {
        return new LabelProvider(){

            public final String getText(Object element) {
                if (isSubSetDisplayed) {
                    return super.getText(element);
                }
                return EditBuildEnginesDialog.this.formatWithProjectArea(element);
            }

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
            }
        };
    }

    @Override
    protected ViewerComparator getTableViewerComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getTopProject() {
                return EditBuildEnginesDialog.this.fCurrentProjectAreaName;
            }

            @Override
            protected String getProject(Object element) {
                return (String)EditBuildEnginesDialog.this.fIdNameMap.get(element);
            }
        };
    }

    @Override
    protected String[] getAllItems() {
        return this.fIdNameMap.keySet().toArray(new String[this.fIdNameMap.size()]);
    }

    @Override
    protected String[] getInitialItems() {
        return this.fSupportingBuildEngineIds;
    }

    @Override
    protected boolean isStartInSubSet() {
        return this.fProjectAreaEngineIds.size() > 0 && this.fProjectAreaEngineIds.containsAll(Arrays.asList(this.fSupportingBuildEngineIds));
    }

    @Override
    protected String getDescription(IStructuredSelection selection) {
        String engineId;
        IBuildEngine engine;
        if (selection.size() == 1 && (engine = (IBuildEngine)this.fBuildEngines.get(engineId = (String)selection.getFirstElement())) != null) {
            return engine.getDescription();
        }
        return null;
    }
}

