/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.AbstractEditItemsDialog;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class EditBuildDefinitionsDialog
extends AbstractEditItemsDialog {
    private Map<String, IBuildDefinition> fAllBuildDefinitionsMap = new HashMap<String, IBuildDefinition>();
    private Map<String, String> fIdNameMap = new HashMap<String, String>();
    private Collection<String> fProjectAreaBuildDefinitionIds = new LinkedList<String>();
    private String[] fSupportedBuildDefinitionIds;
    private String fBuildProjectAreaName;

    public EditBuildDefinitionsDialog(Shell parentShell, Map<IBuildDefinition, String> buildDefinitionToProjectAreaName, IBuildDefinition[] supportedBuildDefinitions, String buildProjectAreaName) {
        super(parentShell);
        this.fBuildProjectAreaName = buildProjectAreaName;
        if (buildDefinitionToProjectAreaName != null) {
            if (this.fBuildProjectAreaName == null || this.fBuildProjectAreaName.equals(BuildUIMessages.UNKNOWN_PROJECT_AREA)) {
                for (IBuildDefinition definition : buildDefinitionToProjectAreaName.keySet()) {
                    this.addDefinition(definition, buildDefinitionToProjectAreaName.get(definition));
                }
            } else {
                for (IBuildDefinition definition : buildDefinitionToProjectAreaName.keySet()) {
                    String projectAreaName = buildDefinitionToProjectAreaName.get(definition);
                    this.addDefinition(definition, projectAreaName);
                    if (!this.fBuildProjectAreaName.equals(projectAreaName)) continue;
                    this.fProjectAreaBuildDefinitionIds.add(definition.getId());
                }
            }
        }
        if (supportedBuildDefinitions != null) {
            this.fSupportedBuildDefinitionIds = new String[supportedBuildDefinitions.length];
            int i = 0;
            while (i < supportedBuildDefinitions.length) {
                String supportedId;
                this.fSupportedBuildDefinitionIds[i] = supportedId = supportedBuildDefinitions[i].getId();
                ++i;
            }
        } else {
            this.fSupportedBuildDefinitionIds = new String[0];
        }
    }

    private void addDefinition(IBuildDefinition definition, String projectAreaName) {
        String definitionId = definition.getId();
        this.fIdNameMap.put(definitionId, projectAreaName);
        this.fAllBuildDefinitionsMap.put(definitionId, definition);
    }

    private String formatWithProjectArea(Object element) {
        String definitionId = element.toString();
        String areaName = this.fIdNameMap.get(definitionId);
        if (areaName == null) {
            areaName = BuildUIMessages.UNKNOWN_PROJECT_AREA;
        }
        return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)definitionId, (Object)areaName);
    }

    public Set<IBuildDefinition> getChangedBuildDefinitions() {
        HashSet<IBuildDefinition> changedDefinitions = new HashSet<IBuildDefinition>();
        Iterator<String> changesAsItems = this.getChangedItems().iterator();
        while (changesAsItems.hasNext()) {
            changedDefinitions.add(this.fAllBuildDefinitionsMap.get(changesAsItems.next()));
        }
        return changedDefinitions;
    }

    @Override
    protected String getDialogDescription() {
        return BuildUIDialogMessages.EditBuildDefinitionsDialog_DESCRIPTION;
    }

    @Override
    protected String getDialogTitle() {
        return BuildUIDialogMessages.EditBuildDefinitionsDialog_TITLE;
    }

    @Override
    protected LabelProvider getLabelProvider(final boolean isSubSetDisplayed) {
        return new LabelProvider(){

            public final String getText(Object element) {
                if (isSubSetDisplayed) {
                    return super.getText(element);
                }
                return EditBuildDefinitionsDialog.this.formatWithProjectArea(element);
            }

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
            }
        };
    }

    @Override
    protected String getShowAllLabel() {
        return BuildUIDialogMessages.EditBuildDefinitionsDialog_SHOW_ALL_LABEL;
    }

    @Override
    protected String getShowSubSetLabel() {
        return BuildUIDialogMessages.EditBuildDefinitionsDialog_SHOW_PROJECT_AREA_LABEL;
    }

    @Override
    protected String[] getAllItems() {
        return this.fAllBuildDefinitionsMap.keySet().toArray(new String[this.fAllBuildDefinitionsMap.size()]);
    }

    @Override
    protected String[] getInitialItems() {
        return this.fSupportedBuildDefinitionIds;
    }

    @Override
    protected Collection<String> getSubSetItems() {
        return this.fProjectAreaBuildDefinitionIds;
    }

    @Override
    protected boolean isStartInSubSet() {
        return this.fProjectAreaBuildDefinitionIds.size() > 0 && this.fProjectAreaBuildDefinitionIds.containsAll(Arrays.asList(this.fSupportedBuildDefinitionIds));
    }

    @Override
    protected ViewerComparator getTableViewerComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getTopProject() {
                return EditBuildDefinitionsDialog.this.fBuildProjectAreaName;
            }

            @Override
            protected String getProject(Object element) {
                return (String)EditBuildDefinitionsDialog.this.fIdNameMap.get(element);
            }
        };
    }

    @Override
    protected String getDescription(IStructuredSelection selection) {
        String definitionId;
        IBuildDefinition definition;
        if (selection.size() == 1 && (definition = this.fAllBuildDefinitionsMap.get(definitionId = (String)selection.getFirstElement())) != null) {
            return definition.getDescription();
        }
        return null;
    }
}

