/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateReleaseDialog
extends Dialog {
    protected Text fReleaseNameText;
    protected Text fBuildTagText;
    protected Button fPrivateButton;
    private String fReleaseName;
    private String fBuildTag = "";
    private boolean fIsPrivate;

    public CreateReleaseDialog(Shell parentShell, String defaultReleaseName) {
        super(parentShell);
        this.fReleaseName = defaultReleaseName;
        this.fBuildTag = defaultReleaseName.replace(" ", "_");
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public String getReleaseName() {
        return this.fReleaseName;
    }

    public String getBuildTag() {
        return this.fBuildTag;
    }

    public boolean isReleasePrivate() {
        return this.fIsPrivate;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        dialogAreaComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        dialogAreaComposite.setLayoutData((Object)gridData);
        this.createLabel(dialogAreaComposite, BuildUIDialogMessages.CreateReleaseDialog_DESCRIPTION, null);
        Label label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        label = new Label(dialogAreaComposite, 0);
        label.setText(BuildUIDialogMessages.CreateReleaseDialog_RELEASE_NAME);
        label.setToolTipText(BuildUIDialogMessages.CreateReleaseDialog_RELEASE_NAME_TOOLTIP);
        label.setLayoutData((Object)new GridData());
        this.fReleaseNameText = new Text(dialogAreaComposite, 2048);
        this.fReleaseNameText.setText(this.fReleaseName);
        this.fReleaseNameText.setLayoutData((Object)new GridData(768));
        this.fReleaseNameText.addModifyListener(this.getNameTextModifyListener());
        this.fReleaseNameText.selectAll();
        label = new Label(dialogAreaComposite, 0);
        label.setText(BuildUIDialogMessages.CreateReleaseDialog_BUILD_TAG);
        label.setToolTipText(BuildUIDialogMessages.CreateReleaseDialog_BUILD_TAG_TOOLTIP);
        label.setLayoutData((Object)new GridData());
        this.fBuildTagText = new Text(dialogAreaComposite, 2048);
        this.fBuildTagText.setText(this.fBuildTag);
        this.fBuildTagText.setLayoutData((Object)new GridData(768));
        this.fBuildTagText.addModifyListener(this.getTagTextModifyListener());
        label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        this.fPrivateButton = new Button(dialogAreaComposite, 32);
        this.fPrivateButton.setText(BuildUIDialogMessages.CreateReleaseDialog_PRIVATE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fPrivateButton.setLayoutData((Object)gridData);
        this.fPrivateButton.addSelectionListener(this.getPrivateButtonListener());
        CreateReleaseDialog.applyDialogFont((Control)dialogAreaComposite);
        this.fReleaseNameText.setFocus();
        if (this.fReleaseNameText.getText().equals("")) {
            Button okButton = this.getButton(0);
            okButton.setEnabled(false);
        }
        return dialogAreaComposite;
    }

    private ModifyListener getNameTextModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateReleaseDialog.this.fReleaseName = CreateReleaseDialog.this.fReleaseNameText.getText();
                Button okButton = CreateReleaseDialog.this.getButton(0);
                okButton.setEnabled(CreateReleaseDialog.this.fReleaseNameText.getText().length() > 0);
            }
        };
    }

    protected ModifyListener getTagTextModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateReleaseDialog.this.fBuildTag = CreateReleaseDialog.this.fBuildTagText.getText().replace(" ", "_");
            }
        };
    }

    protected SelectionListener getPrivateButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateReleaseDialog.this.fIsPrivate = CreateReleaseDialog.this.fPrivateButton.getSelection();
            }
        };
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BuildUIDialogMessages.CreateReleaseDialog_TITLE);
    }
}

