/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.SortedMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class BuildResultAttachmentFileDialog
extends Dialog {
    protected Section fAdvancedSection;
    protected Label fErrorMessageLabel;
    protected Text fComponentNameText;
    protected Text fContentTypeText;
    protected Combo fCharacterEncodingDropdown;
    protected Text fFileNameText;
    protected Text fFileDescriptionText;
    protected String fOriginalFilePath;
    protected String fOriginalFileDescription;
    protected String fOriginalComponentName;
    protected String fOriginalContentType;
    protected String fOriginalCharacterEncoding;
    protected String fFilePath;
    protected String fFileDescription;
    protected String fComponentName;
    protected String fContentType;
    protected String fCharacterEncoding;
    protected static String[] fAvailableCharacterSets;
    protected boolean fFilePathChanged = false;
    protected boolean fIsLink;
    protected boolean fIsAdd;
    protected boolean fIsFileSaved;
    protected Button fBrowseButton;

    public static BuildResultAttachmentFileDialog createAddFileDialog(Shell parentShell, String componentName) {
        return new BuildResultAttachmentFileDialog(parentShell, componentName, false);
    }

    public static BuildResultAttachmentFileDialog createAddLinkDialog(Shell parentShell, String componentName) {
        return new BuildResultAttachmentFileDialog(parentShell, componentName, true);
    }

    public static BuildResultAttachmentFileDialog createEditFileDialog(Shell parentShell, String filePath, String fileDescription, String componentName, String contentType, String characterEncoding, boolean isSaved) {
        return new BuildResultAttachmentFileDialog(parentShell, filePath, fileDescription, componentName, contentType, characterEncoding, false, isSaved);
    }

    public static BuildResultAttachmentFileDialog createEditLinkDialog(Shell parentShell, String linkURL, String linkDescription, String componentName) {
        return new BuildResultAttachmentFileDialog(parentShell, linkURL, linkDescription, componentName, null, null, true, true);
    }

    protected BuildResultAttachmentFileDialog(Shell parentShell, String filePath, String fileDescription, String componentName, String contentType, String characterEncoding, boolean isLink, boolean isSaved) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"parentShell", (Object)parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fFilePath = filePath == null ? "" : filePath;
        this.fOriginalFilePath = this.fFilePath;
        this.fFileDescription = fileDescription == null ? "" : fileDescription;
        this.fOriginalFileDescription = this.fFileDescription;
        this.fComponentName = componentName == null ? "" : componentName;
        this.fOriginalComponentName = this.fComponentName;
        this.fContentType = contentType == null ? "" : contentType;
        this.fOriginalContentType = this.fContentType;
        this.fCharacterEncoding = characterEncoding == null ? "" : characterEncoding;
        this.fOriginalCharacterEncoding = this.fCharacterEncoding;
        this.fIsLink = isLink;
        this.fIsFileSaved = isSaved;
        this.fIsAdd = false;
    }

    protected BuildResultAttachmentFileDialog(Shell parentShell, String componentName, boolean isLink) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"parentShell", (Object)parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fFilePath = "";
        this.fOriginalFilePath = "";
        this.fFileDescription = "";
        this.fOriginalFileDescription = "";
        this.fComponentName = componentName == null ? "" : componentName;
        this.fOriginalComponentName = this.fComponentName;
        this.fContentType = "";
        this.fOriginalContentType = "";
        this.fCharacterEncoding = "";
        this.fOriginalCharacterEncoding = "";
        this.fIsLink = isLink;
        this.fIsFileSaved = false;
        this.fIsAdd = true;
    }

    public boolean isDirty() {
        boolean filePathChanged;
        boolean bl = this.fIsLink ? !this.fOriginalFilePath.equals(this.fFilePath) : (filePathChanged = this.fFilePathChanged);
        return filePathChanged || !this.fOriginalFileDescription.equals(this.fFileDescription) || !this.fOriginalComponentName.equals(this.fComponentName) || !this.fOriginalContentType.equals(this.fContentType) || !this.fOriginalCharacterEncoding.equals(this.fCharacterEncoding);
    }

    public boolean isFilePathChanged() {
        return this.fFilePathChanged;
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public String getFileDescription() {
        return this.fFileDescription;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public String getCharacterEncoding() {
        return this.fCharacterEncoding;
    }

    public int open() {
        if (!this.fIsLink && this.fOriginalFilePath.length() == 0) {
            String filePath = this.promptUserForFile();
            if (filePath == null) {
                return 1;
            }
            this.fFilePath = filePath;
        }
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.fIsLink) {
            this.getButton(0).setEnabled(this.fOriginalFilePath.trim().length() != 0);
        } else if (this.fIsAdd) {
            this.validateFileName(this.fFilePath);
        } else {
            this.updateContentTypeAndCharacterEncoding(!this.fIsFileSaved, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        String message = this.fIsLink ? BuildUIDialogMessages.BuildResultAttachmentFileDialog_ADD_LINK_MESSAGE : BuildUIDialogMessages.BuildResultAttachmentFileDialog_ADD_FILE_MESSAGE;
        new Label(dialogComposite, 0).setText(message);
        this.fErrorMessageLabel = new Label(dialogComposite, 0);
        this.fErrorMessageLabel.setForeground(JFaceColors.getErrorText((Display)dialogComposite.getDisplay()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fErrorMessageLabel);
        Composite optionsComposite = new Composite(dialogComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(optionsComposite);
        GridDataFactory.fillDefaults().applyTo((Control)optionsComposite);
        String nameLabel = this.fIsLink ? BuildUIDialogMessages.BuildResultAttachmentFileDialog_LINK_URL_LABEL : BuildUIDialogMessages.BuildResultAttachmentFileDialog_FILE_NAME_LABEL;
        String filePath = this.fIsLink ? this.fOriginalFilePath : new File(this.fOriginalFilePath).getName();
        this.fFileNameText = this.createText(optionsComposite, nameLabel, filePath, this.fIsLink ? 2 : 1);
        this.fFileNameText.setEditable(this.fIsLink);
        if (!this.fIsLink) {
            this.fBrowseButton = new Button(optionsComposite, 0);
            this.fBrowseButton.setText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_BROWSE_BUTTON_LABEL);
            this.fBrowseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
        }
        this.fFileDescriptionText = this.createText(optionsComposite, BuildUIDialogMessages.DESCRIPTION_LABEL, this.fOriginalFileDescription, 2);
        this.fComponentNameText = this.createText(optionsComposite, BuildUIDialogMessages.BuildResultAttachmentFileDialog_COMPONENT_NAME_LABEL, this.fOriginalComponentName, 2);
        if (!this.fIsLink) {
            this.fAdvancedSection = new Section(dialogComposite, 50);
            GridLayoutFactory.fillDefaults().applyTo((Composite)this.fAdvancedSection);
            GridDataFactory.fillDefaults().indent(0, 10).grab(true, true).applyTo((Control)this.fAdvancedSection);
            this.fAdvancedSection.setText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_ADVANCED_OPTIONS);
            Composite advancedComposite = new Composite((Composite)this.fAdvancedSection, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 10, 0).numColumns(3).applyTo(advancedComposite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)advancedComposite);
            this.fAdvancedSection.setClient((Control)advancedComposite);
            this.fAdvancedSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    BuildResultAttachmentFileDialog.this.handleExpansionStateChanged();
                }
            });
            this.fContentTypeText = this.createText(advancedComposite, BuildUIDialogMessages.BuildResultAttachmentFileDialog_CONTENT_TYPE_LABEL, this.fOriginalContentType, 2);
            this.fContentTypeText.setToolTipText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_CONTENT_TYPE_TOOLTIP);
            if (fAvailableCharacterSets == null) {
                SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
                fAvailableCharacterSets = availableCharsets.keySet().toArray(new String[availableCharsets.size()]);
            }
            this.fCharacterEncodingDropdown = this.createDropdown(advancedComposite, BuildUIDialogMessages.BuildResultAttachmentFileDialog_CHARACTER_ENCODING_LABEL, this.fOriginalCharacterEncoding, fAvailableCharacterSets, BuildUIDialogMessages.BuildResultAttachmentFileDialog_CHARACTER_ENCODING_TOOLTIP, 2);
            this.fContentTypeText.addModifyListener(this.getContentTypeModifiedListener());
            this.fCharacterEncodingDropdown.addModifyListener(this.getCharacterEncodingModifiedListener());
            this.fCharacterEncodingDropdown.addSelectionListener(this.getCharacterEncodingSelectionListener());
        } else {
            this.fFileNameText.addModifyListener(this.getFileNameModifiedListener());
        }
        this.fFileDescriptionText.addModifyListener(this.getDescriptionModifiedListener());
        this.fComponentNameText.addModifyListener(this.getComponentNameModifiedListener());
        BuildResultAttachmentFileDialog.applyDialogFont((Control)dialogComposite);
        if (this.fIsLink) {
            this.fFileNameText.setFocus();
        } else {
            this.fFileDescriptionText.setFocus();
        }
        return dialogComposite;
    }

    private void handleExpansionStateChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildResultAttachmentFileDialog.this.getContents().getParent().pack();
            }
        });
    }

    protected ModifyListener getFileNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildResultAttachmentFileDialog.this.validateUrl(BuildResultAttachmentFileDialog.this.fFileNameText.getText());
            }
        };
    }

    protected ModifyListener getDescriptionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildResultAttachmentFileDialog.this.fFileDescription = BuildResultAttachmentFileDialog.this.fFileDescriptionText.getText();
            }
        };
    }

    protected ModifyListener getComponentNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildResultAttachmentFileDialog.this.fComponentName = BuildResultAttachmentFileDialog.this.fComponentNameText.getText();
            }
        };
    }

    protected ModifyListener getContentTypeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildResultAttachmentFileDialog.this.fContentType = BuildResultAttachmentFileDialog.this.fContentTypeText.getText();
                BuildResultAttachmentFileDialog.this.updateCharacterEncodingEnablement(true);
            }
        };
    }

    protected SelectionListener getCharacterEncodingSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildResultAttachmentFileDialog.this.validateCharacterEncoding(BuildResultAttachmentFileDialog.this.fCharacterEncodingDropdown.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BuildResultAttachmentFileDialog.this.validateCharacterEncoding(BuildResultAttachmentFileDialog.this.fCharacterEncodingDropdown.getText());
            }
        };
    }

    protected ModifyListener getCharacterEncodingModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildResultAttachmentFileDialog.this.validateCharacterEncoding(BuildResultAttachmentFileDialog.this.fCharacterEncodingDropdown.getText());
            }
        };
    }

    protected void validateCharacterEncoding(String characterEncoding) {
        boolean enabled = characterEncoding.length() == 0 || Charset.isSupported(characterEncoding);
        String errorMessage = "";
        if (enabled) {
            this.fCharacterEncoding = characterEncoding;
        } else {
            errorMessage = NLS.bind((String)BuildUIDialogMessages.BuildResultAttachmentFileDialog_CHARACTER_SET_NOT_SUPPORTED_ERROR_MESSAGE, (Object)characterEncoding, (Object[])new Object[0]);
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
        this.fErrorMessageLabel.setText(errorMessage);
    }

    protected void validateUrl(String url) {
        boolean enabled = true;
        String errorMessage = "";
        if (url.trim().length() == 0) {
            enabled = false;
        } else {
            try {
                new URL(url);
                this.fFilePath = url;
            }
            catch (MalformedURLException exception) {
                enabled = false;
                errorMessage = BuildUIDialogMessages.BuildResultAttachmentFileDialog_MALFORMED_URL;
            }
        }
        this.getButton(0).setEnabled(enabled);
        this.fErrorMessageLabel.setText(errorMessage);
    }

    protected boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    protected void validateFileName(String fileName) {
        boolean enabled = true;
        String errorMessage = "";
        this.fFileNameText.setText(new File(fileName).getName());
        if (!this.fileExists(fileName)) {
            enabled = false;
            errorMessage = BuildUIDialogMessages.BuildResultAttachmentFileDialog_FILE_NOT_EXIST;
        } else {
            this.fFilePathChanged = true;
            this.fFilePath = fileName;
            this.fIsFileSaved = false;
        }
        this.updateContentTypeAndCharacterEncoding(enabled && !this.fIsFileSaved, true);
        this.fErrorMessageLabel.setText(errorMessage);
        this.getButton(0).setEnabled(enabled);
    }

    protected void updateContentTypeAndCharacterEncoding(boolean enabled, boolean updateContentType) {
        if (enabled) {
            this.fContentTypeText.setEnabled(true);
            if (updateContentType) {
                this.fContentType = ContentUtil.getContentTypeFromFileName((String)this.fFilePath);
                if (this.fContentType == null) {
                    this.fContentType = "";
                }
                this.fContentTypeText.setText(this.fContentType);
            } else {
                this.updateCharacterEncodingEnablement(false);
            }
        } else {
            this.fContentTypeText.setEnabled(false);
            this.fCharacterEncodingDropdown.setEnabled(false);
        }
    }

    protected void updateCharacterEncodingEnablement(boolean updateEncoding) {
        boolean isTextContent = ContentUtil.isTextContentType((String)this.fContentType);
        if (updateEncoding) {
            this.fCharacterEncoding = isTextContent ? Charset.defaultCharset().name() : "";
            this.fCharacterEncodingDropdown.setText(this.fCharacterEncoding);
        }
        this.fCharacterEncodingDropdown.setEnabled(isTextContent);
    }

    protected SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = BuildResultAttachmentFileDialog.this.promptUserForFile();
                if (filePath != null) {
                    BuildResultAttachmentFileDialog.this.validateFileName(filePath);
                }
            }
        };
    }

    protected String promptUserForFile() {
        FileDialog fileDialog = new FileDialog(this.getParentShell(), 4096);
        fileDialog.setText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_ADD_FILE_SELECTION_DIALOG_TITLE);
        return fileDialog.open();
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Combo createDropdown(Composite parent, String labelText, String defaultText, String[] items, String tooltip, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Combo combo = new Combo(parent, 2048);
        combo.setVisibleItemCount(Math.min(20, items.length));
        combo.setItems(items);
        combo.setText(defaultText);
        combo.setToolTipText(tooltip);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fIsLink) {
            newShell.setText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_LINK_TITLE);
        } else {
            newShell.setText(BuildUIDialogMessages.BuildResultAttachmentFileDialog_FILE_TITLE);
        }
    }
}

