/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtension;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtensionManager;
import com.ibm.team.build.internal.ui.properties.BuildPropertyLabelHelper;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BuildPropertyDialog
extends Dialog {
    private static final String EMPTY_STRING = "";
    protected final String fTitle;
    protected Label fErrorMessageLabel;
    protected Text fPropertyNameText;
    protected Text fPropertyValueText;
    protected Text fPropertyDescriptionText;
    protected Composite fPropertyValueComposite;
    protected final List fExistingProperties;
    protected final IBuildProperty fBuildProperty;
    protected final IBuildProperty fEditBuildProperty;
    protected final boolean fIsNewProperty;
    protected final Shell fParentShell;
    protected final ITeamRepository fTeamRepository;
    protected AbstractBuildPropertyEditor fPropertyEditor;
    private final boolean fSupportsAddingHiddenProperty;
    private Button fEditButton;
    private Button fHiddenButton;

    public BuildPropertyDialog(Shell parentShell, String title, IBuildProperty buildProperty, List<IBuildProperty> existingProperties, boolean isNewProperty, ITeamRepository teamRepository) {
        this(parentShell, title, buildProperty, existingProperties, isNewProperty, teamRepository, false);
    }

    public BuildPropertyDialog(Shell parentShell, String title, IBuildProperty buildProperty, List existingProperties, boolean isNewProperty, ITeamRepository teamRepository, boolean supportsAddingHiddenProperty) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fExistingProperties = existingProperties;
        this.fBuildProperty = buildProperty;
        this.fEditBuildProperty = this.fBuildProperty.copyProperty();
        this.fIsNewProperty = isNewProperty;
        this.fTeamRepository = teamRepository;
        this.fPropertyEditor = this.getPropertyEditor(buildProperty);
        this.fSupportsAddingHiddenProperty = supportsAddingHiddenProperty;
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.fErrorMessageLabel.setText(EMPTY_STRING);
        } else {
            this.fErrorMessageLabel.setText(errorMessage);
        }
        this.fErrorMessageLabel.redraw();
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    private void disableDialog() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    protected String getPropertyNameTextValue() {
        return this.fPropertyNameText.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        composite.setLayoutData((Object)gridData);
        String message = BuildUIDialogMessages.PROPERTY_HEADER;
        if (this.fBuildProperty.isRequired() || this.fBuildProperty.isWellKnown()) {
            message = BuildUIDialogMessages.PROPERTY_HEADER_REQUIRED;
        }
        this.createLabel(composite, message, null);
        this.fErrorMessageLabel = this.createLabel(composite, EMPTY_STRING, JFaceColors.getErrorText((Display)composite.getDisplay()));
        int horizontalSpan = 2;
        boolean addEditButton = false;
        if (this.fPropertyEditor != null) {
            addEditButton = true;
            horizontalSpan = 1;
        }
        String valueText = EMPTY_STRING;
        if (!this.fIsNewProperty) {
            valueText = BuildUIDialogMessages.BuildPropertyDialog_FETCHING_VALUE;
        }
        this.fPropertyNameText = this.createText(composite, BuildUIDialogMessages.PROPERTY_NAME, this.fBuildProperty.getName(), 2);
        this.fPropertyValueText = this.createText(composite, BuildUIDialogMessages.PROPERTY_VALUE, valueText, horizontalSpan);
        if (addEditButton) {
            this.fEditButton = new Button(composite, 0);
            this.fEditButton.setText(BuildUIDialogMessages.BuildPropertyDialog_EDIT_BUTTON_LABEL);
            this.fEditButton.addSelectionListener(this.getEditButtonSelectionListener());
            IBuildPropertyEditorContext context = this.getPropertyEditorContext(this.fBuildProperty, this.fParentShell, this.fTeamRepository);
            this.fPropertyValueText.setEnabled(false);
            if (!this.fIsNewProperty) {
                if (this.fBuildProperty.isHidden()) {
                    if (EMPTY_STRING.equals(this.fBuildProperty.getValue())) {
                        this.fPropertyValueText.setText(EMPTY_STRING);
                    } else {
                        this.fPropertyValueText.setText("*****");
                    }
                } else {
                    BuildPropertyLabelHelper labelHelper = this.getLabelHelper();
                    labelHelper.getPropertyValueLabelInBackground(this.fPropertyEditor, context);
                }
            }
        } else if (this.fBuildProperty.isHidden() && !this.fIsNewProperty && !this.fBuildProperty.getValue().equals(EMPTY_STRING)) {
            this.fPropertyValueText.setText("*****");
        } else {
            this.fPropertyValueText.setText(this.getPropertyValueToEdit(this.fBuildProperty, this.fBuildProperty.getValue()));
        }
        if (this.fSupportsAddingHiddenProperty && this.fIsNewProperty || !this.fIsNewProperty && this.fBuildProperty.isHidden()) {
            Label hiddenLabel = new Label(composite, 0);
            hiddenLabel.setText(BuildUIDialogMessages.BuildPropertyDIalog_HIDDEN_BUTTON_LABEL);
            this.fHiddenButton = new Button(composite, 48);
            this.fHiddenButton.addSelectionListener(this.getHiddenButtonSelectionListener());
            this.fHiddenButton.setSelection(this.fBuildProperty.isHidden());
            hiddenLabel.setLayoutData((Object)new GridData());
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.fHiddenButton);
            if (!this.fIsNewProperty) {
                this.fHiddenButton.setEnabled(false);
            }
        }
        this.fPropertyDescriptionText = this.createText(composite, BuildUIDialogMessages.DESCRIPTION_LABEL, this.fBuildProperty.getDescription(), 2);
        if (this.fBuildProperty.isRequired() || this.fBuildProperty.isWellKnown()) {
            this.fPropertyNameText.setEditable(false);
            this.fPropertyDescriptionText.setEditable(false);
        }
        if (!addEditButton && this.fBuildProperty.isHidden() && !this.fIsNewProperty && !this.fBuildProperty.getValue().equals(EMPTY_STRING)) {
            ValueFieldResetFocusListener focusListener = new ValueFieldResetFocusListener();
            this.fPropertyValueText.addFocusListener((FocusListener)focusListener);
            if (this.fPropertyNameText.getEditable()) {
                this.fPropertyNameText.addFocusListener((FocusListener)focusListener);
            }
            if (this.fPropertyDescriptionText.getEditable()) {
                this.fPropertyDescriptionText.addFocusListener((FocusListener)focusListener);
            }
        }
        this.fPropertyNameText.addModifyListener(this.getNameModifiedListener());
        this.fPropertyDescriptionText.addModifyListener(this.getDescriptionModifiedListener());
        this.fPropertyValueText.addModifyListener(this.getValueModifiedListener());
        BuildPropertyDialog.applyDialogFont((Control)composite);
        if (!this.fIsNewProperty && !addEditButton) {
            if (!this.fBuildProperty.isHidden()) {
                this.fPropertyValueText.setFocus();
                this.fPropertyValueText.selectAll();
            }
        } else {
            this.fPropertyNameText.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_buildproperty");
        return composite;
    }

    private SelectionListener getHiddenButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkboxButton = (Button)e.getSource();
                boolean selected = checkboxButton.getSelection();
                if (BuildPropertyDialog.this.fPropertyValueComposite != null && BuildPropertyDialog.this.fIsNewProperty && BuildPropertyDialog.this.fPropertyEditor == null) {
                    BuildPropertyDialog.this.disableDialog();
                    int style = 2048;
                    Text oldfPropertyValueText = BuildPropertyDialog.this.fPropertyValueText;
                    String oldValue = oldfPropertyValueText.getText();
                    oldfPropertyValueText.removeModifyListener(BuildPropertyDialog.this.getValueModifiedListener());
                    Control[] controlArray = BuildPropertyDialog.this.fPropertyValueComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.dispose();
                        ++n2;
                    }
                    if (selected) {
                        style |= 0x400000;
                    }
                    BuildPropertyDialog.this.fPropertyValueText = new Text(BuildPropertyDialog.this.fPropertyValueComposite, style);
                    BuildPropertyDialog.this.fPropertyValueText.setText(oldValue);
                    BuildPropertyDialog.this.fPropertyValueText.addModifyListener(BuildPropertyDialog.this.getValueModifiedListener());
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)BuildPropertyDialog.this.fPropertyValueText);
                    BuildPropertyDialog.this.fPropertyValueComposite.redraw();
                    BuildPropertyDialog.this.fPropertyValueComposite.getParent().redraw();
                    BuildPropertyDialog.this.fPropertyValueComposite.layout();
                }
                BuildPropertyDialog.this.validate(false);
            }
        };
    }

    private String getPropertyValueToEdit(IBuildProperty buildProperty, String value) {
        if (BuildEngineHelper.isBuildForgeHiddenProperty((IBuildProperty)buildProperty) && value != null) {
            if ("*****".equals(value)) {
                return EMPTY_STRING;
            }
            value = this.getPropertyValueToEditForHiddenProperty(buildProperty, value);
        } else if (buildProperty.isHidden()) {
            value = this.getPropertyValueToEditForHiddenProperty(buildProperty, value);
        }
        return value;
    }

    private String getPropertyValueToEditForHiddenProperty(IBuildProperty buildProperty, String value) {
        String deobfuscated = value;
        try {
            deobfuscated = ObfuscationHelper.decryptString((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (BuildEngineHelper.isDummyPassword((String)deobfuscated) || BuildEngineHelper.startsWithDummyPassword((String)deobfuscated)) {
            return EMPTY_STRING;
        }
        return value;
    }

    private BuildPropertyLabelHelper getLabelHelper() {
        return new BuildPropertyLabelHelper(){

            @Override
            public void labelAvailable(String label, IBuildProperty buildProperty) {
                if (!BuildPropertyDialog.this.fPropertyValueText.isDisposed()) {
                    BuildPropertyDialog.this.fPropertyValueText.setText(BuildPropertyDialog.this.getPropertyValueToEdit(buildProperty, label));
                }
            }
        };
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
            }
        };
    }

    private ModifyListener getDescriptionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
            }
        };
    }

    private ModifyListener getValueModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
            }
        };
    }

    private SelectionListener getEditButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyDialog.this.editProperty(BuildPropertyDialog.this.fEditBuildProperty);
            }
        };
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        int heightHint;
        boolean isDescription;
        boolean isHiddenValue;
        boolean shouldAddPropertyComposite;
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        int style = 2048;
        boolean bl = shouldAddPropertyComposite = labelText.equals(BuildUIDialogMessages.PROPERTY_VALUE) && this.fIsNewProperty && this.fPropertyEditor == null;
        if (shouldAddPropertyComposite) {
            this.fPropertyValueComposite = new Composite(parent, 4);
            GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).equalWidth(false).applyTo(this.fPropertyValueComposite);
        }
        boolean bl2 = isHiddenValue = labelText.equals(BuildUIDialogMessages.PROPERTY_VALUE) && (this.fBuildProperty.isHidden() || BuildEngineHelper.isBuildForgeHiddenProperty((IBuildProperty)this.fBuildProperty));
        if (isHiddenValue) {
            style |= 0x400000;
        }
        style = (isDescription = labelText.equals(BuildUIDialogMessages.DESCRIPTION_LABEL)) ? (style |= 0x42) : (style |= 4);
        Text text = null;
        text = shouldAddPropertyComposite ? new Text(this.fPropertyValueComposite, style) : new Text(parent, style);
        text.setText(defaultText);
        int n = heightHint = isDescription ? text.computeSize((int)300, (int)(text.getLineHeight() * 3)).y : -1;
        if (shouldAddPropertyComposite) {
            GridDataFactory.fillDefaults().span(textHorizontalSpan, 1).hint(100, heightHint).grab(true, false).applyTo((Control)this.fPropertyValueComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        } else {
            GridDataFactory.fillDefaults().span(textHorizontalSpan, 1).hint(100, heightHint).grab(true, isDescription).applyTo((Control)text);
        }
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        if (this.fBuildProperty.isHidden()) {
            this.disableDialog();
            Button cancelButton = this.getButton(1);
            cancelButton.setFocus();
        } else {
            this.validate(true);
        }
    }

    protected List getExistingProperties() {
        return this.fExistingProperties;
    }

    protected String getErrorMessage() {
        String proposedPropertyName = this.getPropertyNameTextValue();
        if (proposedPropertyName.equals(EMPTY_STRING)) {
            return BuildUIDialogMessages.PROPERTY_NAME_REQUIRED;
        }
        if (this.propertyNameConflict(proposedPropertyName)) {
            return BuildUIDialogMessages.PROPERTY_EXISTS;
        }
        Pattern p = Pattern.compile("\\s");
        Matcher m = p.matcher(proposedPropertyName);
        if (m.find()) {
            return BuildUIDialogMessages.PROPERTY_NAME_NO_SPACES;
        }
        return null;
    }

    protected boolean propertyNameConflict(String name) {
        if (this.fBuildProperty.getName().length() != 0 && this.fBuildProperty.getName().equals(name)) {
            return false;
        }
        List properties = this.getExistingProperties();
        for (Object object : properties) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void editProperty(IBuildProperty buildProperty) {
        IBuildPropertyEditorContext context = this.getPropertyEditorContext(buildProperty, this.getShell(), this.fTeamRepository);
        if (this.fPropertyEditor.editProperty(context)) {
            this.fPropertyValueText.setText(BuildUIDialogMessages.BuildPropertyDialog_FETCHING_VALUE);
            BuildPropertyLabelHelper labelHelper = this.getLabelHelper();
            labelHelper.getPropertyValueLabelInBackground(this.fPropertyEditor, context);
        }
    }

    public AbstractBuildPropertyEditor getPropertyEditor(IBuildProperty buildProperty) {
        AbstractBuildPropertyEditor editor = null;
        String editorId = buildProperty.getKind();
        if (BuildEngineHelper.isBuildForgePulldownProperty((IBuildProperty)buildProperty)) {
            editorId = "com.ibm.team.build.property.pulldown";
        }
        try {
            BuildPropertyEditorExtension extension = BuildPropertyEditorExtensionManager.getInstance().getBuildPropertyEditor(editorId);
            if (extension != null) {
                editor = extension.createPropertyEditor();
            }
        }
        catch (CoreException exception) {
            this.handlePropertyEditorException(exception);
        }
        return editor;
    }

    protected IBuildPropertyEditorContext getPropertyEditorContext(final IBuildProperty buildProperty, final Shell parent, ITeamRepository teamRepository) {
        return new IBuildPropertyEditorContext(){

            @Override
            public IBuildProperty getProperty() {
                return buildProperty;
            }

            @Override
            public Shell getShell() {
                return parent;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return BuildPropertyDialog.this.fTeamRepository;
            }
        };
    }

    private void handlePropertyEditorException(CoreException exception) {
        BuildUIPlugin.log(exception);
    }

    protected void okPressed() {
        this.fBuildProperty.setName(this.fPropertyNameText.getText());
        this.fBuildProperty.setDescription(this.fPropertyDescriptionText.getText());
        if (this.fHiddenButton != null) {
            this.fBuildProperty.setHidden(this.fHiddenButton.getSelection());
        }
        if (this.fPropertyEditor == null) {
            this.fBuildProperty.setValue(this.fPropertyValueText.getText());
        } else {
            this.fBuildProperty.setValue(this.fEditBuildProperty.getValue());
        }
        super.okPressed();
    }

    class ValueFieldResetFocusListener
    implements FocusListener {
        private volatile boolean firstTimeFocus = true;

        ValueFieldResetFocusListener() {
        }

        public void focusLost(FocusEvent arg0) {
        }

        public void focusGained(FocusEvent arg0) {
            if (this.firstTimeFocus) {
                BuildPropertyDialog.this.fPropertyValueText.setText(BuildPropertyDialog.EMPTY_STRING);
                this.firstTimeFocus = false;
            }
        }
    }
}

