/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.domain.AbstractBuildDomainNode;
import com.ibm.team.build.internal.ui.domain.BuildDomain;
import com.ibm.team.build.internal.ui.domain.BuildDomainLabelProvider;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class BuildFolderSelectionDialog
extends Dialog
implements IDeferredWorkbenchAdapter,
ITreeContentProvider {
    private IItemHandle[] fItemsToMove;
    private IBuildFolderHandle fSelectedFolder;
    private final IProcessAreaHandle[] fProcessAreaHandles;
    protected TreeViewer fTreeViewer;
    private DeferredTreeContentManager fDeferredTreeManager;
    protected boolean fFetchInProgress;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Set<UUID> fFoldersToIgnore;
    private final AbstractBuildDomainNode rootNode = new AbstractBuildDomainNode(){

        @Override
        public String getLabel() {
            return Messages.BuildDomainContentProvider_BUILD_DOMAIN_NODE;
        }
    };

    protected BuildFolderSelectionDialog(Shell parentShell, IItemHandle[] itemsToMove, IProcessAreaHandle[] processAreaHandles) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x800);
        this.setBlockOnOpen(true);
        this.fItemsToMove = itemsToMove;
        this.fProcessAreaHandles = processAreaHandles;
        this.fFoldersToIgnore = new HashSet<UUID>();
        IItemHandle[] iItemHandleArray = itemsToMove;
        int n = itemsToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle itemHandle = iItemHandleArray[n2];
            if (itemHandle instanceof IBuildFolderHandle) {
                this.fFoldersToIgnore.add(itemHandle.getItemId());
            }
            ++n2;
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData controlGridData = new GridData(4, 4, true, true);
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)controlGridData);
        Label instructionLabel = new Label(control, 0);
        instructionLabel.setText(BuildUIDialogMessages.BuildFolderSelectionDialog_DESTINATION_FOLDER_LABEL);
        GridData labelData = new GridData();
        instructionLabel.setLayoutData((Object)labelData);
        this.fTreeViewer = new TreeViewer(control, 268438274);
        this.fTreeViewer.setContentProvider((IContentProvider)this);
        this.fTreeViewer.setSorter((ViewerSorter)new BuildDomain.BuildDomainNodeViewerSorter());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new BuildDomainLabelProvider(){

            @Override
            public Image getImage(Object element) {
                if (element.equals(BuildFolderSelectionDialog.this.rootNode)) {
                    return BuildUIPlugin.getImage("icons/obj16/builds_obj.gif");
                }
                return super.getImage(element);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 300;
        this.fTreeViewer.getControl().setLayoutData((Object)gridData);
        this.fTreeViewer.getControl().setEnabled(true);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection structuredSelection;
                if (event.getSelection() instanceof StructuredSelection && (structuredSelection = (StructuredSelection)event.getSelection()).size() == 1) {
                    Object firstElement = structuredSelection.getFirstElement();
                    if (firstElement instanceof BuildFolderNode) {
                        BuildFolderNode folderNode = (BuildFolderNode)structuredSelection.getFirstElement();
                        BuildFolderSelectionDialog.this.fSelectedFolder = folderNode.getBuildFolder();
                    } else if (firstElement.equals(BuildFolderSelectionDialog.this.rootNode)) {
                        BuildFolderSelectionDialog.this.fSelectedFolder = null;
                    }
                }
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (BuildFolderSelectionDialog.this.getButton(0).isEnabled()) {
                    BuildFolderSelectionDialog.this.getMoveBuildFolderJob().schedule();
                    BuildFolderSelectionDialog.this.close();
                }
            }
        });
        this.fTreeViewer.setInput((Object)this);
        this.fTreeViewer.setExpandedElements(new Object[]{this.rootNode});
        return control;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.fDeferredTreeManager == null && viewer instanceof AbstractTreeViewer) {
            this.fDeferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (BuildFolderSelectionDialog.this.hasChildren(element)) {
                        return BuildFolderSelectionDialog.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    public static void open(Shell parentShell, IItemHandle[] itemsToMove, IProcessAreaHandle[] processAreaHandles) {
        BuildFolderSelectionDialog dialog = new BuildFolderSelectionDialog(parentShell, itemsToMove, processAreaHandles);
        dialog.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fItemsToMove.length == 1) {
            if (this.fItemsToMove[0] instanceof IBuildDefinitionHandle) {
                shell.setText(BuildUIDialogMessages.BuildFolderSelectionDialog_MOVE_BUILD_DEFINITION_TITLE);
            } else if (this.fItemsToMove[0] instanceof IBuildFolderHandle) {
                shell.setText(BuildUIDialogMessages.BuildFolderSelectionDialog_MOVE_BUILD_FOLDER_TITLE);
            }
        } else {
            shell.setText(BuildUIDialogMessages.BuildFolderSelectionDialog_MOVE_BUILD_ITEMS_TITLE);
        }
    }

    protected void okPressed() {
        this.getMoveBuildFolderJob().schedule();
        super.okPressed();
    }

    protected TeamBuildJob getMoveBuildFolderJob() {
        TeamBuildJob moveFolderJob = new TeamBuildJob(BuildUIDialogMessages.BuildFolderSelectionDialog_MOVE_BUILD_ITEM_JOB_NAME, true, (ITeamRepository)this.fItemsToMove[0].getOrigin()){

            protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask(this.getName(), 1);
                try {
                    ITeamBuildClient recordClient = (ITeamBuildClient)this.getJobTeamRepository().getClientLibrary(ITeamBuildClient.class);
                    recordClient.moveItemsToFolder(BuildFolderSelectionDialog.this.fItemsToMove, BuildFolderSelectionDialog.this.fSelectedFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        return moveFolderJob;
    }

    public Object[] getChildren(Object o) {
        if (o instanceof AbstractBuildDomainNode) {
            return this.fDeferredTreeManager.getChildren(o);
        }
        return EMPTY_ARRAY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof AbstractBuildDomainNode) {
            return ((AbstractBuildDomainNode)o).getLabel();
        }
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        BuildFolderSelectionDialog buildFolderSelectionDialog = this;
        synchronized (buildFolderSelectionDialog) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            if (object == this.rootNode) {
                this.fetchAndCollectChildrenOfBuildFolder(null, collector, monitor);
            } else if (object instanceof BuildFolderNode) {
                this.fetchAndCollectChildrenOfBuildFolder((BuildFolderNode)object, collector, monitor);
            }
        }
        catch (Throwable throwable) {
            BuildFolderSelectionDialog buildFolderSelectionDialog2 = this;
            synchronized (buildFolderSelectionDialog2) {
                this.fFetchInProgress = false;
            }
            collector.done();
            monitor.done();
            throw throwable;
        }
        BuildFolderSelectionDialog buildFolderSelectionDialog3 = this;
        synchronized (buildFolderSelectionDialog3) {
            this.fFetchInProgress = false;
        }
        collector.done();
        monitor.done();
    }

    private void fetchAndCollectChildrenOfBuildFolder(BuildFolderNode node, IElementCollector collector, IProgressMonitor monitor) {
        IBuildFolderHandle parentFolderHandle = node == null ? null : node.getBuildFolder();
        try {
            IBuildItemNamePair[] childPairs;
            ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)((ITeamRepository)this.fItemsToMove[0].getOrigin()));
            IBuildItemNamePair[] iBuildItemNamePairArray = childPairs = teamBuildClient.getChildrenOfFolder(parentFolderHandle, this.fProcessAreaHandles, monitor);
            int n = childPairs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildItemNamePair obj = iBuildItemNamePairArray[n2];
                IItemHandle itemHandle = obj.getItem();
                if (itemHandle instanceof IBuildFolderHandle && !this.fFoldersToIgnore.contains(itemHandle.getItemId())) {
                    BuildFolderNode folderNode = new BuildFolderNode((IBuildFolderHandle)itemHandle, obj.getName(), node, null);
                    collector.add((Object)folderNode, monitor);
                }
                ++n2;
            }
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public void dispose() {
    }

    public boolean hasChildren(Object o) {
        return o instanceof BuildFolderNode || o == this.rootNode;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this) {
            return new Object[]{this.rootNode};
        }
        return this.getChildren(inputElement);
    }
}

