/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BuildFolderPropertiesDialog
extends Dialog {
    private Text fTextName;
    private ControlDecoration fTextNameDecoration;
    private Text fTextProcessArea;
    private IProcessArea fProcessArea;
    private ITeamRepository fTeamRepository;
    private String fName;
    private IBuildFolder fBuildFolder;
    private Button fBrowseButton;
    private boolean fIsNewItem;
    private TeamBuildJob fTeamBuildJob;
    private IBuildFolderHandle fFolderHandle;
    private IProcessAreaHandle fInitialProcessAreaHandle;

    private BuildFolderPropertiesDialog(Shell parentShell, IBuildFolderHandle folderHandle, IProcessAreaHandle initialProcessArea, boolean isNewItem) {
        super(parentShell);
        this.setShellStyle(2112);
        this.setBlockOnOpen(true);
        this.fName = BuildUIDialogMessages.PENDING_LABEL;
        this.fIsNewItem = isNewItem;
        this.fFolderHandle = folderHandle;
        this.fInitialProcessAreaHandle = initialProcessArea;
    }

    public static void openEditFolderDialog(Shell parentShell, IBuildFolderHandle buildFolderHandle) {
        BuildFolderPropertiesDialog dialog = new BuildFolderPropertiesDialog(parentShell, buildFolderHandle, null, false);
        dialog.open();
    }

    public static void openNewFolderDialog(Shell parentShell, IBuildFolderHandle parentBuildFolderHandle) {
        BuildFolderPropertiesDialog dialog = new BuildFolderPropertiesDialog(parentShell, parentBuildFolderHandle, null, true);
        dialog.open();
    }

    public static void openNewFolderDialog(Shell parentShell, IProcessAreaHandle processAreaHandle) {
        BuildFolderPropertiesDialog dialog = new BuildFolderPropertiesDialog(parentShell, null, processAreaHandle, true);
        dialog.open();
    }

    public void create() {
        super.create();
        this.fetchAndUpdate(this.fFolderHandle);
    }

    private void fetchAndUpdate(final IBuildFolderHandle buildFolderHandle) {
        TeamBuildJob fetchFolderJob;
        this.fTeamBuildJob = fetchFolderJob = new TeamBuildJob(BuildUIDialogMessages.BuildFolderPropertiesDialog_FETCHING_FOLDER_JOB_NAME, true, buildFolderHandle != null ? (ITeamRepository)buildFolderHandle.getOrigin() : (ITeamRepository)this.fInitialProcessAreaHandle.getOrigin()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(this.getName(), 2);
                try {
                    try {
                        IProcessArea processArea;
                        IBuildFolder folderToModify;
                        if (!BuildFolderPropertiesDialog.this.fIsNewItem) {
                            folderToModify = (IBuildFolder)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildFolderHandle, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            processArea = (IProcessArea)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)folderToModify.getProcessArea(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            IBuildFolder parentFolder = null;
                            if (buildFolderHandle != null) {
                                parentFolder = (IBuildFolder)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildFolderHandle, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                processArea = (IProcessArea)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)parentFolder.getProcessArea(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                processArea = (IProcessArea)this.getJobTeamRepository().itemManager().fetchCompleteItem((IItemHandle)BuildFolderPropertiesDialog.this.fInitialProcessAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                            folderToModify = (IBuildFolder)BuildItemFactory.createBuildFolder((IBuildFolderHandle)parentFolder, (String)BuildUIActionMessages.NewBuildFolderActionDelegate_DEFAULT_FOLDER_NAME, (IProcessAreaHandle)processArea).getWorkingCopy();
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                BuildFolderPropertiesDialog.this.handleAsyncUpdateComplete(folderToModify, processArea);
                            }
                        });
                    }
                    catch (TeamRepositoryException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (BuildFolderPropertiesDialog.this.getShell() != null && !BuildFolderPropertiesDialog.this.getShell().isDisposed()) {
                                    BuildFolderPropertiesDialog.this.close();
                                }
                            }
                        });
                        Status status = new Status(4, "com.ibm.team.build.ui", BuildUIDialogMessages.BuildFolderPropertiesDialog_FETCHING_FOLDER_ERROR_MESSAGE, (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        fetchFolderJob.schedule();
    }

    private void handleAsyncUpdateComplete(IBuildFolder buildFolder, IProcessArea processArea) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.fBuildFolder = buildFolder;
            this.fName = buildFolder.getName();
            this.fProcessArea = processArea;
            this.fTeamRepository = (ITeamRepository)this.fProcessArea.getOrigin();
            this.update();
            this.validate();
            this.fTextName.setEnabled(true);
            this.fBrowseButton.setEnabled(true);
            this.fTextProcessArea.setEnabled(true);
            this.fTextName.setSelection(0, this.fTextName.getText().length());
            this.fTextName.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 4;
        layout.marginRight = 4;
        layout.marginTop = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).hint(500, -1).create());
        Label labelName = new Label(composite, 0);
        labelName.setText(BuildUIDialogMessages.BuildFolderPropertiesDialog_FOLDER_NAME_LABEL);
        labelName.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).create());
        this.fTextName = new Text(composite, 2048);
        this.fTextName.setEnabled(false);
        this.fTextName.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).create());
        this.fTextName.setText(this.fName);
        this.fTextNameDecoration = new ControlDecoration((Control)this.fTextName, 0x1000000);
        this.fTextName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildFolderPropertiesDialog.this.fName = BuildFolderPropertiesDialog.this.fTextName.getText();
                BuildFolderPropertiesDialog.this.validate();
            }
        });
        Label labelprocessArea = new Label(composite, 0);
        labelprocessArea.setText(BuildUIDialogMessages.BuildFolderPropertiesDialog_PROCESS_AREA_LABEL);
        labelprocessArea.setToolTipText(BuildUIDialogMessages.BuildFolderPropertiesDialog_PROCESS_AREA_TOOLTIP);
        labelprocessArea.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).create());
        this.fTextProcessArea = new Text(composite, 2048);
        this.fTextProcessArea.setText(BuildUIDialogMessages.PENDING_LABEL);
        this.fTextProcessArea.setEnabled(false);
        this.fTextProcessArea.setEditable(false);
        this.fTextProcessArea.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.fBrowseButton = new Button(composite, 0);
        this.fBrowseButton.setEnabled(false);
        this.fBrowseButton.setText(BuildUIDialogMessages.BuildFolderPropertiesDialog_BROWSE_BUTTON_LABEL);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionDialog processAreaSelectionDialog = new ProcessAreaSelectionDialog(BuildFolderPropertiesDialog.this.getParentShell(), false);
                processAreaSelectionDialog.setInput((Object)((ITeamRepository)BuildFolderPropertiesDialog.this.fProcessArea.getOrigin()));
                processAreaSelectionDialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IProcessArea) {
                            IProcessArea processArea = (IProcessArea)element;
                            return processArea.getProjectArea().sameItemId((IItemHandle)BuildFolderPropertiesDialog.this.fProcessArea.getProjectArea());
                        }
                        return true;
                    }
                });
                processAreaSelectionDialog.open();
                if (processAreaSelectionDialog.getSelectedProcessArea() != null) {
                    BuildFolderPropertiesDialog.this.fProcessArea = processAreaSelectionDialog.getSelectedProcessArea();
                }
                BuildFolderPropertiesDialog.this.update();
                BuildFolderPropertiesDialog.this.validate();
            }
        });
        composite.pack();
        return composite;
    }

    public Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void saveFolder() {
        String jobName = this.fIsNewItem ? BuildUIDialogMessages.BuildFolderPropertiesDialog_SAVE_NEW_BUILD_FOLDER_JOB_NAME : BuildUIDialogMessages.BuildFolderPropertiesDialog_SAVE_EXISTING_BUILD_FOLDER_JOB_NAME;
        TeamBuildJob newFolderJob = new TeamBuildJob(jobName, true, this.fTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask(this.getName(), 1);
                try {
                    IBuildFolder workingFolder = (IBuildFolder)BuildFolderPropertiesDialog.this.fBuildFolder.getWorkingCopy();
                    workingFolder.setName(BuildFolderPropertiesDialog.this.fName);
                    workingFolder.setProcessArea((IProcessAreaHandle)BuildFolderPropertiesDialog.this.fProcessArea);
                    ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.getJobTeamRepository());
                    buildClient.save(workingFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BuildFolderPropertiesDialog.this.close();
                        }
                    });
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BuildFolderPropertiesDialog.this.validate();
                        }
                    });
                    throw e;
                }
                finally {
                    monitor.done();
                }
            }
        };
        newFolderJob.schedule();
    }

    protected void cancelPressed() {
        this.fTeamBuildJob.cancel();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.getButton(0).setEnabled(false);
        this.saveFolder();
    }

    private void update() {
        if (this.fProcessArea != null && !this.fTextProcessArea.isDisposed()) {
            this.fTextProcessArea.setText(this.fProcessArea.getName());
        }
        if (this.fName != null && !this.fTextName.isDisposed()) {
            this.fTextName.setText(this.fName);
        }
    }

    private void validate() {
        Button okButton;
        if (!this.getShell().isDisposed() && (okButton = this.getButton(0)) != null) {
            boolean isValid = true;
            if (this.fTextName.getText().length() == 0) {
                this.fTextNameDecoration.setDescriptionText(BuildUIDialogMessages.BuildFolderPropertiesDialog_NAME_DECORATOR_EMPTY_NAME);
                isValid = false;
            } else if (!ItemHelper.validateStringAttributeLength((String)this.fTextName.getText(), (IType)IBuildFolder.ITEM_TYPE, (String)IBuildFolder.PROPERTY_NAME).equals(this.fTextName.getText())) {
                this.fTextNameDecoration.setDescriptionText(BuildUIDialogMessages.BuildFolderPropertiesDialog_NAME_DECORATOR_TOO_LONG_NAME);
                this.fTextNameDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                isValid = false;
            }
            if (!isValid) {
                this.fTextNameDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            } else {
                this.fTextNameDecoration.setImage(null);
            }
            if (this.fProcessArea == null) {
                isValid = false;
            }
            if (okButton.getEnabled() ^ isValid) {
                okButton.setEnabled(isValid);
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fIsNewItem) {
            shell.setText(BuildUIDialogMessages.BuildFolderPropertiesDialog_TITLE_NEW_FOLDER);
        } else {
            shell.setText(BuildUIDialogMessages.BuildFolderPropertiesDialog_TITLE_EXISTING_FOLDER);
        }
    }
}

