/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.AbstractBuildItemsEditDialog;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class AddBuildEnginesDialog2
extends AbstractBuildItemsEditDialog {
    protected Map<String, String> fIdNameMap;
    protected String fCurrentProjectAreaName;
    protected Collection<String> fProjectAreaEngineIds;
    protected Map<String, IBuildEngine> fBuildEngines;
    private Map<String, ArrayList<String>> fProcessAreaItemIdToEngineMap = new HashMap<String, ArrayList<String>>();
    private Set<String> fSupportingEngines;
    private ITeamRepository fTeamRepository;
    private String fBuildProcessAreaItemId;

    public AddBuildEnginesDialog2(Shell parentShell, Map<String, String> buildEngineIdsToProjectAreaName, Collection<String> supportingBuildEngineIds, String currentProjectAreaName, Map<String, IBuildEngine> buildEngines, ITeamRepository repository, String processAreaItemId) {
        super(parentShell);
        this.fTeamRepository = repository;
        this.fBuildProcessAreaItemId = processAreaItemId;
        this.fCurrentProjectAreaName = currentProjectAreaName;
        this.fBuildEngines = buildEngines;
        this.fProjectAreaEngineIds = new LinkedList<String>();
        this.fSupportingEngines = new HashSet<String>();
        if (supportingBuildEngineIds != null) {
            Iterator<String> iterator = supportingBuildEngineIds.iterator();
            while (iterator.hasNext()) {
                this.fSupportingEngines.add(iterator.next());
            }
        }
        if (buildEngineIdsToProjectAreaName != null) {
            this.fIdNameMap = new HashMap<String, String>(buildEngineIdsToProjectAreaName);
            if (supportingBuildEngineIds != null) {
                for (String engineId : supportingBuildEngineIds) {
                    this.fIdNameMap.remove(engineId);
                }
            }
            if (currentProjectAreaName != null && !this.fCurrentProjectAreaName.equals(BuildUIMessages.UNKNOWN_PROJECT_AREA)) {
                for (String engineId : this.fIdNameMap.keySet()) {
                    String projectAreaName = this.fIdNameMap.get(engineId);
                    if (!this.fCurrentProjectAreaName.equals(projectAreaName)) continue;
                    this.fProjectAreaEngineIds.add(engineId);
                }
            }
        } else {
            this.fIdNameMap = new HashMap<String, String>();
        }
        if (buildEngines != null) {
            for (IBuildEngine engine : buildEngines.values()) {
                this.addEngineToMap(engine);
            }
        }
    }

    private void addEngineToMap(IBuildEngine engine) {
        if (engine != null && !this.fSupportingEngines.contains(engine.getId())) {
            IProcessAreaHandle processArea = engine.getProcessArea();
            String processAreaItemId = BuildUIMessages.UNKNOWN_PROJECT_AREA;
            if (processArea != null) {
                processAreaItemId = processArea.getItemId().getUuidValue();
            }
            if (this.fProcessAreaItemIdToEngineMap.get(processAreaItemId) == null) {
                this.fProcessAreaItemIdToEngineMap.put(processAreaItemId, new ArrayList());
            }
            this.fProcessAreaItemIdToEngineMap.get(processAreaItemId).add(engine.getId());
        }
    }

    private String formatWithProjectArea(Object element) {
        String engineId = element.toString();
        String areaName = this.fIdNameMap.get(engineId);
        if (areaName == null) {
            areaName = BuildUIMessages.UNKNOWN_PROJECT_AREA;
        }
        return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)engineId, (Object)areaName);
    }

    public Set<String> getChangedBuildEngineIds() {
        return this.getChangedItems();
    }

    @Override
    protected String getDialogDescription() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_DESCRIPTION;
    }

    @Override
    protected String getDialogTitle() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_TITLE;
    }

    @Override
    protected String getShowAllLabel() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_SHOW_ALL_LABEL;
    }

    @Override
    protected String getShowSubSetLabel() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_SHOW_PROJECT_AREA_LABEL;
    }

    @Override
    protected LabelProvider getLabelProvider(final boolean isSubSetDisplayed) {
        return new LabelProvider(){

            public final String getText(Object element) {
                if (isSubSetDisplayed) {
                    return super.getText(element);
                }
                return AddBuildEnginesDialog2.this.formatWithProjectArea(element);
            }

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
            }
        };
    }

    @Override
    protected ViewerComparator getTableViewerComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getTopProject() {
                return AddBuildEnginesDialog2.this.fCurrentProjectAreaName;
            }

            @Override
            protected String getProject(Object element) {
                return AddBuildEnginesDialog2.this.fIdNameMap.get(element);
            }
        };
    }

    @Override
    protected String[] getAllItems() {
        return this.fIdNameMap.keySet().toArray(new String[this.fIdNameMap.size()]);
    }

    @Override
    protected String[] getInitialItems() {
        return new String[0];
    }

    @Override
    protected boolean isStartInSubSet() {
        return this.fProjectAreaEngineIds.size() > 0;
    }

    @Override
    protected String getDescription(IStructuredSelection selection) {
        String engineId;
        IBuildEngine engine;
        if (selection.size() == 1 && (engine = this.fBuildEngines.get(engineId = (String)selection.getFirstElement())) != null) {
            return engine.getDescription();
        }
        return null;
    }

    @Override
    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    protected String getBuildProcessAreaItemId() {
        return this.fBuildProcessAreaItemId;
    }

    @Override
    protected List<String> getFilteredItems(String processAreaItemId) {
        return processAreaItemId == null ? null : (List)this.fProcessAreaItemIdToEngineMap.get(processAreaItemId);
    }

    @Override
    protected String getBuildProcessAreaName() {
        return this.fCurrentProjectAreaName;
    }

    @Override
    protected String getMatchingItemsLabel() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_MATCHING_ENGINES_LABEL;
    }

    @Override
    protected String getMatchingItemsMaxedLabel() {
        return BuildUIDialogMessages.AddBuildEnginesDialog_MATCHING_ENGINES_LABEL_MAX_LIMIT;
    }
}

