/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.AbstractBuildItemsEditDialog;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class AddBuildDefinitionsDialog
extends AbstractBuildItemsEditDialog {
    private Map<String, IBuildDefinition> fAllBuildDefinitionsMap = new HashMap<String, IBuildDefinition>();
    private Map<String, String> fIdNameMap = new HashMap<String, String>();
    private Collection<String> fProjectAreaBuildDefinitionIds = new LinkedList<String>();
    private Map<String, ArrayList<String>> fProcessAreaItemIdToDefinitionMap = new HashMap<String, ArrayList<String>>();
    private HashSet<String> fSupportedBuildDefinitionIds;
    private String fBuildProjectAreaName;
    private ITeamRepository fTeamRepository;
    private String fBuildProcessAreaItemId;

    public AddBuildDefinitionsDialog(Shell parentShell, Map<IBuildDefinition, String> buildDefinitionToProjectAreaName, IBuildDefinition[] supportedBuildDefinitions, String buildProjectAreaName, ITeamRepository repository, String processAreaItemId) {
        super(parentShell);
        this.fBuildProcessAreaItemId = processAreaItemId;
        this.fTeamRepository = repository;
        this.fBuildProjectAreaName = buildProjectAreaName;
        this.fSupportedBuildDefinitionIds = new HashSet();
        if (supportedBuildDefinitions != null) {
            int i = 0;
            while (i < supportedBuildDefinitions.length) {
                String supportedId = supportedBuildDefinitions[i].getId();
                this.fSupportedBuildDefinitionIds.add(supportedId);
                ++i;
            }
        }
        if (buildDefinitionToProjectAreaName != null) {
            if (this.fBuildProjectAreaName == null || this.fBuildProjectAreaName.equals(BuildUIMessages.UNKNOWN_PROJECT_AREA)) {
                for (IBuildDefinition definition : buildDefinitionToProjectAreaName.keySet()) {
                    this.addDefinition(definition, buildDefinitionToProjectAreaName.get(definition), supportedBuildDefinitions);
                }
            } else {
                for (IBuildDefinition definition : buildDefinitionToProjectAreaName.keySet()) {
                    String projectAreaName;
                    boolean definitionAdded = this.addDefinition(definition, projectAreaName = buildDefinitionToProjectAreaName.get(definition), supportedBuildDefinitions);
                    if (!definitionAdded || !this.fBuildProjectAreaName.equals(projectAreaName)) continue;
                    this.fProjectAreaBuildDefinitionIds.add(definition.getId());
                }
            }
            for (IBuildDefinition definition : buildDefinitionToProjectAreaName.keySet()) {
                this.addDefinitionToMap(definition);
            }
        }
    }

    private void addDefinitionToMap(IBuildDefinition definition) {
        if (definition != null && !this.fSupportedBuildDefinitionIds.contains(definition.getId())) {
            String processAreaItemId;
            IProcessAreaHandle processArea = definition.getProcessArea();
            String string = processAreaItemId = processArea == null ? BuildUIMessages.UNKNOWN_PROJECT_AREA : processArea.getItemId().getUuidValue();
            if (this.fProcessAreaItemIdToDefinitionMap.get(processAreaItemId) == null) {
                this.fProcessAreaItemIdToDefinitionMap.put(processAreaItemId, new ArrayList());
            }
            this.fProcessAreaItemIdToDefinitionMap.get(processAreaItemId).add(definition.getId());
        }
    }

    private boolean addDefinition(IBuildDefinition definition, String projectAreaName, IBuildDefinition[] supportedBuildDefinitions) {
        String definitionId = definition.getId();
        IBuildDefinition[] iBuildDefinitionArray = supportedBuildDefinitions;
        int n = supportedBuildDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinition supportedBuildDefinition = iBuildDefinitionArray[n2];
            if (supportedBuildDefinition.getId().equals(definitionId)) {
                return false;
            }
            ++n2;
        }
        this.fIdNameMap.put(definitionId, projectAreaName);
        this.fAllBuildDefinitionsMap.put(definitionId, definition);
        return true;
    }

    private String formatWithProjectArea(Object element) {
        String definitionId = element.toString();
        String areaName = this.fIdNameMap.get(definitionId);
        if (areaName == null) {
            areaName = BuildUIMessages.UNKNOWN_PROJECT_AREA;
        }
        return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)definitionId, (Object)areaName);
    }

    public Set<IBuildDefinition> getChangedBuildDefinitions() {
        HashSet<IBuildDefinition> changedDefinitions = new HashSet<IBuildDefinition>();
        Iterator<String> changesAsItems = this.getChangedItems().iterator();
        while (changesAsItems.hasNext()) {
            changedDefinitions.add(this.fAllBuildDefinitionsMap.get(changesAsItems.next()));
        }
        return changedDefinitions;
    }

    @Override
    protected String getDialogDescription() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_DESCRIPTION;
    }

    @Override
    protected String getDialogTitle() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_TITLE;
    }

    @Override
    protected LabelProvider getLabelProvider(final boolean isSubSetDisplayed) {
        return new LabelProvider(){

            public final String getText(Object element) {
                if (isSubSetDisplayed) {
                    return super.getText(element);
                }
                return AddBuildDefinitionsDialog.this.formatWithProjectArea(element);
            }

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
            }
        };
    }

    @Override
    protected String getShowAllLabel() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_SHOW_ALL_LABEL;
    }

    @Override
    protected String getShowSubSetLabel() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_SHOW_PROJECT_AREA_LABEL;
    }

    @Override
    protected String[] getAllItems() {
        return this.fAllBuildDefinitionsMap.keySet().toArray(new String[this.fAllBuildDefinitionsMap.size()]);
    }

    @Override
    protected List<String> getFilteredItems(String processAreaItemId) {
        return processAreaItemId == null ? null : (List)this.fProcessAreaItemIdToDefinitionMap.get(processAreaItemId);
    }

    @Override
    protected String[] getInitialItems() {
        return new String[0];
    }

    @Override
    protected boolean isStartInSubSet() {
        return this.fProjectAreaBuildDefinitionIds.size() > 0;
    }

    @Override
    protected ViewerComparator getTableViewerComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getTopProject() {
                return AddBuildDefinitionsDialog.this.fBuildProjectAreaName;
            }

            @Override
            protected String getProject(Object element) {
                return (String)AddBuildDefinitionsDialog.this.fIdNameMap.get(element);
            }
        };
    }

    @Override
    protected String getDescription(IStructuredSelection selection) {
        String definitionId;
        IBuildDefinition definition;
        if (selection.size() == 1 && (definition = this.fAllBuildDefinitionsMap.get(definitionId = (String)selection.getFirstElement())) != null) {
            return definition.getDescription();
        }
        return null;
    }

    @Override
    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    protected String getBuildProcessAreaItemId() {
        return this.fBuildProcessAreaItemId;
    }

    @Override
    protected String getBuildProcessAreaName() {
        return this.fBuildProjectAreaName;
    }

    @Override
    protected String getMatchingItemsLabel() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_MATCHING_DEFINITIONS_LABEL;
    }

    @Override
    protected String getMatchingItemsMaxedLabel() {
        return BuildUIDialogMessages.AddBuildDefinitionsDialog_MATCHING_DEFINITIONS_LABEL_MAX_LIMIT;
    }
}

