/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractBuildItemsEditDialog
extends Dialog {
    protected Set<String> fCheckedItems = new HashSet<String>();
    protected TableViewer fTableViewer;
    protected Button fShowAllItemsButton;
    protected Button fShowSubSetItemsButton;
    protected Button fSelectAllItemsButton;
    protected Button fDeselectAllItemsButton;
    protected Button fBrowseButton;
    protected Label fDescriptionLabel;
    protected Label fSearchByIDLabel;
    protected Label fMatchingItemsLabel;
    private final GridData GRAB_TRUE_GRID_DATA = GridDataFactory.fillDefaults().grab(true, true).create();
    protected Text fDescriptionText;
    private boolean fSingleSelect;
    protected Text fProcessAreaText;
    protected Text fFilterText;
    private String fSelectedProcessAreaItemId;
    private static final int MAX_ITEMS = 100;

    public AbstractBuildItemsEditDialog(Shell parentShell) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"parentShell", (Object)parentShell);
    }

    public void setSingleSelect(boolean singleSelect) {
        this.fSingleSelect = singleSelect;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.createFrom((GridData)this.GRAB_TRUE_GRID_DATA).applyTo((Control)composite);
        this.fDescriptionLabel = this.createLabel(composite, this.getDialogDescription(), null);
        this.fShowAllItemsButton = this.createRadioButton(composite, this.getShowAllLabel(), this.getShowListenerAll(), !this.isStartInSubSet());
        this.fShowSubSetItemsButton = this.createRadioButton(composite, this.getShowSubSetLabel(), this.getShowListener(), this.isStartInSubSet());
        this.createShowSubSetBar(composite);
        this.fSearchByIDLabel = this.createLabel(composite, BuildUIDialogMessages.AbstractEditItemsDialog_SEARCH_BY_ID_LABEL, null);
        this.createFilterText(composite);
        this.fSelectedProcessAreaItemId = this.getBuildProcessAreaItemId();
        this.fMatchingItemsLabel = this.createLabel(composite, NLS.bind((String)this.getMatchingItemsLabel(), (Object)0), null);
        this.createTableRow(composite);
        this.createDescriptionRow(composite);
        this.updateTableItems(this.getInitialItems(), null);
        return composite;
    }

    protected Set<String> getChangedItems() {
        HashSet<String> changedItems = new HashSet<String>();
        changedItems.addAll(this.fCheckedItems);
        String[] stringArray = this.getInitialItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (changedItems.contains(item)) {
                changedItems.remove(item);
            } else {
                changedItems.add(item);
            }
            ++n2;
        }
        return changedItems;
    }

    private final void updateTableItems(Object[] oldChecked, String filterText) {
        this.setCheckedItems(oldChecked);
        List<String> matchingItems = null;
        boolean showAllItems = this.fShowAllItemsButton.getSelection();
        this.fBrowseButton.setEnabled(!showAllItems);
        this.fProcessAreaText.setEnabled(!showAllItems);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider(!showAllItems));
        matchingItems = this.getMatchingItems(showAllItems ? Arrays.asList(this.getAllItems()) : this.getFilteredItems(this.fSelectedProcessAreaItemId), filterText);
        if (matchingItems != null && matchingItems.size() > 100) {
            matchingItems = matchingItems.stream().limit(100L).collect(Collectors.toList());
            this.fMatchingItemsLabel.setText(NLS.bind((String)this.getMatchingItemsMaxedLabel(), (Object)100));
        } else if (matchingItems != null) {
            this.fMatchingItemsLabel.setText(NLS.bind((String)this.getMatchingItemsLabel(), (Object)matchingItems.size()));
        }
        this.fTableViewer.setInput(matchingItems);
        if (this.fSingleSelect) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fCheckedItems.toArray()));
            this.fCheckedItems.removeAll(((IStructuredSelection)this.fTableViewer.getSelection()).toList());
        } else {
            Iterator<String> itr = this.fCheckedItems.iterator();
            while (itr.hasNext()) {
                String checked = itr.next();
                if (!((CheckboxTableViewer)this.fTableViewer).setChecked((Object)checked, true)) continue;
                itr.remove();
            }
        }
    }

    private List<String> getMatchingItems(List<String> candidates, String filterText) {
        filterText = filterText == null || filterText == "" ? "*" : filterText;
        ArrayList<String> matchingElements = new ArrayList<String>();
        if (candidates != null) {
            StringMatcher matcher = new StringMatcher(filterText, true, false);
            for (String item : candidates) {
                if (!matcher.match(item)) continue;
                matchingElements.add(item);
            }
        }
        return matchingElements;
    }

    private void createShowSubSetBar(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(7, 0).margins(4, 0).applyTo(composite);
        this.fProcessAreaText = new Text(composite, 2048);
        this.fProcessAreaText.setEditable(false);
        String buildProcessAreaName = this.getBuildProcessAreaName();
        if (buildProcessAreaName == null) {
            buildProcessAreaName = BuildUIMessages.UNKNOWN_PROJECT_AREA;
        }
        this.fProcessAreaText.setText(buildProcessAreaName);
        GridDataFactory.fillDefaults().grab(true, false).minSize(400, -1).indent(21, 0).applyTo((Control)this.fProcessAreaText);
        this.fBrowseButton = new Button(composite, 8);
        this.fBrowseButton.setText(BuildUIMessages.BROWSE_BUTTON_LABEL);
        this.initializeDialogUnits((Control)this.fBrowseButton);
        this.setButtonLayoutData(this.fBrowseButton);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fBrowseButton), -1).align(16384, 0x1000000).grab(false, true).applyTo((Control)this.fBrowseButton);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
    }

    private SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildItemsEditDialog.this.handleBrowseButtonSelected();
            }
        };
    }

    private void handleBrowseButtonSelected() {
        IProcessArea selectedProcessArea;
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getShell(), false);
        dialog.setInput((Object)this.getTeamRepository());
        if (dialog.open() == 0 && (selectedProcessArea = dialog.getSelectedProcessArea()) != null) {
            this.fProcessAreaText.setText(selectedProcessArea.getName());
            this.fSelectedProcessAreaItemId = selectedProcessArea.getItemId().getUuidValue();
            this.updateTableItems(this.getSelectedElements(), this.fFilterText.getText());
        }
    }

    private Button createRadioButton(Composite parent, String text, SelectionAdapter adapter, boolean isSelected) {
        int indent = 4;
        Button newButton = new Button(parent, 16);
        newButton.setText(text);
        newButton.addSelectionListener((SelectionListener)adapter);
        newButton.setSelection(isSelected);
        GridDataFactory.fillDefaults().indent(indent, indent).grab(true, false).align(1, 4).applyTo((Control)newButton);
        return newButton;
    }

    protected SelectionAdapter getShowListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AbstractBuildItemsEditDialog.this.updateTableItems(AbstractBuildItemsEditDialog.this.getSelectedElements(), AbstractBuildItemsEditDialog.this.fFilterText.getText());
                }
            }
        };
    }

    protected SelectionAdapter getShowListenerAll() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AbstractBuildItemsEditDialog.this.updateTableItems(AbstractBuildItemsEditDialog.this.getSelectedElements(), AbstractBuildItemsEditDialog.this.fFilterText.getText());
                }
            }
        };
    }

    private Object[] getSelectedElements() {
        if (this.fSingleSelect) {
            return ((IStructuredSelection)this.fTableViewer.getSelection()).toArray();
        }
        return ((CheckboxTableViewer)this.fTableViewer).getCheckedElements();
    }

    protected final void setCheckedItems(Object[] newChecked) {
        Object[] objectArray = newChecked;
        int n = newChecked.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.fCheckedItems.add((String)o);
            ++n2;
        }
    }

    private final void createTableRow(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridDataFactory.createFrom((GridData)this.GRAB_TRUE_GRID_DATA).hint(parent.getSize().x, -1).applyTo((Control)composite);
        int numColumns = this.fSingleSelect ? 1 : 2;
        GridLayoutFactory.swtDefaults().numColumns(numColumns).spacing(7, 0).margins(4, 0).applyTo(composite);
        this.fTableViewer = this.fSingleSelect ? new TableViewer(composite, 2048) : CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        if (!this.fSingleSelect) {
            this.createTableButtonBar(composite);
        }
        this.fTableViewer.setComparator(this.getTableViewerComparator());
        this.fTableViewer.setContentProvider(this.getContentProvider());
        this.fTableViewer.addSelectionChangedListener(this.getTableSelectionListener());
        this.fTableViewer.addOpenListener(this.getTableOpenListener());
        int hint = 200;
        GridDataFactory.createFrom((GridData)this.GRAB_TRUE_GRID_DATA).hint(hint, hint).applyTo((Control)this.fTableViewer.getTable());
    }

    private ISelectionChangedListener getTableSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractBuildItemsEditDialog.this.updateDescription((IStructuredSelection)event.getSelection());
            }
        };
    }

    private IOpenListener getTableOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                if (AbstractBuildItemsEditDialog.this.fSingleSelect) {
                    AbstractBuildItemsEditDialog.this.okPressed();
                }
            }
        };
    }

    protected void updateDescription(IStructuredSelection selection) {
        String description = this.getDescription(selection);
        if (description == null || description.length() == 0) {
            description = BuildUIDialogMessages.AbstractEditItemsDialog_NO_DESCRIPTION;
        }
        this.fDescriptionText.setText(description);
    }

    protected abstract String getDescription(IStructuredSelection var1);

    private final void createTableButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fSelectAllItemsButton = this.createPushButton(composite, BuildUIDialogMessages.AbstractEditItemsDialog_SELECT_ALL_LABEL, true, (SelectionListener)this.getSelectAllListener());
        this.fDeselectAllItemsButton = this.createPushButton(composite, BuildUIDialogMessages.AbstractEditItemsDialog_DESELECT_ALL_LABEL, true, (SelectionListener)this.getDeselectAllListener());
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fSelectAllItemsButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fSelectAllItemsButton);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fDeselectAllItemsButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fDeselectAllItemsButton);
    }

    private Button createPushButton(Composite composite, String text, boolean isEnabled, SelectionListener listener) {
        Button newButton = new Button(composite, 8);
        newButton.setText(text);
        newButton.setEnabled(isEnabled);
        newButton.addSelectionListener(listener);
        return newButton;
    }

    protected SelectionAdapter getSelectAllListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractBuildItemsEditDialog.this.fSingleSelect) {
                    ((CheckboxTableViewer)AbstractBuildItemsEditDialog.this.fTableViewer).setAllChecked(true);
                }
            }
        };
    }

    protected SelectionAdapter getDeselectAllListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractBuildItemsEditDialog.this.fSingleSelect) {
                    ((CheckboxTableViewer)AbstractBuildItemsEditDialog.this.fTableViewer).setAllChecked(false);
                }
            }
        };
    }

    private final Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        int indent = 4;
        label.setText(text);
        label.setForeground(color);
        GridDataFactory.fillDefaults().indent(indent, indent).applyTo((Control)label);
        return label;
    }

    private final void createDescriptionRow(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().margins(4, 5).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(BuildUIDialogMessages.AbstractEditItemsDialog_DESCRIPTION);
        this.fDescriptionText = new Text(composite, 586);
        this.fDescriptionText.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).hint(100, this.fDescriptionText.computeTrim((int)0, (int)0, (int)100, (int)(this.fDescriptionText.getLineHeight() * 3)).height).applyTo((Control)this.fDescriptionText);
        this.updateDescription((IStructuredSelection)this.fTableViewer.getSelection());
    }

    protected Text createFilterText(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().margins(4, 0).applyTo(composite);
        Text text = new Text(composite, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                String filterText = AbstractBuildItemsEditDialog.this.fFilterText.getText();
                AbstractBuildItemsEditDialog.this.updateTableItems(AbstractBuildItemsEditDialog.this.getSelectedElements(), filterText);
            }
        };
        text.addListener(24, listener);
        text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.fFilterText = text;
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setCheckedItems(this.getSelectedElements());
        super.okPressed();
    }

    protected abstract ViewerComparator getTableViewerComparator();

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected abstract String getDialogTitle();

    protected abstract String getDialogDescription();

    protected abstract String getShowAllLabel();

    protected abstract String getShowSubSetLabel();

    protected abstract String[] getAllItems();

    protected abstract String[] getInitialItems();

    protected abstract LabelProvider getLabelProvider(boolean var1);

    protected abstract boolean isStartInSubSet();

    protected abstract List<String> getFilteredItems(String var1);

    protected abstract ITeamRepository getTeamRepository();

    protected abstract String getBuildProcessAreaItemId();

    protected abstract String getBuildProcessAreaName();

    protected abstract String getMatchingItemsLabel();

    protected abstract String getMatchingItemsMaxedLabel();
}

