/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.commands;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class BuildToolkitDocHandler
extends AbstractHandler {
    private static final String AntEditor = "org.eclipse.ant.internal.ui.editor.AntEditor";
    private static final String Attribute_ID = "id";
    private static final String Attribute_PATH = "path";
    private static final String Attribute_TYPE = "type";
    private static final String Default_Type = "";
    private static final String HelpContents = "Contents";
    private static final String HelpExtension = "com.ibm.team.build.ui.buildToolkitDocument";
    private static final String HelpSearch = "buildtoolkittasks";
    private static final String HelpView = "org.eclipse.help.ui.HelpView";
    private static final String TaskNamePattern = "<?((.*):)?([a-zA-Z0-9]*)(\\s)?$";
    private static final String HelpFilePath = "/%1$s/%2$s";

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        block11: {
            ISelection selection;
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (part.getClass().getName().equals(AntEditor) && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                String text = textSelection.getText().toLowerCase();
                String type = null;
                if (text != null && !text.isEmpty()) {
                    Map<String, Object> extensions;
                    Pattern p = Pattern.compile(TaskNamePattern);
                    Matcher m = p.matcher(text);
                    if (m.find()) {
                        type = m.group(2);
                        text = m.group(3);
                    }
                    if ((extensions = this.loadExtensions()).containsKey(text)) {
                        try {
                            IConfigurationElement extension;
                            Object o = extensions.get(text);
                            if (o instanceof IConfigurationElement) {
                                extension = (IConfigurationElement)o;
                            } else {
                                HashMap extensionMap = (HashMap)o;
                                extension = type != null && extensionMap.containsKey(type) ? (IConfigurationElement)extensionMap.get(type) : (IConfigurationElement)extensionMap.get(Default_Type);
                            }
                            if (extension != null) {
                                String bundleName = extension.getContributor().getName();
                                String path = extension.getAttribute(Attribute_PATH);
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                HelpView helpView = (HelpView)page.showView(HelpView);
                                helpView.showHelp(String.format(HelpFilePath, bundleName, path));
                                break block11;
                            }
                            this.textSearch(text);
                        }
                        catch (Exception e) {
                            BuildUIPlugin.log(e);
                        }
                    } else {
                        this.textSearch(text);
                    }
                } else {
                    this.textSearch(HelpSearch);
                }
            }
        }
        return null;
    }

    private void textSearch(String text) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            HelpView helpView = (HelpView)page.showView(HelpView);
            helpView.startSearch(text);
        }
        catch (Exception e) {
            BuildUIPlugin.log(e);
        }
    }

    private final IConfigurationElement[] getElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private final Map<String, Object> loadExtensions() {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(HelpExtension);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = this.getElements(extensionPoint);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String id = configurationElement.getAttribute(Attribute_ID);
                if (extensions.containsKey(id)) {
                    HashMap<String, IConfigurationElement> extensionMap;
                    Object value = extensions.get(id);
                    if (value instanceof IConfigurationElement) {
                        IConfigurationElement element = (IConfigurationElement)value;
                        extensionMap = new HashMap<String, IConfigurationElement>();
                        extensionMap.put(this.getType(element), element);
                        extensions.put(id, extensionMap);
                    } else {
                        extensionMap = (HashMap<String, IConfigurationElement>)value;
                    }
                    extensionMap.put(this.getType(configurationElement), configurationElement);
                } else {
                    extensions.put(configurationElement.getAttribute(Attribute_ID), configurationElement);
                }
                ++n2;
            }
        }
        return extensions;
    }

    private String getType(IConfigurationElement element) {
        String result = element.getAttribute(Attribute_TYPE);
        if (result != null) {
            return result;
        }
        if (Boolean.getBoolean("com.ibm.team.build.internal.ui.commands.BuildToolkitDocHandler.getType")) {
            System.out.println("Duplicate ID without type: " + element.getAttribute(Attribute_ID));
        }
        return Default_Type;
    }

    public final void showContents() {
        try {
            IContributionItem[] cis;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            HelpView helpView = (HelpView)page.showView(HelpView);
            helpView.getViewSite().getShell().setVisible(true);
            helpView.setFocus();
            IContributionItem[] iContributionItemArray = cis = helpView.getViewSite().getActionBars().getMenuManager().getItems();
            int n = cis.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem ci = iContributionItemArray[n2];
                if (ci instanceof ActionContributionItem) {
                    ActionContributionItem aci = (ActionContributionItem)ci;
                    if (HelpContents.equals(aci.getAction().getText())) {
                        aci.getAction().run();
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            BuildUIPlugin.log(e);
        }
    }
}

