/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.dialogs.tags.PromptForTagDialog;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQueryByTag;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowBuildResultsWithTagActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private List<IBuildDefinition> fDefinitions;
    private IWorkbenchPartSite fPartSite;
    private IStructuredSelection fSelection;

    public Action getAction(final List<BuildDomainQueryNode> queryNodes, final List<IBuildDefinitionHandle> buildDefHandles, final IWorkbenchPartSite partSite) {
        return new Action(Messages.BuildDomainActionHelper_TAG_QUERY_ACTION_NAME){

            public void run() {
                if (queryNodes.size() > 1) {
                    ShowBuildResultsWithTagActionDelegate.run(null, buildDefHandles, partSite);
                } else {
                    ShowBuildResultsWithTagActionDelegate.run(((BuildDomainQueryNode)queryNodes.get(0)).getLabel(), buildDefHandles, partSite);
                }
            }

            public String getId() {
                return "show.builds.tag.and.definition";
            }
        };
    }

    public static void run(String label, List<IBuildDefinitionHandle> buildDefHandles, IWorkbenchPartSite partSite) {
        ITeamRepository teamRepository = (ITeamRepository)buildDefHandles.get(0).getOrigin();
        String tag = ShowBuildResultsWithTagActionDelegate.promptForTag(partSite.getShell(), teamRepository, buildDefHandles);
        String name = null;
        name = buildDefHandles.size() == 1 ? NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_ONE_DEFINITION, (Object)label, (Object)tag) : NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_MULTIPLE_DEFINITIONS, (Object)tag);
        name = TextProcessor.process((String)name);
        BuildQueryByTag query = new BuildQueryByTag(name, null, AdaptableBuildQueryRow.Factory, buildDefHandles.toArray(new IBuildDefinitionHandle[buildDefHandles.size()]), tag, teamRepository);
        BuildQueryView.displayQuery(query, partSite.getPage());
    }

    public void run(IAction action) {
        if (this.fDefinitions != null) {
            if (this.fDefinitions.size() > 1) {
                ShowBuildResultsWithTagActionDelegate.run(null, this.fDefinitions.stream().map(fBuildDef -> (IBuildDefinitionHandle)fBuildDef.getItemHandle()).collect(Collectors.toList()), this.fPartSite);
            } else {
                ShowBuildResultsWithTagActionDelegate.run(this.fDefinitions.get(0).getId(), this.fDefinitions.stream().map(fBuildDef -> (IBuildDefinitionHandle)fBuildDef.getItemHandle()).collect(Collectors.toList()), this.fPartSite);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.fDefinitions = new ArrayList<IBuildDefinition>();
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
            Object[] objectArray = this.fSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IBuildDefinition) {
                    this.fDefinitions.add((IBuildDefinition)obj);
                }
                ++n2;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPartSite = targetPart.getSite();
    }

    protected static String promptForTag(Shell shell, ITeamRepository teamRepository, List<IBuildDefinitionHandle> buildDefHandles) {
        String tag = "";
        TagContentProposalProvider tagProvider = null;
        tagProvider = new TagContentProposalProvider(teamRepository, buildDefHandles.toArray(new IBuildDefinitionHandle[buildDefHandles.size()]));
        PromptForTagDialog dialog = new PromptForTagDialog(shell, tagProvider);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            tag = dialog.getTags();
        }
        return tag;
    }
}

