/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryBySelectedProcessAreas;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowBuildResultsActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private List<BuildDomainQueryNode> fBuildDefinitionQueryNodes;
    private List<IBuildDefinition> fBuildDefinitions;
    private IWorkbenchPartSite fPartSite;
    private IProjectAreaHandle projectAreaHandle;

    public Action getAction(final IProjectAreaHandle projectAreaHandle, final IWorkbenchPartSite partSite) {
        return new Action(Messages.BuildDomainActionHelper_SHOW_BUILDS){

            public void run() {
                ShowBuildResultsActionDelegate.run(projectAreaHandle, partSite);
            }

            public String getId() {
                return "show.builds.selected.teams";
            }
        };
    }

    public Action getAction(final List<BuildDomainQueryNode> queryNodes, final List<IBuildDefinitionHandle> buildDefs, final IWorkbenchPartSite partSite) {
        return new Action(Messages.BuildDomainActionHelper_SHOW_BUILDS){

            public void run() {
                if (queryNodes.size() > 1) {
                    ShowBuildResultsActionDelegate.run(null, buildDefs, partSite);
                } else {
                    ShowBuildResultsActionDelegate.run(((BuildDomainQueryNode)queryNodes.get(0)).getLabel(), buildDefs, partSite);
                }
            }

            public String getId() {
                return "show.builds.build.types";
            }
        };
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPartSite = targetPart.getSite();
    }

    public static void run(IProjectAreaHandle projectAreaHandle, IWorkbenchPartSite partSite) {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        String projectAreaName = ConnectedProjectAreaRegistryHelper.getProjectAreaName(projectAreaHandle);
        String queryName = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_MY_BUILDS_FOR_PROJECT, (Object)projectAreaName);
        BuildQueryBySelectedProcessAreas query = new BuildQueryBySelectedProcessAreas(queryName, projectAreaHandle, teamRepository);
        BuildQueryView.displayQuery(query, partSite.getPage());
    }

    public static void run(String name, List<IBuildDefinitionHandle> buildDefs, IWorkbenchPartSite partSite) {
        ITeamRepository teamRepository = (ITeamRepository)buildDefs.get(0).getOrigin();
        if (buildDefs.size() > 1) {
            name = NLS.bind((String)Messages.BuildDomainActionHelper_QUERY_NAME_MULTIPLE, (Object)buildDefs.size());
        }
        BuildQueryByDefinition query = new BuildQueryByDefinition(name, null, AdaptableBuildQueryRow.Factory, buildDefs, teamRepository);
        BuildQueryView.displayQuery(query, partSite.getPage());
    }

    public void run(IAction action) {
        if (this.fBuildDefinitions.size() > 1) {
            ShowBuildResultsActionDelegate.run(null, this.fBuildDefinitions.stream().map(buildDef -> (IBuildDefinitionHandle)buildDef.getItemHandle()).collect(Collectors.toList()), this.fPartSite);
        } else {
            ShowBuildResultsActionDelegate.run(this.fBuildDefinitions.get(0).getId(), this.fBuildDefinitions.stream().map(buildDef -> (IBuildDefinitionHandle)buildDef.getItemHandle()).collect(Collectors.toList()), this.fPartSite);
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.fBuildDefinitions = new ArrayList<IBuildDefinition>();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IBuildDefinition) {
                    IBuildDefinition buildDef = (IBuildDefinition)obj;
                    IProcessAreaHandle processArea = buildDef.getProcessArea();
                    if (processArea instanceof IProjectAreaHandle) {
                        this.projectAreaHandle = (IProjectAreaHandle)processArea;
                    }
                    this.fBuildDefinitions.add(buildDef);
                }
                ++n2;
            }
        }
    }
}

