/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;

public final class ShowBuildResultsAction
extends Action {
    private final List<BuildDomainQueryNode> fBuildDefinitionQueryNodes;
    private final List<IBuildDefinitionHandle> fBuildDefinitionHandles;
    private IWorkbenchPage fWorkbenchPage;

    public ShowBuildResultsAction(List<BuildDomainQueryNode> buildDefinitionQueryNodes, List<IBuildDefinitionHandle> buildDefinitionHandles, IWorkbenchPage workbenchPage) {
        super(Messages.BuildDomainActionHelper_SHOW_BUILDS);
        this.fBuildDefinitionQueryNodes = buildDefinitionQueryNodes;
        this.fBuildDefinitionHandles = buildDefinitionHandles;
        this.fWorkbenchPage = workbenchPage;
    }

    public void run() {
        ITeamRepository teamRepository = (ITeamRepository)this.fBuildDefinitionHandles.get(0).getOrigin();
        String name = this.fBuildDefinitionQueryNodes.get(0).getLabel();
        if (this.fBuildDefinitionHandles.size() > 1) {
            name = NLS.bind((String)Messages.BuildDomainActionHelper_QUERY_NAME_MULTIPLE, (Object)this.fBuildDefinitionHandles.size());
        }
        BuildQueryByDefinition query = new BuildQueryByDefinition(name, null, AdaptableBuildQueryRow.Factory, this.fBuildDefinitionHandles, teamRepository);
        BuildQueryView.displayQuery(query, this.fWorkbenchPage);
    }

    public String getId() {
        return "show.builds.build.types";
    }
}

