/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.internal.ui.actions.SaveRepositoryFileAction;
import com.ibm.team.build.internal.ui.actions.SaveURLAction;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class SaveDownloadActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            if (this.fSelection.size() == 1 && action != null) {
                this.updateEnablement(action, this.fSelection);
            }
        }
    }

    protected void updateEnablement(IAction action, IStructuredSelection selection) {
        DownloadContributionNode node = this.getNode(selection);
        if (node != null) {
            action.setEnabled(node.isExternalArtifact() || node.getContribution().getExtendedContributionData() != null);
        }
    }

    protected DownloadContributionNode getNode(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof DownloadContributionNode) {
            return (DownloadContributionNode)element;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof DownloadContributionNode) {
            Action saveAction = null;
            DownloadContributionNode node = (DownloadContributionNode)this.fSelection.getFirstElement();
            saveAction = node.isExternalArtifact() ? new SaveURLAction(node.getFileURL(), this.fTargetPart.getSite().getShell()) : new SaveRepositoryFileAction(this.fTargetPart.getSite(), node.getRepository(), node.getFileName(), node.getContribution().getExtendedContributionData());
            this.runAction((IAction)saveAction);
        }
    }

    protected void runAction(IAction action) {
        action.run();
    }
}

