/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionDelegate;

public class RequestBuildActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IBuildDefinition fDefinition;
    private IWorkbenchPartSite fPartSite;
    private IStructuredSelection fSelection;

    public Action getAction(final IBuildDefinitionHandle buildDef, final IWorkbenchPartSite partSite) {
        return new Action(Messages.BuildDomain_REQUEST_BUILD_ACTION_LABEL){

            public void run() {
                RequestBuildActionDelegate.run(buildDef, partSite);
            }

            public String getId() {
                return "request.build.type";
            }
        };
    }

    public static void run(IBuildDefinitionHandle buildDef, IWorkbenchPartSite partSite) {
        if (buildDef != null && partSite != null) {
            RequestBuildDialog dialog = new RequestBuildDialog(partSite.getShell(), buildDef);
            dialog.setWorkbenchPartSite(partSite);
            dialog.open();
        }
    }

    public void run(IAction action) {
        RequestBuildActionDelegate.run((IBuildDefinitionHandle)this.fDefinition.getItemHandle(), this.fPartSite);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
            Object[] objectArray = this.fSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IBuildDefinition) {
                    this.fDefinition = (IBuildDefinition)obj;
                }
                if (obj instanceof BuildDefinitionQueryNode) {
                    BuildDefinitionQueryNode queryNode = (BuildDefinitionQueryNode)obj;
                    this.fDefinition = queryNode.getBuildDefinition();
                }
                ++n2;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPartSite = targetPart.getSite();
    }
}

