/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionDelegate;

public class OpenLatestBuildActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IBuildDefinition fDefinition;
    private IWorkbenchPartSite fPartSite;
    private IStructuredSelection fSelection;

    public Action getAction(final String buildDefID, final ITeamRepository teamRepository, final IWorkbenchPartSite partSite) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_LATEST_BUILD){

            public void run() {
                OpenLatestBuildActionDelegate.run(buildDefID, teamRepository, null, partSite);
            }

            public String getId() {
                return "open.latest.build";
            }
        };
    }

    public static void run(final String buildDefID, final ITeamRepository teamRepository, final IBuildDefinition buildDef, final IWorkbenchPartSite partSite) {
        String jobName = Messages.BuildDomainActionHelper_JOB_LABEL_OPEN_LATEST_BUILD;
        TeamBuildJob job = new TeamBuildJob(jobName, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildDefinition buildDefinition;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
                IBuildDefinition iBuildDefinition = buildDefinition = buildDef == null ? client.getBuildDefinition(buildDefID, (IProgressMonitor)subMonitor.newChild(1)) : buildDef;
                if (buildDefinition != null) {
                    BuildState[] buildStatesOfInterest = new BuildState[]{BuildState.INCOMPLETE, BuildState.IN_PROGRESS, BuildState.COMPLETED};
                    IBuildResult buildResult = client.getLastBuildResult((IBuildDefinitionHandle)buildDefinition, buildStatesOfInterest, IBuildResult.PROPERTIES_VIEW_ITEM, (IProgressMonitor)subMonitor.newChild(1));
                    if (buildResult != null) {
                        BuildUI.getDefault().open((IBuildResultHandle)buildResult, teamRepository, partSite.getPage());
                    } else {
                        BuildUIHelper.showInfoDialog(partSite.getShell(), Messages.BuildDomainActionHelper_NO_BUILDS_TITLE, Messages.BuildDomainActionHelper_NO_BUILDS_FOUND);
                    }
                } else {
                    BuildUIHelper.showErrorDialog(Messages.BuildDomainActionHelper_NO_DEFINITION_FOUND);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void run(IAction action) {
        OpenLatestBuildActionDelegate.run(null, (ITeamRepository)this.fDefinition.getOrigin(), this.fDefinition, this.fPartSite);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
            Object[] objectArray = this.fSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IBuildDefinition) {
                    this.fDefinition = (IBuildDefinition)obj;
                }
                ++n2;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPartSite = targetPart.getSite();
    }
}

