/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.dialogs.BuildFolderPropertiesDialog;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class NewBuildFolderActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private final IPreferenceStore fPreferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();

    public Action getAction(IProcessAreaHandle processAreaHandle, Shell parentShell) {
        ValidationHelper.validateNotNull((String)"processAreaHandle", (Object)processAreaHandle);
        return this.getAction(processAreaHandle, null, parentShell);
    }

    public Action getAction(IBuildFolderHandle parentFolderHandle, Shell parentShell) {
        ValidationHelper.validateNotNull((String)"parentFolderHandle", (Object)parentFolderHandle);
        return this.getAction(null, parentFolderHandle, parentShell);
    }

    private Action getAction(final IProcessAreaHandle processAreaHandle, final IBuildFolderHandle parentFolderHandle, final Shell parentShell) {
        return new Action(){

            public void run() {
                ITeamRepository teamRepository = null;
                if (processAreaHandle != null) {
                    teamRepository = (ITeamRepository)processAreaHandle.getOrigin();
                } else if (parentFolderHandle != null) {
                    teamRepository = (ITeamRepository)parentFolderHandle.getOrigin();
                }
                NewBuildFolderActionDelegate.this.run(processAreaHandle, parentFolderHandle, teamRepository, parentShell);
            }

            public String getText() {
                return BuildUIActionMessages.NewBuildFolderActionDelegate_LABEL_NEW_BUILD_FOLDER;
            }

            public String getId() {
                return "new.build.folder";
            }
        };
    }

    private void run(final IProcessAreaHandle processAreaHandle, final IBuildFolderHandle parentFolderHandle, ITeamRepository teamRepository, final Shell parentShell) {
        TeamBuildJob newFolderJob = new TeamBuildJob(BuildUIActionMessages.NewBuildFolderActionDelegate_LABEL_NEW_BUILD_FOLDER, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    boolean showFolders = NewBuildFolderActionDelegate.this.fPreferenceStore.getBoolean("show_build_folders");
                    if (!showFolders) {
                        boolean response = BuildUIHelper.showInfoQueryDialogSync(parentShell, BuildUIActionMessages.BuildFolderActionDelegate_ENABLE_FOLDERS_TITLE, BuildUIActionMessages.BuildFolderActionDelegate_ENABLE_FOLDERS_NEW_FOLDER_CONFIRMATION_MESSAGE);
                        if (response) {
                            NewBuildFolderActionDelegate.this.fPreferenceStore.setValue("show_build_folders", true);
                        } else {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!parentShell.isDisposed()) {
                                if (parentFolderHandle != null) {
                                    BuildFolderPropertiesDialog.openNewFolderDialog(parentShell, parentFolderHandle);
                                } else {
                                    BuildFolderPropertiesDialog.openNewFolderDialog(parentShell, processAreaHandle);
                                }
                            }
                        }
                    });
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        newFolderJob.schedule();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

