/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.dialogs.BuildFolderSelectionDialog;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.common.IItemHandle;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class MoveBuildItemsAction
extends Action {
    private final IPreferenceStore fPreferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
    private final Shell fParentShell;
    private final IItemHandle[] fItemHandles;
    private final IProcessAreaHandle fProcessAreaHandle;

    public MoveBuildItemsAction(Shell parentShell, IItemHandle[] itemHandles, IProcessAreaHandle processAreaHandle) {
        this.fParentShell = parentShell;
        this.fItemHandles = itemHandles;
        this.fProcessAreaHandle = processAreaHandle;
    }

    public void run() {
        if (!this.fParentShell.isDisposed()) {
            IProjectArea projectArea;
            boolean showFolders = this.fPreferenceStore.getBoolean("show_build_folders");
            if (!showFolders) {
                boolean response = BuildUIHelper.showInfoQueryDialog(this.fParentShell, BuildUIActionMessages.BuildFolderActionDelegate_ENABLE_FOLDERS_TITLE, BuildUIActionMessages.BuildFolderActionDelegate_ENABLE_FOLDERS_MOVE_CONFIRMATION_MESSAGE);
                if (response) {
                    this.fPreferenceStore.setValue("show_build_folders", true);
                } else {
                    return;
                }
            }
            List processAreas = null;
            if (this.fProcessAreaHandle instanceof IProjectAreaHandle) {
                processAreas = ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas((IProjectAreaHandle)this.fProcessAreaHandle);
            } else if (this.fProcessAreaHandle instanceof ITeamAreaHandle && (projectArea = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectArea((ITeamAreaHandle)this.fProcessAreaHandle)) != null) {
                processAreas = ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas((IProjectAreaHandle)projectArea);
            }
            if (processAreas != null) {
                BuildFolderSelectionDialog.open(this.fParentShell, this.fItemHandles, processAreas.toArray(new IProcessAreaHandle[processAreas.size()]));
            }
        }
    }

    public String getId() {
        return "move.build.items.to.folder";
    }

    public String getText() {
        return Messages.BuildDomainActionHelper_MOVE_BUILD_ITEMS_JOB_LABEL;
    }
}

