/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditBuildEngineActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof IBuildEngine) {
            IBuildEngine buildEngine = (IBuildEngine)this.fSelection.getFirstElement();
            EditBuildEngineActionDelegate.run(buildEngine, this.fTargetPart.getSite().getPage());
        }
    }

    public static void run(final IBuildEngine buildEngine, final IWorkbenchPage workbenchPage) {
        String jobName = BuildUIActionMessages.EditBuildDefinitionActionDelegate_FETCHING_TEAM_AREA;
        TeamBuildJob job = new TeamBuildJob(jobName, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ITeamRepository teamRepository = (ITeamRepository)buildEngine.getOrigin();
                IProcessAreaHandle processAreaHandle = buildEngine.getProcessArea();
                final IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EditBuildEngineActionDelegate.handleAsyncExec(workbenchPage, buildEngine, processArea);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void handleAsyncExec(IWorkbenchPage workbenchPage, IBuildEngine buildEngine, IProcessArea processArea) {
        if (!workbenchPage.getWorkbenchWindow().getShell().isDisposed()) {
            try {
                BuildEngineEditorInput input = new BuildEngineEditorInput(buildEngine, processArea, (ITeamRepository)buildEngine.getOrigin());
                workbenchPage.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildEngineEditor");
            }
            catch (PartInitException exception) {
                BuildUIPlugin.log(exception);
            }
        }
    }
}

