/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.MultipleErrorTeamBuildException;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteBuildFolderActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    private List<IBuildFolderHandle> fFoldersToDelete;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    @Override
    protected String getConfirmationMessage() {
        return BuildUIActionMessages.DeleteBuildFolderActionDelegate_CONFIRMATION_MESSAGE;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (this.fFoldersToDelete != null && this.fFoldersToDelete.size() > 0) {
            HashMap repoToFolderMap = new HashMap();
            for (IBuildFolderHandle folderHandle : this.fFoldersToDelete) {
                ITeamRepository teamRepository = (ITeamRepository)folderHandle.getOrigin();
                if (!repoToFolderMap.containsKey(teamRepository)) {
                    ArrayList<IBuildFolderHandle> list = new ArrayList<IBuildFolderHandle>();
                    list.add(folderHandle);
                    repoToFolderMap.put(teamRepository, list);
                    continue;
                }
                ((List)repoToFolderMap.get(teamRepository)).add(folderHandle);
            }
            progressMonitor.beginTask(BuildUIActionMessages.DeleteBuildFolderActionDelegate_JOB_TITLE, this.fFoldersToDelete.size());
            try {
                ArrayList<TeamRepositoryException> exceptions = null;
                int failedDeleteCount = 0;
                for (ITeamRepository teamRepository : repoToFolderMap.keySet()) {
                    List repoFoldersToDelete = (List)repoToFolderMap.get(teamRepository);
                    ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
                    try {
                        teamBuildClient.delete(repoFoldersToDelete.toArray(new IBuildFolderHandle[repoFoldersToDelete.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, repoFoldersToDelete.size()));
                    }
                    catch (TeamRepositoryException e) {
                        if (e instanceof TeamOperationCanceledException) continue;
                        if (exceptions == null) {
                            exceptions = new ArrayList<TeamRepositoryException>();
                        }
                        exceptions.add(e);
                        failedDeleteCount += repoFoldersToDelete.size();
                    }
                }
                if (exceptions != null) {
                    if (exceptions.size() == 1) {
                        throw new TeamBuildException(NLS.bind((String)BuildUIActionMessages.DeleteBuildFolderActionDelegate_FOLDER_DELETE_FAILED, (Object)failedDeleteCount, (Object[])new Object[0]), (Throwable)exceptions.get(0));
                    }
                    throw new MultipleErrorTeamBuildException(NLS.bind((String)BuildUIActionMessages.DeleteBuildFolderActionDelegate_FOLDER_DELETE_FAILED, (Object)failedDeleteCount, (Object[])new Object[0]), exceptions.toArray(new Throwable[exceptions.size()]));
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    @Override
    protected String getJobLabel() {
        return BuildUIActionMessages.DeleteBuildFolderActionDelegate_JOB_TITLE;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.fFoldersToDelete = new ArrayList<IBuildFolderHandle>();
        for (IBuildFolderHandle folderHandle : structuredSelection) {
            this.fFoldersToDelete.add(folderHandle);
        }
    }

    @Override
    public void run(IAction action) {
        boolean proceed;
        String confirmationMessage = this.getConfirmationMessage();
        if (confirmationMessage != null && !(proceed = BuildUIHelper.showInfoQueryDialog(BuildUIActionMessages.AbstractRepositoryActionDelegate_0, confirmationMessage))) {
            return;
        }
        TeamBuildJob job = this.createJob();
        job.setUser(true);
        job.schedule();
    }
}

