/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteBuildDefinitionActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    protected List<IBuildDefinition> fBuildDefinitions = new ArrayList<IBuildDefinition>();

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.fBuildDefinitions.clear();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object object : structuredSelection) {
            if (!(object instanceof IBuildDefinition)) continue;
            this.fBuildDefinitions.add((IBuildDefinition)object);
        }
    }

    @Override
    protected String getConfirmationMessage() {
        return BuildUIActionMessages.RemoveBuildDefinitionActionDelegate_1;
    }

    @Override
    protected String getJobLabel() {
        return BuildUIActionMessages.RemoveBuildDefinitionActionDelegate_0;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        progressMonitor.beginTask(BuildUIActionMessages.RemoveBuildDefinitionActionDelegate_0, this.fBuildDefinitions.size() * 2);
        try {
            for (IBuildDefinition buildDefinition : this.fBuildDefinitions) {
                ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
                ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
                IBaseBuildResultQueryModel.IBuildResultQueryModel queryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
                IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)queryModel);
                query.select(query.count());
                query.filter(queryModel.buildDefinition()._eq(query.newItemHandleArg()));
                IDataQueryPage page = teamBuildClient.queryData(query, new Object[]{buildDefinition}, 1, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                IDataRow row = page.getRow(0);
                if (row.getInt(0) > 0) {
                    this.openError(BuildUIActionMessages.DeleteBuildDefinitionActionDelegate_DELETE_PROBLEM, NLS.bind((String)BuildUIActionMessages.DeleteBuildDefinitionActionDelegate_CANT_DELETE, (Object)buildDefinition.getId()));
                    continue;
                }
                try {
                    teamBuildClient.delete((IBuildDefinitionHandle)buildDefinition, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    protected void openError(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)DeleteBuildDefinitionActionDelegate.this.getShell(), (String)title, (String)message);
            }
        });
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

