/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.editors.result.download.CopyToClipboardAction;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;

public class CopyDownloadLinkLocationActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private IStructuredSelection fSelection;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            if (action != null) {
                this.updateEnablement(action, this.fSelection);
            }
        }
    }

    protected void updateEnablement(IAction action, IStructuredSelection selection) {
        DownloadContributionNode node = this.getNode(selection);
        if (node != null) {
            action.setText(node.isExternalArtifact() ? BuildUIActionMessages.CopyToClipboardAction_LinkMenuText : BuildUIActionMessages.CopyToClipboardAction_FileMenuText);
        }
    }

    protected DownloadContributionNode getNode(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof DownloadContributionNode) {
            return (DownloadContributionNode)element;
        }
        return null;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof DownloadContributionNode) {
            DownloadContributionNode node = (DownloadContributionNode)this.fSelection.getFirstElement();
            this.runAction((IAction)new CopyToClipboardAction(node.getFileURL(), node.isExternalArtifact()));
        }
    }

    protected void runAction(IAction action) {
        action.run();
    }
}

