/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.history.BuildPropertyCompareEditorInput;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class CompareBuildResultUserPropertiesActionDelegate
extends ActionDelegate {
    private IStructuredSelection fSelection;

    public void run(IAction action) {
        if (this.fSelection != null) {
            Object[] elements = this.fSelection.toArray();
            IBuildResultRecord firstResultRecord = (IBuildResultRecord)elements[0];
            IBuildResultRecord secondResultRecord = (IBuildResultRecord)elements[1];
            IBuildRequest request1 = firstResultRecord.getBuildRequests()[0];
            IBuildRequest request2 = secondResultRecord.getBuildRequests()[0];
            List buildPropertiesList1 = request1.getBuildDefinitionInstance().getProperties();
            List buildPropertiesList2 = request2.getBuildDefinitionInstance().getProperties();
            String leftLabel = firstResultRecord.getBuildResult().getLabel();
            String rightLabel = secondResultRecord.getBuildResult().getLabel();
            CompareConfiguration configuration = new CompareConfiguration();
            configuration.setLeftEditable(false);
            configuration.setRightEditable(false);
            configuration.setLeftLabel(leftLabel);
            configuration.setRightLabel(rightLabel);
            BuildPropertyCompareEditorInput input = new BuildPropertyCompareEditorInput(this.getPropertiesText(buildPropertiesList1), this.getPropertiesText(buildPropertiesList2), null, leftLabel, rightLabel, configuration);
            String title = request1.getBuildDefinitionInstance().getBuildDefinitionId();
            input.setTitle(title != null ? String.valueOf(title) + "-" + BuildUIHistoryMessages.AuditableHistoryPage_COMPARE_TITLE : BuildUIHistoryMessages.AuditableHistoryPage_COMPARE_TITLE);
            CompareBuildResultUserPropertiesActionDelegate.internalOpenCompareEditor(input, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages()[0], CompareBuildResultUserPropertiesActionDelegate.findReusableEditor(input, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages()[0]));
        }
    }

    private static void internalOpenCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (page == null || input == null) {
            return;
        }
        if (editor != null) {
            IEditorReference editorReference = CompareBuildResultUserPropertiesActionDelegate.getEditorReference((IEditorPart)editor, page);
            if (editorReference != null && !editorReference.isDirty() && !editorReference.isPinned()) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals(input)) {
                    CompareBuildResultUserPropertiesActionDelegate.showEditor(page, editor);
                }
            } else {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
            }
        } else {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
        }
    }

    private String getPropertiesText(List buildProperties) {
        String propertiesText = "";
        if (buildProperties != null) {
            for (Object object : buildProperties) {
                IBuildProperty property = (IBuildProperty)object;
                if (!property.isGenericEditAllowed()) continue;
                propertiesText = String.valueOf(propertiesText) + property.getName() + "=" + property.getValue() + "\n";
            }
        }
        return propertiesText;
    }

    public static IEditorReference getEditorReference(IEditorPart editor, IWorkbenchPage page) {
        IEditorReference[] editorReferences = page.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            if (editor.equals(editorReferences[i].getEditor(false))) {
                return editorReferences[i];
            }
            ++i;
        }
        return null;
    }

    private static void showEditor(final IWorkbenchPage page, final IReusableEditor editor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (OpenStrategy.activateOnOpen()) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
            }
        });
    }

    public static IReusableEditor findReusableEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IReusableEditor re;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part instanceof IReusableEditor && input.equals((re = (IReusableEditor)part).getEditorInput())) {
                return re;
            }
            ++i;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = null;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

