/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.MultipleErrorTeamBuildException;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AbandonBuildActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fActivePart;

    @Override
    protected String getConfirmationMessage() {
        if (this.fSelection.size() == 1) {
            return BuildUIActionMessages.AbandonBuildAction_3;
        }
        return NLS.bind((String)BuildUIActionMessages.AbandonBuildAction_2, (Object)this.fSelection.size());
    }

    @Override
    protected String getJobLabel() {
        if (this.fSelection.size() > 1) {
            return BuildUIActionMessages.AbandonBuildAction_ABANDON_MULTIPLE_BUILDS_JOB_TITLE;
        }
        return BuildUIActionMessages.AbandonBuildAction_ABANDON_SINGLE_BUILD_JOB_TITLE;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (this.fSelection.isEmpty()) {
            return;
        }
        ArrayList<TeamRepositoryException> errors = null;
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IBuildResultRecord record = (IBuildResultRecord)object;
            ITeamRepository repository = (ITeamRepository)record.getBuildResult().getOrigin();
            try {
                ITeamBuildRequestClient client = ClientFactory.getTeamBuildRequestClient((ITeamRepository)repository);
                client.makeBuildIncomplete((IBuildResultHandle)record.getBuildResult(), IBuildResult.PROPERTIES_REQUIRED, progressMonitor);
            }
            catch (TeamRepositoryException exception) {
                if (errors == null) {
                    errors = new ArrayList<TeamRepositoryException>();
                }
                errors.add(exception);
            }
            ++n2;
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw (TeamRepositoryException)((Object)errors.get(0));
            }
            throw new MultipleErrorTeamBuildException((Throwable[])errors.toArray(new TeamRepositoryException[errors.size()]));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.isQueryActionInProgress()) {
            action.setEnabled(false);
        }
        this.fSelection = (IStructuredSelection)selection;
    }

    protected boolean isQueryActionInProgress() {
        if (this.fActivePart instanceof BuildQueryView) {
            BuildQueryView buildQueryView = (BuildQueryView)this.fActivePart;
            return buildQueryView.isRunBuildQueryActionInProgress();
        }
        return false;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fActivePart = targetPart;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

