/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.internal.common.MicrosoftBuildItem;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.IMicrosoftBuildItemControlListener;
import com.ibm.team.build.internal.ui.MicrosoftBuildItemLabelProvider;
import com.ibm.team.build.internal.ui.dialogs.MicrosoftBuildInputDataDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MicrosoftBuildItemsTableControl {
    private Button fAddSolutionButton;
    private Button fEditSolutionButton;
    private Button fRemoveSolutionButton;
    private Button fMoveUpBuildItemButton;
    private Button fMoveDownBuildItemButton;
    protected Shell fParentShell;
    protected List<MicrosoftBuildItem> fBuildItemProperties;
    private TableViewer fTableViewer;
    private Composite solutionsToBuildComposite;
    private IMicrosoftBuildItemControlListener fChangeListener;
    private static final String[] COLUMN_HEADERS = new String[]{BuildUIMessages.MicrosoftBuildConfigurationEditor_SOLUTION_LABEL, BuildUIMessages.MicrosoftBuildConfigurationEditor_CONFIG_LABEL, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_TYPE_LABEL, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_OUTPUT_LABEL, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_ADDITIONAL_ARG_LABEL, BuildUIMessages.MicrosoftBuildConfigurationEditor_WORKING_DIR_LABEL};
    private static final String[] COLUMN_HEADERS_DESC = new String[]{BuildUIMessages.MicrosoftBuildConfigurationEditor_SOLUTION_DESC, BuildUIMessages.MicrosoftBuildConfigurationEditor_CONFIG_DESC, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_TYPE_DESC, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_OUTPUT_DESC, BuildUIMessages.MicrosoftBuildConfigurationEditor_BUILD_ADDITIONAL_ARG_DESC, BuildUIMessages.MicrosoftBuildConfigurationEditor_WORKING_DIR_DESC};

    public MicrosoftBuildItemsTableControl(Composite parent, FormToolkit fToolkit, List<MicrosoftBuildItem> buildItemProperties) {
        this.fParentShell = parent.getShell();
        this.fBuildItemProperties = buildItemProperties;
        if (this.fBuildItemProperties == null) {
            this.fBuildItemProperties = new ArrayList<MicrosoftBuildItem>(1);
        }
        Composite lableComposite = fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)lableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(lableComposite);
        fToolkit.createLabel(lableComposite, BuildUIMessages.MicrosoftBuildConfigurationEditor_SOLUTION_DESC);
        this.solutionsToBuildComposite = fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.solutionsToBuildComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.solutionsToBuildComposite);
        Composite tableComposite = fToolkit.createComposite(this.solutionsToBuildComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)tableComposite);
        Table table = fToolkit.createTable(tableComposite, 68354);
        this.fTableViewer = new TableViewer(table);
        TableColumnLayout layout = new TableColumnLayout();
        int i = 0;
        while (i < COLUMN_HEADERS.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(COLUMN_HEADERS[i]);
            column.setToolTipText(COLUMN_HEADERS_DESC[i]);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10));
            ++i;
        }
        tableComposite.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fTableViewer.setInput(this.fBuildItemProperties);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.addDoubleClickListener(this.getDoubldClickListener());
        Composite buttonBar = fToolkit.createComposite(this.solutionsToBuildComposite);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fAddSolutionButton = fToolkit.createButton(buttonBar, BuildUIMessages.MicrosoftBuildConfigurationEditor_ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fAddSolutionButton.addSelectionListener(this.getAddSolutionListener());
        this.fEditSolutionButton = fToolkit.createButton(buttonBar, BuildUIMessages.MicrosoftBuildConfigurationEditor_EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditSolutionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildItem buildItem = MicrosoftBuildItemsTableControl.this.getSelectedProperty();
                if (buildItem != null) {
                    MicrosoftBuildItemsTableControl.this.editProperty(buildItem);
                }
            }
        });
        this.fRemoveSolutionButton = fToolkit.createButton(buttonBar, BuildUIMessages.MicrosoftBuildConfigurationEditor_REMOVE_BUTTON_LABEL, 8);
        this.fRemoveSolutionButton.addSelectionListener(this.getRemovePropertyListener());
        this.fMoveUpBuildItemButton = fToolkit.createButton(buttonBar, BuildUIMessages.MicrosoftBuildConfigurationEditor_MOVEUP_BUTTON_LABEL, 8);
        this.fMoveUpBuildItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildItem buildItem = MicrosoftBuildItemsTableControl.this.getSelectedProperty();
                if (buildItem != null) {
                    MicrosoftBuildItemsTableControl.this.moveProperty(true);
                }
            }
        });
        this.fMoveDownBuildItemButton = fToolkit.createButton(buttonBar, BuildUIMessages.MicrosoftBuildConfigurationEditor_MOVEDOWN_BUTTON_LABEL, 8);
        this.fMoveDownBuildItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildItem buildItem = MicrosoftBuildItemsTableControl.this.getSelectedProperty();
                if (buildItem != null) {
                    MicrosoftBuildItemsTableControl.this.moveProperty(false);
                }
            }
        });
        this.updatePropertyButtonEnablement();
        this.setButtonLayoutData();
    }

    protected SelectionListener getRemovePropertyListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildItemsTableControl.this.removeSelectedProperties();
            }
        };
    }

    private void removeSelectedProperties() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (MicrosoftBuildItem buildProperty : structuredSelection) {
                this.fTableViewer.remove((Object)buildProperty);
                this.fBuildItemProperties.remove(buildProperty);
                this.notifyChange();
            }
        }
    }

    private void editProperty(MicrosoftBuildItem buildItem) {
        MicrosoftBuildInputDataDialog dialog = new MicrosoftBuildInputDataDialog(this.fParentShell, BuildUIMessages.MicrosoftBuildConfigurationEditor_EDIT_BUILD_ITEM_DESC, buildItem);
        if (dialog.open() == 0) {
            this.fTableViewer.refresh();
            this.notifyChange();
        }
    }

    private void moveProperty(boolean moveUp) {
        MicrosoftBuildItem buildItem = this.getSelectedProperty();
        int index = this.getElementIndex(buildItem);
        if (moveUp) {
            if (!this.isElementFirstItem(buildItem)) {
                Collections.swap(this.fBuildItemProperties, index, index - 1);
                this.fTableViewer.refresh();
                this.notifyChange();
            }
        } else if (!this.isElementLastItem(buildItem)) {
            Collections.swap(this.fBuildItemProperties, index, index + 1);
            this.fTableViewer.refresh();
            this.notifyChange();
        }
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MicrosoftBuildItemsTableControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    private IDoubleClickListener getDoubldClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MicrosoftBuildItem buildItem = MicrosoftBuildItemsTableControl.this.getSelectedProperty();
                if (buildItem != null) {
                    MicrosoftBuildItemsTableControl.this.editProperty(buildItem);
                }
            }
        };
    }

    private void updatePropertyButtonEnablement() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditSolutionButton.setEnabled(false);
        this.fMoveUpBuildItemButton.setEnabled(false);
        this.fMoveDownBuildItemButton.setEnabled(false);
        this.fRemoveSolutionButton.setEnabled(false);
        if (selection.size() == 1) {
            this.fEditSolutionButton.setEnabled(true);
            this.fMoveUpBuildItemButton.setEnabled(!this.isElementFirstItem(this.getSelectedProperty()));
            this.fMoveDownBuildItemButton.setEnabled(!this.isElementLastItem(this.getSelectedProperty()));
        }
        this.fRemoveSolutionButton.setEnabled(!selection.isEmpty());
    }

    private ITableLabelProvider getLabelProvider() {
        return new MicrosoftBuildItemLabelProvider();
    }

    public Composite getComposite() {
        return this.solutionsToBuildComposite;
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddSolutionButton);
        gc.setFont(this.fAddSolutionButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddSolutionButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditSolutionButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveSolutionButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddSolutionButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditSolutionButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveSolutionButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveUpBuildItemButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveDownBuildItemButton.setLayoutData((Object)gridData);
    }

    protected SelectionListener getAddSolutionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildItemsTableControl.this.addSolution();
            }
        };
    }

    private void addSolution() {
        MicrosoftBuildInputDataDialog dialog = this.getAddSolutionDialog();
        if (dialog.open() == 0) {
            this.fBuildItemProperties.add(dialog.getBuildItem());
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyChange();
        }
    }

    protected MicrosoftBuildInputDataDialog getAddSolutionDialog() {
        return new MicrosoftBuildInputDataDialog(this.fParentShell, BuildUIMessages.MicrosoftBuildConfigurationEditor_ADD_BUILD_ITEM_DESC);
    }

    protected IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private MicrosoftBuildItem getSelectedProperty() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        Object element = selection.getFirstElement();
        if (element instanceof MicrosoftBuildItem) {
            return (MicrosoftBuildItem)element;
        }
        return null;
    }

    private int getElementIndex(MicrosoftBuildItem buildItem) {
        if (this.fBuildItemProperties != null) {
            int i = 0;
            while (i < this.fBuildItemProperties.size()) {
                if (this.fBuildItemProperties.get(i) == buildItem) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean isElementFirstItem(MicrosoftBuildItem buildItem) {
        return this.getElementIndex(buildItem) == 0;
    }

    private boolean isElementLastItem(MicrosoftBuildItem buildItem) {
        return this.fBuildItemProperties != null && this.getElementIndex(buildItem) + 1 == this.fBuildItemProperties.size();
    }

    protected void notifyChange() {
        if (this.fChangeListener != null) {
            this.fChangeListener.buildItemsChanged(this.getBuildProperties());
        }
    }

    public List getBuildProperties() {
        return this.fBuildItemProperties;
    }

    public void setBuildProperties(List<MicrosoftBuildItem> buildProperties) {
        this.fBuildItemProperties = buildProperties;
        this.fTableViewer.setInput(this.fBuildItemProperties);
        this.updatePropertyButtonEnablement();
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public void setChangeListener(IMicrosoftBuildItemControlListener changeListener) {
        this.fChangeListener = changeListener;
    }
}

