/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.FormColors;

public class InformationBar
extends Composite {
    private Label fLabelImage;
    private Link fLabelMessage;
    private Composite fLabelComposite;
    private LocalResourceManager fResourceManager;
    private ListenerList fLinkListeners = new ListenerList(1);
    private final int fStyle;
    private ToolItem fCloseButton;

    public InformationBar(Composite parent, int style) {
        super(parent, 0);
        this.fStyle = style;
        GridLayoutFactory.swtDefaults().margins(2, 0).extendedMargins(0, 0, 0, InformationBar.hasBit(this.fStyle, 2048) ? 3 : 0).applyTo((Composite)this);
        this.createControl();
        this.setVisible(false);
        this.setBackground(this.getDisplay().getSystemColor(29));
    }

    private static boolean hasBit(int mask, int bit) {
        return (mask & bit) != 0;
    }

    public void addLinkListener(IInformationBarListener linkListener) {
        this.fLinkListeners.add((Object)linkListener);
    }

    public void removeLinkListener(IInformationBarListener linkListener) {
        this.fLinkListeners.remove((Object)linkListener);
    }

    protected void createControl() {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        if (InformationBar.hasBit(this.fStyle, 2048)) {
            this.addPaintListener(new PaintListener(){
                final Color fStrokeColor;
                {
                    this.fStrokeColor = InformationBar.this.fResourceManager.createColor(FormColors.blend((RGB)InformationBar.this.getDisplay().getSystemColor(22).getRGB(), (RGB)InformationBar.this.getDisplay().getSystemColor(18).getRGB(), (int)20));
                }

                public void paintControl(PaintEvent e) {
                    Rectangle bounds = InformationBar.this.getClientArea();
                    int yOffset = bounds.y + bounds.height - 3;
                    e.gc.setForeground(e.gc.getDevice().getSystemColor(29));
                    e.gc.drawLine(bounds.x, yOffset, bounds.x + bounds.width, yOffset);
                    e.gc.setForeground(e.gc.getDevice().getSystemColor(25));
                    e.gc.drawLine(bounds.x, ++yOffset, bounds.x + bounds.width, yOffset);
                    e.gc.setForeground(this.fStrokeColor);
                    e.gc.drawLine(bounds.x, ++yOffset, bounds.x + bounds.width, yOffset);
                }
            });
        }
        Composite container = new Composite((Composite)this, 0);
        container.setBackground(container.getShell().getDisplay().getSystemColor(29));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)container);
        this.fLabelComposite = new Composite(container, 0);
        this.fLabelComposite.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.fLabelComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fLabelComposite);
        this.fLabelImage = new Label(this.fLabelComposite, 16384);
        this.fLabelImage.setBackground(this.fLabelComposite.getBackground());
        GridDataFactory.swtDefaults().align(0x1000000, 128).grab(false, true).applyTo((Control)this.fLabelImage);
        this.fLabelMessage = new Link(this.fLabelComposite, 16384);
        this.fLabelMessage.setBackground(this.fLabelComposite.getBackground());
        this.fLabelMessage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] listeners;
                Object[] objectArray = listeners = InformationBar.this.fLinkListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IInformationBarListener)listener).clicked(e.text);
                    ++n2;
                }
            }
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fLabelMessage);
        ToolBar toolBar = new ToolBar(container, 0x820000);
        toolBar.setBackground(container.getBackground());
        GridDataFactory.swtDefaults().align(131072, 128).grab(false, true).applyTo((Control)toolBar);
        this.fCloseButton = new ToolItem(toolBar, 8);
        this.fCloseButton.setImage(BuildUIPlugin.getImage("icons/elcl16/close.gif"));
        this.fCloseButton.setHotImage(BuildUIPlugin.getImage("icons/elcl16/close_hov.gif"));
        this.fCloseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InformationBar.this.hide(true);
            }
        });
    }

    public void setMessage(String message, int type) {
        boolean hasMessage;
        boolean bl = hasMessage = message != null && message.trim().length() > 0;
        if (!hasMessage && !this.isVisible()) {
            return;
        }
        if (!hasMessage && this.isVisible()) {
            this.hide(false);
        } else if (!(!hasMessage || this.isVisible() && message.equals(this.fLabelMessage.getText()))) {
            this.fLabelMessage.setText(message);
            boolean showImage = true;
            this.fLabelImage.setImage(BuildUIPlugin.getImage("icons/obj16/info.gif"));
            GridData imageGridData = (GridData)this.fLabelImage.getLayoutData();
            if (showImage) {
                int indent;
                int closeButtonHeight = this.fCloseButton.getBounds().height;
                int imageHeight = this.fLabelImage.getImage().getImageData().height;
                imageGridData.verticalIndent = indent = Math.max(0, (closeButtonHeight - imageHeight) / 2);
                imageGridData.horizontalIndent = indent;
            }
            this.fLabelImage.setVisible(showImage);
            imageGridData.exclude = !showImage;
            this.fLabelComposite.layout(true, true);
            this.show();
        }
    }

    public void hide(boolean notifyListeners) {
        this.setVisible(false);
        this.getParent().layout(true, true);
        if (notifyListeners) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fLinkListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IInformationBarListener)listener).closed();
                ++n2;
            }
        }
    }

    public void show() {
        this.setVisible(true);
        this.getParent().layout(true, true);
    }

    public void setLayoutData(Object data) {
        if (data != null && data instanceof GridData) {
            ((GridData)data).exclude = !this.isVisible();
        }
        super.setLayoutData(data);
    }

    public void setVisible(boolean visible) {
        Object data = this.getLayoutData();
        if (data != null && data instanceof GridData) {
            ((GridData)data).exclude = !visible;
            super.setLayoutData(data);
        }
        super.setVisible(visible);
    }

    public static interface IInformationBarListener {
        public void clicked(String var1);

        public void closed();
    }
}

