/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorInput;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.tooltips.jobs.OpenEditorJob;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class BuildUISupport {
    private static final BuildUISupport fDefaultBuildUISupport = new BuildUISupport();

    public static BuildUISupport getDefault() {
        return fDefaultBuildUISupport;
    }

    public void open(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
        FindResultJob findResultJob = this.createFindResultJob(buildResultHandle, teamRepository, workbenchPage);
        findResultJob.schedule();
    }

    protected FindResultJob createFindResultJob(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
        return new FindResultJob(buildResultHandle, teamRepository, workbenchPage);
    }

    protected static class FindResultJob
    extends TeamBuildJob {
        private final IBuildResultHandle fBuildResultHandle;
        private final ITeamRepository fTeamRepository;
        private final IWorkbenchPage fWorkbenchPage;

        protected FindResultJob(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
            super(BuildUIMessages.BuildUISupport_OPEN_BUILD_RESULT_JOB_TITLE, true, teamRepository);
            this.fBuildResultHandle = buildResultHandle;
            this.fTeamRepository = teamRepository;
            this.fWorkbenchPage = workbenchPage;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ITeamBuildRecordClient client = (ITeamBuildRecordClient)this.fTeamRepository.getClientLibrary(ITeamBuildRecordClient.class);
            IBuildResultRecord buildResultRecord = client.getBuildResultRecord(this.fBuildResultHandle, IBuildResult.PROPERTIES_COMPLETE, monitor);
            OpenResultEditorJob openResultEditorJob = this.createOpenResultEditorJob(buildResultRecord, this.fTeamRepository, this.fWorkbenchPage);
            openResultEditorJob.schedule();
            return Status.OK_STATUS;
        }

        protected OpenResultEditorJob createOpenResultEditorJob(IBuildResultRecord buildResultRecord, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
            return new OpenResultEditorJob(buildResultRecord, teamRepository, workbenchPage);
        }
    }

    protected static class OpenResultEditorJob
    extends OpenEditorJob {
        private final IBuildResultRecord fBuildResultRecord;

        protected OpenResultEditorJob(IBuildResultRecord buildResultRecord, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
            super(BuildUIMessages.BuildUISupport_OPEN_BUILD_RESULT_EDITOR_JOB_TITLE, teamRepository, workbenchPage);
            this.fBuildResultRecord = buildResultRecord;
        }

        @Override
        protected IEditorInput getEditorInput() {
            return new BuildResultEditorInput(this.fBuildResultRecord, this.getTeamRepository());
        }

        @Override
        protected String getEditorId() {
            return "com.ibm.team.build.ui.editors.buildResultExplorer";
        }
    }
}

