/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildItem;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildStatusCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BuildResultLabelProvider
extends TypeLabelProvider {
    private final Object FETCH_LOCK = new Object();
    private BuildJob fFetchJob;
    private Hashtable<UUID, Image> fBuildResultImages = new Hashtable();
    private Map<UUID, IBuildResultHandle> fCurrentlyFetching = new Hashtable<UUID, IBuildResultHandle>();
    private final Collection<String> REQUIRED_BUILD_RESULT_PROPERTIES = new Vector<String>(3);
    private Set<IBuildItem> fCachedBuildItems = new HashSet<IBuildItem>();
    private Set<UUID> fDeletedBuilds = new HashSet<UUID>();
    private FetchJobStatus fFetchJobStatus = FetchJobStatus.NOT_RUNNING;

    public BuildResultLabelProvider() {
        this.REQUIRED_BUILD_RESULT_PROPERTIES.add(IBuildResult.PROPERTY_LABEL);
        this.REQUIRED_BUILD_RESULT_PROPERTIES.add(IBuildResult.PROPERTY_BUILD_DEFINITION);
        this.REQUIRED_BUILD_RESULT_PROPERTIES.add(IBuildResult.PROPERTY_BUILD_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabel(ViewerLabel label, Object element) {
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)element;
        Object[] buildResultInfo = this.getBuildResultLabelObjects(buildResultHandle);
        Object object = this.FETCH_LOCK;
        synchronized (object) {
            if (buildResultInfo == null) {
                if (this.fDeletedBuilds.contains(buildResultHandle.getItemId())) {
                    if (label.getText() == null || label.getText().length() == 0) {
                        label.setText(BuildUIMessages.BUILD_RESULT_LABEL_DELETED);
                    }
                    label.setImage(BuildUIPlugin.getImage("icons/obj16/abanblds_obj.gif"));
                } else if (!this.fCurrentlyFetching.containsKey(buildResultHandle.getItemId())) {
                    if (this.fBuildResultImages.containsKey(buildResultHandle.getItemId())) {
                        label.setImage(this.fBuildResultImages.get(buildResultHandle.getItemId()));
                    } else {
                        label.setImage(BuildUIPlugin.getImage("icons/obj16/bld_rslt.gif"));
                    }
                    this.fCurrentlyFetching.put(buildResultHandle.getItemId(), buildResultHandle);
                    if (this.fFetchJob == null) {
                        this.fFetchJob = this.createFetchJob();
                    }
                    if (this.fFetchJobStatus == FetchJobStatus.NOT_RUNNING) {
                        this.scheduleFetchJob(this.fFetchJob);
                        this.fFetchJobStatus = FetchJobStatus.SCHEDULED;
                    }
                }
            }
        }
        if (buildResultInfo != null) {
            this.updateLabel(label, (IBuildResult)buildResultInfo[0], (IBuildDefinition)buildResultInfo[1]);
        }
    }

    protected void updateLabel(ViewerLabel label, IBuildResult buildResult, IBuildDefinition buildDefinition) {
        label.setText(NLS.bind((String)BuildUIMessages.BUILD_RESULT_LABEL, (Object)buildDefinition.getId(), (Object)buildResult.getLabel()));
        if (!this.fBuildResultImages.containsKey(buildResult.getItemId())) {
            this.fBuildResultImages.put(buildResult.getItemId(), BuildStatusCompositeImageDescriptor.getBuildResultComposite(buildResult, this.getResources()));
        }
        label.setImage(this.fBuildResultImages.get(buildResult.getItemId()));
    }

    protected Object[] getBuildResultLabelObjects(IBuildResultHandle handle) {
        Object[] objectArray;
        IBuildDefinition buildDefinition = null;
        IBuildResult buildResult = this.getBuildResult(handle);
        if (buildResult != null) {
            buildDefinition = this.getBuildDefinition(buildResult);
        }
        if (buildDefinition == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = buildResult;
            objectArray = objectArray2;
            objectArray2[1] = buildDefinition;
        }
        return objectArray;
    }

    protected IBuildResult getBuildResult(IBuildResultHandle handle) {
        IBuildResult buildResult;
        ITeamRepository repository = this.getOrigin(handle);
        if (repository == null) {
            return null;
        }
        IBuildResult iBuildResult = buildResult = handle instanceof IBuildResult ? (IBuildResult)handle : null;
        if (buildResult == null) {
            buildResult = (IBuildResult)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
        }
        if (buildResult == null || !this.hasRequiredProperties(buildResult)) {
            return null;
        }
        this.fCachedBuildItems.add((IBuildItem)buildResult);
        return buildResult;
    }

    protected IBuildDefinition getBuildDefinition(IBuildResult buildResult) {
        ITeamRepository repository = this.getOrigin((IBuildResultHandle)buildResult);
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().getSharedItemIfKnown((IItemHandle)buildResult.getBuildDefinition());
        if (buildDefinition == null || !buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            return null;
        }
        this.fCachedBuildItems.add((IBuildItem)buildDefinition);
        return buildDefinition;
    }

    private boolean hasRequiredProperties(IBuildResult buildResult) {
        for (String requiredProperty : this.REQUIRED_BUILD_RESULT_PROPERTIES) {
            if (buildResult.isPropertySet(requiredProperty)) continue;
            return false;
        }
        return true;
    }

    protected void scheduleFetchJob(BuildJob fetchJob) {
        fetchJob.scheduleJob();
    }

    protected BuildJob createFetchJob() {
        return new BuildJob(BuildUIMessages.BuildResultLabelProvider_FETCH_BUILD_RESULT_JOB_TITLE){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BuildResultLabelProvider.this.fetchBuildResults(monitor);
                }
                finally {
                    BuildResultLabelProvider.this.fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                }
                return Status.OK_STATUS;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void fetchBuildResults(IProgressMonitor monitor) {
        buildResultsToResolve = new HashSet<IBuildResultHandle>();
        resolvedBuildResults = new ArrayList<IBuildResult>();
        teamRepository = null;
        while (true) {
            block35: {
                var5_5 = this.FETCH_LOCK;
                synchronized (var5_5) {
                    if (this.fCurrentlyFetching.size() <= 0) {
                        this.fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                        break;
                    }
                    this.fFetchJobStatus = FetchJobStatus.RUNNING;
                    buildResultsToResolve.clear();
                    resolvedBuildResults.clear();
                    teamRepository = null;
                    iterator = this.fCurrentlyFetching.values().iterator();
                    while (iterator.hasNext()) {
                        handle = iterator.next();
                        if (this.getOrigin(handle) == null) {
                            iterator.remove();
                            continue;
                        }
                        if (teamRepository == null) {
                            buildResultsToResolve.add(handle);
                            teamRepository = this.getOrigin(handle);
                            continue;
                        }
                        if (!teamRepository.getId().equals((Object)this.getOrigin(handle).getId())) continue;
                        buildResultsToResolve.add(handle);
                    }
                }
                try {
                    try {
                        resultsToFetch = new ArrayList<IBuildResultHandle>();
                        definitionsToFetch = new ArrayList<IBuildDefinitionHandle>();
                        for (IBuildResultHandle buildResultHandle : buildResultsToResolve) {
                            buildResult = this.getBuildResult(buildResultHandle);
                            if (buildResult == null) {
                                resultsToFetch.add(buildResultHandle);
                                continue;
                            }
                            resolvedBuildResults.add(buildResult);
                            definition = this.getBuildDefinition(buildResult);
                            if (definition != null) continue;
                            definitionsToFetch.add(buildResult.getBuildDefinition());
                        }
                        if (resultsToFetch.size() > 0) {
                            fetchedBuildResults = teamRepository.itemManager().fetchPartialItems(resultsToFetch, 0, this.REQUIRED_BUILD_RESULT_PROPERTIES, monitor);
                            i = 0;
                            while (i < fetchedBuildResults.size()) {
                                fetchedResult = (IBuildResult)fetchedBuildResults.get(i);
                                if (fetchedResult != null) {
                                    resolvedBuildResults.add(fetchedResult);
                                    definition = this.getBuildDefinition(fetchedResult);
                                    if (definition == null) {
                                        definitionsToFetch.add(fetchedResult.getBuildDefinition());
                                    }
                                } else {
                                    this.fDeletedBuilds.add(((IBuildResultHandle)resultsToFetch.get(i)).getItemId());
                                }
                                ++i;
                            }
                        }
                        this.fCachedBuildItems.addAll(resolvedBuildResults);
                        if (definitionsToFetch.size() > 0) {
                            this.fCachedBuildItems.addAll(teamRepository.itemManager().fetchPartialItems(definitionsToFetch, 0, Arrays.asList(new String[]{IBuildDefinition.PROPERTY_ID, IBuildDefinition.PROPERTY_PROCESS_AREA}), monitor));
                        }
                        break block35;
                    }
                    catch (TeamRepositoryException exception) {
                        BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), BuildUIMessages.BuildResultLabelProvider_FETCH_ERROR, (Throwable)exception));
                        ** for (resolvedResult : resolvedBuildResults)
                    }
                }
                catch (Throwable var11_16) {
                    ** for (resolvedResult : resolvedBuildResults)
                }
lbl-1000:
                // 1 sources

                {
                    this.fBuildResultImages.put(resolvedResult.getItemId(), BuildStatusCompositeImageDescriptor.getBuildResultComposite((IBuildResult)resolvedResult, this.getResources()));
                    continue;
                }
lbl79:
                // 1 sources

                resolvedResult = this.FETCH_LOCK;
                synchronized (resolvedResult) {
                    for (Object handle : buildResultsToResolve) {
                        this.fCurrentlyFetching.remove(handle.getItemId());
                    }
                }
                this.fireLabelProviderChangeEvent(buildResultsToResolve);
                continue;
lbl-1000:
                // 1 sources

                {
                    this.fBuildResultImages.put(resolvedResult.getItemId(), BuildStatusCompositeImageDescriptor.getBuildResultComposite((IBuildResult)resolvedResult, this.getResources()));
                    continue;
                }
lbl96:
                // 1 sources

                resolvedResult = this.FETCH_LOCK;
                synchronized (resolvedResult) {
                    for (Object handle : buildResultsToResolve) {
                        this.fCurrentlyFetching.remove(handle.getItemId());
                    }
                }
                this.fireLabelProviderChangeEvent(buildResultsToResolve);
                throw var11_16;
            }
            handle = resolvedBuildResults.iterator();
            while (handle.hasNext()) {
                resolvedResult = (IBuildResult)handle.next();
                this.fBuildResultImages.put(resolvedResult.getItemId(), BuildStatusCompositeImageDescriptor.getBuildResultComposite((IBuildResult)resolvedResult, this.getResources()));
            }
            var12_13 = this.FETCH_LOCK;
            synchronized (var12_13) {
                for (Object handle : buildResultsToResolve) {
                    this.fCurrentlyFetching.remove(handle.getItemId());
                }
            }
            this.fireLabelProviderChangeEvent(buildResultsToResolve);
        }
    }

    protected void fireLabelProviderChangeEvent(Collection<IBuildResultHandle> buildResultsHandles) {
        final ArrayList<IBuildResultHandle> buildResults = new ArrayList<IBuildResultHandle>();
        buildResults.addAll(buildResultsHandles);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildResultLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildResultLabelProvider.this, (Object[])buildResults.toArray(new IBuildResultHandle[buildResults.size()])));
            }
        });
    }

    protected ITeamRepository getOrigin(IBuildResultHandle buildResultHandle) {
        return (ITeamRepository)buildResultHandle.getOrigin();
    }

    public void dispose() {
        if (this.fFetchJob != null) {
            this.fFetchJob.cancel();
            this.fFetchJob = null;
        }
        super.dispose();
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected static enum FetchJobStatus {
        SCHEDULED,
        RUNNING,
        NOT_RUNNING;

    }
}

