/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BuildDefinitionLabelProvider
extends TypeLabelProvider {
    private static final Object FETCH_LOCK = new Object();
    private static BuildJob fFetchJob;
    private static Map<UUID, IBuildDefinitionHandle> fCurrentlyFetching;
    private Set<IBuildDefinition> fCachedBuildDefinitions = new HashSet<IBuildDefinition>();
    private Set<UUID> fDeletedBuildDefinitions = new HashSet<UUID>();
    private static FetchJobStatus fFetchJobStatus;
    private boolean fShowRepository;

    static {
        fCurrentlyFetching = new Hashtable<UUID, IBuildDefinitionHandle>();
        fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
    }

    public BuildDefinitionLabelProvider() {
        this.fShowRepository = false;
    }

    public BuildDefinitionLabelProvider(boolean showRepository) {
        this.fShowRepository = showRepository;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        Object[] labelObjects = this.getBuildDefinitionLabelObjects(element);
        String definitionId = (String)labelObjects[0];
        IBuildDefinitionHandle handle = (IBuildDefinitionHandle)labelObjects[1];
        if (handle != null) {
            label.setImage(this.getDefinitionImage());
            if (definitionId != null) {
                label.setText(this.getLabel(handle, definitionId));
            } else if (this.fDeletedBuildDefinitions.contains(handle.getItemId())) {
                label.setText(BuildUIMessages.BUILD_DEFINITION_LABEL_DELETED);
            } else {
                this.fetchDefinition(handle, element);
            }
        }
    }

    protected Object[] getBuildDefinitionLabelObjects(Object element) {
        ITeamRepository repository;
        IBuildDefinition buildDefinition;
        String definitionId = null;
        IBuildDefinition handle = null;
        if (element instanceof IBuildDefinitionStatusRecord) {
            handle = ((IBuildDefinitionStatusRecord)element).getBuildDefinition();
            definitionId = ((IBuildDefinitionStatusRecord)element).getBuildDefinition().getId();
        } else if (element instanceof IBuildDefinition) {
            handle = (IBuildDefinition)element;
            definitionId = ((IBuildDefinition)element).getId();
        } else if (element instanceof BuildDefinitionHandleHelper) {
            BuildDefinitionHandleHelper helper = (BuildDefinitionHandleHelper)element;
            handle = helper.getBuildDefinitionHandle();
            definitionId = helper.getBuildDefinitionId();
        } else if (element instanceof IBuildDefinitionHandle && (buildDefinition = (IBuildDefinition)(repository = this.getOrigin((IBuildDefinitionHandle)(handle = (IBuildDefinitionHandle)element))).itemManager().getSharedItemIfKnown((IItemHandle)handle)) != null && buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            definitionId = buildDefinition.getId();
        }
        return new Object[]{definitionId, handle};
    }

    protected Image getDefinitionImage() {
        return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
    }

    protected IBuildDefinition getBuildDefinition(IBuildDefinitionHandle handle) {
        ITeamRepository repository = this.getOrigin(handle);
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
        if (buildDefinition == null || !buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            return null;
        }
        this.fCachedBuildDefinitions.add(buildDefinition);
        return buildDefinition;
    }

    protected String getLabel(IBuildDefinitionHandle definitionHandle, String id) {
        return TextProcessor.process((String)this.getUnprocessedLabel(definitionHandle, id), (String)"()");
    }

    private String getUnprocessedLabel(IBuildDefinitionHandle definitionHandle, String id) {
        if (this.fShowRepository && this.getOrigin(definitionHandle) != null) {
            ITeamRepository repo = this.getOrigin(definitionHandle);
            String repoId = repo.getName();
            if (repoId == null || repoId.length() == 0) {
                repoId = repo.getRepositoryURI();
            }
            return NLS.bind((String)BuildUIMessages.BUILD_DEFINITION_LABEL_WITH_REPOSITORY, (Object)id, (Object)repoId);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchDefinition(IBuildDefinitionHandle handle, Object element) {
        Object object = FETCH_LOCK;
        synchronized (object) {
            if (fCurrentlyFetching.containsKey(handle.getItemId())) {
                return;
            }
            fCurrentlyFetching.put(handle.getItemId(), handle);
            if (fFetchJob == null) {
                fFetchJob = this.createFetchJob();
            }
            if (fFetchJobStatus == FetchJobStatus.NOT_RUNNING) {
                this.scheduleFetchJob(fFetchJob);
                fFetchJobStatus = FetchJobStatus.SCHEDULED;
            }
        }
    }

    protected void scheduleFetchJob(BuildJob fetchJob) {
        fetchJob.scheduleJob();
    }

    protected BuildJob createFetchJob() {
        return new BuildJob(BuildUIMessages.BuildDefinitionLabelProvider_FETCH_BUILD_DEFINITION_JOB_TITLE){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BuildDefinitionLabelProvider.this.fetchBuildItems(monitor);
                }
                finally {
                    fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                }
                return Status.OK_STATUS;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchBuildItems(IProgressMonitor monitor) {
        ArrayList<IBuildDefinitionHandle> definitionsToResolve = new ArrayList<IBuildDefinitionHandle>();
        ArrayList<IBuildDefinition> resolvedDefinitions = new ArrayList<IBuildDefinition>();
        ITeamRepository teamRepository = null;
        while (true) {
            Object object;
            block29: {
                Object object2 = FETCH_LOCK;
                synchronized (object2) {
                    if (fCurrentlyFetching.size() <= 0) {
                        fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                        break;
                    }
                    fFetchJobStatus = FetchJobStatus.RUNNING;
                    definitionsToResolve.clear();
                    for (IBuildDefinitionHandle handle : fCurrentlyFetching.values()) {
                        if (teamRepository == null) {
                            definitionsToResolve.add(handle);
                            teamRepository = this.getOrigin(handle);
                            continue;
                        }
                        if (!teamRepository.getId().equals((Object)this.getOrigin(handle).getId())) continue;
                        definitionsToResolve.add(handle);
                    }
                }
                try {
                    try {
                        ArrayList<IBuildDefinitionHandle> definitionsToFetch = new ArrayList<IBuildDefinitionHandle>();
                        for (IBuildDefinitionHandle handle : definitionsToResolve) {
                            IBuildDefinition definition = this.getBuildDefinition(handle);
                            if (definition == null) {
                                definitionsToFetch.add(handle);
                                continue;
                            }
                            resolvedDefinitions.add(definition);
                        }
                        if (definitionsToFetch.size() > 0) {
                            List fetchedDefinitions = teamRepository.itemManager().fetchPartialItems(definitionsToFetch, 0, Collections.singleton(IBuildDefinition.PROPERTY_ID), monitor);
                            int i = 0;
                            while (i < fetchedDefinitions.size()) {
                                IBuildDefinition fetchedDefinition = (IBuildDefinition)fetchedDefinitions.get(i);
                                if (fetchedDefinition != null) {
                                    resolvedDefinitions.add(fetchedDefinition);
                                } else {
                                    this.fDeletedBuildDefinitions.add(((IBuildDefinitionHandle)definitionsToFetch.get(i)).getItemId());
                                }
                                ++i;
                            }
                        }
                        this.fCachedBuildDefinitions.addAll(resolvedDefinitions);
                        break block29;
                    }
                    catch (TeamRepositoryException exception) {
                        BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), BuildUIMessages.BuildResultLabelProvider_FETCH_ERROR, (Throwable)exception));
                        object = FETCH_LOCK;
                        synchronized (object) {
                            for (IBuildDefinitionHandle handle : definitionsToResolve) {
                                fCurrentlyFetching.remove(handle.getItemId());
                            }
                        }
                    }
                    this.fireLabelProviderChangeEvent(definitionsToResolve);
                    continue;
                }
                catch (Throwable throwable) {
                    object = FETCH_LOCK;
                    synchronized (object) {
                        for (IBuildDefinitionHandle handle : definitionsToResolve) {
                            fCurrentlyFetching.remove(handle.getItemId());
                        }
                    }
                }
                this.fireLabelProviderChangeEvent(definitionsToResolve);
                throw throwable;
            }
            object = FETCH_LOCK;
            synchronized (object) {
                for (IBuildDefinitionHandle handle : definitionsToResolve) {
                    fCurrentlyFetching.remove(handle.getItemId());
                }
            }
            this.fireLabelProviderChangeEvent(definitionsToResolve);
        }
    }

    protected void fireLabelProviderChangeEvent(Collection<IBuildDefinitionHandle> buildDefinitionHandles) {
        final ArrayList<IBuildDefinitionHandle> buildDefinitions = new ArrayList<IBuildDefinitionHandle>();
        buildDefinitions.addAll(buildDefinitionHandles);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildDefinitionLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildDefinitionLabelProvider.this, (Object[])buildDefinitions.toArray(new IBuildDefinitionHandle[buildDefinitions.size()])));
            }
        });
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected ITeamRepository getOrigin(IBuildDefinitionHandle buildItemHandle) {
        return (ITeamRepository)buildItemHandle.getOrigin();
    }

    protected static enum FetchJobStatus {
        SCHEDULED,
        RUNNING,
        NOT_RUNNING;

    }
}

