/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildActivityCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.BuildStatusCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.PersonalBuildCompositeImageDescriptor;
import java.util.Hashtable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class BuildCompositeImageRegistry {
    private static Hashtable<Image, Image[]> fBuildStatusImageMap = new Hashtable();
    private static Hashtable<Image, Image[]> fBuildActivityStateImageMap = new Hashtable();
    private static Hashtable<Image, Image> fPersonalBuildImageMap = new Hashtable();

    public static Image getImage(Image baseImage, BuildStatus status) {
        return BuildCompositeImageRegistry.getImage(baseImage, status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(Image baseImage, BuildStatus status, boolean decorateSuccessfulImage) {
        if (status == BuildStatus.OK && !decorateSuccessfulImage) {
            return baseImage;
        }
        Image decoratedImage = null;
        Hashtable<Image, Image[]> hashtable = fBuildStatusImageMap;
        synchronized (hashtable) {
            Image[] decoratedImages = fBuildStatusImageMap.get(baseImage);
            if (decoratedImages == null) {
                decoratedImages = new Image[BuildStatus.values().length];
                fBuildStatusImageMap.put(baseImage, decoratedImages);
            }
            if (decoratedImages[status.ordinal()] == null) {
                BuildStatusCompositeImageDescriptor descriptor = new BuildStatusCompositeImageDescriptor(baseImage, status);
                decoratedImages[status.ordinal()] = decoratedImage = descriptor.createImage();
            }
            decoratedImage = decoratedImages[status.ordinal()];
        }
        return decoratedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getBuildActivityImage(BuildState state) {
        ValidationHelper.validateNotNull((String)"state", (Object)state);
        if (state != BuildState.IN_PROGRESS && state != BuildState.INCOMPLETE && state != BuildState.COMPLETED) {
            throw new IllegalArgumentException(NLS.bind((String)BuildUIMessages.BuildCompositeImageRegistry_INVALID_STATE_FOR_BUILD_ACTIVITY, (Object)state.toString()));
        }
        Image image = BuildUIPlugin.getImage("icons/obj16/bld_act_obj.gif");
        Hashtable<Image, Image[]> hashtable = fBuildActivityStateImageMap;
        synchronized (hashtable) {
            Image[] decoratedImages = fBuildActivityStateImageMap.get(image);
            if (decoratedImages == null) {
                decoratedImages = new Image[BuildState.values().length];
                fBuildActivityStateImageMap.put(image, decoratedImages);
            }
            if (decoratedImages[state.ordinal()] == null) {
                BuildActivityCompositeImageDescriptor descriptor = new BuildActivityCompositeImageDescriptor(image, state);
                decoratedImages[state.ordinal()] = image = descriptor.createImage();
            }
            image = decoratedImages[state.ordinal()];
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getPersonalBuildImage(Image baseImage) {
        Image decoratedImage = null;
        Hashtable<Image, Image> hashtable = fPersonalBuildImageMap;
        synchronized (hashtable) {
            decoratedImage = fPersonalBuildImageMap.get(baseImage);
            if (decoratedImage == null) {
                PersonalBuildCompositeImageDescriptor descriptor = new PersonalBuildCompositeImageDescriptor(baseImage);
                decoratedImage = descriptor.createImage();
                fPersonalBuildImageMap.put(baseImage, decoratedImage);
            }
        }
        return decoratedImage;
    }
}

