/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.utils;

import com.ibm.team.build.internal.toolkit.utils.Messages;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class VersionFileUtils {
    public static final String PRODUCT_VERSION_FULL_PROP_NAME = "product_version";

    private static Map<String, String> parseProperties(List<String> lines) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : lines) {
            String[] parts = line.split("=");
            if (parts == null || parts.length != 2 || parts[0] == null || parts[1] == null) continue;
            properties.put(parts[0], parts[1]);
        }
        return properties;
    }

    public static String getBuildToolkitReleaseFromVersionFile(URL url) throws BuildException {
        String release;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Scanner s = new Scanner(url.openStream());){
                ArrayList<String> lines = new ArrayList<String>();
                while (s.hasNext()) {
                    lines.add(s.nextLine());
                }
                Map<String, String> properties = VersionFileUtils.parseProperties(lines);
                release = "";
                if (properties.containsKey(PRODUCT_VERSION_FULL_PROP_NAME)) {
                    release = properties.get(PRODUCT_VERSION_FULL_PROP_NAME);
                }
                if (release == null) {
                    throw new BuildException(NLS.bind((String)Messages.VersionFileUtils_UNABLE_TO_FIND_PROPERTY_IN_VERSION_FILE, (Object)PRODUCT_VERSION_FULL_PROP_NAME, (Object)url.toExternalForm()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exp) {
            throw new BuildException(NLS.bind((String)Messages.VersionFileUtils_UNABLE_TO_OPEN_VERSION_FILE_AT_PATH, (Object)url.toExternalForm()));
        }
        return release;
    }
}

