/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.unit;

import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class UnitParser
extends DefaultHandler {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    private List<String> parseErrors = new ArrayList<String>();

    public void parse(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        this.parseErrors.clear();
        SAXParserFactory inst = SAXParserFactory.newInstance();
        inst.setFeature("http://xml.org/sax/features/external-general-entities", false);
        inst.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser sx = inst.newSAXParser();
        XMLReader xmlReader = sx.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(inputStream);
            xmlReader.parse(inputSource);
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public final void error(SAXParseException exception) throws SAXException {
        this.parseErrors.add(exception.getLocalizedMessage());
    }

    public final String[] getParseErrors() {
        return this.parseErrors.toArray(new String[this.parseErrors.size()]);
    }

    public abstract JUnitParserTestSuiteData[] getTestSuites();
}

