/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.IBuildLogListener;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.scm.AcceptReport;
import com.ibm.team.build.internal.scm.AutoDeliverReport;
import com.ibm.team.build.internal.scm.BuildScmLoadOptions;
import com.ibm.team.build.internal.scm.BuildWorkspaceDescriptor;
import com.ibm.team.build.internal.scm.FolderEntry;
import com.ibm.team.build.internal.scm.RepositoryManager;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.operations.IncrementalLoadOperation;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IncrementalLoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IncrementalLoadOpLoadRuleUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LoadRuleSpecificLoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnknownWorkspaceComponentStateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class SourceControlUtility {
    private static List<Object> argumentCollector;
    private static Log logger;
    public static final String BUILD_SCM_LOAD_OPTIONS_METADATA_FILE_NAME = ".buildScmLoadOptions";

    static {
        logger = LogFactory.getLog((String)SourceControlUtility.class.getName());
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
            new SourceControlUtility();
        }
    }

    private SourceControlUtility() {
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(workspaceName);
        List result = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findWorkspaces(criteria, 10, (IProgressMonitor)progress.newChild(1));
        if (!result.isEmpty()) {
            IWorkspaceHandle r = (IWorkspaceHandle)result.get(0);
            return (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)r, 0, (IProgressMonitor)progress.newChild(1));
        }
        return null;
    }

    public static AutoDeliverReport autoDeliverComponentsToTarget(RepositoryManager manager, IBaselineSet acceptSnapshot, BuildWorkspaceDescriptor buildWorkspace, BuildWorkspaceDescriptor deliverTarget, boolean deliverAllComponents, Collection<IComponentHandle> componentsToDeliverSubset, boolean addComponents, boolean removeComponents, boolean forceReplace, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineConnection baselineConnection;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection buildWorkspaceConnection = buildWorkspace.getConnection(manager, false, (IProgressMonitor)progress.newChild(5));
        IWorkspaceConnection deliverTargetConnection = deliverTarget.getConnection(manager, false, (IProgressMonitor)progress.newChild(5));
        ArrayList<IComponentHandle> snapshotComponentHandles = new ArrayList<IComponentHandle>();
        HashSet<UUID> snapshotComponentHandleIds = new HashSet<UUID>();
        ItemHandleAwareHashMap componentToBaseline = new ItemHandleAwareHashMap();
        IItemManager itemManager = deliverTargetConnection.teamRepository().itemManager();
        SubMonitor loopProgress = progress.newChild(5).setWorkRemaining(acceptSnapshot.getBaselines().size());
        for (IBaselineHandle baselineHandle : acceptSnapshot.getBaselines()) {
            IItem object = itemManager.fetchCompleteItem((IItemHandle)baselineHandle, 1, (IProgressMonitor)loopProgress.newChild(1));
            if (!(object instanceof IBaseline)) continue;
            IBaseline baseline = (IBaseline)object;
            componentToBaseline.put((Object)baseline.getComponent(), (Object)baselineHandle);
            snapshotComponentHandles.add(baseline.getComponent());
            snapshotComponentHandleIds.add(baseline.getComponent().getItemId());
        }
        Collection<Object> actualComponentsToDeliver = deliverAllComponents ? snapshotComponentHandles : componentsToDeliverSubset;
        if (actualComponentsToDeliver == null) {
            actualComponentsToDeliver = Collections.emptyList();
        }
        Iterator<Object> iComponents = actualComponentsToDeliver.iterator();
        while (iComponents.hasNext()) {
            IComponentHandle componentHandle = (IComponentHandle)iComponents.next();
            if (snapshotComponentHandleIds.contains(componentHandle.getItemId())) continue;
            iComponents.remove();
        }
        ArrayList<IComponentHandle> componentsToRemove = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> componentsToReplace = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> componentsToAdd = new ArrayList<IComponentHandle>();
        HashSet<UUID> componentsToRemoveIds = new HashSet<UUID>();
        List deliverTargetComponents = deliverTargetConnection.getComponents();
        HashSet<UUID> deliverTargetComponentsIds = new HashSet<UUID>();
        for (IComponentHandle componentHandle : deliverTargetComponents) {
            deliverTargetComponentsIds.add(componentHandle.getItemId());
            if (snapshotComponentHandleIds.contains(componentHandle.getItemId())) continue;
            componentsToRemove.add(componentHandle);
            componentsToRemoveIds.add(componentHandle.getItemId());
        }
        HashSet<UUID> componentsToAddIds = new HashSet<UUID>();
        for (IComponentHandle iComponentHandle : actualComponentsToDeliver) {
            if (deliverTargetComponentsIds.contains(iComponentHandle.getItemId())) continue;
            componentsToAdd.add(iComponentHandle);
            componentsToAddIds.add(iComponentHandle.getItemId());
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (IComponentHandle iComponentHandle : actualComponentsToDeliver) {
            if (componentsToAddIds.contains(iComponentHandle.getItemId()) || componentsToRemoveIds.contains(iComponentHandle.getItemId())) continue;
            componentsToReplace.add(iComponentHandle);
            hashSet.add(iComponentHandle.getItemId());
        }
        if (syncInfo != null) {
            for (IComponentHandle iComponentHandle : deliverTargetComponents) {
                if (hashSet.contains(iComponentHandle.getItemId())) continue;
                syncInfo.addChangeHistoryTime((IWorkspaceHandle)deliverTargetConnection.getResolvedWorkspace(), iComponentHandle, ISyncTime.TIME_NONE);
            }
        }
        AutoDeliverReport autoDeliverReport = new AutoDeliverReport();
        autoDeliverReport.setSnapshotUUID(acceptSnapshot.getItemId());
        autoDeliverReport.setSnapshotName(acceptSnapshot.getName());
        autoDeliverReport.setWorkspaceUUID(buildWorkspace.getWorkspaceHandle().getItemId());
        autoDeliverReport.setWorkspaceName(buildWorkspaceConnection.getName());
        autoDeliverReport.setDeliverTargetUUID(deliverTarget.getWorkspaceHandle().getItemId());
        autoDeliverReport.setDeliverTargetName(deliverTargetConnection.getName());
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)deliverTargetConnection.teamRepository());
        IFlowNodeConnection.IComponentOpFactory opFactory = deliverTargetConnection.componentOpFactory();
        ArrayList<Object> componentOperations = new ArrayList<Object>();
        if (removeComponents) {
            loopProgress = progress.newChild(5).setWorkRemaining(componentsToRemove.size());
            for (IComponentHandle componentHandle : componentsToRemove) {
                componentOperations.add(opFactory.removeComponent(componentHandle, false));
                IItem component = itemManager.fetchCompleteItem((IItemHandle)componentHandle, 1, (IProgressMonitor)loopProgress.newChild(1));
                if (!(component instanceof IComponent)) continue;
                autoDeliverReport.addComponentRemoval(componentHandle.getItemId(), ((IComponent)component).getName());
            }
        }
        if (addComponents) {
            loopProgress = progress.newChild(5).setWorkRemaining(componentsToAdd.size() * 2);
            for (IComponentHandle componentHandle : componentsToAdd) {
                baselineConnection = wm.getBaselineConnection((IBaselineHandle)componentToBaseline.get((Object)componentHandle), (IProgressMonitor)loopProgress.newChild(1));
                componentOperations.add(opFactory.addComponent(componentHandle, (IConnection)baselineConnection, buildWorkspace.getWorkspaceHandle(), false));
                IItem component = itemManager.fetchCompleteItem((IItemHandle)componentHandle, 1, (IProgressMonitor)loopProgress.newChild(1));
                if (!(component instanceof IComponent)) continue;
                autoDeliverReport.addComponentAdd(componentHandle.getItemId(), ((IComponent)component).getName());
                autoDeliverReport.addComponentToBaseline(componentHandle.getItemId(), baselineConnection.getBaseline().getItemId());
                autoDeliverReport.addBaselineName(baselineConnection.getBaseline().getItemId(), baselineConnection.getName());
            }
        }
        loopProgress = progress.newChild(5).setWorkRemaining(componentsToReplace.size() * 2);
        for (IComponentHandle componentHandle : componentsToReplace) {
            IItem component;
            baselineConnection = wm.getBaselineConnection((IBaselineHandle)componentToBaseline.get((Object)componentHandle), (IProgressMonitor)loopProgress.newChild(1));
            boolean performReplace = true;
            if (!forceReplace && deliverTargetConnection.isComponentAtBaseline(componentHandle, baselineConnection.getResolvedBaseline()) && baselineConnection.getBaseline().sameItemId((IItemHandle)deliverTargetConnection.getComponentInfo(componentHandle).basis())) {
                performReplace = false;
            }
            if (performReplace) {
                componentOperations.add(opFactory.replaceComponent(componentHandle, (IConnection)baselineConnection, buildWorkspace.getWorkspaceHandle(), false));
            }
            if (!((component = itemManager.fetchCompleteItem((IItemHandle)componentHandle, 1, (IProgressMonitor)loopProgress.newChild(1))) instanceof IComponent)) continue;
            String componentName = ((IComponent)component).getName();
            if (performReplace) {
                autoDeliverReport.addComponentReplace(componentHandle.getItemId(), componentName);
            } else {
                autoDeliverReport.addTargetComponentAlreadyAtBaseline(componentHandle.getItemId(), componentName);
            }
            autoDeliverReport.addComponentToBaseline(componentHandle.getItemId(), baselineConnection.getBaseline().getItemId());
            autoDeliverReport.addBaselineName(baselineConnection.getBaseline().getItemId(), baselineConnection.getName());
        }
        if (!componentOperations.isEmpty()) {
            try {
                if (syncInfo != null) {
                    deliverTargetConnection.applyComponentOperations(componentOperations, false, syncInfo, (IProgressMonitor)progress.newChild(70));
                } else {
                    deliverTargetConnection.applyComponentOperations(componentOperations, false, (IProgressMonitor)progress.newChild(70));
                }
            }
            catch (StaleDataException sde) {
                autoDeliverReport.setIsStaleDataExceptionThrownDuringAutoDeliver(true);
            }
        }
        return autoDeliverReport;
    }

    public static void updateFileCopyArea(BuildScmLoadOptions loadOptions, IBuildLogListener buildLogListener, IProgressMonitor monitor) throws TeamRepositoryException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SourceControlUtility#updateFileCopyArea: Start.");
        }
        boolean shouldInvokeOptimizedIncrementalLoad = false;
        IPath metadataRoot = (IPath)SharingMetadataFactory.getMetadataRoot((ILocation)SourceControlUtility.getFetchDestinationPath(loadOptions.getFetchDestination())).getAdapter(IPath.class);
        File loadOptionsMetadataFile = metadataRoot.append(BUILD_SCM_LOAD_OPTIONS_METADATA_FILE_NAME).toFile();
        BuildScmLoadOptions.BuildScmLoadOptionsFileStorageManager buildScmLoadOptionsFileStorageManager = new BuildScmLoadOptions.BuildScmLoadOptionsFileStorageManager(loadOptionsMetadataFile);
        boolean doesLoadOptionsMetaDataExist = buildScmLoadOptionsFileStorageManager.doesFileExists();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Should invoke optimized incremental load: " + loadOptions.shouldInvokeOptimizedIncrementalLoad()));
            logger.trace((Object)("Does buildScmLoadOptions metadata file exists: " + doesLoadOptionsMetaDataExist));
        }
        if (loadOptions.shouldInvokeOptimizedIncrementalLoad() && buildLogListener != null) {
            buildLogListener.log(ScmMessages.SourceControlUtility_SHOULD_INVOKE_INCREMENTAL_UPDATE);
            if (!doesLoadOptionsMetaDataExist) {
                buildLogListener.log(ScmMessages.SourceControlUtility_LOAD_OPTIONS_METADATA_FILE_DOES_NOT_EXIST);
            }
        }
        BuildScmLoadOptions prevLoadOptions = null;
        if (loadOptions.shouldInvokeOptimizedIncrementalLoad() && doesLoadOptionsMetaDataExist) {
            boolean loadOptionsSupportedWithOptimizedIncrementalLoad;
            boolean bl = loadOptionsSupportedWithOptimizedIncrementalLoad = !loadOptions.hasOptionsNotSupportedWithOptimizedIncrementalLoad();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("All load options supported with optimized incremental load: " + loadOptionsSupportedWithOptimizedIncrementalLoad));
            }
            if (loadOptionsSupportedWithOptimizedIncrementalLoad) {
                boolean areLoadOptionsEqual = false;
                try {
                    prevLoadOptions = buildScmLoadOptionsFileStorageManager.readFromFile();
                    areLoadOptionsEqual = loadOptions.isEqual(prevLoadOptions);
                }
                catch (Exception exception) {
                    String errorMessage = NLS.bind((String)ScmMessages.SourceControlUtility_ERROR_READING_BUILD_SCM_LOAD_OPTIONS_FILE, (Object)exception, (Object[])new Object[0]);
                    logger.error((Object)errorMessage);
                    throw new TeamBuildException(errorMessage, (Throwable)exception);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Are load options equal: " + areLoadOptionsEqual));
                }
                shouldInvokeOptimizedIncrementalLoad = areLoadOptionsEqual;
                if (!areLoadOptionsEqual && buildLogListener != null) {
                    buildLogListener.log(ScmMessages.SourceControlUtility_LOAD_OPTIONS_CHANGED);
                }
            } else if (buildLogListener != null) {
                buildLogListener.log(ScmMessages.SourceControlUtility_LOAD_OPTIONS_NOT_SUPPORTED);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Should invoke optimized incremental load: " + shouldInvokeOptimizedIncrementalLoad));
        }
        if (doesLoadOptionsMetaDataExist) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Deleting buildScmLoadOptions metadata file before load.");
            }
            try {
                buildScmLoadOptionsFileStorageManager.deleteFile();
            }
            catch (Exception exception) {
                String errorMessage = NLS.bind((String)ScmMessages.SourceControlUtility_ERROR_DELETING_BUILD_SCM_LOAD_OPTIONS_FILE, (Object)exception, (Object[])new Object[0]);
                logger.error((Object)errorMessage);
                throw new TeamBuildException(errorMessage, (Throwable)exception);
            }
        }
        boolean fallbackToIncrementalLoad = false;
        if (shouldInvokeOptimizedIncrementalLoad) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Invoking optimized incremental load.");
            }
            boolean bl = fallbackToIncrementalLoad = !SourceControlUtility.doOptimizedIncrementalLoadOfFileCopyArea(loadOptions, buildLogListener, monitor);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Fallback to incremental load: " + fallbackToIncrementalLoad));
            }
        }
        if (!shouldInvokeOptimizedIncrementalLoad || fallbackToIncrementalLoad) {
            if (loadOptions.shouldUseLoadRulesExclusively()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Load is based upon load rules only.");
                }
                ILoadRule2 loadRule = null;
                if (loadOptions.getComponentLoadRules().size() == 1) {
                    loadRule = loadOptions.getComponentLoadRules().iterator().next();
                }
                SourceControlUtility.updateFileCopyArea(loadOptions.getWorkspaceConnection(), loadOptions.getFetchDestination(), loadOptions.shouldSynchronizeLoad(), loadRule, loadOptions.shouldPreserveFileTimestamps(), loadOptions.shouldExpandKeywords(), monitor);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Load is not based upon load rules only.");
                }
                SourceControlUtility.updateFileCopyArea(loadOptions.getWorkspaceConnection(), loadOptions.getFetchDestination(), loadOptions.shouldIncludeComponents(), loadOptions.getComponents(), loadOptions.shouldSynchronizeLoad(), loadOptions.getComponentLoadRules(), loadOptions.shouldCreateFoldersForComponents(), loadOptions.shouldPreserveFileTimestamps(), loadOptions.shouldExpandKeywords(), monitor);
            }
        }
        if (loadOptions.shouldInvokeOptimizedIncrementalLoad() && metadataRoot.toFile().exists()) {
            try {
                buildScmLoadOptionsFileStorageManager.persistToFile(loadOptions);
            }
            catch (Exception exception) {
                String errorMessage = NLS.bind((String)ScmMessages.SourceControlUtility_ERROR_UPDATING_BUILD_SCM_LOAD_OPTIONS_FILE, (Object)exception, (Object[])new Object[0]);
                logger.error((Object)errorMessage);
                try {
                    buildScmLoadOptionsFileStorageManager.deleteFile();
                }
                catch (Exception exceptionOnDelete) {
                    String errorMessageOnDelete = NLS.bind((String)ScmMessages.SourceControlUtility_ERROR_DELETING_BUILD_SCM_LOAD_OPTIONS_FILE, (Object)exceptionOnDelete, (Object[])new Object[0]);
                    logger.error((Object)errorMessageOnDelete);
                    throw new TeamBuildException(errorMessageOnDelete, (Throwable)exceptionOnDelete);
                }
                throw new TeamBuildException(errorMessage, (Throwable)exception);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SourceControlUtility#updateFileCopyArea: End.");
        }
    }

    private static PathLocation getFetchDestinationPath(String fetchDestination) throws TeamRepositoryException {
        File fetchDestinationFile = new File(fetchDestination);
        Path fetchDestinationPath = null;
        try {
            fetchDestinationPath = new Path(fetchDestinationFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_INVALID_ROOT_PATH, (Object)fetchDestinationPath, (Object[])new Object[0]), (Throwable)e);
        }
        return new PathLocation((IPath)fetchDestinationPath);
    }

    private static boolean doOptimizedIncrementalLoadOfFileCopyArea(BuildScmLoadOptions loadOptions, IBuildLogListener buildLogListener, IProgressMonitor monitor) throws TeamRepositoryException {
        IncrementalLoadOperation optimizedIncrementalLoadOperation;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SourceControlUtility#doOptimizedIncrementalLoadOfFileCopyArea: Start.");
        }
        if (argumentCollector != null) {
            argumentCollector.clear();
            argumentCollector.add("doOptimizedIncrementalLoadOfFileCopyArea");
            argumentCollector.add(loadOptions);
        }
        IWorkspaceConnection wsConnection = loadOptions.getWorkspaceConnection();
        if (!loadOptions.shouldSynchronizeLoad()) {
            wsConnection.refresh(monitor);
        }
        ISharingManager manager = FileSystemCore.getSharingManager();
        PathLocation fetchDestinationPath = SourceControlUtility.getFetchDestinationPath(loadOptions.getFetchDestination());
        ISandbox sandbox = manager.getSandbox((ILocation)fetchDestinationPath, false);
        LoadDilemmaHandler loadDilemmaHandler = SourceControlUtility.getLoadDilemmaHandler();
        Collection<ILoadRule2> loadRules = loadOptions.getComponentLoadRules();
        HashSet idOfComponentsToLoadUsingLoadRules = new HashSet();
        HashMap loadRuleToComponentIdsMap = new HashMap();
        HashSet<UUID> idOfComponentsHavingConflictingLoadRules = new HashSet<UUID>();
        for (ILoadRule2 loadRule : loadRules) {
            ILoadOperation loadOp = loadRule.getLoadOp(sandbox, loadDilemmaHandler, monitor);
            HashSet<UUID> idOfComponentsToLoadUsingCurrentLoadRule = new HashSet<UUID>();
            for (ILoadRequest loadRequest : loadOp.getLoadRequests()) {
                if (idOfComponentsToLoadUsingLoadRules.contains(loadRequest.getComponent().getItemId())) {
                    idOfComponentsHavingConflictingLoadRules.add(loadRequest.getComponent().getItemId());
                }
                idOfComponentsToLoadUsingCurrentLoadRule.add(loadRequest.getComponent().getItemId());
            }
            idOfComponentsToLoadUsingLoadRules.addAll(idOfComponentsToLoadUsingCurrentLoadRule);
            loadRuleToComponentIdsMap.put(loadRule, idOfComponentsToLoadUsingCurrentLoadRule);
        }
        HashSet<Object> componentsToLoadOrUpdate = null;
        componentsToLoadOrUpdate = loadOptions.shouldUseLoadRulesExclusively() ? (loadRules.size() == 1 ? new HashSet(idOfComponentsToLoadUsingLoadRules) : SourceControlUtility.getComponentsToLoad(wsConnection, false, Collections.EMPTY_LIST)) : SourceControlUtility.getComponentsToLoad(wsConnection, loadOptions.shouldIncludeComponents(), loadOptions.getComponents());
        List componentsInWorkspace = wsConnection.getComponents();
        HashSet<UUID> componentsToLoadOrUpdateExcludingComponentsNotInWorkspace = new HashSet<UUID>();
        for (IComponentHandle component : componentsInWorkspace) {
            if (!componentsToLoadOrUpdate.contains(component.getItemId())) continue;
            componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.add(component.getItemId());
        }
        boolean handleComponentDeletions = false;
        boolean handleComponentAdditions = false;
        boolean handleComponentRenames = false;
        HashSet<UUID> loadedComponentsUUid = new HashSet<UUID>();
        for (IConfigurationDescriptor loadedConfigurationDescriptor : sandbox.allLoadedConfigurations(monitor)) {
            if (!loadedConfigurationDescriptor.getConnectionHandle().sameItemId((IItemHandle)wsConnection.getContextHandle())) continue;
            UUID componentItemId = loadedConfigurationDescriptor.getComponentHandle().getItemId();
            loadedComponentsUUid.add(componentItemId);
            if (componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.contains(componentItemId)) continue;
            handleComponentDeletions = true;
            break;
        }
        if (handleComponentDeletions) {
            if (buildLogListener != null) {
                buildLogListener.log(ScmMessages.SourceControlUtility_OPTIMIZED_INCREMENTAL_LOAD_UNLOAD_LOADED_COMPONENTS);
            }
            return false;
        }
        for (UUID componentItemId : componentsToLoadOrUpdateExcludingComponentsNotInWorkspace) {
            if (loadedComponentsUUid.contains(componentItemId)) continue;
            handleComponentAdditions = true;
            break;
        }
        if (handleComponentAdditions) {
            if (buildLogListener != null) {
                buildLogListener.log(ScmMessages.SourceControlUtility_OPTIMIZED_INCREMENTAL_LOAD_NEW_COMPONENTS_TO_LOAD);
            }
            return false;
        }
        if (loadOptions.shouldCreateFoldersForComponents() || !loadOptions.getComponentLoadRules().isEmpty()) {
            Collection loadedConfigurations = sandbox.allLoadedConfigurations(monitor);
            HashMap componentNameFromLoadedConfigurations = new HashMap();
            for (LoadedConfigurationDescriptor loadedConfiguration : loadedConfigurations) {
                if (!loadedConfiguration.getConnectionHandle().sameItemId((IItemHandle)wsConnection.getContextHandle())) continue;
                componentNameFromLoadedConfigurations.put(loadedConfiguration.getComponentHandle().getItemId(), loadedConfiguration.componentName);
            }
            ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
            for (UUID componentItemId : componentsToLoadOrUpdateExcludingComponentsNotInWorkspace) {
                componentHandles.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentItemId, null));
            }
            List components = wsConnection.teamRepository().itemManager().fetchCompleteItems(componentHandles, 1, monitor);
            Iterator iterator = components.iterator();
            while (iterator.hasNext()) {
                String componentNameFromLoadedConfiguration;
                IComponent component = (IComponent)iterator.next();
                if (component == null || (componentNameFromLoadedConfiguration = (String)componentNameFromLoadedConfigurations.get(component.getItemId())) == null || componentNameFromLoadedConfiguration.equals(component.getName())) continue;
                handleComponentRenames = true;
                break;
            }
        }
        if (handleComponentRenames) {
            if (buildLogListener != null) {
                buildLogListener.log(ScmMessages.SourceControlUtility_OPTIMIZED_INCREMENTAL_LOAD_LOADED_COMPONENTS_RENAMED);
            }
            return false;
        }
        if (buildLogListener != null) {
            buildLogListener.log(ScmMessages.SourceControlUtility_INVOKING_INCREMENTAL_UPDATE);
        }
        if (!idOfComponentsToLoadUsingLoadRules.isEmpty() && !loadOptions.shouldUseLoadRulesExclusively()) {
            for (UUID componentId : idOfComponentsToLoadUsingLoadRules) {
                if (componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.contains(componentId)) continue;
                IItem component = null;
                try {
                    component = wsConnection.teamRepository().itemManager().fetchCompleteItem(IComponent.ITEM_TYPE.createItemHandle(componentId, null), 0, monitor);
                }
                catch (TeamRepositoryException components) {
                    // empty catch block
                }
                if (component instanceof IComponent) {
                    throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_LOAD_RULE_FOR_NAMED_UNLOADED_COMPONENT, (Object)((IComponent)component).getName(), (Object[])new Object[0]));
                }
                throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_LOAD_RULE_FOR_MISSING_UNLOADED_COMPONENT, (Object)componentId.getUuidValue(), (Object[])new Object[0]));
            }
        }
        if (!idOfComponentsHavingConflictingLoadRules.isEmpty()) {
            Iterator idOfComponentsHavingConflictingLoadRulesIter = idOfComponentsHavingConflictingLoadRules.iterator();
            while (idOfComponentsHavingConflictingLoadRulesIter.hasNext()) {
                if (componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.contains(idOfComponentsHavingConflictingLoadRulesIter.next())) continue;
                idOfComponentsHavingConflictingLoadRulesIter.remove();
            }
            if (!idOfComponentsHavingConflictingLoadRules.isEmpty()) {
                StringBuilder componentIdStrings = new StringBuilder();
                for (UUID componentId : idOfComponentsHavingConflictingLoadRules) {
                    componentIdStrings.append(componentId.getUuidValue()).append(" ");
                }
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.SourceControlUtility_CONFLICTING_LOAD_RULES_FOR_COMPONENTS_WITH_UUIDS, (Object)componentIdStrings.toString().trim(), (Object[])new Object[0]));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Number of components to load or update: " + componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.size()));
        }
        ISynchronizationInfo synchronizationInfo = null;
        if (loadOptions.shouldSynchronizeLoad()) {
            synchronizationInfo = ISynchronizationInfo.FACTORY.newInstance();
            for (ICurrentComponentInfo componentInfo : wsConnection.getComponentsInfo()) {
                if (!componentsToLoadOrUpdateExcludingComponentsNotInWorkspace.contains(componentInfo.getComponent().getItemId())) continue;
                synchronizationInfo.addConfigurationTime((IWorkspaceHandle)wsConnection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
            }
        }
        HashSet<UUID> idOfComponentsFromLoadRules = new HashSet<UUID>();
        HashSet<UUID> idOfComponentsNotFromLoadRules = new HashSet<UUID>();
        for (UUID componentUuid : componentsToLoadOrUpdateExcludingComponentsNotInWorkspace) {
            if (idOfComponentsToLoadUsingLoadRules.contains(componentUuid)) {
                idOfComponentsFromLoadRules.add(componentUuid);
                continue;
            }
            idOfComponentsNotFromLoadRules.add(componentUuid);
        }
        ArrayList<ILoadOperation> loadOperationForAllComponents = new ArrayList<ILoadOperation>();
        if (!idOfComponentsNotFromLoadRules.isEmpty()) {
            loadOperationForAllComponents.addAll(SourceControlUtility.getLoadOperations(sandbox, idOfComponentsNotFromLoadRules, loadOptions, monitor));
        }
        if (!idOfComponentsFromLoadRules.isEmpty()) {
            loadOperationForAllComponents.addAll(SourceControlUtility.getLoadOperationsUsingLoadRules(sandbox, idOfComponentsFromLoadRules, loadOptions, monitor));
        }
        SourceControlUtility.populateLoadOperations(loadOperationForAllComponents, loadOptions, synchronizationInfo, monitor);
        Collection<IShare> deletedShares = SourceControlUtility.deleteShares(sandbox, wsConnection, componentsToLoadOrUpdateExcludingComponentsNotInWorkspace, loadOperationForAllComponents, monitor);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Number of components already loaded: " + loadedComponentsUUid.size()));
        }
        int updatesToProcess = 3;
        IncrementalLoadDilemmaHandler optimizedIncrementalLoadDilemmaHandler = SourceControlUtility.getOptimizedIncrementalLoadDilemmaHandler(loadOptions);
        ArrayList<IncrementalLoadOperation> optimizedIncrementalLoadOperations = new ArrayList<IncrementalLoadOperation>();
        if (loadOptions.shouldUseLoadRulesExclusively()) {
            ILoadRule2 loadRule = null;
            if (loadOptions.getComponentLoadRules().size() == 1) {
                loadRule = loadOptions.getComponentLoadRules().iterator().next();
            }
            optimizedIncrementalLoadOperation = null;
            optimizedIncrementalLoadOperation = loadRule != null ? new IncrementalLoadOperation(wsConnection, (Collection)Collections.EMPTY_LIST, updatesToProcess, optimizedIncrementalLoadDilemmaHandler, (ILocation)fetchDestinationPath, loadRule, false, deletedShares, null) : new IncrementalLoadOperation(wsConnection, (Collection)Collections.EMPTY_LIST, updatesToProcess, optimizedIncrementalLoadDilemmaHandler, (ILocation)fetchDestinationPath, null);
            optimizedIncrementalLoadOperations.add(optimizedIncrementalLoadOperation);
        } else if (!loadOptions.getComponentLoadRules().isEmpty()) {
            if (!idOfComponentsNotFromLoadRules.isEmpty()) {
                ArrayList<IComponentHandle> componentsLoadedUsingLoadRules = new ArrayList<IComponentHandle>();
                for (UUID componentId : idOfComponentsToLoadUsingLoadRules) {
                    componentsLoadedUsingLoadRules.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentId, null));
                }
                optimizedIncrementalLoadOperation = new IncrementalLoadOperation(wsConnection, componentsLoadedUsingLoadRules, updatesToProcess, optimizedIncrementalLoadDilemmaHandler, (ILocation)fetchDestinationPath, null);
                optimizedIncrementalLoadOperations.add(optimizedIncrementalLoadOperation);
            }
            for (ILoadRule2 loadRule : loadRules) {
                HashSet idOfComponentsLoadedUsingCurrentLoadRule = (HashSet)loadRuleToComponentIdsMap.get(loadRule);
                if (idOfComponentsLoadedUsingCurrentLoadRule == null || idOfComponentsLoadedUsingCurrentLoadRule.isEmpty()) continue;
                ArrayList<IComponentHandle> componentsNotLoadedUsingCurrentLoadRules = new ArrayList<IComponentHandle>();
                for (UUID componentId : componentsToLoadOrUpdateExcludingComponentsNotInWorkspace) {
                    if (idOfComponentsLoadedUsingCurrentLoadRule.contains(componentId)) continue;
                    componentsNotLoadedUsingCurrentLoadRules.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentId, null));
                }
                IncrementalLoadOperation optimizedIncrementalLoadOperation2 = new IncrementalLoadOperation(wsConnection, componentsNotLoadedUsingCurrentLoadRules, updatesToProcess, optimizedIncrementalLoadDilemmaHandler, (ILocation)fetchDestinationPath, loadRule, loadOptions.shouldCreateFoldersForComponents(), deletedShares, null);
                optimizedIncrementalLoadOperations.add(optimizedIncrementalLoadOperation2);
            }
        } else {
            IncrementalLoadOperation optimizedIncrementalLoadOperation3 = new IncrementalLoadOperation(wsConnection, (Collection)Collections.EMPTY_LIST, updatesToProcess, optimizedIncrementalLoadDilemmaHandler, (ILocation)fetchDestinationPath, null);
            optimizedIncrementalLoadOperations.add(optimizedIncrementalLoadOperation3);
        }
        for (IncrementalLoadOperation optimizedIncrementalLoadOperation3 : optimizedIncrementalLoadOperations) {
            if (loadOptions.shouldSynchronizeLoad() && synchronizationInfo != null) {
                optimizedIncrementalLoadOperation3.setSynchronizationInfo(synchronizationInfo);
            }
            optimizedIncrementalLoadOperation3.setExpandKeywords(loadOptions.shouldExpandKeywords());
            optimizedIncrementalLoadOperation3.run(monitor);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SourceControlUtility#doOptimizedIncrementalLoadOfFileCopyArea: End.");
        }
        return true;
    }

    private static IncrementalLoadDilemmaHandler getOptimizedIncrementalLoadDilemmaHandler(final BuildScmLoadOptions loadOptions) {
        final UnknownWorkspaceComponentStateDilemmaHandler unknownWCStateDilemmaHandler = new UnknownWorkspaceComponentStateDilemmaHandler(){

            public LoadDilemmaHandler getLoadDilemmaHandler() {
                return SourceControlUtility.getLoadDilemmaHandler();
            }

            public int unknownWorkspaceComponentState() {
                return 2;
            }

            public boolean isPreserveLocalChangesOnReload() {
                return false;
            }
        };
        final UpdateDilemmaHandler updateDilemmaHandler = new UpdateDilemmaHandler(){

            public boolean isPreserveLocalChanges() {
                return false;
            }
        };
        final IncrementalLoadOpLoadRuleUpdateDilemmaHandler incrementalLoadOpLoadRuleUpdateDilemmaHandler = new IncrementalLoadOpLoadRuleUpdateDilemmaHandler(){

            public boolean isPreserveLocalChanges() {
                return false;
            }
        };
        final LoadRuleSpecificLoadDilemmaHandler loadRulesSpecificLoadDilemmaHandler = new LoadRuleSpecificLoadDilemmaHandler(){

            public LoadDilemmaHandler getLoadDilemmaHandler() {
                return SourceControlUtility.getLoadDilemmaHandler();
            }

            public int getEclipseSpecificLoadOptions() {
                return 0;
            }

            public boolean isPreserveFileTimestamps() {
                return loadOptions.shouldPreserveFileTimestamps();
            }

            public boolean isSynchronizeLoad() {
                return loadOptions.shouldSynchronizeLoad();
            }
        };
        IncrementalLoadDilemmaHandler optimizedIncrementalLoadDilemmaHandler = new IncrementalLoadDilemmaHandler(){

            public UnknownWorkspaceComponentStateDilemmaHandler getUnknownWorkspaceComponentStateDilemmaHandler() {
                return unknownWCStateDilemmaHandler;
            }

            public UpdateDilemmaHandler getUpdateDilemmaHandler(boolean loadrule) {
                if (loadrule) {
                    return incrementalLoadOpLoadRuleUpdateDilemmaHandler;
                }
                return updateDilemmaHandler;
            }

            public LoadRuleSpecificLoadDilemmaHandler getLoadRuleSpecificLoadDilemmaHandler() {
                return loadRulesSpecificLoadDilemmaHandler;
            }
        };
        return optimizedIncrementalLoadDilemmaHandler;
    }

    private static Collection<ILoadOperation> getLoadOperations(ISandbox sandbox, Set<UUID> idOfComponentsToLoad, BuildScmLoadOptions loadOptions, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ILoadOperation> loadOperations = new ArrayList<ILoadOperation>();
        IWorkspaceConnection wsConnection = loadOptions.getWorkspaceConnection();
        if (!idOfComponentsToLoad.isEmpty()) {
            ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation(SourceControlUtility.getLoadDilemmaHandler());
            RelativeLocation relativeLocation = null;
            for (UUID componentItemId : idOfComponentsToLoad) {
                IItem completeComponent;
                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentItemId, null);
                IConfiguration configuration = wsConnection.configuration(component);
                Map children = configuration.childEntriesForRoot(null);
                relativeLocation = null;
                if (loadOptions.shouldCreateFoldersForComponents() && (completeComponent = wsConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 1, monitor)) instanceof IComponent) {
                    relativeLocation = new RelativeLocation(((IComponent)completeComponent).getName());
                }
                loadOp.requestLoad(sandbox, relativeLocation, wsConnection, component, children.values());
            }
            loadOperations.add(loadOp);
        }
        return loadOperations;
    }

    private static Collection<ILoadOperation> getLoadOperationsUsingLoadRules(ISandbox sandbox, Set<UUID> idOfComponentsToLoad, BuildScmLoadOptions loadOptions, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ILoadOperation> loadOperations = new ArrayList<ILoadOperation>();
        Collection<ILoadRule2> loadRules = loadOptions.getComponentLoadRules();
        IWorkspaceConnection wsConnection = loadOptions.getWorkspaceConnection();
        LoadDilemmaHandler loadDilemmaHandler = SourceControlUtility.getLoadDilemmaHandler();
        for (ILoadRule2 loadRule : loadRules) {
            ILoadOperation loadOp = loadRule.getLoadOp(sandbox, loadDilemmaHandler, monitor);
            IRelativeLocation relativeLocation = null;
            Collection loadRequests = loadOp.getLoadRequests();
            loadOp.removeLoadRequests(loadRequests);
            for (ILoadRequest loadRequest : loadRequests) {
                IItem completeComponent;
                IComponentHandle component = loadRequest.getComponent();
                if (!idOfComponentsToLoad.contains(component.getItemId())) continue;
                relativeLocation = loadRequest.getRelativeLoadPath();
                if (!loadOptions.shouldUseLoadRulesExclusively() && loadOptions.shouldCreateFoldersForComponents() && (completeComponent = wsConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 1, monitor)) instanceof IComponent) {
                    relativeLocation = new RelativeLocation(((IComponent)completeComponent).getName());
                    if (loadRequest.getRelativeLoadPath() != null) {
                        relativeLocation = relativeLocation.append(loadRequest.getRelativeLoadPath());
                    }
                }
                if (!(loadRequest.getConnection() instanceof IWorkspaceConnection)) continue;
                if (loadRequest.getAlternativeName() != null && !loadRequest.getAlternativeName().equals("")) {
                    loadOp.requestLoadAs(sandbox, relativeLocation, loadRequest.getAlternativeName(), (IWorkspaceConnection)loadRequest.getConnection(), loadRequest.getComponent(), loadRequest.getVersionableToLoad());
                    continue;
                }
                loadOp.requestLoad(sandbox, relativeLocation, (IWorkspaceConnection)loadRequest.getConnection(), loadRequest.getComponent(), Collections.singleton(loadRequest.getVersionableToLoad()));
            }
            loadOperations.add(loadOp);
        }
        return loadOperations;
    }

    private static void populateLoadOperations(Collection<ILoadOperation> loadOperations, BuildScmLoadOptions loadOptions, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) {
        for (ILoadOperation loadOp : loadOperations) {
            loadOp.setEclipseSpecificLoadOptions(0);
            loadOp.setPreserveFileTimestamps(loadOptions.shouldPreserveFileTimestamps());
            loadOp.setExpandKeywords(loadOptions.shouldExpandKeywords());
            if (!loadOptions.shouldSynchronizeLoad() || synchronizationInfo == null) continue;
            loadOp.setSychronizationInfo(synchronizationInfo);
        }
    }

    public static void updateFileCopyArea(RepositoryManager manager, BuildWorkspaceDescriptor workspace, String destinationPath, boolean createFoldersForComponents, Collection<IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceConnection workspaceConnection = workspace.getConnection(manager, false, (IProgressMonitor)progress.newChild(1));
        SourceControlUtility.updateFileCopyArea(workspaceConnection, destinationPath, false, components, false, Collections.EMPTY_LIST, createFoldersForComponents, (IProgressMonitor)progress.newChild(1));
    }

    public static void updateFileCopyArea(IWorkspaceConnection workspaceConnection, String destinationPath, boolean includedComponents, Collection<IComponentHandle> components, boolean synchronizeLoad, Collection<ILoadRule2> loadRules, boolean createFoldersForComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        SourceControlUtility.updateFileCopyArea(workspaceConnection, destinationPath, includedComponents, components, synchronizeLoad, loadRules, createFoldersForComponents, false, false, monitor);
    }

    public static void updateFileCopyArea(IWorkspaceConnection workspaceConnection, String destinationPath, boolean includedComponents, Collection<IComponentHandle> components, boolean synchronizeLoad, Collection<ILoadRule2> loadRules, boolean createFoldersForComponents, boolean preserveFileTimestamps, IProgressMonitor monitor) throws TeamRepositoryException {
        SourceControlUtility.updateFileCopyArea(workspaceConnection, destinationPath, includedComponents, components, synchronizeLoad, loadRules, createFoldersForComponents, preserveFileTimestamps, false, monitor);
    }

    public static void updateFileCopyArea(IWorkspaceConnection workspaceConnection, String destinationPath, boolean includedComponents, Collection<IComponentHandle> components, boolean synchronizeLoad, Collection<ILoadRule2> loadRules, boolean createFoldersForComponents, boolean preserveFileTimestamps, boolean expandKeywords, IProgressMonitor monitor) throws TeamRepositoryException {
        Path rootPath;
        if (argumentCollector != null) {
            argumentCollector.clear();
            argumentCollector.add("updateFileCopyArea1");
            argumentCollector.add(workspaceConnection);
            argumentCollector.add(destinationPath);
            argumentCollector.add(includedComponents);
            argumentCollector.add(components);
            argumentCollector.add(synchronizeLoad);
            argumentCollector.add(loadRules);
            argumentCollector.add(createFoldersForComponents);
            argumentCollector.add(preserveFileTimestamps);
            argumentCollector.add(expandKeywords);
        }
        File localRoot = new File(destinationPath);
        try {
            rootPath = new Path(localRoot.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_INVALID_ROOT_PATH, (Object)localRoot, (Object[])new Object[0]), (Throwable)e);
        }
        localRoot.mkdirs();
        if (!synchronizeLoad) {
            workspaceConnection.refresh(monitor);
        }
        LoadDilemmaHandler handler = SourceControlUtility.getLoadDilemmaHandler();
        HashSet<UUID> componentsToLoad = SourceControlUtility.getComponentsToLoad(workspaceConnection, includedComponents, components);
        ISynchronizationInfo synchronizationInfo = null;
        if (synchronizeLoad) {
            synchronizationInfo = ISynchronizationInfo.FACTORY.newInstance();
            for (ICurrentComponentInfo componentInfo : workspaceConnection.getComponentsInfo()) {
                if (!componentsToLoad.contains(componentInfo.getComponent().getItemId())) continue;
                synchronizationInfo.addConfigurationTime((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
            }
        }
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new PathLocation((IPath)rootPath), false);
        ArrayList<ILoadOperation> loadOperations = new ArrayList<ILoadOperation>(1 + loadRules.size());
        HashSet<UUID> componentIdsFromLoadRules = new HashSet<UUID>();
        for (ILoadRule2 loadRule : loadRules) {
            ILoadOperation loadOp = loadRule.getLoadOp(sandbox, handler, monitor);
            for (ILoadRequest request : loadOp.getLoadRequests()) {
                if (!componentsToLoad.contains(request.getComponent().getItemId())) {
                    IItem component = null;
                    try {
                        component = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)request.getComponent(), 0, monitor);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    if (component instanceof IComponent) {
                        throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_LOAD_RULE_FOR_NAMED_UNLOADED_COMPONENT, (Object)((IComponent)component).getName(), (Object[])new Object[0]));
                    }
                    throw new TeamRepositoryException(ScmMessages.SourceControlUtility_LOAD_RULE_FOR_UNLOADED_COMPONENT);
                }
                componentIdsFromLoadRules.add(request.getComponent().getItemId());
                if (!synchronizeLoad || synchronizationInfo == null) continue;
                loadOp.setSychronizationInfo(synchronizationInfo);
            }
            loadOp.setEclipseSpecificLoadOptions(0);
            loadOp.setPreserveFileTimestamps(preserveFileTimestamps);
            loadOp.setExpandKeywords(expandKeywords);
            loadOperations.add(loadOp);
        }
        RelativeLocation relativeLocation = null;
        if (createFoldersForComponents) {
            for (ILoadOperation loadOperation : loadOperations) {
                Collection requests = loadOperation.getLoadRequests();
                loadOperation.removeLoadRequests(requests);
                IItemHandle prevComponentHandle = null;
                for (ILoadRequest request : requests) {
                    IItem component = null;
                    try {
                        if (!request.getComponent().sameItemId(prevComponentHandle)) {
                            component = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)request.getComponent(), 1, monitor);
                        }
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    if (!(component instanceof IComponent)) continue;
                    relativeLocation = new RelativeLocation(((IComponent)component).getName());
                    if (request.getRelativeLoadPath() != null) {
                        relativeLocation = relativeLocation.append(request.getRelativeLoadPath());
                    }
                    if (!(request.getConnection() instanceof IWorkspaceConnection)) continue;
                    if (request.getAlternativeName() != null && !request.getAlternativeName().equals("")) {
                        loadOperation.requestLoadAs(sandbox, (IRelativeLocation)relativeLocation, request.getAlternativeName(), (IWorkspaceConnection)request.getConnection(), request.getComponent(), request.getVersionableToLoad());
                        continue;
                    }
                    loadOperation.requestLoad(sandbox, (IRelativeLocation)relativeLocation, (IWorkspaceConnection)request.getConnection(), request.getComponent(), Collections.singleton(request.getVersionableToLoad()));
                }
            }
        }
        ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation(handler);
        loadOp.setPreserveFileTimestamps(preserveFileTimestamps);
        loadOp.setExpandKeywords(expandKeywords);
        if (synchronizeLoad && synchronizationInfo != null) {
            loadOp.setSychronizationInfo(synchronizationInfo);
        }
        boolean entireComponentsToLoad = false;
        for (IComponentHandle component : workspaceConnection.getComponents()) {
            IItem completeComponent;
            if (!componentsToLoad.contains(component.getItemId()) || componentIdsFromLoadRules.contains(component.getItemId())) continue;
            IConfiguration configuration = workspaceConnection.configuration(component);
            Map children = configuration.childEntriesForRoot(null);
            relativeLocation = null;
            if (createFoldersForComponents && (completeComponent = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 1, monitor)) instanceof IComponent) {
                relativeLocation = new RelativeLocation(((IComponent)completeComponent).getName());
            }
            loadOp.requestLoad(sandbox, (IRelativeLocation)relativeLocation, workspaceConnection, component, children.values());
            entireComponentsToLoad = true;
        }
        if (entireComponentsToLoad) {
            loadOperations.add(loadOp);
        }
        SourceControlUtility.deleteShares(sandbox, workspaceConnection, componentsToLoad, loadOperations, monitor);
        try {
            for (ILoadOperation loadOperation : loadOperations) {
                loadOperation.run(monitor);
            }
        }
        catch (FileSystemStatusException exception) {
            throw new FileSystemStatusException(exception.getStatus()){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(System.getProperty("line.separator"));
                    SourceControlUtility.getChildStatusMessages(new IStatus[]{exception.getStatus()}, messages);
                    return messages.toString();
                }
            };
        }
        catch (StaleDataException e) {
            throw new TeamBuildException(ScmMessages.SourceControlUtility_LOAD_STALE_DATA, (Throwable)e);
        }
    }

    private static HashSet<UUID> getComponentsToLoad(IWorkspaceConnection workspaceConnection, boolean includedComponents, Collection<IComponentHandle> components) throws TeamRepositoryException {
        HashSet<UUID> componentsToLoad = new HashSet<UUID>();
        if (includedComponents) {
            for (IComponentHandle component : components) {
                componentsToLoad.add(component.getItemId());
            }
        } else if (components == null || components.isEmpty()) {
            for (IComponentHandle component : workspaceConnection.getComponents()) {
                componentsToLoad.add(component.getItemId());
            }
        } else {
            HashSet<UUID> componentIds = new HashSet<UUID>();
            for (IComponentHandle component : components) {
                componentIds.add(component.getItemId());
            }
            for (IComponentHandle component : workspaceConnection.getComponents()) {
                if (componentIds.contains(component.getItemId())) continue;
                componentsToLoad.add(component.getItemId());
            }
        }
        return componentsToLoad;
    }

    public static void updateFileCopyArea(IWorkspaceConnection workspaceConnection, String destinationPath, boolean synchronizeLoad, ILoadRule2 loadRule, boolean preserveFileTimestamps, IProgressMonitor monitor) throws TeamRepositoryException {
        SourceControlUtility.updateFileCopyArea(workspaceConnection, destinationPath, synchronizeLoad, loadRule, preserveFileTimestamps, false, monitor);
    }

    public static void updateFileCopyArea(IWorkspaceConnection workspaceConnection, String destinationPath, boolean synchronizeLoad, ILoadRule2 loadRule, boolean preserveFileTimestamps, boolean expandKeywords, IProgressMonitor monitor) throws TeamRepositoryException {
        Path rootPath;
        if (argumentCollector != null) {
            argumentCollector.clear();
            argumentCollector.add("updateFileCopyArea2");
            argumentCollector.add(workspaceConnection);
            argumentCollector.add(destinationPath);
            argumentCollector.add(synchronizeLoad);
            argumentCollector.add(loadRule);
            argumentCollector.add(preserveFileTimestamps);
            argumentCollector.add(expandKeywords);
        }
        File localRoot = new File(destinationPath);
        try {
            rootPath = new Path(localRoot.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_INVALID_ROOT_PATH, (Object)localRoot, (Object[])new Object[0]), (Throwable)e);
        }
        localRoot.mkdirs();
        if (!synchronizeLoad) {
            workspaceConnection.refresh(monitor);
        }
        LoadDilemmaHandler handler = SourceControlUtility.getLoadDilemmaHandler();
        HashSet<UUID> componentsToLoad = new HashSet<UUID>();
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new PathLocation((IPath)rootPath), false);
        ILoadOperation loadOp = null;
        if (loadRule != null) {
            loadOp = loadRule.getLoadOp(sandbox, handler, monitor);
            for (ILoadRequest request : loadOp.getLoadRequests()) {
                componentsToLoad.add(request.getComponent().getItemId());
            }
        } else {
            loadOp = IOperationFactory.instance.getLoadOperation(handler);
            for (IComponentHandle component : workspaceConnection.getComponents()) {
                IConfiguration configuration = workspaceConnection.configuration(component);
                Map children = configuration.childEntriesForRoot(null);
                loadOp.requestLoad(sandbox, null, workspaceConnection, component, children.values());
                componentsToLoad.add(component.getItemId());
            }
        }
        if (synchronizeLoad) {
            ISynchronizationInfo synchronizationInfo = ISynchronizationInfo.FACTORY.newInstance();
            for (ICurrentComponentInfo componentInfo : workspaceConnection.getComponentsInfo()) {
                if (!componentsToLoad.contains(componentInfo.getComponent().getItemId())) continue;
                synchronizationInfo.addConfigurationTime((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
            }
            loadOp.setSychronizationInfo(synchronizationInfo);
        }
        loadOp.setEclipseSpecificLoadOptions(0);
        loadOp.setPreserveFileTimestamps(preserveFileTimestamps);
        loadOp.setExpandKeywords(expandKeywords);
        SourceControlUtility.deleteShares(sandbox, workspaceConnection, componentsToLoad, Collections.singletonList(loadOp), monitor);
        try {
            loadOp.run(monitor);
        }
        catch (FileSystemStatusException exception) {
            throw new FileSystemStatusException(exception.getStatus()){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(System.getProperty("line.separator"));
                    SourceControlUtility.getChildStatusMessages(new IStatus[]{exception.getStatus()}, messages);
                    return messages.toString();
                }
            };
        }
        catch (StaleDataException e) {
            throw new TeamBuildException(ScmMessages.SourceControlUtility_LOAD_STALE_DATA, (Throwable)e);
        }
    }

    private static Collection<IShare> deleteShares(ISandbox sandbox, final IWorkspaceConnection workspaceConnection, HashSet<UUID> componentsToLoad, List<ILoadOperation> loadOperations, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IShare[] shares = sandbox.allShares(monitor);
        if (shares.length == 0) {
            return Collections.EMPTY_LIST;
        }
        HashMap<UUID, HashMap<UUID, IShare>> sharesByComponent = new HashMap<UUID, HashMap<UUID, IShare>>();
        ArrayList<IShare> toUnshareList = new ArrayList<IShare>();
        int i = 0;
        while (i < shares.length) {
            if (shares[i].getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)workspaceConnection.getContextHandle())) {
                UUID componentItemId = shares[i].getSharingDescriptor().getComponent().getItemId();
                if (!componentsToLoad.contains(componentItemId)) {
                    toUnshareList.add(shares[i]);
                } else {
                    HashMap<UUID, IShare> sharesForComponent = (HashMap<UUID, IShare>)sharesByComponent.get(componentItemId);
                    if (sharesForComponent == null) {
                        sharesForComponent = new HashMap<UUID, IShare>();
                        sharesByComponent.put(componentItemId, sharesForComponent);
                    }
                    sharesForComponent.put(shares[i].getSharingDescriptor().getRootVersionable().getItemId(), shares[i]);
                }
            }
            ++i;
        }
        shares = null;
        for (ILoadOperation loadOp : loadOperations) {
            for (ILoadRequest request : loadOp.getLoadRequests()) {
                Map sharesForComponent = (Map)sharesByComponent.get(request.getComponent().getItemId());
                if (sharesForComponent == null) continue;
                sharesForComponent.remove(request.getVersionableToLoad().getItemId());
            }
        }
        for (Map sharesForComponent : sharesByComponent.values()) {
            toUnshareList.addAll(sharesForComponent.values());
        }
        sharesByComponent = null;
        if (!toUnshareList.isEmpty()) {
            IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation(UnshareDilemmaHandler.getDefault(), new IRepositoryResolver(){

                public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                    return workspaceConnection.teamRepository();
                }
            });
            unshareOp.requestUnshareShares(toUnshareList);
            unshareOp.setDeleteContent(true);
            unshareOp.run(monitor);
        }
        return toUnshareList;
    }

    private static void getChildStatusMessages(IStatus[] children, StringBuffer messages) {
        String newLine = System.getProperty("line.separator");
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            messages.append(status.getMessage());
            messages.append(newLine);
            SourceControlUtility.getChildStatusMessages(status.getChildren(), messages);
            ++n2;
        }
    }

    private static LoadDilemmaHandler getLoadDilemmaHandler() {
        LoadDilemmaHandler handler = new LoadDilemmaHandler(){

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(true);
                }
                return 0;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return new BackupDilemmaHandler(){

                    public boolean backupEnabled() {
                        return false;
                    }
                };
            }

            public int deletedContent(Collection<IShareable> contentDeleted) {
                return 0;
            }
        };
        return handler;
    }

    public static Map<String, Date> getLastModifiedTimes(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<FolderEntry, IBaseline> lastModifiedBaselines = SourceControlUtility.fetchLastModified(repository, sourceDirectory, workspace, monitor);
        HashMap<String, Date> lastModifiedTimes = new HashMap<String, Date>(lastModifiedBaselines.size());
        for (FolderEntry entry : lastModifiedBaselines.keySet()) {
            IBaseline baseline = lastModifiedBaselines.get(entry);
            lastModifiedTimes.put(entry.getFolderName(), baseline.getCreationDate());
        }
        return lastModifiedTimes;
    }

    public static Map<IFolderHandle, IBaseline> getLastModifiedBaselines(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<FolderEntry, IBaseline> lastModifiedBaselines = SourceControlUtility.fetchLastModified(repository, sourceDirectory, workspace, monitor);
        HashMap<IFolderHandle, IBaseline> lastModifiedTimes = new HashMap<IFolderHandle, IBaseline>(lastModifiedBaselines.size());
        for (FolderEntry entry : lastModifiedBaselines.keySet()) {
            IBaseline baseline = lastModifiedBaselines.get(entry);
            lastModifiedTimes.put(entry.getFolderHandle(), baseline);
        }
        return lastModifiedTimes;
    }

    private static Map<FolderEntry, IBaseline> fetchLastModified(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!sourceDirectory.exists()) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_DIRECTORY_DOES_NOT_EXIST, (Object)sourceDirectory.getAbsolutePath(), (Object[])new Object[0]));
        }
        try {
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            ISandbox sandbox = sharingManager.getSandbox((ILocation)new PathLocation(sourceDirectory.getAbsolutePath()), false);
            sharingManager.register(sandbox, true, monitor);
        }
        catch (FileSystemException e) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_INVALID_SANDBOX, (Object)sourceDirectory.getAbsolutePath(), (Object[])new Object[0]), (Throwable)e);
        }
        File[] rootFolders = sourceDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().startsWith(".jazz");
            }
        });
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspace, (IProgressMonitor)progress.newChild(1));
        connection.refresh((IProgressMonitor)progress.newChild(1));
        IComponentHandle startComponent = null;
        HashMap<UUID, ArrayList<IFolderHandle>> entriesGroupedByComponent = new HashMap<UUID, ArrayList<IFolderHandle>>();
        HashMap<UUID, String> folderNames = new HashMap<UUID, String>();
        progress.setWorkRemaining(rootFolders.length * 2);
        int i = 0;
        while (i < rootFolders.length) {
            File folder = rootFolders[i];
            Map<IComponentHandle, IVersionableHandle> location = SourceControlUtility.locateFolder(connection, folder, (IProgressMonitor)progress.newChild(1));
            if (location != null && location.size() == 1) {
                startComponent = location.keySet().iterator().next();
                IVersionableHandle folderHandle = location.values().iterator().next();
                ArrayList<IFolderHandle> entries = (ArrayList<IFolderHandle>)entriesGroupedByComponent.get(startComponent.getItemId());
                if (entries == null) {
                    entries = new ArrayList<IFolderHandle>();
                    entriesGroupedByComponent.put(startComponent.getItemId(), entries);
                }
                entries.add((IFolderHandle)folderHandle);
                folderNames.put(folderHandle.getItemId(), folder.getName());
            }
            ++i;
        }
        HashMap<FolderEntry, IBaseline> lastModifiedTimes = new HashMap<FolderEntry, IBaseline>(folderNames.size());
        for (UUID componentUUID : entriesGroupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            List folders = (List)entriesGroupedByComponent.get(componentUUID);
            List baselines = connection.getMostRecentBaselinesAffecting(componentHandle, folders, (IProgressMonitor)progress.newChild(1));
            int i2 = 0;
            while (i2 < baselines.size()) {
                IBaseline baseline = (IBaseline)baselines.get(i2);
                FolderEntry entry = new FolderEntry((IFolderHandle)folders.get(i2), baseline.getComponent(), (String)folderNames.get(((IFolderHandle)folders.get(i2)).getItemId()));
                lastModifiedTimes.put(entry, baseline);
                ++i2;
            }
        }
        return lastModifiedTimes;
    }

    private static Map<IComponentHandle, IVersionableHandle> locateFolder(IWorkspaceConnection workspaceConnection, File folder, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ISharingManager manager = FileSystemCore.getSharingManager();
        ISandbox sandbox = manager.getSandbox((ILocation)new PathLocation((IPath)new Path(folder.getParentFile().getAbsolutePath())), false);
        IShareable shareable = sandbox.findShareable((IRelativeLocation)new RelativeLocation(folder.getName()), ResourceType.FOLDER);
        if (shareable == null) {
            return null;
        }
        IVersionableHandle versionableHandle = shareable.getVersionable((IProgressMonitor)progress.newChild(1));
        if (versionableHandle == null) {
            return null;
        }
        IShare iShare = shareable.getShare((IProgressMonitor)progress.newChild(1));
        if (!iShare.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)workspaceConnection.getContextHandle())) {
            return null;
        }
        IComponentHandle componentHandle = iShare.getSharingDescriptor().getComponent();
        try {
            workspaceConnection.getComponentInfo(componentHandle);
        }
        catch (ComponentNotInWorkspaceException e) {
            return null;
        }
        HashMap<IComponentHandle, IVersionableHandle> returnVersionable = new HashMap<IComponentHandle, IVersionableHandle>(1);
        returnVersionable.put(componentHandle, versionableHandle);
        return returnVersionable;
    }

    public static AcceptReport checkForIncoming(RepositoryManager manager, BuildWorkspaceDescriptor workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceConnection workspaceConnection = workspace.getConnection(manager, true, (IProgressMonitor)progress.newChild(1));
        return SourceControlUtility.acceptAllIncoming(manager, workspaceConnection, "", true, (IProgressMonitor)progress.newChild(1));
    }

    public static AcceptReport acceptAllIncoming(RepositoryManager manager, BuildWorkspaceDescriptor workspace, String snapshotName, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceConnection workspaceConnection = workspace.getConnection(manager, true, (IProgressMonitor)progress.newChild(1));
        try {
            return SourceControlUtility.acceptAllIncoming(manager, workspaceConnection, snapshotName, false, (IProgressMonitor)progress.newChild(1));
        }
        catch (StaleDataException e) {
            throw new TeamBuildException(ScmMessages.SourceControlUtility_STALE_DATA, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AcceptReport acceptAllIncoming(RepositoryManager repositoryManager, IWorkspaceConnection workspaceConnection, String snapshotName, boolean checkOnly, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workspaceConnection.isStream()) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_CANNOT_ACCEPT_INTO_STREAM, (Object)workspaceConnection.getName(), (Object[])new Object[0]));
        }
        toLogout = new ArrayList<ITeamRepository>();
        try {
            acceptReport = new AcceptReport();
            flowTable = workspaceConnection.getFlowTable();
            acceptSourceIter = flowTable.acceptSources().iterator();
            deliverTargetIter = flowTable.deliverTargets().iterator();
            incomingComponentIds = new HashSet<UUID>(workspaceConnection.getComponents().size());
            outgoingComponentIds = new HashSet<UUID>(workspaceConnection.getComponents().size());
            refreshedWorkspaces = new HashSet<UUID>(flowTable.acceptSources().size());
            mon = SubMonitor.convert((IProgressMonitor)monitor);
            while (acceptSourceIter.hasNext()) {
                flowEntry = (IFlowEntry)acceptSourceIter.next();
                source = flowEntry.getFlowNode();
                remoteRepositoryURI = flowEntry.getRemoteRepositoryURI();
                if (remoteRepositoryURI == null) {
                    sourceRepository = workspaceConnection.teamRepository();
                } else {
                    sourceRepository = repositoryManager.getRepository(remoteRepositoryURI, false);
                    if (sourceRepository == null) {
                        if (repositoryManager.hasAuthenticationFailure(remoteRepositoryURI)) {
                            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_WORKSPACE_FLOW_HAD_PREVIOUS_AUTH_FAILURE, (Object)workspaceConnection.getName(), (Object[])new Object[]{remoteRepositoryURI}));
                        }
                        throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_FLOW_WORKSPACE_AUTH_MISSING, (Object)workspaceConnection.getName(), (Object[])new Object[]{remoteRepositoryURI}));
                    }
                    if (!sourceRepository.loggedIn()) {
                        repositoryManager.login(sourceRepository, (IProgressMonitor)mon.newChild(1));
                        toLogout.add(sourceRepository);
                    }
                }
                if (!(source instanceof IWorkspaceHandle)) continue;
                sourceWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)sourceRepository).getWorkspaceConnection((IWorkspaceHandle)source, (IProgressMonitor)mon.newChild(10));
                sourceWorkspaceConnection.refresh((IProgressMonitor)mon.newChild(10));
                refreshedWorkspaces.add(source.getItemId());
                incomingComponentScopes = SourceControlUtility.determineComponents(flowTable, source, sourceWorkspaceConnection);
                if (incomingComponentScopes.isEmpty()) {
                    report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, 0, Collections.EMPTY_LIST, monitor);
                    incomingComponentScopes.addAll(report.remoteComponents());
                } else {
                    helper = new HashSet<UUID>();
                    exclusions = new ArrayList<IComponentHandle>();
                    for (IComponentHandle component : incomingComponentScopes) {
                        helper.add(component.getItemId());
                    }
                    for (IComponentHandle component : workspaceConnection.getComponents()) {
                        if (helper.contains(component.getItemId())) continue;
                        exclusions.add(component);
                    }
                    report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, 0, exclusions, monitor);
                }
                for (IComponentHandle componentHandle : incomingComponentScopes) {
                    if (incomingComponentIds.add(componentHandle.getItemId())) continue;
                    componentName = "";
                    try {
                        component = (IComponent)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                        componentName = component.getName();
                        throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_MULTIPLE_COMPONENT_ACCEPT_FLOWS, (Object)componentName, (Object[])new Object[0]));
                    }
                    catch (TeamRepositoryException var24_25) {
                        // empty catch block
                    }
                    throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_MULTIPLE_COMPONENT_ACCEPT_FLOWS, (Object)componentName, (Object[])new Object[0]));
                }
                SourceControlUtility.addComponents(report, workspaceConnection, (IFlowNodeConnection)sourceWorkspaceConnection, incomingComponentScopes, checkOnly, acceptReport, monitor);
                SourceControlUtility.acceptAllFromComponents(report, workspaceConnection, sourceWorkspaceConnection, incomingComponentScopes, checkOnly, acceptReport, monitor);
            }
            while (deliverTargetIter.hasNext()) {
                flowEntry = (IFlowEntry)deliverTargetIter.next();
                target = flowEntry.getFlowNode();
                remoteRepositoryURI = flowEntry.getRemoteRepositoryURI();
                if (remoteRepositoryURI == null) {
                    targetRepository = workspaceConnection.teamRepository();
                } else {
                    targetRepository = repositoryManager.getRepository(remoteRepositoryURI, false);
                    if (targetRepository == null) {
                        if (repositoryManager.hasAuthenticationFailure(remoteRepositoryURI)) {
                            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_WORKSPACE_FLOW_HAD_PREVIOUS_AUTH_FAILURE, (Object)workspaceConnection.getName(), (Object[])new Object[]{remoteRepositoryURI}));
                        }
                        throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_FLOW_WORKSPACE_AUTH_MISSING, (Object)workspaceConnection.getName(), (Object[])new Object[]{remoteRepositoryURI}));
                    }
                    if (!targetRepository.loggedIn()) {
                        repositoryManager.login(targetRepository, (IProgressMonitor)mon.newChild(1));
                        toLogout.add(targetRepository);
                    }
                }
                if (!(target instanceof IWorkspaceHandle)) continue;
                targetWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)targetRepository).getWorkspaceConnection((IWorkspaceHandle)target, (IProgressMonitor)mon.newChild(10));
                if (!refreshedWorkspaces.contains(target.getItemId())) {
                    targetWorkspaceConnection.refresh((IProgressMonitor)mon.newChild(10));
                }
                if ((outgoingComponentScopes = SourceControlUtility.determineComponents(flowTable, target, targetWorkspaceConnection)).isEmpty()) {
                    outgoingComponentScopes.addAll(targetWorkspaceConnection.getComponents());
                }
                for (IComponentHandle componentHandle : outgoingComponentScopes) {
                    outgoingComponentIds.add(componentHandle.getItemId());
                }
            }
            if (!flowTable.acceptSources().isEmpty()) {
                SourceControlUtility.removeComponents(workspaceConnection, incomingComponentIds, outgoingComponentIds, checkOnly, acceptReport, monitor);
            }
            if (!checkOnly) {
                if (snapshotName != null && snapshotName.length() > 0) {
                    snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, snapshotName, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, 1, monitor);
                    acceptReport.addSnapshot((IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, monitor));
                }
                for (IComponentHandle componentHandle : workspaceConnection.getComponents()) {
                    baselineHandle = workspaceConnection.getComponentInfo(componentHandle).basis();
                    SourceControlUtility.calculateBaseline(workspaceConnection, componentHandle, baselineHandle, acceptReport, monitor);
                }
            }
            var26_26 = acceptReport;
            return var26_26;
        }
        finally {
            ** for (sourceRepository : toLogout)
        }
lbl-1000:
        // 1 sources

        {
            if (!sourceRepository.loggedIn()) continue;
            sourceRepository.logout();
            continue;
        }
lbl110:
        // 1 sources

        return var26_26;
    }

    private static List determineComponents(IFlowTable flowTable, IFlowNodeHandle source, IWorkspaceConnection sourceWorkspaceConnection) throws TeamRepositoryException {
        ArrayList componentScopes = new ArrayList();
        HashMap<UUID, IComponentHandle> allComponents = new HashMap<UUID, IComponentHandle>(sourceWorkspaceConnection.getComponents().size());
        for (IComponentHandle component : sourceWorkspaceConnection.getComponents()) {
            allComponents.put(component.getItemId(), component);
        }
        HashSet<UUID> toRetain = new HashSet<UUID>();
        for (IComponentHandle component : flowTable.getComponentScopes(source)) {
            toRetain.add(component.getItemId());
        }
        allComponents.keySet().retainAll(toRetain);
        componentScopes.addAll(allComponents.values());
        return componentScopes;
    }

    private static void removeComponents(IWorkspaceConnection workspaceConnection, HashSet<UUID> incomingComponentIds, HashSet<UUID> outgoingComponentIds, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        List components = workspaceConnection.getComponents();
        ArrayList<IFlowNodeConnection.IComponentDeletionOp> dropOps = new ArrayList<IFlowNodeConnection.IComponentDeletionOp>();
        for (IComponentHandle componentHandle : components) {
            if (incomingComponentIds.contains(componentHandle.getItemId()) || outgoingComponentIds.contains(componentHandle.getItemId())) continue;
            if (!checkOnly) {
                dropOps.add(workspaceConnection.componentOpFactory().removeComponent(componentHandle, false));
            }
            acceptReport.componentRemoval(componentHandle);
        }
        if (!dropOps.isEmpty()) {
            workspaceConnection.applyComponentOperations(dropOps, monitor);
        }
    }

    private static void acceptAllFromComponents(IChangeHistorySyncReport syncReport, IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection, List components, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        acceptReport.addAcceptChangeSets(syncReport.incomingChangeSets());
        acceptReport.addDiscardChangeSets(syncReport.outgoingChangeSets());
        if (checkOnly) {
            return;
        }
        ArrayList<IFlowNodeConnection.IComponentReplacementOp> replaceOps = new ArrayList<IFlowNodeConnection.IComponentReplacementOp>();
        for (IComponentHandle componentHandle : components) {
            List incomingChanges = syncReport.incomingChangeSets(componentHandle);
            List outgoingChanges = syncReport.outgoingChangeSets(componentHandle);
            if (incomingChanges.isEmpty() && outgoingChanges.isEmpty()) continue;
            replaceOps.add(workspaceConnection.componentOpFactory().replaceComponent(componentHandle, (IConnection)sourceWorkspaceConnection, false));
        }
        if (!replaceOps.isEmpty()) {
            workspaceConnection.applyComponentOperations(replaceOps, monitor);
        }
    }

    private static void addComponents(IChangeHistorySyncReport report, IWorkspaceConnection workspaceConnection, IFlowNodeConnection sourceWorkspaceConnection, List components, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IFlowNodeConnection.IComponentAdditionOp> addOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            IComponentHandle componentHandle = (IComponentHandle)iter.next();
            if (SourceControlUtility.componentExists(componentHandle, report.localComponents())) continue;
            if (!checkOnly) {
                addOps.add(workspaceConnection.componentOpFactory().addComponent(componentHandle, (IConnection)sourceWorkspaceConnection, false));
            }
            acceptReport.componentAdd(componentHandle);
            iter.remove();
        }
        if (!addOps.isEmpty()) {
            workspaceConnection.applyComponentOperations(addOps, monitor);
        }
        if (!checkOnly) {
            for (IComponentHandle componentHandle : components) {
                List activeCS = workspaceConnection.activeChangeSets(componentHandle);
                if (activeCS.isEmpty()) continue;
                workspaceConnection.ensureClosed((Collection)activeCS, monitor);
            }
        }
    }

    private static void calculateBaseline(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IBaselineHandle baselineHandle, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)baselineHandle);
        IBaseline baselineOfComponent = (IBaseline)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 0, monitor);
        acceptReport.addComponentBaseline(baselineOfComponent);
    }

    private static boolean componentExists(IComponentHandle componentHandle, Collection components) {
        for (IComponentHandle existingComponentHandle : components) {
            if (!existingComponentHandle.getItemId().equals((Object)componentHandle.getItemId())) continue;
            return true;
        }
        return false;
    }

    public static List<IBaselineSetHandle> getSnapshotsFromName(ITeamRepository teamRepository, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSetSearchCriteria criteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
        criteria.setExactName(name);
        return SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).findBaselineSets(criteria, Integer.MAX_VALUE, monitor);
    }

    public static void associateBuildResultToSnapshot(ITeamRepository repo, IBaselineSetHandle snapshotHandle, IBuildResultHandle buildResultHandle, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) {
        if (repo == null) {
            throw new IllegalArgumentException("'repo' cannot be null");
        }
        if (snapshotHandle == null) {
            throw new IllegalArgumentException("'snapshotHandle' cannot be null");
        }
        if (buildResultHandle == null) {
            throw new IllegalArgumentException("'buildResultHandle' cannot be null");
        }
        try {
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            manager.addBaselineSetAssociation(snapshotHandle, (IItemHandle)buildResultHandle, syncTimes, monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public static void associateIterationToSnapshot(ITeamRepository repo, IBaselineSetHandle snapshotHandle, IBuildResultHandle buildResultHandle, String customIteration, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean foundCustomIteration;
        block23: {
            if (buildResultHandle == null) {
                throw new IllegalArgumentException("'buildResultHandle' cannot be null.");
            }
            if (snapshotHandle == null) {
                throw new IllegalArgumentException("'snapshotHandle' cannot be null.");
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            foundCustomIteration = false;
            try {
                try {
                    IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 1, (IProgressMonitor)progress.newChild(1));
                    IBuildDefinition buildDefinition = (IBuildDefinition)repo.itemManager().fetchCompleteItem((IItemHandle)buildResult.getBuildDefinition(), 1, (IProgressMonitor)progress.newChild(1));
                    IProcessAreaHandle processAreaHandle = buildDefinition.getProcessArea();
                    IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, (IProgressMonitor)progress.newChild(1));
                    IIterationHandle iterationToAssociate = null;
                    if (customIteration == null || customIteration.trim().isEmpty()) {
                        IDevelopmentLineHandle devLineHandle = null;
                        if (processArea instanceof ITeamArea) {
                            ITeamArea teamArea = (ITeamArea)processArea;
                            IProjectArea projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 1, (IProgressMonitor)progress.newChild(1));
                            devLineHandle = projectArea.getTeamAreaHierarchy().getDevelopmentLine((ITeamAreaHandle)teamArea);
                        } else if (processArea instanceof IProjectArea) {
                            devLineHandle = ((IProjectArea)processArea).getProjectDevelopmentLine();
                        }
                        progress.setWorkRemaining(2);
                        if (devLineHandle != null) {
                            IDevelopmentLine devLine = (IDevelopmentLine)repo.itemManager().fetchCompleteItem((IItemHandle)devLineHandle, 1, (IProgressMonitor)progress.newChild(1));
                            iterationToAssociate = devLine.getCurrentIteration();
                        }
                    } else {
                        List<String> segments = SourceControlUtility.split(customIteration, "/");
                        ArrayList<IDevelopmentLineHandle> devLineHandles = new ArrayList<IDevelopmentLineHandle>();
                        if (processArea instanceof ITeamArea) {
                            ITeamArea teamArea = (ITeamArea)processArea;
                            IProjectArea projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 1, (IProgressMonitor)progress.newChild(1));
                            devLineHandles.addAll(Arrays.asList(projectArea.getDevelopmentLines()));
                        } else if (processArea instanceof IProjectArea) {
                            IProjectArea projectArea = (IProjectArea)processArea;
                            devLineHandles.addAll(Arrays.asList(projectArea.getDevelopmentLines()));
                        }
                        ArrayList<IDevelopmentLine> fetchedDevLines = new ArrayList<IDevelopmentLine>(devLineHandles.size());
                        if (!devLineHandles.isEmpty()) {
                            IFetchResult result = repo.itemManager().fetchCompleteItemsPermissionAware(devLineHandles, 1, (IProgressMonitor)progress.newChild(1));
                            for (Object o : result.getRetrievedItems()) {
                                if (!(o instanceof IDevelopmentLine)) continue;
                                fetchedDevLines.add((IDevelopmentLine)o);
                            }
                        }
                        if (!fetchedDevLines.isEmpty()) {
                            String timelineSegment = segments.remove(0);
                            block5: for (IDevelopmentLine devLine : fetchedDevLines) {
                                if (!timelineSegment.equals(devLine.getId())) continue;
                                List<IIterationHandle> children = Arrays.asList(devLine.getIterations());
                                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(children, 1, monitor);
                                HashSet<UUID> visited = new HashSet<UUID>();
                                for (Object o : fetchResult.getRetrievedItems()) {
                                    if (!(o instanceof IIteration) || (iterationToAssociate = SourceControlUtility.search(repo, segments, (IIteration)o, visited, monitor)) == null) continue;
                                    foundCustomIteration = true;
                                    continue block5;
                                }
                            }
                        }
                    }
                    if (iterationToAssociate != null) {
                        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        manager.addBaselineSetAssociation(snapshotHandle, (IItemHandle)iterationToAssociate, syncTimes, (IProgressMonitor)progress.newChild(1));
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    progress.done();
                    break block23;
                }
            }
            catch (Throwable throwable) {
                progress.done();
                throw throwable;
            }
            progress.done();
        }
        if (customIteration != null && !customIteration.trim().isEmpty() && !foundCustomIteration) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_CUSTOM_ITERATION_NOT_FOUND_ERROR, (Object)customIteration, (Object[])new Object[0]));
        }
    }

    private static IIteration search(ITeamRepository repo, List<String> segments, IIteration iteration, Set<UUID> visited, IProgressMonitor monitor) throws TeamRepositoryException {
        if (segments != null && !segments.isEmpty() && iteration != null && !visited.contains(iteration.getItemId())) {
            visited.add(iteration.getItemId());
            ArrayList<String> newSegments = new ArrayList<String>(segments);
            String currentSegment = (String)newSegments.remove(0);
            if (currentSegment.equals(iteration.getId())) {
                if (newSegments.isEmpty()) {
                    return iteration;
                }
                List<IIterationHandle> children = Arrays.asList(iteration.getChildren());
                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(children, 1, monitor);
                for (Object o : fetchResult.getRetrievedItems()) {
                    IIteration foundNode;
                    if (!(o instanceof IIteration) || (foundNode = SourceControlUtility.search(repo, newSegments, (IIteration)o, visited, monitor)) == null) continue;
                    return foundNode;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static void removeSnapshotToBuildResultAssociation(IBaselineSetHandle snapshotHandle, IBuildResultHandle buildResultHandle, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) {
        if (snapshotHandle == null) {
            throw new IllegalArgumentException("'snapshot' cannot be null");
        }
        if (buildResultHandle == null) {
            throw new IllegalArgumentException("'buildResult' cannot be null");
        }
        if (snapshotHandle.getOrigin() instanceof ITeamRepository) {
            ITeamRepository repo = (ITeamRepository)snapshotHandle.getOrigin();
            try {
                IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                manager.removeBaselineSetAssociation(snapshotHandle, (IItemHandle)buildResultHandle, syncTimes, monitor);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    public static void associateReleaseToSnapshot(ITeamRepository repo, IBaselineSetHandle snapshot, IDeliverableHandle release, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) {
        if (repo == null) {
            throw new IllegalArgumentException("'repo' cannot be null");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("'snapshot' cannot be null");
        }
        if (release == null) {
            throw new IllegalArgumentException("'release' cannot be null");
        }
        try {
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            manager.addBaselineSetAssociation(snapshot, (IItemHandle)release, syncTimes, monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public static List<String> split(Object string, String sep) {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        if (string != null && !(s = string.toString().trim()).isEmpty()) {
            String[] stringArray = s.split(sep);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                l.add(token.trim());
                ++n2;
            }
        }
        return l;
    }

    public static void setArgumentCollector(List<Object> paramArgumentCollector) {
        argumentCollector = paramArgumentCollector;
    }
}

