/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.internal.client.ProxyHelper;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.internal.utils.RepositoryRegistry;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.IRetryPolicy;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.IntegratedWindowsLoginInfo;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class RepositoryManager {
    private Map<String, ITeamRepository> repositories = new HashMap<String, ITeamRepository>();
    private Set<String> authFailures = new HashSet<String>();
    private IRetryPolicy retryPolicy;

    public static RepositoryManager createWith(ITeamRepository repository) {
        RepositoryManager manager = new RepositoryManager();
        manager.add(repository);
        return manager;
    }

    public static RepositoryManager createFromRegistryFile(File file, IConsole console) {
        RepositoryManager manager = new RepositoryManager();
        RepositoryRegistry registry = new RepositoryRegistry(file);
        for (IRepositoryRecord record : registry) {
            ITeamRepository teamRepository = null;
            if (record.getUsername() != null && record.getPassword() != null) {
                teamRepository = RepositoryManager.getTeamRepository(record.getUrl(), record.getUsername(), record.getPassword(), console);
                RepositoryManager.updateCredentialsFromUsernameAndPassword(teamRepository, record.getUsername(), record.getPassword());
            } else if (record.getCertficiateLocation() != null && record.getPassword() != null) {
                teamRepository = RepositoryManager.getTeamRepository(record.getUrl(), console);
                RepositoryManager.updateCredentialsFromCertificateFile(teamRepository, record.getCertficiateLocation(), record.getPassword());
            } else if (record.isSmartCard() && record.getUsername() != null) {
                teamRepository = RepositoryManager.getTeamRepository(record.getUrl(), console);
                RepositoryManager.updateCredentialsFromSmartCard(teamRepository, record.getUsername());
            } else if (record.isKerberos()) {
                teamRepository = RepositoryManager.getTeamRepository(record.getUrl(), console);
                RepositoryManager.updateCredentialsFromKerberos(teamRepository);
            } else if (record.isIntegratedWindows()) {
                teamRepository = RepositoryManager.getTeamRepository(record.getUrl(), console);
                RepositoryManager.updateCredentialsFromIntegratedWindows(teamRepository);
            }
            manager.add(teamRepository);
        }
        return manager;
    }

    public static RepositoryManager createForUsernameAndPassword(String repositoryAddress, String userId, String password, IConsole console) {
        ITeamRepository teamRepository = RepositoryManager.getTeamRepository(repositoryAddress, userId, password, console);
        RepositoryManager.updateCredentialsFromUsernameAndPassword(teamRepository, userId, password);
        return RepositoryManager.createWith(teamRepository);
    }

    public static RepositoryManager createForCertificateFile(String repositoryAddress, File certificateFile, String password, IConsole console) {
        if (!certificateFile.exists()) {
            throw new IllegalArgumentException(ScmMessages.RepositoryManager_CERTIFICATE_FILE_MUST_EXIST);
        }
        ITeamRepository teamRepository = RepositoryManager.getTeamRepository(repositoryAddress, console);
        RepositoryManager.updateCredentialsFromCertificateFile(teamRepository, certificateFile.getAbsolutePath(), password);
        return RepositoryManager.createWith(teamRepository);
    }

    public static RepositoryManager createForSmartCard(String repositoryAddress, String userId, IConsole console) {
        ITeamRepository teamRepository = RepositoryManager.getTeamRepository(repositoryAddress, console);
        RepositoryManager.updateCredentialsFromSmartCard(teamRepository, userId);
        return RepositoryManager.createWith(teamRepository);
    }

    public static RepositoryManager createForKerberos(String repositoryAddress, IConsole console) {
        ITeamRepository teamRepository = RepositoryManager.getTeamRepository(repositoryAddress, console);
        RepositoryManager.updateCredentialsFromKerberos(teamRepository);
        return RepositoryManager.createWith(teamRepository);
    }

    public static RepositoryManager createForIntegratedWindows(String repositoryAddress, IConsole console) {
        ITeamRepository teamRepository = RepositoryManager.getTeamRepository(repositoryAddress, console);
        RepositoryManager.updateCredentialsFromIntegratedWindows(teamRepository);
        return RepositoryManager.createWith(teamRepository);
    }

    private static ITeamRepository getTeamRepository(String url, String jazzUsername, String jazzPassword, IConsole console) {
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(url);
        RepositoryManager.setProxyDetails(url, teamRepository, console, jazzUsername, jazzPassword);
        return teamRepository;
    }

    private static ITeamRepository getTeamRepository(String url, IConsole console) {
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(url);
        RepositoryManager.setProxyDetails(url, teamRepository, console, null, null);
        return teamRepository;
    }

    private static void setProxyDetails(String url, ITeamRepository teamRepository, IConsole console, String defaultProxyUsername, String defaultProxyPassword) {
        String host = ProxyHelper.getProxyHost((String)url);
        if (host != null) {
            int port = ProxyHelper.getProxyPort((String)url);
            String proxyType = null;
            String proxyUser = ProxyHelper.getProxyUser((String)url, (String)defaultProxyUsername);
            String proxyPassword = ProxyHelper.getProxyPassword((String)url, (String)defaultProxyPassword);
            teamRepository.setProxy(host, proxyType, port, proxyUser, proxyPassword);
            if (console != null) {
                console.print(NLS.bind((String)ScmMessages.RepositoryManager_USING_PROXY, (Object)host, (Object[])new Object[]{port, url}));
            }
        } else if (console != null) {
            console.print(NLS.bind((String)ScmMessages.RepositoryManager_NOT_USING_PROXY, (Object)url, (Object[])new Object[0]));
        }
    }

    private static void updateCredentialsFromUsernameAndPassword(ITeamRepository teamRepository, String username, String password) {
        teamRepository.registerLoginHandler((ITeamRepository.ILoginHandler)new LoginHandler(username, password));
    }

    private static void updateCredentialsFromCertificateFile(ITeamRepository teamRepository, String certificateFilePath, String password) {
        teamRepository.registerLoginHandler((ILoginHandler2)new CertificateLoginHandler(certificateFilePath, password));
    }

    private static void updateCredentialsFromSmartCard(ITeamRepository teamRepository, String username) {
        teamRepository.registerLoginHandler((ILoginHandler2)new SmartCardLoginHandler(username));
    }

    private static void updateCredentialsFromKerberos(ITeamRepository teamRepository) {
        teamRepository.registerLoginHandler((ILoginHandler2)new KerberosLoginHandler());
    }

    private static void updateCredentialsFromIntegratedWindows(ITeamRepository teamRepository) {
        teamRepository.registerLoginHandler((ILoginHandler2)new IntegratedWindowsLoginHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITeamRepository getRepository(String repositoryUri, boolean failIfAbsent) throws TeamRepositoryException {
        ITeamRepository repo;
        if (this.hasAuthenticationFailure(repositoryUri = this.canonicalizeRepositoryURI(repositoryUri))) {
            if (failIfAbsent) {
                throw new TeamRepositoryException(NLS.bind((String)ScmMessages.RepositoryManager_AUTH_PREVIOUSLY_FAILED, (Object)repositoryUri, (Object[])new Object[0]));
            }
            return null;
        }
        Map<String, ITeamRepository> map = this.repositories;
        synchronized (map) {
            repo = this.repositories.get(repositoryUri);
        }
        if (repo == null && failIfAbsent) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.RepositoryManager_AUTH_INFO_MISSING, (Object)repositoryUri, (Object[])new Object[0]));
        }
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ITeamRepository repository) {
        if (repository != null) {
            Map<String, ITeamRepository> map = this.repositories;
            synchronized (map) {
                if (this.retryPolicy != null) {
                    repository.setRetryPolicy(this.retryPolicy);
                }
                this.repositories.put(this.canonicalizeRepositoryURI(repository.getRepositoryURI()), repository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetryPolicy(IRetryPolicy policy) {
        Map<String, ITeamRepository> map = this.repositories;
        synchronized (map) {
            this.retryPolicy = policy;
            for (ITeamRepository repository : this.repositories.values()) {
                repository.setRetryPolicy(policy);
            }
        }
    }

    public void handleAuthenticationFailure(ITeamRepository repository, AuthenticationException exception) throws AuthenticationException {
        this.authFailures.add(this.canonicalizeRepositoryURI(repository.getRepositoryURI()));
        throw exception;
    }

    public boolean hasAuthenticationFailure(String remoteRepositoryURI) {
        return this.authFailures.contains(this.canonicalizeRepositoryURI(remoteRepositoryURI));
    }

    public void login(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            try {
                repository.login(monitor);
            }
            catch (OperationCanceledException exception) {
                if (repository.getErrorState() == 2) {
                    throw this.asAuthenticationException(repository);
                }
                throw exception;
            }
        }
        catch (AuthenticationException exception) {
            this.handleAuthenticationFailure(repository, exception);
        }
    }

    private AuthenticationException asAuthenticationException(ITeamRepository repository) {
        Throwable lastError = repository.getLastError();
        if (lastError != null) {
            if (lastError instanceof AuthenticationException) {
                return (AuthenticationException)lastError;
            }
            return new AuthenticationException(lastError.getMessage(), lastError);
        }
        return new AuthenticationException(NLS.bind((String)ScmMessages.RepositoryManager_AUTHENTICATION_FAILED, (Object)repository.getRepositoryURI(), (Object[])new Object[0]));
    }

    private String canonicalizeRepositoryURI(String repositoryURI) {
        if (!repositoryURI.endsWith("/")) {
            repositoryURI = String.valueOf(repositoryURI) + "/";
        }
        return repositoryURI;
    }

    private static abstract class AbstractLoginHandler {
        private final ILoginInfo2 loginInfo;

        protected AbstractLoginHandler(ILoginInfo2 loginInfo) {
            this.loginInfo = loginInfo;
        }

        protected final ILoginInfo2 getLoginInfo() {
            return this.loginInfo;
        }
    }

    private static abstract class AbstractLoginHandler2
    extends AbstractLoginHandler
    implements ILoginHandler2 {
        protected AbstractLoginHandler2(ILoginInfo2 loginInfo) {
            super(loginInfo);
        }

        public ILoginInfo2 challenge(ITeamRepository repository) {
            return this.getLoginInfo();
        }
    }

    private static class CertificateLoginHandler
    extends AbstractLoginHandler2 {
        private CertificateLoginHandler(String certificateFile, String password) {
            super((ILoginInfo2)new SSLCertificateLoginInfo(certificateFile, password));
        }
    }

    public static interface IConsole {
        public void print(String var1);
    }

    private static class IntegratedWindowsLoginHandler
    extends AbstractLoginHandler2 {
        public IntegratedWindowsLoginHandler() {
            super((ILoginInfo2)new IntegratedWindowsLoginInfo());
        }
    }

    private static class KerberosLoginHandler
    extends AbstractLoginHandler2 {
        public KerberosLoginHandler() {
            super((ILoginInfo2)new KerberosLoginInfo());
        }
    }

    private static class LoginHandler
    extends AbstractLoginHandler
    implements ITeamRepository.ILoginHandler,
    ITeamRepository.ILoginHandler.ILoginInfo {
        private LoginHandler(String username, String password) {
            super((ILoginInfo2)new UsernameAndPasswordLoginInfo(username, password));
        }

        public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
            return this;
        }

        public String getPassword() {
            try {
                return this.getUsernameAndPasswordLoginInfo().getPassword();
            }
            catch (SavedPasswordNotObtainedException e) {
                return null;
            }
        }

        public String getUserId() {
            return this.getUsernameAndPasswordLoginInfo().getUsername();
        }

        private UsernameAndPasswordLoginInfo getUsernameAndPasswordLoginInfo() {
            return (UsernameAndPasswordLoginInfo)this.getLoginInfo();
        }
    }

    private static class SmartCardLoginHandler
    extends AbstractLoginHandler2 {
        public SmartCardLoginHandler(String alias) {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias));
        }

        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias) {
            IAliasChooser chooser = SmartCardLoginHandler.createAliasChooser(requestedAlias);
            return new SmartCardLoginInfo(chooser);
        }

        private static IAliasChooser createAliasChooser(final String requestedAlias) {
            return new IAliasChooser(){

                public String chooseAlias(List<String> aliases) {
                    for (String alias : aliases) {
                        if (!alias.equals(requestedAlias)) continue;
                        return alias;
                    }
                    return null;
                }
            };
        }
    }
}

