/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class LoadComponents {
    private ITeamRepository repository;
    private String componentUuidProperty;
    private Collection<IComponentHandle> components;

    public LoadComponents(ITeamRepository repository, String componentUUIDs) {
        this.repository = repository;
        this.componentUuidProperty = componentUUIDs;
        this.components = this.buildComponents();
    }

    public LoadComponents(Collection<IComponentHandle> loadComponents) {
        this.components = new ArrayList<IComponentHandle>(loadComponents.size());
        this.components.addAll(loadComponents);
        this.componentUuidProperty = this.buildProperty();
    }

    public Collection<IComponentHandle> getComponentHandles() {
        return this.components;
    }

    public String getBuildProperty() {
        return this.componentUuidProperty;
    }

    private String buildProperty() {
        StringBuffer result = new StringBuffer();
        for (IComponentHandle componentHandle : this.components) {
            result.append(componentHandle.getItemId().getUuidValue()).append(' ');
        }
        return result.toString().trim();
    }

    private Collection<IComponentHandle> buildComponents() {
        if (this.componentUuidProperty == null) {
            return Collections.EMPTY_LIST;
        }
        String componentsProperty = this.componentUuidProperty.trim();
        if (componentsProperty.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        boolean done = false;
        while (!done) {
            String uuidValue;
            int index = componentsProperty.indexOf(" ");
            if (index == -1) {
                done = true;
                uuidValue = componentsProperty;
            } else {
                uuidValue = componentsProperty.substring(0, index);
                componentsProperty = componentsProperty.substring(index).trim();
            }
            UUID itemId = UUID.valueOf((String)uuidValue);
            result.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)this.repository, itemId, null));
        }
        return result;
    }

    public Collection<IComponentHandle> getIntersectingComponents(Collection<IComponentHandle> otherComponents) {
        HashSet<UUID> loadComponentUuids = new HashSet<UUID>();
        for (IComponentHandle component : this.components) {
            loadComponentUuids.add(component.getItemId());
        }
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        for (IComponentHandle component : otherComponents) {
            if (!loadComponentUuids.contains(component.getItemId())) continue;
            result.add(component);
        }
        return result;
    }
}

