/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ComponentLoadRules {
    HashMap<IComponentHandle, IFileItemHandle> fLoadRuleFiles = new HashMap();
    private static final String COMPONENT = "component=";
    private static final String FILEITEM = "fileitem=";

    public ComponentLoadRules(Map<IComponentHandle, IFileItemHandle> files) {
        if (files != null) {
            HashSet<UUID> componentIds = new HashSet<UUID>();
            for (Map.Entry<IComponentHandle, IFileItemHandle> entry : files.entrySet()) {
                if (!componentIds.add(entry.getKey().getItemId())) {
                    throw new IllegalArgumentException();
                }
                this.fLoadRuleFiles.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public ComponentLoadRules(String propertySetting) {
        if (propertySetting == null || propertySetting.length() == 0) {
            return;
        }
        String UUIDs = propertySetting.trim();
        while (UUIDs.length() > 0) {
            UUID fileUUID;
            String fileID;
            UUID componentUUID;
            if (!UUIDs.startsWith(COMPONENT)) {
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY, (Object)propertySetting));
            }
            int idx = (UUIDs = UUIDs.substring(COMPONENT.length())).indexOf(FILEITEM);
            if (idx == -1) {
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_3, (Object)propertySetting));
            }
            String componentID = UUIDs.substring(0, idx);
            try {
                componentUUID = UUID.valueOf((String)componentID);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_COMPONENT, (Object)componentID, (Object)propertySetting));
            }
            if (idx + FILEITEM.length() + 1 > UUIDs.length()) {
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_2, (Object)propertySetting));
            }
            if ((idx = (UUIDs = UUIDs.substring(idx + FILEITEM.length())).indexOf(COMPONENT)) == -1) {
                fileID = UUIDs;
                UUIDs = "";
            } else {
                fileID = UUIDs.substring(0, idx);
                UUIDs = UUIDs.substring(idx);
            }
            try {
                fileUUID = UUID.valueOf((String)fileID);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_FILE, (Object)fileID, (Object)propertySetting));
            }
            this.fLoadRuleFiles.put((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null), (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileUUID, null));
        }
    }

    public Collection<ILoadRule2> getLoadRules(IWorkspaceConnection workspaceConnection, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.fLoadRuleFiles.size());
        ArrayList<ILoadRule2> loadRules = new ArrayList<ILoadRule2>(this.fLoadRuleFiles.size());
        for (Map.Entry<IComponentHandle, IFileItemHandle> entry : this.fLoadRuleFiles.entrySet()) {
            IComponentHandle componentHandle = entry.getKey();
            try {
                ILoadRule2 rule = ILoadRuleFactory.loadRuleFactory.getLoadRule(workspaceConnection, componentHandle, entry.getValue(), (IProgressMonitor)monitor.newChild(1));
                loadRules.add(rule);
            }
            catch (VersionablePermissionDeniedException e1) {
                monitor.setWorkRemaining(1);
                ITeamRepository repo = (ITeamRepository)workspaceConnection.getResolvedWorkspace().getOrigin();
                IContributor contributor = repo.loggedInContributor();
                IComponent component = null;
                try {
                    component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)monitor.newChild(1));
                }
                catch (TeamRepositoryException e2) {
                    throw e1;
                }
                if (contributor != null && component != null) {
                    String errMsg = NLS.bind((String)ScmMessages.ComponentLoadRules_PRIVATE_LOAD_RULE, (Object[])new String[]{contributor.getName(), contributor.getUserId(), component.getName()});
                    throw new VersionablePermissionDeniedException(errMsg, (Throwable)e1);
                }
                throw e1;
            }
        }
        return loadRules;
    }

    public Map<IComponentHandle, IFileItemHandle> getLoadRuleFiles() {
        return Collections.unmodifiableMap(this.fLoadRuleFiles);
    }

    public String getBuildPropertySetting() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<IComponentHandle, IFileItemHandle> entry : this.fLoadRuleFiles.entrySet()) {
            builder.append(COMPONENT);
            builder.append(entry.getKey().getItemId().getUuidValue());
            builder.append(' ');
            builder.append(FILEITEM);
            builder.append(entry.getValue().getItemId().getUuidValue());
            builder.append(' ');
        }
        return builder.toString();
    }

    public Collection<ILoadRule2> getLoadRules(ITeamRepository teamRepository, IWorkspace workspace, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
        return this.getLoadRules(workspaceConnection, (IProgressMonitor)monitor.newChild(90));
    }

    public boolean isLoadRulesInXMLFormat(IWorkspaceConnection workspaceConnection, IProgressMonitor progress) throws TeamRepositoryException, UnsupportedEncodingException {
        boolean isLoadRulesInXMLFormat = true;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.fLoadRuleFiles.size());
        for (Map.Entry<IComponentHandle, IFileItemHandle> entry : this.fLoadRuleFiles.entrySet()) {
            IComponentHandle componentHandle = entry.getKey();
            if (ILoadRuleFactory.loadRuleFactory.isXMLLoadRule(ComponentLoadRules.getLoadRuleReader(workspaceConnection, componentHandle, entry.getValue(), (IProgressMonitor)monitor))) continue;
            isLoadRulesInXMLFormat = false;
            break;
        }
        return isLoadRulesInXMLFormat;
    }

    public static Reader getLoadRuleReader(IWorkspaceConnection connection, IComponentHandle componentHandle, IFileItemHandle fileVersionable, IProgressMonitor progress) throws TeamRepositoryException, UnsupportedEncodingException {
        InputStreamReader reader;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileItem file = (IFileItem)connection.configuration(componentHandle).fetchCompleteItem((IVersionableHandle)fileVersionable, (IProgressMonitor)monitor.newChild(50));
        InputStream stream = FileSystemCore.getContentManager((ITeamRepository)connection.teamRepository()).retrieveContentStream((IFileItemHandle)file, file.getContent(), (IProgressMonitor)monitor.newChild(50));
        if (file.getContent().getCharacterEncoding() == null || file.getContent().getCharacterEncoding() == "") {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            reader = new InputStreamReader(stream, decoder);
        } else {
            reader = new InputStreamReader(stream, file.getContent().getCharacterEncoding());
        }
        return reader;
    }
}

