/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntry2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ContributorDTO;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BaseChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogStreamOutput;
import com.ibm.team.filesystem.rcp.core.internal.changelog.GenerateChangeLogOperation;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.NullPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ChangeLogReport {
    public static final String DATE_FORMAT_STRING = "MMM d, yyyy hh:mm aaa";
    private ChangeLogEntryDTO fChangeLog;

    public ChangeLogReport(ITeamRepository teamRepository, IBaselineSetHandle currentSnapshot, IBaselineSetHandle beforeSnapshot, boolean showFileChanges, boolean showVersionIdentifiers) throws TeamRepositoryException {
        BaselineSetId currentId = BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)currentSnapshot);
        BaselineSetId beforeId = BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)beforeSnapshot);
        SnapshotSyncReport syncReport = SnapshotSyncReport.compare((ISnapshot)currentId.getSnapshot(null), (ISnapshot)beforeId.getSnapshot(null), null, null);
        IPathResolver pathResolver = this.getPathResolver((SnapshotId)currentId, (SnapshotId)beforeId);
        ChangeLogCustomizer customizer = this.getCustomizer(showFileChanges, showVersionIdentifiers);
        GenerateChangeLogOperation operation = new GenerateChangeLogOperation();
        operation.setChangeLogRequest(teamRepository, syncReport, pathResolver, customizer);
        this.fChangeLog = operation.run(null);
    }

    private IPathResolver getPathResolver(SnapshotId currentId, SnapshotId beforeId) {
        LinkedList<Object> pathResolvers = new LinkedList<Object>();
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)currentId));
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)beforeId));
        pathResolvers.add(NullPathResolver.create());
        return new FallbackPathResolver(pathResolvers);
    }

    private ChangeLogCustomizer getCustomizer(boolean showFileChanges, boolean showVersionIdentifiers) {
        ChangeLogCustomizer customizer = new ChangeLogCustomizer();
        customizer.setPruneUnchangedComponents(true);
        customizer.setPruneEmptyDirections(true);
        customizer.setIncludeDirection(true);
        customizer.setIncludeWorkItems(true);
        customizer.setIncludeBaselines(false);
        customizer.setIncludePaths(showFileChanges);
        customizer.setIncludeVersionIdentifiers(showVersionIdentifiers);
        return customizer;
    }

    public void outputToFile(File changeLogFile) throws IOException {
        if (changeLogFile.exists()) {
            changeLogFile.delete();
        } else {
            File parentDir = changeLogFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
        }
        try (PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(changeLogFile)));){
            ChangeLogStreamOutput output = new ChangeLogStreamOutput(printStream);
            AntTaskChangeLogEntryVisitor visitor = new AntTaskChangeLogEntryVisitor((IChangeLogOutput)output);
            ChangeLogEntryVisitor.acceptInto((ChangeLogEntryDTO)this.fChangeLog, (ChangeLogEntryVisitor)visitor);
            visitor.printComponentSections();
        }
    }

    protected String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_STRING);
        return NLS.bind((String)ScmMessages.ChangeLogReport_CHANGE_SET_OUTPUT_DATE_FORMATTING, (Object)formatter.format(date));
    }

    private class AntTaskChangeLogEntryVisitor
    extends BaseChangeLogEntryVisitor {
        private boolean fIsIncoming;
        private boolean fAddedWritten;
        private boolean fRemovedWritten;
        private Map<String, String> fAddedComponents = new LinkedHashMap<String, String>();
        private Map<String, String> fRemovedComponents = new LinkedHashMap<String, String>();

        public AntTaskChangeLogEntryVisitor(IChangeLogOutput output) {
            this.setOutput(output);
            this.setShowChangeSetWorkItems(true);
            this.fIsIncoming = false;
            this.fAddedWritten = false;
            this.fRemovedWritten = false;
        }

        protected void visitDirection(ChangeLogEntryDTO parent, ChangeLogDirectionEntryDTO dto) {
            this.fIsIncoming = !"incoming".equals(dto.getFlowDirection());
        }

        protected void visitComponent(ChangeLogEntryDTO parent, ChangeLogComponentEntryDTO dto) {
            String componentID = dto.getItemId();
            String componentName = this.findComponentName(dto);
            if ("addComponent".equals(dto.getChangeType())) {
                if (this.fIsIncoming) {
                    this.fAddedComponents.put(componentID, componentName);
                } else {
                    this.fRemovedComponents.put(componentID, componentName);
                }
            } else if ("removeComponent".equals(dto.getChangeType())) {
                if (this.fIsIncoming) {
                    this.fRemovedComponents.put(componentID, componentName);
                } else {
                    this.fAddedComponents.put(componentID, componentName);
                }
            } else {
                String output = NLS.bind((String)ScmMessages.EclipseChangeLogEntryVisitor_COMPONENT, (Object)componentName);
                this.out.writeLine(output);
            }
        }

        protected void visitVersionable(ChangeLogEntryDTO parent, ChangeLogVersionableEntryDTO dto) {
            if (dto instanceof ChangeLogVersionableEntry2DTO) {
                ChangeLogVersionableEntry2DTO dto2 = (ChangeLogVersionableEntry2DTO)dto;
                if (dto2.getShortVersionId() != null) {
                    this.out.writeLine(NLS.bind((String)ScmMessages.ChangeLogReport_VERSIONABLE_NAME_AND_IDENTIFIER, (Object)this.findVersionableName((ChangeLogVersionableEntryDTO)dto2), (Object)dto2.getShortVersionId()));
                } else {
                    this.out.writeLine(this.findVersionableName((ChangeLogVersionableEntryDTO)dto2));
                }
            } else {
                this.out.writeLine(this.findVersionableName(dto));
            }
        }

        protected void visitChangeSet(ChangeLogEntryDTO parent, ChangeLogChangeSetEntryDTO dto) {
            String output = AntTaskChangeLogEntryVisitor.sanitizeText((String)dto.getEntryName());
            if (dto.getWorkItems().size() > 0) {
                String wiText = this.findMultiWorkItemName(dto.getWorkItems());
                output = output == null || "".equals(output) ? wiText : NLS.bind((String)ScmMessages.EclipseChangeLogEntryVisitor_WORKITEM_TEXT_AND_CHANGESET_COMMENT, (Object)wiText, (Object)AntTaskChangeLogEntryVisitor.sanitizeText((String)output));
            } else if (output == null || "".equals(output)) {
                output = ScmMessages.EclipseChangeLogEntryVisitor_MISSING_CHANGESET_COMMENT;
            }
            if (dto.getCreationDate() != 0L) {
                output = NLS.bind((String)ScmMessages.ChangeLogReport_CHANGE_SET_OUTPUT_SPACING, (Object)output, (Object)ChangeLogReport.this.formatDate(new Date(dto.getCreationDate())));
            }
            if (dto.getCreator() != null) {
                output = NLS.bind((String)ScmMessages.ChangeLogReport_CHANGE_SET_OUTPUT_SPACING, (Object)output, (Object)this.getName(dto.getCreator()));
            }
            this.out.writeLine(output);
        }

        private String getName(ContributorDTO contributor) {
            return NLS.bind((String)ScmMessages.ChangeLogReport_CHANGE_SET_CONTRIBUTOR_FORMAT, (Object)contributor.getFullName(), (Object)contributor.getEmailAddress());
        }

        private String findMultiWorkItemName(List<ChangeLogWorkItemEntryDTO> list) {
            String numberBuf = Long.toString(list.get(0).getWorkItemNumber());
            int i = 1;
            while (i < list.size()) {
                numberBuf = NLS.bind((String)ScmMessages.BaseChangeLogEntryVisitor_WORKITEM_LIST_GENERATOR, (Object)numberBuf, (Object)Long.toString(list.get(i).getWorkItemNumber()));
                ++i;
            }
            return NLS.bind((String)ScmMessages.BaseChangeLogEntryVisitor_MULTIPLE_WORKITEM_NUMBERS_AND_SINGLE_NAME, (Object)numberBuf, (Object)list.get(0).getEntryName());
        }

        public void visitChild(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
            this.handleChild(parent, child);
            super.visitChild(parent, child);
        }

        private void handleChild(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
            if ("clentry_direction".equals(parent.getEntryType())) {
                ChangeLogComponentEntryDTO dto;
                if ("clentry_component".equals(child.getEntryType()) && ("addComponent".equals((dto = (ChangeLogComponentEntryDTO)child).getChangeType()) || "removeComponent".equals(dto.getChangeType()))) {
                    return;
                }
                this.out.setIndent(0);
                if (this.fIsIncoming) {
                    if (!this.fRemovedWritten) {
                        if (this.fAddedWritten) {
                            this.printNewLine();
                        }
                        this.fRemovedWritten = true;
                        this.out.writeLine(ScmMessages.ChangeLogReport_ADDED_CHANGE_SETS_HEADING);
                    }
                } else if (!this.fAddedWritten) {
                    if (this.fRemovedWritten) {
                        this.printNewLine();
                    }
                    this.fAddedWritten = true;
                    this.out.writeLine(ScmMessages.ChangeLogReport_REMOVED_CHANGE_SETS_HEADING);
                }
            }
        }

        private void printNewLine() {
            this.out.writeLine("");
        }

        public void printComponentSections() {
            boolean addedComponentSectionExists;
            boolean bl = addedComponentSectionExists = this.fAddedComponents.size() > 0;
            if (addedComponentSectionExists) {
                this.out.setIndent(0);
                if (this.fAddedWritten || this.fRemovedWritten) {
                    this.printNewLine();
                }
                this.out.writeLine(ScmMessages.ChangeLogReport_ADDED_COMPONENTS_HEADING);
                this.printComponents(this.fAddedComponents);
            }
            if (this.fRemovedComponents.size() > 0) {
                this.out.setIndent(0);
                if (this.fAddedWritten || this.fRemovedWritten || addedComponentSectionExists) {
                    this.printNewLine();
                }
                this.out.writeLine(ScmMessages.ChangeLogReport_REMOVED_COMPONENTS_HEADING);
                this.printComponents(this.fRemovedComponents);
            }
        }

        private void printComponents(Map<String, String> components) {
            Iterator<Map.Entry<String, String>> componentIterator = components.entrySet().iterator();
            while (componentIterator.hasNext()) {
                this.out.setIndent(1);
                this.out.writeLine(componentIterator.next().getValue());
            }
        }
    }
}

