/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.internal.scm.RepositoryManager;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildWorkspaceDescriptor {
    private final String repositoryUri;
    private final String workspaceId;
    private final String workspaceName;
    private IWorkspace workspace;

    public BuildWorkspaceDescriptor(ITeamRepository teamRepository, String workspaceUUID, String workspaceName) {
        Assert.isNotNull((Object)teamRepository);
        Assert.isTrue((workspaceUUID != null || workspaceName != null ? 1 : 0) != 0);
        this.repositoryUri = teamRepository.getRepositoryURI();
        this.workspaceId = workspaceUUID;
        this.workspaceName = workspaceName;
    }

    public BuildWorkspaceDescriptor(ITeamRepository teamRepository, IWorkspace workspace) {
        Assert.isNotNull((Object)teamRepository);
        Assert.isNotNull((Object)workspace);
        this.repositoryUri = teamRepository.getRepositoryURI();
        this.workspaceId = workspace.getItemId().getUuidValue();
        this.workspace = workspace;
        this.workspaceName = workspace.getName();
    }

    public IWorkspace getWorkspace(RepositoryManager repositoryManager, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.workspace == null) {
            this.workspace = this.fetchWorkspace(repositoryManager, monitor);
        }
        return this.workspace;
    }

    private IWorkspace fetchWorkspace(RepositoryManager repositoryManager, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.getRepository(repositoryManager);
        if (this.workspaceId != null) {
            return this.fetchWorkspace(teamRepository, this.getWorkspaceHandle(), monitor);
        }
        return this.fetchWorkspace(teamRepository, this.workspaceName, monitor);
    }

    private ITeamRepository getRepository(RepositoryManager repositoryManager) throws TeamRepositoryException {
        return repositoryManager.getRepository(this.repositoryUri, true);
    }

    private IWorkspace fetchWorkspace(ITeamRepository teamRepository, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace ws = SourceControlUtility.getWorkspace(teamRepository, name, monitor);
        if (ws == null) {
            throw new TeamBuildException(NLS.bind((String)ScmMessages.BuildWorkspaceDescriptor_WORKSPACE_WITH_NAME_NOT_FOUND, (Object)name));
        }
        return ws;
    }

    private IWorkspace fetchWorkspace(ITeamRepository teamRepository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException, TeamBuildException {
        IItem item;
        try {
            item = teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, monitor);
        }
        catch (ItemNotFoundException exception) {
            throw new TeamBuildException(NLS.bind((String)ScmMessages.BuildWorkspaceDescriptor_WORKSPACE_WITH_UUID_NOT_FOUND, (Object)this.workspaceId), (Throwable)exception);
        }
        catch (PermissionDeniedException exception) {
            throw new TeamBuildException(NLS.bind((String)ScmMessages.BuildWorkspaceDescriptor_USER_LACKS_READ_ACCESS, (Object)teamRepository.getUserId(), (Object)this.workspaceId));
        }
        if (!(item instanceof IWorkspaceHandle)) {
            throw new TeamBuildException(NLS.bind((String)ScmMessages.BuildWorkspaceDescriptor_ITEM_NOT_A_WORKSPACE, (Object)this.workspaceId, (Object)item.getItemType().getName()));
        }
        return (IWorkspace)item;
    }

    public IWorkspaceHandle getWorkspaceHandle() throws TeamBuildException {
        if (this.workspace != null) {
            return this.workspace;
        }
        if (this.workspaceId != null) {
            try {
                UUID workspaceUuid = UUID.valueOf((String)this.workspaceId);
                return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
            }
            catch (IllegalArgumentException exception) {
                throw new TeamBuildException(NLS.bind((String)ScmMessages.BuildWorkspaceDescriptor_UUID_INVALID, (Object)this.workspaceId), (Throwable)exception);
            }
        }
        throw new IllegalStateException("getWorkpace must be called for descriptors created using a name");
    }

    public IWorkspaceConnection getConnection(RepositoryManager manager, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(refresh ? 3 : 2));
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository(manager)).getWorkspaceConnection((IWorkspaceHandle)this.getWorkspace(manager, (IProgressMonitor)progress.newChild(1)), (IProgressMonitor)progress.newChild(1));
        if (refresh) {
            workspaceConnection.refresh((IProgressMonitor)progress.newChild(1));
        }
        return workspaceConnection;
    }
}

