/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildScmLoadOptions {
    private static final int LOAD_OPTIONS_VERSION = 0;
    private static final String VERSION_STRING = "version";
    private static final String EMPTY_STRING = "";
    private static final String HAS_OPTIONS_NOT_SUPPORTED_WITH_INCREMENTAL_UPDATE = "hasOptionsNotSupportedWithIncrementalUpdate";
    private static final String USE_LOAD_RULES_EXCLUSIVELY = "useLoadRulesExclusively";
    private static final String COMPONENT_LOAD_RULES_WITH_STATE_ID = "componentLoadRulesWithStateId";
    private static final String INVOKE_INCREMENTAL_UPDATE = "invokeIncrementalUpdate";
    private static final String SYNCHRONIZE_LOAD = "synchronizeLoad";
    private static final String LOAD_POLICY_USE_DYNAMIC_LOAD_RULES = "useDynamicLoadRules";
    private int version;
    private String workspaceUuid;
    private String fetchDestination;
    private boolean deleteDestinationBeforeFetch;
    private String loadMethod;
    private String loadPolicy;
    private String componentLoadConfig;
    private boolean createFoldersForComponents;
    private boolean includeComponents;
    private String componentUuids;
    private boolean synchronizeLoad;
    private String componentLoadRuleUuids;
    private boolean preserveFileTimestamps;
    private boolean expandKeywords;
    private boolean invokeIncrementalUpdate;
    private IWorkspaceConnection workspaceConnection;
    private Collection<IComponentHandle> components;
    private Collection<ILoadRule2> componentLoadRules;
    private String componentLoadRuleUuidsWithStateIds;
    private boolean useLoadRulesExclusively;
    private static Log logger = LogFactory.getLog((String)BuildScmLoadOptions.class.getName());

    private BuildScmLoadOptions() {
    }

    private BuildScmLoadOptions(int version, String workspaceUuid, boolean synchronizeLoad, String fetchDestination, boolean deleteDestinationBeforeFetch, String loadMethod, String loadPolicy, boolean createFoldersForComponents, String componentLoadConfig, boolean includeComponents, String componentUuids, boolean useLoadRulesExclusively, String componentLoadRuleUuids, boolean preserveFileTimestamps, boolean expandKeywords, boolean invokeIncrementalUpdate) {
        this.version = version;
        this.workspaceUuid = Objects.toString(workspaceUuid, EMPTY_STRING);
        this.synchronizeLoad = synchronizeLoad;
        this.fetchDestination = Objects.toString(fetchDestination, EMPTY_STRING);
        this.deleteDestinationBeforeFetch = deleteDestinationBeforeFetch;
        this.loadMethod = Objects.toString(loadMethod, EMPTY_STRING);
        this.loadPolicy = Objects.toString(loadPolicy, EMPTY_STRING);
        this.createFoldersForComponents = createFoldersForComponents;
        this.componentLoadConfig = Objects.toString(componentLoadConfig, EMPTY_STRING);
        this.includeComponents = includeComponents;
        this.componentUuids = Objects.toString(componentUuids, EMPTY_STRING);
        this.componentLoadRuleUuids = Objects.toString(componentLoadRuleUuids, EMPTY_STRING);
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.expandKeywords = expandKeywords;
        this.useLoadRulesExclusively = useLoadRulesExclusively;
        this.invokeIncrementalUpdate = invokeIncrementalUpdate;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public String getFetchDestination() {
        return this.fetchDestination;
    }

    public boolean shouldIncludeComponents() {
        return this.includeComponents;
    }

    public boolean shouldSynchronizeLoad() {
        return this.synchronizeLoad;
    }

    public boolean shouldUseLoadRulesExclusively() {
        return this.useLoadRulesExclusively;
    }

    public boolean shouldCreateFoldersForComponents() {
        return this.createFoldersForComponents;
    }

    public boolean shouldPreserveFileTimestamps() {
        return this.preserveFileTimestamps;
    }

    public boolean shouldExpandKeywords() {
        return this.expandKeywords;
    }

    public boolean shouldInvokeOptimizedIncrementalLoad() {
        return this.invokeIncrementalUpdate;
    }

    public Collection<ILoadRule2> getComponentLoadRules() {
        return this.componentLoadRules != null ? this.componentLoadRules : Collections.EMPTY_LIST;
    }

    public Collection<IComponentHandle> getComponents() {
        return this.components != null ? this.components : Collections.EMPTY_LIST;
    }

    public boolean hasOptionsNotSupportedWithOptimizedIncrementalLoad() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"BuildScmLoadOptions#hasOptionsNotSupportedWithOptimizedIncrementalLoad: Start.");
        }
        if (LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(this.loadPolicy)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Load is based on dynamic load rules. Optimized incremental load operation is not supported when using dynamic load rules for load.");
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"All the specified load options are supported when doing optimized incremental load.");
            logger.trace((Object)"BuildScmLoadOptions#hasOptionsNotSupportedWithOptimizedIncrementalLoad: End.");
        }
        return false;
    }

    public boolean isEqual(BuildScmLoadOptions loadOptions) {
        return this._isEqual(loadOptions) == 0;
    }

    private int _isEqual(BuildScmLoadOptions loadOptions) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"BuildScmLoadOptions#isEqual: Start.");
        }
        if (loadOptions == null) {
            return -1;
        }
        if (this.version != loadOptions.version) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("version-1: " + loadOptions.version + ". version-2: " + this.version + "."));
            }
            return 1;
        }
        if (!BuildScmLoadOptions.areUuidsEqual(this.workspaceUuid, loadOptions.workspaceUuid)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("workspaceUuid-1: " + loadOptions.workspaceUuid + ". workspaceUuid-2: " + this.workspaceUuid + "."));
            }
            return 2;
        }
        if (!BuildScmLoadOptions.areStringsEqual(this.fetchDestination, loadOptions.fetchDestination)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("fetchDestination-1: " + loadOptions.fetchDestination + ". fetchDestination-2: " + this.fetchDestination + "."));
            }
            return 3;
        }
        if (this.deleteDestinationBeforeFetch != loadOptions.deleteDestinationBeforeFetch) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("deleteDestinationBeforeFetch-1: " + loadOptions.deleteDestinationBeforeFetch + ". deleteDestinationBeforeFetch-2: " + this.deleteDestinationBeforeFetch + "."));
            }
            return 4;
        }
        if (!BuildScmLoadOptions.areStringsEqual(this.loadMethod, loadOptions.loadMethod)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("loadMethod-1: " + loadOptions.loadMethod + ". loadMethod-2: " + this.loadMethod + "."));
            }
            return 5;
        }
        if (!BuildScmLoadOptions.areStringsEqual(this.loadPolicy, loadOptions.loadPolicy)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("loadPolicy-1: " + loadOptions.loadPolicy + ". loadPolicy-2: " + this.loadPolicy + "."));
            }
            return 6;
        }
        if (this.createFoldersForComponents != loadOptions.createFoldersForComponents) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("createFoldersForComponents-1: " + loadOptions.createFoldersForComponents + ". createFoldersForComponents-2: " + this.createFoldersForComponents + "."));
            }
            return 7;
        }
        if (!BuildScmLoadOptions.areStringsEqual(this.componentLoadConfig, loadOptions.componentLoadConfig)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("componentLoadConfig-1: " + loadOptions.componentLoadConfig + ". componentLoadConfig-2: " + this.componentLoadConfig + "."));
            }
            return 8;
        }
        if (this.includeComponents != loadOptions.includeComponents) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("includeComponents-1: " + loadOptions.includeComponents + ". includeComponents-2: " + this.includeComponents + "."));
            }
            return 9;
        }
        if (!BuildScmLoadOptions.areLoadComponentsEqual(this.componentUuids, loadOptions.componentUuids)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("componentUuids-1: " + loadOptions.componentUuids + ". componentUuids-2 " + this.componentUuids + "."));
            }
            return 10;
        }
        if (!BuildScmLoadOptions.areComponentLoadRulesEqual(this.componentLoadRuleUuidsWithStateIds, loadOptions.componentLoadRuleUuidsWithStateIds)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("componentLoadRuleUuidsWithStateIds-1: " + loadOptions.componentLoadRuleUuidsWithStateIds + ". componentLoadRuleUuidsWithStateIds-2: " + this.componentLoadRuleUuidsWithStateIds + "."));
            }
            return 11;
        }
        if (this.preserveFileTimestamps != loadOptions.preserveFileTimestamps) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("preserveFileTimestamps-1: " + loadOptions.preserveFileTimestamps + ". preserveFileTimestamps-2: " + this.preserveFileTimestamps + "."));
            }
            return 12;
        }
        if (this.expandKeywords != loadOptions.expandKeywords) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("expandKeywords-1: " + loadOptions.expandKeywords + ". expandKeywords-2: " + this.expandKeywords + "."));
            }
            return 13;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"BuildScmLoadOptions#isEqual: Load options are equal.");
            logger.trace((Object)"BuildScmLoadOptions#isEqual: End.");
        }
        return 0;
    }

    private static boolean areStringsEqual(String s1, String s2) {
        boolean areEqual;
        boolean bl = areEqual = BuildScmLoadOptions.isEmptyOrNull(s1) && BuildScmLoadOptions.isEmptyOrNull(s2);
        if (!(areEqual || BuildScmLoadOptions.isEmptyOrNull(s1) || BuildScmLoadOptions.isEmptyOrNull(s2))) {
            return s1.trim().equals(s2.trim());
        }
        return areEqual;
    }

    private static boolean areUuidsEqual(String uuid1, String uuid2) {
        boolean areEqual;
        boolean bl = areEqual = BuildScmLoadOptions.isEmptyOrNull(uuid1) && BuildScmLoadOptions.isEmptyOrNull(uuid2);
        if (!(areEqual || BuildScmLoadOptions.isEmptyOrNull(uuid1) || BuildScmLoadOptions.isEmptyOrNull(uuid2))) {
            return UUID.valueOf((String)uuid1.trim()).equals((Object)UUID.valueOf((String)uuid2.trim()));
        }
        return areEqual;
    }

    private static boolean isEmptyOrNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static boolean areLoadComponentsEqual(String componentUuids1, String componentUuids2) {
        boolean areEqual;
        boolean bl = areEqual = BuildScmLoadOptions.isEmptyOrNull(componentUuids1) && BuildScmLoadOptions.isEmptyOrNull(componentUuids2);
        if (!(areEqual || BuildScmLoadOptions.isEmptyOrNull(componentUuids1) || BuildScmLoadOptions.isEmptyOrNull(componentUuids2))) {
            areEqual = true;
            List<UUID> componentUuidsList1 = BuildScmLoadOptions.getComponentUuidsList(componentUuids1);
            List<UUID> componentUuidsList2 = BuildScmLoadOptions.getComponentUuidsList(componentUuids2);
            if (componentUuidsList1.size() != componentUuidsList2.size()) {
                areEqual = false;
            } else {
                for (UUID componentUuid : componentUuidsList1) {
                    if (componentUuidsList2.contains(componentUuid)) continue;
                    areEqual = false;
                    break;
                }
            }
        }
        return areEqual;
    }

    private static List<UUID> getComponentUuidsList(String loadComponentUuids) {
        ArrayList<UUID> componentUuidsList = new ArrayList<UUID>();
        if (loadComponentUuids != null) {
            boolean done = false;
            while (!done) {
                String uuidValue;
                int index = loadComponentUuids.indexOf(" ");
                if (index == -1) {
                    done = true;
                    uuidValue = loadComponentUuids;
                } else {
                    uuidValue = loadComponentUuids.substring(0, index);
                    loadComponentUuids = loadComponentUuids.substring(index).trim();
                }
                componentUuidsList.add(UUID.valueOf((String)uuidValue));
            }
        }
        return componentUuidsList;
    }

    private static boolean areComponentLoadRulesEqual(String componentLoadRuleUuidsWithStateIds1, String componentLoadRuleUuidsWithStateIds2) {
        return new ComponentLoadRulesWithStateRepresentation(componentLoadRuleUuidsWithStateIds1).isEqual(new ComponentLoadRulesWithStateRepresentation(componentLoadRuleUuidsWithStateIds2));
    }

    /* synthetic */ BuildScmLoadOptions(BuildScmLoadOptions buildScmLoadOptions) {
        this();
    }

    /* synthetic */ BuildScmLoadOptions(int n, String string, boolean bl, String string2, boolean bl2, String string3, String string4, boolean bl3, String string5, boolean bl4, String string6, boolean bl5, String string7, boolean bl6, boolean bl7, boolean bl8, BuildScmLoadOptions buildScmLoadOptions) {
        this(n, string, bl, string2, bl2, string3, string4, bl3, string5, bl4, string6, bl5, string7, bl6, bl7, bl8);
    }

    public static class BuildScmLoadOptionsFactory {
        private static BuildScmLoadOptionsFactory instance;

        private BuildScmLoadOptionsFactory() {
        }

        public static BuildScmLoadOptionsFactory getInstance() {
            if (instance == null) {
                instance = new BuildScmLoadOptionsFactory();
            }
            return instance;
        }

        public BuildScmLoadOptions getBuildScmLoadOptions(IWorkspaceConnection workspaceConnection, boolean synchronizeLoad, String fetchDestination, boolean deleteDestinationBeforeFetch, String loadMethod, String loadPolicy, boolean createFoldersForComponents, String componentLoadConfig, boolean includeComponents, String componentUuids, String componentLoadRuleUuids, boolean preserveFileTimestamps, boolean expandKeywords, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
            BuildScmLoadOptionsAdditionalDetailsProviderImpl additionalDetailsProvider = new BuildScmLoadOptionsAdditionalDetailsProviderImpl();
            return this.createBuildScmLoadOptions(workspaceConnection, synchronizeLoad, fetchDestination, deleteDestinationBeforeFetch, loadMethod, loadPolicy, createFoldersForComponents, componentLoadConfig, includeComponents, componentUuids, componentLoadRuleUuids, preserveFileTimestamps, expandKeywords, repository, additionalDetailsProvider, monitor);
        }

        private BuildScmLoadOptions createBuildScmLoadOptions(IWorkspaceConnection workspaceConnection, boolean synchronizeLoad, String fetchDestination, boolean deleteDestinationBeforeFetch, String loadMethod, String loadPolicy, boolean createFoldersForComponents, String componentLoadConfig, boolean includeComponents, String componentUuids, String componentLoadRuleUuids, boolean preserveFileTimestamps, boolean expandKeywords, ITeamRepository repository, IBuildScmLoadOptionsAdditionalDetailsProvider additionalDetailsProvider, IProgressMonitor monitor) throws TeamRepositoryException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"BuildScmLoadOptionsFactory#createBuildScmLoadOptions1: Start.");
                logger.trace((Object)("workspaceUuid: " + workspaceConnection.getResolvedWorkspace().getItemId().getUuidValue()));
                logger.trace((Object)("synchronizeLoad: " + synchronizeLoad));
                logger.trace((Object)("fetchDestination: " + fetchDestination));
                logger.trace((Object)("deleteDestinationBeforeFetch: " + deleteDestinationBeforeFetch));
                logger.trace((Object)("loadMethod: " + loadMethod));
                logger.trace((Object)("loadPolicy: " + loadPolicy));
                logger.trace((Object)("createFoldersForComponents: " + createFoldersForComponents));
                logger.trace((Object)("componentLoadConfig: " + componentLoadConfig));
                logger.trace((Object)("includeComponents: " + includeComponents));
                logger.trace((Object)("componentUuids: " + componentUuids));
                logger.trace((Object)("componentLoadRuleUuids: " + componentLoadRuleUuids));
                logger.trace((Object)("preserveFileTimestamps: " + preserveFileTimestamps));
                logger.trace((Object)("expandKeywords: " + expandKeywords));
            }
            boolean useLoadRulesExclusively = false;
            if (loadPolicy != null) {
                if (additionalDetailsProvider.isLoadPolicySetToUseLoadRules(loadPolicy)) {
                    useLoadRulesExclusively = true;
                    createFoldersForComponents = false;
                    includeComponents = false;
                    componentUuids = null;
                } else if (this.isLoadPolicySetToUseComponentLoadConfig(loadPolicy)) {
                    boolean isComponentLoadConfigPropertyLoadAllComponents = this.isComponentLoadConfigSetToLoadAllComponents(componentLoadConfig);
                    if (!isComponentLoadConfigPropertyLoadAllComponents && !this.isComponentLoadConfigSetToExcludeSomeComponents(componentLoadConfig)) {
                        throw new IllegalArgumentException(NLS.bind((String)ScmMessages.BuildScmLoadOptions_Invalid_ComponentLoadConfig, (Object)componentLoadConfig, (Object)"team.scm.componentLoadConfig"));
                    }
                    includeComponents = isComponentLoadConfigPropertyLoadAllComponents ? false : includeComponents;
                    componentUuids = isComponentLoadConfigPropertyLoadAllComponents ? null : componentUuids;
                    componentLoadRuleUuids = null;
                } else if (!additionalDetailsProvider.isLoadPolicyValid(loadPolicy)) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.BuildScmLoadOptions_Invalid_LoadPolicy, (Object)loadPolicy, (Object)"team.scm.loadPolicy"));
                }
            }
            if (!this.isLoadPolicySetToUseComponentLoadConfig(loadPolicy)) {
                componentLoadConfig = null;
            }
            try {
                fetchDestination = Objects.toString(fetchDestination, BuildScmLoadOptions.EMPTY_STRING).isEmpty() ? fetchDestination : new File(fetchDestination).getCanonicalPath();
            }
            catch (IOException isComponentLoadConfigPropertyLoadAllComponents) {
                // empty catch block
            }
            boolean invokeIncrementalUpdate = !deleteDestinationBeforeFetch && loadMethod != null && loadMethod.trim().length() > 0 && "optimizedIncrementalLoad".equals(loadMethod);
            BuildScmLoadOptions loadOptions = this.createBuildScmLoadOptions(0, workspaceConnection.getResolvedWorkspace().getItemId().getUuidValue(), synchronizeLoad, fetchDestination, deleteDestinationBeforeFetch, loadMethod, loadPolicy, createFoldersForComponents, componentLoadConfig, includeComponents, componentUuids, useLoadRulesExclusively, componentLoadRuleUuids, preserveFileTimestamps, expandKeywords, invokeIncrementalUpdate);
            loadOptions.workspaceConnection = workspaceConnection;
            if (repository != null) {
                if (loadOptions.useLoadRulesExclusively) {
                    ILoadRule2 loadRule = additionalDetailsProvider.getLoadRule(loadOptions, loadOptions.workspaceConnection, monitor);
                    if (loadRule != null) {
                        loadOptions.componentLoadRules = Collections.singletonList(loadRule);
                    }
                } else {
                    loadOptions.components = additionalDetailsProvider.getComponents(loadOptions, repository);
                    loadOptions.componentLoadRules = additionalDetailsProvider.getComponentLoadRules(loadOptions, loadOptions.workspaceConnection, monitor);
                }
                ComponentLoadRulesWithStateRepresentation componentLoadRulesWithStateRepresentation = new ComponentLoadRulesWithStateRepresentation(this.getComponentLoadRulesWithStateId(loadOptions.componentLoadRuleUuids, loadOptions.workspaceConnection, monitor));
                loadOptions.componentLoadRuleUuidsWithStateIds = componentLoadRulesWithStateRepresentation.getComponentLoadRulesWithStateIdString();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("componentLoadRuleUuidsWithStateIds: " + loadOptions.componentLoadRuleUuidsWithStateIds));
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"BuildScmLoadOptionsFactory#createBuildScmLoadOptions1: End.");
            }
            return loadOptions;
        }

        private BuildScmLoadOptions createBuildScmLoadOptions(int version, String workspaceUuid, boolean synchronizeLoad, String fetchDestination, boolean deleteDestinationBeforeFetch, String loadMethod, String loadPolicy, boolean createFoldersForComponents, String componentLoadConfig, boolean includeComponents, String componentUuids, boolean useLoadRulesExclusively, String componentLoadRuleUuids, boolean preserveFileTimestamps, boolean expandKeywords, boolean invokeIncrementalUpdate) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"BuildScmLoadOptionsFactory#createBuildScmLoadOptions2: Start.");
                logger.trace((Object)("workspaceUuid: " + workspaceUuid));
                logger.trace((Object)("synchronizeLoad: " + synchronizeLoad));
                logger.trace((Object)("fetchDestination: " + fetchDestination));
                logger.trace((Object)("deleteDestinationBeforeFetch: " + deleteDestinationBeforeFetch));
                logger.trace((Object)("loadMethod: " + loadMethod));
                logger.trace((Object)("loadPolicy: " + loadPolicy));
                logger.trace((Object)("createFoldersForComponents: " + createFoldersForComponents));
                logger.trace((Object)("componentLoadConfig: " + componentLoadConfig));
                logger.trace((Object)("includeComponents: " + includeComponents));
                logger.trace((Object)("useLoadRulesExclusively: " + useLoadRulesExclusively));
                logger.trace((Object)("componentUuids: " + componentUuids));
                logger.trace((Object)("componentLoadRuleUuids: " + componentLoadRuleUuids));
                logger.trace((Object)("preserveFileTimestamps: " + preserveFileTimestamps));
                logger.trace((Object)("expandKeywords: " + expandKeywords));
                logger.trace((Object)("invokeIncrementalUpdate: " + invokeIncrementalUpdate));
            }
            BuildScmLoadOptions loadOptions = new BuildScmLoadOptions(version, workspaceUuid, synchronizeLoad, fetchDestination, deleteDestinationBeforeFetch, loadMethod, loadPolicy, createFoldersForComponents, componentLoadConfig, includeComponents, componentUuids, useLoadRulesExclusively, componentLoadRuleUuids, preserveFileTimestamps, expandKeywords, invokeIncrementalUpdate, null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"BuildScmLoadOptionsFactory#createBuildScmLoadOptions2: End.");
            }
            return loadOptions;
        }

        private Map<IComponentHandle, IFileItemHandle> getComponentLoadRulesWithStateId(String componentLoadRuleUuids, IWorkspaceConnection wsConnection, IProgressMonitor monitor) throws TeamRepositoryException {
            Map<IComponentHandle, IFileItemHandle> loadRuleFiles = new ComponentLoadRules(componentLoadRuleUuids).getLoadRuleFiles();
            HashMap<IComponentHandle, IFileItemHandle> loadRuleFilesState = new HashMap<IComponentHandle, IFileItemHandle>();
            for (IComponentHandle componentHandle : loadRuleFiles.keySet()) {
                IConfiguration configuration = wsConnection.configuration(componentHandle);
                IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)loadRuleFiles.get(componentHandle), monitor);
                loadRuleFilesState.put(componentHandle, (IFileItemHandle)fileItem.getStateHandle());
            }
            return loadRuleFilesState;
        }

        private boolean isLoadPolicySetToUseComponentLoadConfig(String loadPolicy) {
            return loadPolicy != null && "useComponentLoadConfig".equals(loadPolicy);
        }

        private boolean isComponentLoadConfigSetToLoadAllComponents(String componentLoadConfig) {
            return componentLoadConfig != null && "loadAllComponents".equals(componentLoadConfig);
        }

        private boolean isComponentLoadConfigSetToExcludeSomeComponents(String componentLoadConfig) {
            return componentLoadConfig != null && "excludeSomeComponents".equals(componentLoadConfig);
        }

        private static class BuildScmLoadOptionsAdditionalDetailsProviderImpl
        implements IBuildScmLoadOptionsAdditionalDetailsProvider {
            private BuildScmLoadOptionsAdditionalDetailsProviderImpl() {
            }

            @Override
            public boolean isLoadPolicySetToUseLoadRules(String loadPolicy) {
                return loadPolicy != null && "useLoadRules".equals(loadPolicy);
            }

            @Override
            public ILoadRule2 getLoadRule(BuildScmLoadOptions loadOptions, IWorkspaceConnection wsConnection, IProgressMonitor monitor) throws TeamRepositoryException {
                Iterator<ILoadRule2> loadRuleIterator;
                Collection<ILoadRule2> loadRules = this.getComponentLoadRules(loadOptions, wsConnection, monitor);
                ILoadRule2 loadRule = null;
                if (loadRules != null && (loadRuleIterator = loadRules.iterator()).hasNext()) {
                    loadRule = loadRuleIterator.next();
                }
                return loadRule;
            }

            @Override
            public Collection<IComponentHandle> getComponents(BuildScmLoadOptions loadOptions, ITeamRepository repository) {
                return new LoadComponents(repository, loadOptions.componentUuids).getComponentHandles();
            }

            @Override
            public Collection<ILoadRule2> getComponentLoadRules(BuildScmLoadOptions loadOptions, IWorkspaceConnection wsConnection, IProgressMonitor monitor) throws TeamRepositoryException {
                return new ComponentLoadRules(loadOptions.componentLoadRuleUuids).getLoadRules(wsConnection, monitor);
            }

            @Override
            public boolean isLoadPolicyValid(String loadPolicy) {
                return loadPolicy == null || "useComponentLoadConfig".equals(loadPolicy) || "useLoadRules".equals(loadPolicy);
            }
        }
    }

    public static class BuildScmLoadOptionsFileStorageManager {
        File storageFile;

        public BuildScmLoadOptionsFileStorageManager(File storageFile) {
            this.storageFile = storageFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void persistToFile(BuildScmLoadOptions loadOptions) throws IOException {
            block15: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"BuildScmLoadOptionsFileStorageManager#persistToFile: Start.");
                }
                if (!this.doesFileExists()) {
                    this.storageFile.createNewFile();
                }
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    FileOutputStream outputStream = new FileOutputStream(this.storageFile);
                    try {
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
                            Properties loadOptionProperties = new Properties();
                            loadOptionProperties.put(BuildScmLoadOptions.VERSION_STRING, Integer.toString(loadOptions.version));
                            loadOptionProperties.put("team.scm.workspaceUUID", Objects.toString(loadOptions.workspaceUuid, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.fetchDestination", Objects.toString(loadOptions.fetchDestination, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.deleteDestinationBeforeFetch", Boolean.toString(loadOptions.deleteDestinationBeforeFetch));
                            loadOptionProperties.put("team.scm.loadMethod", Objects.toString(loadOptions.loadMethod, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.loadPolicy", Objects.toString(loadOptions.loadPolicy, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.createFoldersForComponents", Boolean.toString(loadOptions.createFoldersForComponents));
                            loadOptionProperties.put("team.scm.componentLoadConfig", Objects.toString(loadOptions.componentLoadConfig, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.loadComponents", Objects.toString(loadOptions.componentUuids, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.includeComponents", Boolean.toString(loadOptions.includeComponents));
                            loadOptionProperties.put(BuildScmLoadOptions.COMPONENT_LOAD_RULES_WITH_STATE_ID, Objects.toString(loadOptions.componentLoadRuleUuidsWithStateIds, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put("team.scm.preserveFileTimestamps", Boolean.toString(loadOptions.preserveFileTimestamps));
                            loadOptionProperties.put("team.scm.expandKeywords", Boolean.toString(loadOptions.expandKeywords));
                            loadOptionProperties.put(BuildScmLoadOptions.SYNCHRONIZE_LOAD, Boolean.toString(loadOptions.shouldSynchronizeLoad()));
                            loadOptionProperties.put(BuildScmLoadOptions.USE_LOAD_RULES_EXCLUSIVELY, Boolean.toString(loadOptions.useLoadRulesExclusively));
                            loadOptionProperties.put("team.scm.componentLoadRules", Objects.toString(loadOptions.componentLoadRuleUuids, BuildScmLoadOptions.EMPTY_STRING));
                            loadOptionProperties.put(BuildScmLoadOptions.INVOKE_INCREMENTAL_UPDATE, Boolean.toString(loadOptions.invokeIncrementalUpdate));
                            loadOptionProperties.put(BuildScmLoadOptions.HAS_OPTIONS_NOT_SUPPORTED_WITH_INCREMENTAL_UPDATE, Boolean.toString(loadOptions.hasOptionsNotSupportedWithOptimizedIncrementalLoad()));
                            loadOptionProperties.store(writer, "Build SCM Load Options");
                        }
                        if (outputStream == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (!logger.isTraceEnabled()) return;
            logger.trace((Object)"BuildScmLoadOptionsFileStorageManager#persistToFile: End.");
        }

        public boolean doesFileExists() {
            return this.storageFile.exists();
        }

        public void deleteFile() {
            if (this.doesFileExists()) {
                this.storageFile.delete();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public BuildScmLoadOptions readFromFile() throws IOException {
            BuildScmLoadOptions loadOptions;
            block15: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"BuildScmLoadOptionsFileStorageManager#readFromFile: Start.");
                }
                if (!this.storageFile.exists()) {
                    return null;
                }
                loadOptions = new BuildScmLoadOptions(null);
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    FileInputStream inputStream = new FileInputStream(this.storageFile);
                    try {
                        try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");){
                            Properties loadOptionProperties = new Properties();
                            loadOptionProperties.load(reader);
                            loadOptions = BuildScmLoadOptionsFactory.getInstance().createBuildScmLoadOptions(Integer.parseInt(loadOptionProperties.getProperty(BuildScmLoadOptions.VERSION_STRING)), loadOptionProperties.getProperty("team.scm.workspaceUUID"), Boolean.parseBoolean(loadOptionProperties.getProperty(BuildScmLoadOptions.SYNCHRONIZE_LOAD)), loadOptionProperties.getProperty("team.scm.fetchDestination"), Boolean.parseBoolean(loadOptionProperties.getProperty("team.scm.deleteDestinationBeforeFetch")), loadOptionProperties.getProperty("team.scm.loadMethod"), loadOptionProperties.getProperty("team.scm.loadPolicy"), Boolean.parseBoolean(loadOptionProperties.getProperty("team.scm.createFoldersForComponents")), loadOptionProperties.getProperty("team.scm.componentLoadConfig"), Boolean.parseBoolean(loadOptionProperties.getProperty("team.scm.includeComponents")), loadOptionProperties.getProperty("team.scm.loadComponents"), Boolean.parseBoolean(loadOptionProperties.getProperty(BuildScmLoadOptions.USE_LOAD_RULES_EXCLUSIVELY)), loadOptionProperties.getProperty("team.scm.componentLoadRules"), Boolean.parseBoolean(loadOptionProperties.getProperty("team.scm.preserveFileTimestamps")), Boolean.parseBoolean(loadOptionProperties.getProperty("team.scm.expandKeywords")), Boolean.parseBoolean(loadOptionProperties.getProperty(BuildScmLoadOptions.INVOKE_INCREMENTAL_UPDATE)));
                            loadOptions.componentLoadRuleUuidsWithStateIds = loadOptionProperties.getProperty(BuildScmLoadOptions.COMPONENT_LOAD_RULES_WITH_STATE_ID);
                        }
                        if (inputStream == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (!logger.isTraceEnabled()) return loadOptions;
            logger.trace((Object)"BuildScmLoadOptionsFileStorageManager#readFromFile: End.");
            return loadOptions;
        }
    }

    public static class ComponentLoadRulesWithStateRepresentation {
        private static final String COMPONENT = "component=";
        private static final String FILEITEM = "fileitem=";
        private static final String FILESTATE = "filestate=";
        private HashMap<UUID, IFileItemHandle> fLoadRuleFiles = new HashMap();

        public ComponentLoadRulesWithStateRepresentation(Map<IComponentHandle, IFileItemHandle> files) {
            if (files != null) {
                HashSet<UUID> componentIds = new HashSet<UUID>();
                for (Map.Entry<IComponentHandle, IFileItemHandle> entry : files.entrySet()) {
                    if (!componentIds.add(entry.getKey().getItemId())) {
                        throw new IllegalArgumentException();
                    }
                    this.fLoadRuleFiles.put(entry.getKey().getItemId(), entry.getValue());
                }
            }
        }

        public ComponentLoadRulesWithStateRepresentation(String propertySetting) {
            if (propertySetting == null || propertySetting.trim().length() == 0) {
                return;
            }
            String UUIDs = propertySetting.trim();
            while (UUIDs.length() > 0) {
                UUID stateUUID;
                String stateID;
                UUID fileUUID;
                UUID componentUUID;
                if (!UUIDs.startsWith(COMPONENT)) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY, (Object)propertySetting));
                }
                int idx = (UUIDs = UUIDs.substring(COMPONENT.length())).indexOf(FILEITEM);
                if (idx == -1) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_3, (Object)propertySetting));
                }
                String componentID = UUIDs.substring(0, idx);
                try {
                    componentUUID = UUID.valueOf((String)componentID);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_COMPONENT, (Object)componentID, (Object)propertySetting));
                }
                if (idx + FILEITEM.length() + 1 > UUIDs.length()) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_2, (Object)propertySetting));
                }
                if ((idx = (UUIDs = UUIDs.substring(idx + FILEITEM.length())).indexOf(FILESTATE)) == -1) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.BuildScmLoadOptions_ComponentLoadRules_INTERNAL_MALFORMED_PROPERTY_4, (Object)propertySetting));
                }
                String fileID = UUIDs.substring(0, idx);
                try {
                    fileUUID = UUID.valueOf((String)fileID);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.ComponentLoadRules_MALFORMED_PROPERTY_FILE, (Object)fileID, (Object)propertySetting));
                }
                if (idx + FILESTATE.length() + 1 > UUIDs.length()) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.BuildScmLoadOptions_ComponentLoadRules_INTERNAL_MALFORMED_PROPERTY_5, (Object)propertySetting));
                }
                if ((idx = (UUIDs = UUIDs.substring(idx + FILESTATE.length())).indexOf(COMPONENT)) == -1) {
                    stateID = UUIDs;
                    UUIDs = BuildScmLoadOptions.EMPTY_STRING;
                } else {
                    stateID = UUIDs.substring(0, idx);
                    UUIDs = UUIDs.substring(idx);
                }
                try {
                    stateUUID = UUID.valueOf((String)stateID);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(NLS.bind((String)ScmMessages.BuildScmLoadOptions_ComponentLoadRules_INTERNAL_MALFORMED_PROPERTY_FILE_STATE, (Object)stateID, (Object)propertySetting));
                }
                this.fLoadRuleFiles.put(componentUUID, (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileUUID, stateUUID));
            }
        }

        public String getComponentLoadRulesWithStateIdString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<UUID, IFileItemHandle> entry : this.fLoadRuleFiles.entrySet()) {
                builder.append(COMPONENT);
                builder.append(entry.getKey().getUuidValue());
                builder.append(' ');
                builder.append(FILEITEM);
                builder.append(entry.getValue().getItemId().getUuidValue());
                builder.append(' ');
                builder.append(FILESTATE);
                builder.append(entry.getValue().getStateId().getUuidValue());
                builder.append(' ');
            }
            return builder.toString();
        }

        public Map<UUID, IFileItemHandle> getLoadRuleFiles() {
            return Collections.unmodifiableMap(this.fLoadRuleFiles);
        }

        public boolean isEqual(ComponentLoadRulesWithStateRepresentation componentLoadRulesWithStateRepresentation) {
            boolean isEqual = true;
            Map<UUID, IFileItemHandle> loadRuleFiles = componentLoadRulesWithStateRepresentation.getLoadRuleFiles();
            if (this.fLoadRuleFiles.size() != loadRuleFiles.size()) {
                return false;
            }
            for (Map.Entry<UUID, IFileItemHandle> entry : this.fLoadRuleFiles.entrySet()) {
                IFileItemHandle fileItem1 = entry.getValue();
                IFileItemHandle fileItem2 = loadRuleFiles.get(entry.getKey());
                if (fileItem1 != null && fileItem2 == null || fileItem1 == null && fileItem2 != null) {
                    return false;
                }
                if (fileItem1 == null || fileItem2 == null || fileItem1.getItemId().equals((Object)fileItem2.getItemId()) && fileItem1.getStateId().equals((Object)fileItem2.getStateId())) continue;
                return false;
            }
            return isEqual;
        }
    }

    private static interface IBuildScmLoadOptionsAdditionalDetailsProvider {
        public boolean isLoadPolicySetToUseLoadRules(String var1);

        public ILoadRule2 getLoadRule(BuildScmLoadOptions var1, IWorkspaceConnection var2, IProgressMonitor var3) throws TeamRepositoryException;

        public Collection<IComponentHandle> getComponents(BuildScmLoadOptions var1, ITeamRepository var2);

        public Collection<ILoadRule2> getComponentLoadRules(BuildScmLoadOptions var1, IWorkspaceConnection var2, IProgressMonitor var3) throws TeamRepositoryException;

        public boolean isLoadPolicyValid(String var1);
    }

    public static class JenkinsBuildScmLoadOptionsFactory {
        private static JenkinsBuildScmLoadOptionsFactory instance;

        private JenkinsBuildScmLoadOptionsFactory() {
        }

        public static JenkinsBuildScmLoadOptionsFactory getInstance() {
            if (instance == null) {
                instance = new JenkinsBuildScmLoadOptionsFactory();
            }
            return instance;
        }

        public BuildScmLoadOptions getBuildScmLoadOptions(IWorkspaceConnection workspaceConnection, boolean synchronizeLoad, String fetchDestination, boolean deleteDestinationBeforeFetch, String loadMethod, String loadPolicy, boolean createFoldersForComponents, String componentLoadConfig, boolean includeComponents, String componentUuids, String componentLoadRuleUuids, final Collection<ILoadRule2> dynamicLoadRules, final ILoadRule2 dynamicLoadRule, boolean preserveFileTimestamps, boolean expandKeywords, final ITeamRepository repository, final IProgressMonitor monitor) throws TeamRepositoryException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"JenkinsBuildScmLoadOptionsFactory#getBuildScmLoadOptions: Start.");
                logger.trace((Object)("loadPolicy: " + loadPolicy));
                logger.trace((Object)("dynamicLoadRules is null or empty: " + (dynamicLoadRules == null || dynamicLoadRules.isEmpty())));
                logger.trace((Object)("dynamicLoadRule is null: " + dynamicLoadRule == null ? 1 : 0));
            }
            final BuildScmLoadOptionsFactory.BuildScmLoadOptionsAdditionalDetailsProviderImpl defaultAdditionalDetailsProvider = new BuildScmLoadOptionsFactory.BuildScmLoadOptionsAdditionalDetailsProviderImpl();
            IBuildScmLoadOptionsAdditionalDetailsProvider jenkinsAdditionalDetailsProvider = new IBuildScmLoadOptionsAdditionalDetailsProvider(){

                @Override
                public boolean isLoadPolicySetToUseLoadRules(String loadPolicy1) {
                    return loadPolicy1 != null && ("useLoadRules".equals(loadPolicy1) || BuildScmLoadOptions.LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(loadPolicy1) && (dynamicLoadRules == null || dynamicLoadRules.isEmpty()) && dynamicLoadRule != null);
                }

                @Override
                public ILoadRule2 getLoadRule(BuildScmLoadOptions loadOptions, IWorkspaceConnection wsConnection, IProgressMonitor monitor1) throws TeamRepositoryException {
                    ILoadRule2 tempLoadRule = null;
                    tempLoadRule = loadOptions.loadPolicy != null && BuildScmLoadOptions.LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(loadOptions.loadPolicy) ? dynamicLoadRule : defaultAdditionalDetailsProvider.getLoadRule(loadOptions, wsConnection, monitor);
                    return tempLoadRule;
                }

                @Override
                public Collection<IComponentHandle> getComponents(BuildScmLoadOptions loadOptions, ITeamRepository repository1) {
                    return defaultAdditionalDetailsProvider.getComponents(loadOptions, repository);
                }

                @Override
                public Collection<ILoadRule2> getComponentLoadRules(BuildScmLoadOptions loadOptions, IWorkspaceConnection wsConnection, IProgressMonitor monitor1) throws TeamRepositoryException {
                    Collection<ILoadRule2> tempComponentLoadRules = null;
                    tempComponentLoadRules = loadOptions.loadPolicy != null && BuildScmLoadOptions.LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(loadOptions.loadPolicy) ? dynamicLoadRules : defaultAdditionalDetailsProvider.getComponentLoadRules(loadOptions, wsConnection, monitor);
                    return tempComponentLoadRules;
                }

                @Override
                public boolean isLoadPolicyValid(String loadPolicy1) {
                    return loadPolicy1 == null || "useComponentLoadConfig".equals(loadPolicy1) || "useLoadRules".equals(loadPolicy1) || BuildScmLoadOptions.LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(loadPolicy1);
                }
            };
            if (BuildScmLoadOptions.LOAD_POLICY_USE_DYNAMIC_LOAD_RULES.equals(loadPolicy)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("loadPolicy set to useDynamicLoadRules. Setting componentLoadRuleUuids to null. Provided value for componentLoadRuleUuids is: " + componentLoadRuleUuids));
                }
                componentLoadRuleUuids = null;
            }
            BuildScmLoadOptions loadOptions = BuildScmLoadOptionsFactory.getInstance().createBuildScmLoadOptions(workspaceConnection, synchronizeLoad, fetchDestination, deleteDestinationBeforeFetch, loadMethod, loadPolicy, createFoldersForComponents, componentLoadConfig, includeComponents, componentUuids, componentLoadRuleUuids, preserveFileTimestamps, expandKeywords, repository, jenkinsAdditionalDetailsProvider, monitor);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"JenkinsBuildScmLoadOptionsFactory#getBuildScmLoadOptions: End.");
            }
            return loadOptions;
        }
    }
}

