/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.parser.AbstractMSBuildCompileLogParser;
import com.ibm.team.build.internal.parser.DevenvBuildSimpleCompileLogParser;
import com.ibm.team.build.internal.parser.MSBuildSimpleCompileLogParser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSBuildCompileLogPublisher {
    private static final String DEVENV_BUILD = "devenv";

    public Collection publish(IBuildResult buildResult, String logDirectoryPath, String buildCmdType, String buildFile, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IBuildResultContribution> compileContributions = this.createCompileContribution(buildResult, logDirectoryPath, buildCmdType, buildFile, teamRepository, monitor);
        if (compileContributions != null && compileContributions.size() >= 1) {
            for (IBuildResultContribution contribution : compileContributions) {
                ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
                for (Object object : compileContribution.getCompilePackages()) {
                    this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
                }
                ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compileContribution, monitor);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, compileContributions.toArray(new IBuildResultContribution[compileContributions.size()]), monitor);
        }
        return compileContributions;
    }

    private List<IBuildResultContribution> createCompileContribution(IBuildResult buildResult, String logDirectory, String buildCmdType, String buildFile, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractMSBuildCompileLogParser parser = buildCmdType != null && buildCmdType.equals(DEVENV_BUILD) ? new DevenvBuildSimpleCompileLogParser(logDirectory, buildFile) : new MSBuildSimpleCompileLogParser(logDirectory);
        try {
            parser.parse();
        }
        catch (IOException exception) {
            throw new TeamBuildException((Throwable)exception);
        }
        LinkedList<IBuildResultContribution> compileContributions = new LinkedList<IBuildResultContribution>();
        if (parser.getProjectsData() != null) {
            for (AbstractMSBuildCompileLogParser.ProjectData pData : parser.getProjectsData()) {
                ICompileContribution extendedContribution = BuildItemFactory.createCompileContribution();
                extendedContribution.setWarningCount(pData.getWarningCount());
                extendedContribution.setErrorCount(pData.getErrorCount());
                extendedContribution.setBuildResult((IBuildResultHandle)buildResult);
                if (pData.getWarningCount() > 0) {
                    extendedContribution.setWarnings(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)pData.getWarnings(), (IProgressMonitor)monitor));
                }
                if (pData.getErrorCount() > 0) {
                    extendedContribution.setErrors(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)pData.getErrors(), (IProgressMonitor)monitor));
                }
                IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                contribution.setComponentName(pData.getSolutionName());
                contribution.setLabel(pData.getProjectName());
                contribution.setStatus(this.getBuildStatus(pData));
                contribution.setImpactsPrimaryResult(true);
                contribution.setExtendedContribution((IItemHandle)extendedContribution);
                contribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
                compileContributions.add(contribution);
            }
        }
        return compileContributions;
    }

    private void saveCompilePackage(ICompilePackage compilePackage, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Object object : compilePackage.getSubCompilePackages()) {
            this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compilePackage, monitor);
    }

    private BuildStatus getBuildStatus(AbstractMSBuildCompileLogParser.ProjectData pData) {
        if (pData.getErrorCount() == 0 && pData.getWarningCount() == 0) {
            return BuildStatus.OK;
        }
        if (pData.getErrorCount() == 0) {
            return BuildStatus.WARNING;
        }
        return BuildStatus.ERROR;
    }
}

