/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.CompileProblemType;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompileOutputFile;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.JdtSimpleCompileLogParser;
import com.ibm.team.build.internal.parser.JdtXmlCompileLogParser;
import com.ibm.team.build.internal.parser.data.JdtParserCompileData;
import com.ibm.team.build.internal.parser.data.JdtParserProblemData;
import com.ibm.team.build.internal.parser.data.JdtParserSourceData;
import com.ibm.team.build.internal.publishing.ComponentMapRegistry;
import com.ibm.team.build.internal.publishing.PublishingMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXParseException;

public class JdtCompileLogPublisher {
    private static final String SIMPLE_LOG_SUFFIX = ".log";
    private static final String XML_LOG_SUFFIX = ".xml";
    private static final String PDE_BUILD_SIMPLE_LOG_SUFFIX = ".bin.log";
    private static final String PDE_BUILD_XML_LOG_SUFFIX = ".bin.xml";
    private static final String PDE_BUILD_DOT_SIMPLE_LOG = "@dot.log";
    private static final String PDE_BUILD_DOT_XML_LOG = "@dot.xml";
    private String fComponentName;
    private File fComponentMapFile;
    private ComponentMapRegistry fComponentMap;
    private List<IBuildResultContribution> fSimpleCompileContributions = new LinkedList<IBuildResultContribution>();
    private Hashtable<String, IBuildResultContribution> fCompileContributions = new Hashtable();
    private boolean fPdeBuild = false;

    public void setComponentName(String componentName) {
        ValidationHelper.validateNotEmpty((String)"componentName", (String)componentName);
        this.fComponentName = componentName;
    }

    public void setComponentMap(File componentMap) {
        this.fComponentMapFile = componentMap;
    }

    public void setPdeBuild(boolean isPdeBuild) {
        this.fPdeBuild = isPdeBuild;
    }

    public Collection publish(IBuildResult buildResult, String logFilePath, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        String sourceDirectory = logFilePath;
        String[] logFiles = null;
        File logFile = new File(logFilePath);
        if (logFile.isDirectory()) {
            logFiles = this.getLogFiles(logFile);
        } else {
            logFiles = new String[]{logFilePath};
            sourceDirectory = null;
        }
        this.createBuildResultContributions(buildResult, logFiles, sourceDirectory, teamRepository, monitor);
        Collection<IBuildResultContribution> contributions = this.fSimpleCompileContributions;
        if (contributions.size() == 0) {
            contributions = this.fCompileContributions.values();
        } else {
            contributions.addAll(this.fCompileContributions.values());
        }
        for (IBuildResultContribution contribution : contributions) {
            ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
            for (Object object : compileContribution.getCompilePackages()) {
                this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compileContribution, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), monitor);
        return contributions;
    }

    private void saveCompilePackage(ICompilePackage compilePackage, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Object object : compilePackage.getSubCompilePackages()) {
            this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compilePackage, monitor);
    }

    private void createBuildResultContributions(IBuildResult buildResult, String[] logFiles, String directory, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fComponentMapFile != null) {
            try {
                this.fComponentMap = new ComponentMapRegistry(this.fComponentMapFile.getAbsolutePath());
            }
            catch (Exception exception) {
                throw new TeamRepositoryException((Throwable)exception);
            }
        }
        String simpleLogSuffix = this.fPdeBuild ? PDE_BUILD_SIMPLE_LOG_SUFFIX : SIMPLE_LOG_SUFFIX;
        int i = 0;
        while (i < logFiles.length) {
            if (logFiles[i].endsWith(simpleLogSuffix)) {
                this.createSimpleCompileContribution(buildResult, logFiles[i], directory, teamRepository, monitor);
            } else {
                this.createCompileContribution(logFiles[i], directory, teamRepository);
            }
            ++i;
        }
        for (IBuildResultContribution buildResultContribution : this.fCompileContributions.values()) {
            BuildStatus status;
            ICompileContribution compileContribution = (ICompileContribution)buildResultContribution.getExtendedContribution();
            compileContribution.setBuildResult((IBuildResultHandle)buildResult);
            for (Object object : compileContribution.getCompilePackages()) {
                ICompilePackage compilePackage = (ICompilePackage)object;
                compilePackage.setBuildResult((IBuildResultHandle)buildResult);
                this.updateCompilePackage(buildResult, compilePackage);
                compileContribution.setErrorCount(compileContribution.getErrorCount() + compilePackage.getErrorCount());
                compileContribution.setWarningCount(compileContribution.getWarningCount() + compilePackage.getWarningCount());
                compileContribution.setClassCount(compileContribution.getClassCount() + compilePackage.getClassCount());
            }
            BuildStatus currentStatus = buildResultContribution.getStatus();
            if (currentStatus == BuildStatus.ERROR || (status = this.getBuildStatus(compileContribution)) == BuildStatus.OK) continue;
            buildResultContribution.setStatus(status);
        }
    }

    private void createSimpleCompileContribution(IBuildResult buildResult, String logFile, String directory, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        JdtSimpleCompileLogParser parser = new JdtSimpleCompileLogParser(logFile);
        try {
            parser.parse();
        }
        catch (IOException exception) {
            throw new TeamBuildException((Throwable)exception);
        }
        ICompileContribution extendedContribution = BuildItemFactory.createCompileContribution();
        extendedContribution.setWarningCount(parser.getWarningCount());
        extendedContribution.setErrorCount(parser.getErrorCount());
        extendedContribution.setBuildResult((IBuildResultHandle)buildResult);
        if (parser.getWarningCount() > 0) {
            extendedContribution.setWarnings(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)parser.getWarnings(), (IProgressMonitor)monitor));
        }
        if (parser.getErrorCount() > 0) {
            extendedContribution.setErrors(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)parser.getErrors(), (IProgressMonitor)monitor));
        }
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setLabel(this.getContributionLabel(logFile, directory));
        contribution.setStatus(this.getBuildStatus(parser));
        contribution.setImpactsPrimaryResult(true);
        contribution.setExtendedContribution((IItemHandle)extendedContribution);
        contribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        if (this.fComponentName != null) {
            contribution.setComponentName(this.fComponentName);
        }
        this.fSimpleCompileContributions.add(contribution);
    }

    private IBuildResultContribution getCompileContribution(String componentName, String logFile, String directory) {
        if (componentName == null) {
            componentName = "";
        }
        if (this.fCompileContributions.get(componentName) == null) {
            ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
            IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
            if (componentName.length() > 0) {
                contribution.setComponentName(componentName);
                contribution.setLabel(componentName);
            } else {
                contribution.setLabel(this.getContributionLabel(logFile, directory));
            }
            contribution.setImpactsPrimaryResult(true);
            contribution.setExtendedContribution((IItemHandle)compileContribution);
            contribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
            this.fCompileContributions.put(componentName, contribution);
        }
        return this.fCompileContributions.get(componentName);
    }

    private void createCompileContribution(String logFile, String directory, ITeamRepository teamRepository) throws TeamRepositoryException {
        JdtXmlCompileLogParser parser = new JdtXmlCompileLogParser(new File(logFile));
        try {
            parser.parse();
        }
        catch (SAXParseException exception) {
            throw new TeamBuildException(NLS.bind((String)PublishingMessages.JdtCompileLogPublisher_SAX_PARSING_EXCEPTION, (Object)exception.getMessage(), (Object)exception.getLineNumber()), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new TeamBuildException((Throwable)exception);
        }
        JdtParserCompileData compileData = parser.getParsedData();
        if (compileData == null) {
            return;
        }
        String componentName = null;
        IBuildResultContribution buildResultContribution = null;
        ICompileContribution compileContribution = null;
        if (!this.fPdeBuild) {
            for (String packageName : compileData.getPackageNames()) {
                if (this.fComponentName != null) {
                    componentName = this.fComponentName;
                } else if (this.fComponentMap != null) {
                    componentName = this.fComponentMap.mapPackageToComponent(packageName);
                }
                buildResultContribution = this.getCompileContribution(componentName, logFile, directory);
                compileContribution = (ICompileContribution)buildResultContribution.getExtendedContribution();
                this.addSourcesToJavaPackage(compileContribution.getCompilePackages(), packageName, compileData.getSourcesInPackage(packageName));
            }
        } else {
            if (this.fComponentName != null) {
                componentName = this.fComponentName;
            } else if (this.fComponentMap != null) {
                for (String packageName : compileData.getPackageNames()) {
                    componentName = this.fComponentMap.mapPackageToComponent(packageName);
                    if (componentName != null) break;
                }
            }
            buildResultContribution = this.getCompileContribution(componentName, logFile, directory);
            compileContribution = (ICompileContribution)buildResultContribution.getExtendedContribution();
            this.addSourcesToPlugin(compileContribution, this.fileNameToPluginName(logFile), compileData);
            if (buildResultContribution.getTimeTaken() == -1L) {
                buildResultContribution.setTimeTaken(compileData.getCompileTime());
            } else {
                buildResultContribution.setTimeTaken(buildResultContribution.getTimeTaken() + compileData.getCompileTime());
            }
        }
    }

    protected String fileNameToPluginName(String logFileName) {
        File logFile = new File(logFileName);
        File pluginNameDirectory = logFile.getParentFile();
        File pluginParentDirectory = pluginNameDirectory.getParentFile();
        String pluginsDirectoryName = "plugins";
        while (pluginParentDirectory != null && !pluginParentDirectory.getName().equalsIgnoreCase(pluginsDirectoryName)) {
            pluginNameDirectory = pluginParentDirectory;
            pluginParentDirectory = pluginParentDirectory.getParentFile();
        }
        if (pluginParentDirectory == null || !pluginParentDirectory.getName().equalsIgnoreCase(pluginsDirectoryName)) {
            return logFileName;
        }
        String pluginName = pluginNameDirectory.getName();
        if (pluginName.indexOf(95) != -1) {
            pluginName = pluginName.substring(0, pluginName.indexOf(95));
        }
        return pluginName;
    }

    private void updateCompilePackage(IBuildResult buildResult, ICompilePackage compilePackage) {
        int errors = 0;
        int warnings = 0;
        int sourceFiles = 0;
        for (Object object : compilePackage.getSubCompilePackages()) {
            ICompilePackage subPackage = (ICompilePackage)object;
            this.updateCompilePackage(buildResult, subPackage);
            errors += subPackage.getErrorCount();
            warnings += subPackage.getWarningCount();
            sourceFiles += subPackage.getClassCount();
        }
        for (Object object : compilePackage.getCompileSources()) {
            ICompileSource source = (ICompileSource)object;
            source.setErrorCount(source.getErrors().size());
            source.setWarningCount(source.getWarnings().size());
            errors += source.getErrorCount();
            warnings += source.getWarningCount();
            ++sourceFiles;
        }
        compilePackage.setErrorCount(errors);
        compilePackage.setWarningCount(warnings);
        compilePackage.setClassCount(sourceFiles);
        compilePackage.setBuildResult((IBuildResultHandle)buildResult);
    }

    private void addSourcesToPlugin(ICompileContribution compileContribution, String pluginName, JdtParserCompileData compileData) {
        ICompilePackage pluginPackage = null;
        for (Object object : compileContribution.getCompilePackages()) {
            ICompilePackage loopPackage = (ICompilePackage)object;
            if (!loopPackage.getPackageType().equals("plugin") || !loopPackage.getPackageName().equals(pluginName)) continue;
            pluginPackage = loopPackage;
            break;
        }
        if (pluginPackage == null) {
            pluginPackage = BuildItemFactory.createCompilePackage();
            pluginPackage.setPackageType("plugin");
            pluginPackage.setPackageName(pluginName);
            compileContribution.getCompilePackages().add(pluginPackage);
        }
        for (String packageName : compileData.getPackageNames()) {
            this.addSourcesToJavaPackage(pluginPackage.getSubCompilePackages(), packageName, compileData.getSourcesInPackage(packageName));
        }
    }

    private void addSourcesToJavaPackage(List compilePackages, String packageName, Collection<JdtParserSourceData> sourcesInPackage) {
        ICompilePackage compilePackage = null;
        for (Object object : compilePackages) {
            ICompilePackage loopCompilePackage = (ICompilePackage)object;
            if (!loopCompilePackage.getPackageType().equals("package") || !loopCompilePackage.getPackageName().equals(packageName)) continue;
            compilePackage = loopCompilePackage;
            break;
        }
        if (compilePackage == null) {
            compilePackage = BuildItemFactory.createCompilePackage();
            compilePackage.setPackageType("package");
            compilePackage.setPackageName(packageName);
            compilePackages.add(compilePackage);
        }
        this.addSources(compilePackage.getCompileSources(), sourcesInPackage);
    }

    private void addSources(List compileSources, Collection<JdtParserSourceData> sourcesInPackage) {
        for (JdtParserSourceData sourceData : sourcesInPackage) {
            ICompileSource source = BuildItemFactory.createCompileSource();
            source.setSourceName(sourceData.getClassName());
            source.setSourcePath(sourceData.getPath());
            source.setErrorCount(sourceData.getErrorCount());
            source.setWarningCount(sourceData.getWarningCount());
            for (JdtParserProblemData problemData : sourceData.getErrors()) {
                ICompileProblem error = this.createCompileProblem(problemData);
                source.getErrors().add(error);
            }
            for (JdtParserProblemData problemData : sourceData.getWarnings()) {
                ICompileProblem warning = this.createCompileProblem(problemData);
                source.getWarnings().add(warning);
            }
            String[] stringArray = sourceData.getClassfileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String classfileName = stringArray[n2];
                ICompileOutputFile outputFile = BuildItemFactory.createCompileOutputFile();
                outputFile.setOutputFilePath(classfileName);
                source.getCompileOutputFiles().add(outputFile);
                ++n2;
            }
            compileSources.add(source);
        }
    }

    private ICompileProblem createCompileProblem(JdtParserProblemData problemData) {
        ICompileProblem problem = BuildItemFactory.createCompileProblem();
        problem.setLineNumber(problemData.getLineNumber());
        problem.setMessageText(problemData.getMessage());
        problem.setSourceText(problemData.getSource());
        problem.setSourceStart(problemData.getSourceStart());
        problem.setSourceEnd(problemData.getSourceEnd());
        problem.setProblemType(problemData.isError() ? CompileProblemType.ERROR : CompileProblemType.WARNING);
        return problem;
    }

    private BuildStatus getBuildStatus(JdtSimpleCompileLogParser parser) {
        if (parser.getErrorCount() == 0 && parser.getWarningCount() == 0) {
            return BuildStatus.OK;
        }
        if (parser.getErrorCount() == 0) {
            return BuildStatus.WARNING;
        }
        return BuildStatus.ERROR;
    }

    private BuildStatus getBuildStatus(ICompileContribution contribution) {
        if (contribution.getErrorCount() == 0 && contribution.getWarningCount() == 0) {
            return BuildStatus.OK;
        }
        if (contribution.getErrorCount() == 0) {
            return BuildStatus.WARNING;
        }
        return BuildStatus.ERROR;
    }

    private String getContributionLabel(String logFilePath, String directory) {
        String fileName = null;
        if (this.fPdeBuild) {
            fileName = this.fileNameToPluginName(logFilePath);
            if (!fileName.equals(logFilePath)) {
                return fileName;
            }
            fileName = null;
        } else {
            File file = new File(logFilePath);
            fileName = file.getName();
            fileName = fileName.indexOf(PDE_BUILD_SIMPLE_LOG_SUFFIX) != -1 ? fileName.substring(0, fileName.lastIndexOf(PDE_BUILD_SIMPLE_LOG_SUFFIX)) : (fileName.indexOf(PDE_BUILD_XML_LOG_SUFFIX) != -1 ? fileName.substring(0, fileName.lastIndexOf(PDE_BUILD_XML_LOG_SUFFIX)) : (fileName.indexOf(SIMPLE_LOG_SUFFIX) != -1 ? fileName.substring(0, fileName.lastIndexOf(SIMPLE_LOG_SUFFIX)) : fileName.substring(0, fileName.lastIndexOf(XML_LOG_SUFFIX))));
        }
        return this.ensureGoodFileName(fileName, directory, logFilePath);
    }

    protected String ensureGoodFileName(String fileName, String directory, String logFilePath) {
        if (fileName == null || fileName.equals("@dot")) {
            try {
                fileName = this.getFileNameFromPath(directory, logFilePath);
            }
            catch (IOException exception) {
                fileName = logFilePath.substring(directory.length());
            }
        }
        return fileName;
    }

    protected String getFileNameFromPath(String directory, String logFilePath) throws IOException {
        String fileName = null;
        if (directory != null) {
            String canonicalDir = new File(directory).getCanonicalPath();
            String canonicalFile = new File(logFilePath).getCanonicalPath();
            fileName = canonicalFile.substring(canonicalDir.length());
        } else {
            fileName = logFilePath;
        }
        return fileName;
    }

    private String[] getLogFiles(File directory) {
        ArrayList<String> list = new ArrayList<String>();
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    if (JdtCompileLogPublisher.this.fPdeBuild) {
                        return FileHelper.hasFileSuffix((File)pathname, (String[])new String[]{JdtCompileLogPublisher.PDE_BUILD_SIMPLE_LOG_SUFFIX, JdtCompileLogPublisher.PDE_BUILD_XML_LOG_SUFFIX, JdtCompileLogPublisher.PDE_BUILD_DOT_SIMPLE_LOG, JdtCompileLogPublisher.PDE_BUILD_DOT_XML_LOG});
                    }
                    return FileHelper.hasFileSuffix((File)pathname, (String[])new String[]{JdtCompileLogPublisher.SIMPLE_LOG_SUFFIX, JdtCompileLogPublisher.XML_LOG_SUFFIX});
                }
                return false;
            }
        });
        int i = 0;
        while (i < files.length) {
            list.add(files[i].getAbsolutePath());
            ++i;
        }
        File[] directories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int i2 = 0;
        while (i2 < directories.length) {
            String[] filePaths = this.getLogFiles(directories[i2]);
            int j = 0;
            while (j < filePaths.length) {
                list.add(filePaths[j]);
                ++j;
            }
            ++i2;
        }
        return list.toArray(new String[list.size()]);
    }
}

