/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.IJUnitTestCase;
import com.ibm.team.build.common.model.IJUnitTestClass;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.JUnitLogParser;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestClassData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import com.ibm.team.build.internal.publishing.ComponentMapRegistry;
import com.ibm.team.build.internal.publishing.PublishingMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class JUnitLogPublisher {
    private String fComponentName;
    private File fComponentMapFile;
    private ComponentMapRegistry fComponentMapRegistry;
    private List<IBuildResultContribution> fPublishedContributions = new ArrayList<IBuildResultContribution>();

    public void setComponentName(String componentName) {
        ValidationHelper.validateNotEmpty((String)"componentName", (String)componentName);
        this.fComponentName = componentName;
    }

    public void setComponentMap(File componentMap) {
        this.fComponentMapFile = componentMap;
    }

    public IBuildResultContribution[] getPublishedContributions() {
        return this.fPublishedContributions.toArray(new IBuildResultContribution[this.fPublishedContributions.size()]);
    }

    public String[] publish(IBuildResult buildResult, String logFileOrDirectory, String mayFailPattern, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fPublishedContributions = new ArrayList<IBuildResultContribution>();
        File fileOrDirectory = new File(logFileOrDirectory);
        if (fileOrDirectory.isDirectory()) {
            File[] files = fileOrDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && FileHelper.hasFileSuffix((File)pathname, (String[])new String[]{".xml"});
                }
            });
            ArrayList<String> warnings = new ArrayList<String>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String[] results;
                File file = fileArray[n2];
                String[] stringArray = results = this.publishFile(buildResult, file.getAbsolutePath(), mayFailPattern, teamRepository, monitor);
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    String warning = stringArray[n4];
                    warnings.add(NLS.bind((String)PublishingMessages.JUnitLogPublisher_PUBLISH_FILE_AND_WARNING, (Object)file.getAbsolutePath(), (Object)warning));
                    ++n4;
                }
                ++n2;
            }
            return warnings.toArray(new String[warnings.size()]);
        }
        return this.publishFile(buildResult, fileOrDirectory.getAbsolutePath(), mayFailPattern, teamRepository, monitor);
    }

    private String[] publishFile(IBuildResult buildResult, String logFile, String mayFailPattern, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        JUnitLogParser parser = null;
        try {
            parser = new JUnitLogParser(new File(logFile));
            parser.parse();
        }
        catch (SAXException exception) {
            throw new TeamBuildException(NLS.bind((String)PublishingMessages._EXCEPTION_PARSING, (Object)logFile), (Throwable)exception);
        }
        catch (IOException exception) {
            throw new TeamBuildException(NLS.bind((String)PublishingMessages._EXCEPTION_PARSING, (Object)logFile), (Throwable)exception);
        }
        catch (ParserConfigurationException exception) {
            throw new TeamBuildException(NLS.bind((String)PublishingMessages._EXCEPTION_PARSING, (Object)logFile), (Throwable)exception);
        }
        JUnitParserTestSuiteData[] testSuites = parser.getTestSuites();
        IBuildResultContribution[] contributions = new IBuildResultContribution[testSuites.length];
        int i = 0;
        while (i < testSuites.length) {
            contributions[i] = this.createBuildResultContribution(buildResult, testSuites[i], teamRepository);
            String componentName = null;
            try {
                componentName = this.getComponentName(testSuites[i]);
            }
            catch (Exception exception) {
                String testSuiteName = testSuites[i].getTestSuiteName() == null ? PublishingMessages.JUnitLogPublisher_UNKNOWN_TEST_SUITE_NAME : testSuites[i].getTestSuiteName();
                throw new TeamRepositoryException(NLS.bind((String)PublishingMessages.JUnitLogPublisher_EXCEPTION_GETTING_COMPONENT, (Object)testSuiteName), (Throwable)exception);
            }
            if (componentName != null) {
                contributions[i].setComponentName(componentName);
            }
            if (mayFailPattern != null && mayFailPattern.length() > 0 && contributions[i].getLabel().indexOf(mayFailPattern) > -1) {
                contributions[i].setImpactsPrimaryResult(false);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save((IJUnitTestSuiteContribution)contributions[i].getExtendedContribution(), null);
            ++i;
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions, null);
        this.fPublishedContributions.addAll(Arrays.asList(contributions));
        return parser.getParseErrors();
    }

    private String getComponentName(JUnitParserTestSuiteData testSuiteData) throws IOException, SAXException, ParserConfigurationException {
        String componentName = this.fComponentName;
        if (this.fComponentMapFile != null && testSuiteData.getTestSuiteName() != null) {
            if (this.fComponentMapRegistry == null) {
                this.fComponentMapRegistry = new ComponentMapRegistry(this.fComponentMapFile.getAbsolutePath());
            }
            componentName = this.fComponentMapRegistry.mapPackageToComponent(testSuiteData.getTestSuiteName());
        }
        return componentName;
    }

    private IBuildResultContribution createBuildResultContribution(IBuildResult buildResult, JUnitParserTestSuiteData testSuiteData, ITeamRepository teamRepository) throws TeamRepositoryException {
        JUnitParserTestClassData[] testClassesData;
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        IJUnitTestSuiteContribution testSuiteContribution = BuildItemFactory.createJUnitTestSuiteContribution();
        String testSuiteName = testSuiteData.getTestSuiteName() == null ? PublishingMessages.JUnitLogPublisher_UNKNOWN_TEST_SUITE_NAME : testSuiteData.getTestSuiteName();
        buildResultContribution.setLabel(testSuiteName);
        buildResultContribution.setTimeTaken(testSuiteData.getTimeTaken());
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContributionTypeId(IJUnitTestSuiteContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        buildResultContribution.setExtendedContribution((IItemHandle)testSuiteContribution);
        if (testSuiteData.getErrorCount() == 0 && testSuiteData.getFailureCount() == 0) {
            buildResultContribution.setStatus(BuildStatus.OK);
        } else {
            buildResultContribution.setStatus(BuildStatus.ERROR);
        }
        testSuiteContribution.setTestSuiteClassName(testSuiteName);
        testSuiteContribution.setErrorCount(testSuiteData.getErrorCount());
        testSuiteContribution.setFailureCount(testSuiteData.getFailureCount());
        testSuiteContribution.setTestCount(testSuiteData.getTestCount());
        testSuiteContribution.setBuildResult((IBuildResultHandle)buildResult);
        if (testSuiteData.getErrorData() != null) {
            testSuiteContribution.setErrorData(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)testSuiteData.getErrorData().getStackTrace()));
        }
        JUnitParserTestClassData[] jUnitParserTestClassDataArray = testClassesData = testSuiteData.getTestClasses();
        int n = testClassesData.length;
        int n2 = 0;
        while (n2 < n) {
            JUnitParserTestCaseData[] testCasesData;
            JUnitParserTestClassData testClassData = jUnitParserTestClassDataArray[n2];
            IJUnitTestClass testClass = BuildItemFactory.createJUnitTestClass();
            testClass.setClassName(testClassData.getTestClassName());
            testClass.setErrorCount(testClassData.getErrorCount());
            testClass.setFailureCount(testClassData.getFailureCount());
            testClass.setTestCount(testClassData.getTestCount());
            testClass.setTimeTaken(testClassData.getTimeTaken());
            testClass.setOrdinal(testClassData.getOrdinal());
            testClass.setBuildResult((IBuildResultHandle)buildResult);
            JUnitParserTestCaseData[] jUnitParserTestCaseDataArray = testCasesData = testClassData.getTestCases();
            int n3 = testCasesData.length;
            int n4 = 0;
            while (n4 < n3) {
                JUnitParserTestCaseData testCaseData = jUnitParserTestCaseDataArray[n4];
                IJUnitTestCase testCase = BuildItemFactory.createJUnitTestCase();
                testCase.setName(testCaseData.getName());
                testCase.setClassName(testCaseData.getTestClassName());
                testCase.setTimeTaken(testCaseData.getTimeTaken());
                testCase.setOrdinal(testCaseData.getOrdinal());
                testCase.setError(testCaseData.isError());
                if (testCaseData.getErrorData() != null) {
                    testCase.setErrorData(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)testCaseData.getErrorData().getStackTrace()));
                }
                testCase.setFailure(testCaseData.isFailure());
                if (testCaseData.getFailureData() != null) {
                    testCase.setFailureData(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)testCaseData.getFailureData().getStackTrace()));
                }
                testClass.getTestCases().add(testCase);
                ++n4;
            }
            testSuiteContribution.getTestClasses().add(testClass);
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(testClass, null);
            ++n2;
        }
        return buildResultContribution;
    }
}

